/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

class BinaryDoubleAccessor
extends Accessor {
    static final int MAXLENGTH = 8;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:27_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BinaryDoubleAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind));
                OracleLog.recursiveTrace = false;
            }
            this.init(stmt, 101, 101, form, forBind);
            this.initForDataAccess(external_type, max_len, null);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BinaryDoubleAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form));
                OracleLog.recursiveTrace = false;
            }
            this.init(stmt, 101, 101, form, false);
            this.initForDescribe(101, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            int max_field_size = stmt.maxFieldSize;
            if (max_field_size > 0 && (max_len == 0 || max_field_size < max_len)) {
                max_len = max_field_size;
            }
            this.initForDataAccess(0, max_len, null);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(OracleStatement stmt, int internal_type, int database_type, int max_len, short form, int external_type) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(internal_type) + ", " + OracleLog.argument(database_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type));
                OracleLog.recursiveTrace = false;
            }
            this.init(stmt, internal_type, database_type, form, false);
            this.initForDataAccess(external_type, max_len, null);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(OracleStatement stmt, int internal_type, int database_type, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(internal_type) + ", " + OracleLog.argument(database_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form));
                OracleLog.recursiveTrace = false;
            }
            this.init(stmt, internal_type, database_type, form, false);
            this.initForDescribe(internal_type, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            int max_field_size = stmt.maxFieldSize;
            if (max_field_size > 0 && (max_len == 0 || max_field_size < max_len)) {
                max_len = max_field_size;
            }
            this.initForDataAccess(0, max_len, null);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(external_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(typeName));
                OracleLog.recursiveTrace = false;
            }
            if (external_type != 0) {
                this.externalType = external_type;
            }
            this.internalTypeMaxLength = 8;
            if (max_len > 0 && max_len < this.internalTypeMaxLength) {
                this.internalTypeMaxLength = max_len;
            }
            this.byteLength = this.internalTypeMaxLength;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    double getDouble(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    BinaryDoubleAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "return: 0.0");
                    OracleLog.recursiveTrace = false;
                }
                double d2 = 0.0;
                return d2;
            }
            int off = this.columnIndex + this.byteLength * currentRow;
            int b0 = this.rowSpaceByte[off];
            int b1 = this.rowSpaceByte[off + 1];
            int b2 = this.rowSpaceByte[off + 2];
            int b3 = this.rowSpaceByte[off + 3];
            int b4 = this.rowSpaceByte[off + 4];
            int b5 = this.rowSpaceByte[off + 5];
            int b6 = this.rowSpaceByte[off + 6];
            int b7 = this.rowSpaceByte[off + 7];
            if ((b0 & 0x80) != 0) {
                b0 &= 0x7F;
                b1 &= 0xFF;
                b2 &= 0xFF;
                b3 &= 0xFF;
                b4 &= 0xFF;
                b5 &= 0xFF;
                b6 &= 0xFF;
                b7 &= 0xFF;
            } else {
                b0 = ~b0 & 0xFF;
                b1 = ~b1 & 0xFF;
                b2 = ~b2 & 0xFF;
                b3 = ~b3 & 0xFF;
                b4 = ~b4 & 0xFF;
                b5 = ~b5 & 0xFF;
                b6 = ~b6 & 0xFF;
                b7 = ~b7 & 0xFF;
            }
            int hiBits = b0 << 24 | b1 << 16 | b2 << 8 | b3;
            int loBits = b4 << 24 | b5 << 16 | b6 << 8 | b7;
            long longBits = (long)hiBits << 32 | (long)loBits & 0xFFFFFFFFL;
            double __result__ = Double.longBitsToDouble(longBits);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            double d3 = __result__;
            return d3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String getString(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    BinaryDoubleAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                String __result__ = Double.toString(this.getDouble(currentRow));
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                String string = __result__;
                return string;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            String string = null;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object getObject(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    BinaryDoubleAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                Double __result__ = new Double(this.getDouble(currentRow));
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                Double d2 = __result__;
                return d2;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            Object var2_3 = null;
            return var2_3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object getObject(int currentRow, Map map) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(map));
                OracleLog.recursiveTrace = false;
            }
            Double __result__ = new Double(this.getDouble(currentRow));
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            Double d2 = __result__;
            return d2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            BINARY_DOUBLE __result__ = this.getBINARY_DOUBLE(currentRow);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            BINARY_DOUBLE bINARY_DOUBLE = __result__;
            return bINARY_DOUBLE;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BINARY_DOUBLE getBINARY_DOUBLE(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            BINARY_DOUBLE result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    BinaryDoubleAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
                int off = this.columnIndex + this.byteLength * currentRow;
                byte[] data = new byte[len];
                System.arraycopy(this.rowSpaceByte, off, data, 0, len);
                result = new BINARY_DOUBLE(data);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            BINARY_DOUBLE bINARY_DOUBLE = result;
            return bINARY_DOUBLE;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    NUMBER getNUMBER(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    BinaryDoubleAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                NUMBER __result__ = new NUMBER(this.getDouble(currentRow));
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                NUMBER nUMBER = __result__;
                return nUMBER;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            NUMBER nUMBER = null;
            return nUMBER;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BigInteger getBigInteger(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    BinaryDoubleAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                BigInteger __result__ = new BigInteger(this.getString(currentRow));
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                BigInteger bigInteger = __result__;
                return bigInteger;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            BigInteger bigInteger = null;
            return bigInteger;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    BigDecimal getBigDecimal(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    BinaryDoubleAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                BigDecimal __result__ = new BigDecimal(this.getString(currentRow));
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                BigDecimal bigDecimal = __result__;
                return bigDecimal;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            BigDecimal bigDecimal = null;
            return bigDecimal;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    byte getByte(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            byte __result__ = (byte)this.getDouble(currentRow);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            byte by = __result__;
            return by;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    short getShort(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            short __result__ = (short)this.getDouble(currentRow);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            short s2 = __result__;
            return s2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int getInt(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = (int)this.getDouble(currentRow);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long getLong(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            long __result__ = (long)this.getDouble(currentRow);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            long l2 = __result__;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    float getFloat(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            float __result__ = (float)this.getDouble(currentRow);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            float f2 = __result__;
            return f2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BinaryDoubleAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.BinaryDoubleAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

