/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.core.lmx.CoreException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.VarnumBinder;

class BigDecimalBinder
extends VarnumBinder {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:32_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BigDecimalBinder() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BigDecimalBinder.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BigDecimalBinder.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues) throws SQLException {
        try {
            char c2;
            int signed;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BigDecimalBinder.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(bindPosition) + ", " + OracleLog.argument(rankInBuffer) + ", " + OracleLog.argument(rank) + ", " + OracleLog.argument(bindBytes) + ", " + OracleLog.argument(bindChars) + ", " + OracleLog.argument(bindIndicators) + ", " + OracleLog.argument(bytePitch) + ", " + OracleLog.argument(charPitch) + ", " + OracleLog.argument(byteoffset) + ", " + OracleLog.argument(charoffset) + ", " + OracleLog.argument(lenoffset) + ", " + OracleLog.argument(indoffset) + ", " + OracleLog.argument(clearPriorBindValues));
                OracleLog.recursiveTrace = false;
            }
            byte[] b2 = bindBytes;
            int offset = byteoffset + 1;
            BigDecimal val = stmt.parameterBigDecimal[rank][bindPosition];
            int rlen = 0;
            String sval = val.toString();
            int eIndex = sval.indexOf("E");
            if (eIndex != -1) {
                StringBuffer s2 = new StringBuffer(sval.length() + 5);
                int digits = 0;
                BigDecimal val2 = null;
                boolean isValueNegative = sval.charAt(0) == '-';
                String eValue = sval.substring(eIndex + 1);
                String intVal = sval.substring(isValueNegative ? 1 : 0, eIndex);
                val2 = new BigDecimal(intVal);
                boolean isExponentNegative = eValue.charAt(0) == '-';
                eValue = eValue.substring(1);
                digits = Integer.parseInt(eValue);
                String sval2 = val2.toString();
                int dotIndex = sval2.indexOf(".");
                int sval2Length = sval2.length();
                int suggestedDotIndex = sval2Length--;
                if (dotIndex != -1) {
                    sval2 = sval2.substring(0, dotIndex) + sval2.substring(dotIndex + 1);
                    if (isExponentNegative) {
                        digits -= dotIndex;
                    } else {
                        suggestedDotIndex = ++digits;
                    }
                } else if (isExponentNegative) {
                    digits -= sval2Length;
                } else {
                    suggestedDotIndex = ++digits;
                }
                if (isValueNegative) {
                    s2.append("-");
                }
                if (isExponentNegative) {
                    s2.append("0.");
                    for (int index = 0; index < digits; ++index) {
                        s2.append("0");
                    }
                    s2.append(sval2);
                } else {
                    int maxLen = digits > sval2Length ? digits : sval2Length;
                    for (int index = 0; index < maxLen; ++index) {
                        if (suggestedDotIndex == index) {
                            s2.append(".");
                        }
                        s2.append(sval2Length > index ? sval2.charAt(index) : (char)'0');
                    }
                }
                sval = s2.toString();
            }
            int len = sval.length();
            int ppos = sval.indexOf(46);
            int nzpos = signed = sval.charAt(0) == '-' ? 1 : 0;
            int nlen = 2;
            int lim1 = len;
            if (ppos == -1) {
                ppos = len;
            } else if ((len - ppos & 1) != 0) {
                lim1 = len + 1;
            }
            while (nzpos < len && ((c2 = sval.charAt(nzpos)) < '1' || c2 > '9')) {
                ++nzpos;
            }
            if (nzpos >= len) {
                b2[offset] = -128;
                rlen = 1;
            } else {
                int dig;
                int pos;
                int lim2;
                int diglen = nzpos < ppos ? 2 - (ppos - nzpos & 1) : 1 + (nzpos - ppos & 1);
                int exp = (ppos - nzpos - 1) / 2;
                if (exp > 62) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        BigDecimalBinder.logger().log(Level.SEVERE, "Throwing SQLException: 1" + CoreException.getMessage((byte)3) + " trying to bind " + val);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)3) + " trying to bind " + val);
                }
                if (exp < -65) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        BigDecimalBinder.logger().log(Level.SEVERE, "Throwing SQLException: 1" + CoreException.getMessage((byte)2) + " trying to bind " + val);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)2) + " trying to bind " + val);
                }
                if ((lim2 = nzpos + diglen + 38) > len) {
                    lim2 = len;
                }
                for (pos = nzpos + diglen; pos < lim2; pos += 2) {
                    if (pos == ppos) {
                        --pos;
                        if (lim2 >= len) continue;
                        ++lim2;
                        continue;
                    }
                    if (sval.charAt(pos) == '0' && (pos + 1 >= len || sval.charAt(pos + 1) == '0')) continue;
                    nlen = (pos - nzpos - diglen) / 2 + 3;
                }
                int i2 = offset + 2;
                pos = nzpos + diglen;
                if (signed == 0) {
                    b2[offset] = (byte)(192 + exp + 1);
                    dig = sval.charAt(nzpos) - 48;
                    if (diglen == 2) {
                        dig = dig * 10 + (nzpos + 1 < len ? sval.charAt(nzpos + 1) - 48 : 0);
                    }
                    b2[offset + 1] = (byte)(dig + 1);
                    while (i2 < offset + nlen) {
                        if (pos == ppos) {
                            ++pos;
                        }
                        dig = (sval.charAt(pos) - 48) * 10;
                        if (pos + 1 < len) {
                            dig += sval.charAt(pos + 1) - 48;
                        }
                        b2[i2++] = (byte)(dig + 1);
                        pos += 2;
                    }
                } else {
                    b2[offset] = (byte)(62 - exp);
                    dig = sval.charAt(nzpos) - 48;
                    if (diglen == 2) {
                        dig = dig * 10 + (nzpos + 1 < len ? sval.charAt(nzpos + 1) - 48 : 0);
                    }
                    b2[offset + 1] = (byte)(101 - dig);
                    while (i2 < offset + nlen) {
                        if (pos == ppos) {
                            ++pos;
                        }
                        dig = (sval.charAt(pos) - 48) * 10;
                        if (pos + 1 < len) {
                            dig += sval.charAt(pos + 1) - 48;
                        }
                        b2[i2++] = (byte)(101 - dig);
                        pos += 2;
                    }
                    if (nlen < 21) {
                        b2[offset + nlen++] = 102;
                    }
                }
                rlen = nlen;
            }
            b2[byteoffset] = (byte)rlen;
            bindIndicators[indoffset] = 0;
            bindIndicators[lenoffset] = (short)(rlen + 1);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BigDecimalBinder.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.BigDecimalBinder"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

