/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class ArrayDataResultSet
extends BaseResultSet {
    Datum[] data;
    Map map;
    private int currentIndex;
    private int lastIndex;
    PhysicalConnection connection;
    private Boolean wasNull;
    private static Boolean BOOLEAN_TRUE = new Boolean(true);
    private static Boolean BOOLEAN_FALSE = new Boolean(false);
    private int fetchSize;
    ARRAY array;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:27_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayDataResultSet(OracleConnection conn, Datum[] data, Map map) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(data) + ", " + OracleLog.argument(map));
                OracleLog.recursiveTrace = false;
            }
            this.connection = (PhysicalConnection)conn;
            this.data = data;
            this.map = map;
            this.currentIndex = 0;
            this.lastIndex = this.data == null ? 0 : this.data.length;
            this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayDataResultSet(OracleConnection conn, Datum[] data, long index, int count, Map map) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(data) + ", " + OracleLog.argument(index) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(map));
                OracleLog.recursiveTrace = false;
            }
            this.connection = (PhysicalConnection)conn;
            this.data = data;
            this.map = map;
            this.currentIndex = (int)index - 1;
            int length = this.data == null ? 0 : this.data.length;
            this.lastIndex = this.currentIndex + Math.min(length - this.currentIndex, count);
            this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayDataResultSet(OracleConnection conn, ARRAY array, long index, int count, Map map) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(array) + ", " + OracleLog.argument(index) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(map));
                OracleLog.recursiveTrace = false;
            }
            this.connection = (PhysicalConnection)conn;
            this.array = array;
            this.map = map;
            this.currentIndex = (int)index - 1;
            int length = this.array == null ? 0 : array.length();
            this.lastIndex = this.currentIndex + (count == -1 ? length - this.currentIndex : Math.min(length - this.currentIndex, count));
            this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        boolean bl;
        block7: {
            try {
                boolean __result__;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (this.closed) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 10next");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 10, "next");
                }
                ++this.currentIndex;
                boolean bl2 = __result__ = this.currentIndex <= this.lastIndex;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    super.close();
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block11: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.wasNull == null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 24" + null);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 24, null);
                    }
                    boolean __result__ = this.wasNull;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    bl = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block11;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getString(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            String string;
            block11: {
                block9: {
                    String string2;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            String __result__ = datum.stringValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            string2 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return string2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                string = null;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCursor(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ResultSet resultSet;
            block10: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getCursor");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCursor");
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    resultSet = null;
                    if (!TRACE || OracleLog.recursiveTrace) break block10;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Datum getOracleObject(int columnIndex) throws SQLException {
        block21: {
            block19: {
                block20: {
                    block17: {
                        block18: {
                            block15: {
                                block16: {
                                    try {
                                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                                            OracleLog.recursiveTrace = true;
                                            ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                            OracleLog.recursiveTrace = false;
                                        }
                                        if (this.currentIndex <= 0) {
                                            if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                                                OracleLog.recursiveTrace = true;
                                                ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14" + null);
                                                OracleLog.recursiveTrace = false;
                                            }
                                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14, null);
                                        }
                                        if (columnIndex != 1) break block15;
                                        this.wasNull = ArrayDataResultSet.BOOLEAN_FALSE;
                                        __result__ = new NUMBER(this.currentIndex);
                                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                                            OracleLog.recursiveTrace = true;
                                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                            OracleLog.recursiveTrace = false;
                                        }
                                        var3_5 = __result__;
                                        if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block16;
                                        OracleLog.recursiveTrace = true;
                                    }
                                    catch (Throwable var4_7) {
                                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                                            OracleLog.recursiveTrace = true;
                                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                            OracleLog.recursiveTrace = false;
                                        }
                                        throw var4_7;
                                    }
                                    ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                    OracleLog.recursiveTrace = false;
                                }
                                return var3_5;
                            }
                            if (columnIndex != 2) ** GOTO lbl70
                            if (this.data == null) break block17;
                            v0 = this.wasNull = this.data[this.currentIndex - 1] == null ? ArrayDataResultSet.BOOLEAN_TRUE : ArrayDataResultSet.BOOLEAN_FALSE;
                            if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.data[this.currentIndex - 1]);
                                OracleLog.recursiveTrace = false;
                            }
                            __result__ = this.data[this.currentIndex - 1];
                            if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block18;
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        return __result__;
                    }
                    if (this.array == null || (darray = this.array.getOracleArray(this.currentIndex, 1)) == null || darray.length < 1) break block19;
                    v1 = this.wasNull = darray[0] == null ? ArrayDataResultSet.BOOLEAN_TRUE : ArrayDataResultSet.BOOLEAN_FALSE;
                    if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + darray[0]);
                        OracleLog.recursiveTrace = false;
                    }
                    var3_6 = darray[0];
                    if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block20;
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return var3_6;
            }
            if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 1Out of sync");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Out of sync");
lbl70:
            // 2 sources

            if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3" + null);
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3, null);
            if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            var2_4 = null;
            if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block21;
            OracleLog.recursiveTrace = true;
            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return var2_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public ROWID getROWID(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof ROWID)) break block13;
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (ROWID)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (ROWID)datum;
                        if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getROWID");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getROWID");
lbl30:
                // 2 sources

                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public NUMBER getNUMBER(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof NUMBER)) break block13;
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (NUMBER)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (NUMBER)datum;
                        if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getNUMBER");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getNUMBER");
lbl30:
                // 2 sources

                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public DATE getDATE(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof DATE)) break block13;
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (DATE)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (DATE)datum;
                        if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getDATE");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getDATE");
lbl30:
                // 2 sources

                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public ARRAY getARRAY(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof ARRAY)) break block13;
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (ARRAY)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (ARRAY)datum;
                        if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getARRAY");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getARRAY");
lbl30:
                // 2 sources

                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public STRUCT getSTRUCT(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof STRUCT)) break block13;
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (STRUCT)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (STRUCT)datum;
                        if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getSTRUCT");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSTRUCT");
lbl30:
                // 2 sources

                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OPAQUE getOPAQUE(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof OPAQUE)) break block13;
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (OPAQUE)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (OPAQUE)datum;
                        if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getOPAQUE");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getOPAQUE");
lbl30:
                // 2 sources

                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public REF getREF(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof REF)) break block13;
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (REF)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (REF)datum;
                        if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getREF");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getREF");
lbl30:
                // 2 sources

                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public CHAR getCHAR(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof CHAR)) break block13;
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (CHAR)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (CHAR)datum;
                        if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getCHAR");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCHAR");
lbl30:
                // 2 sources

                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public RAW getRAW(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof RAW)) break block13;
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (RAW)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (RAW)datum;
                        if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getRAW");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getRAW");
lbl30:
                // 2 sources

                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public BLOB getBLOB(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof BLOB)) break block13;
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (BLOB)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (BLOB)datum;
                        if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getBLOB");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBLOB");
lbl30:
                // 2 sources

                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public CLOB getCLOB(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof CLOB)) break block13;
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (CLOB)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (CLOB)datum;
                        if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getCLOB");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCLOB");
lbl30:
                // 2 sources

                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public BFILE getBFILE(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof BFILE)) break block13;
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (BFILE)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (BFILE)datum;
                        if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getBFILE");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBFILE");
lbl30:
                // 2 sources

                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public INTERVALDS getINTERVALDS(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof INTERVALDS)) break block13;
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (INTERVALDS)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (INTERVALDS)datum;
                        if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
lbl30:
                // 2 sources

                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public INTERVALYM getINTERVALYM(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof INTERVALYM)) break block13;
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (INTERVALYM)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (INTERVALYM)datum;
                        if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
lbl30:
                // 2 sources

                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBfile(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BFILE bFILE;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    BFILE __result__ = this.getBFILE(columnIndex);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    bFILE = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bFILE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public TIMESTAMP getTIMESTAMP(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof TIMESTAMP)) break block13;
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (TIMESTAMP)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (TIMESTAMP)datum;
                        if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getTIMESTAMP");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMP");
lbl30:
                // 2 sources

                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof TIMESTAMPTZ)) break block13;
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (TIMESTAMPTZ)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (TIMESTAMPTZ)datum;
                        if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getTIMESTAMPTZ");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPTZ");
lbl30:
                // 2 sources

                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof TIMESTAMPLTZ)) break block13;
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (TIMESTAMPLTZ)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (TIMESTAMPLTZ)datum;
                        if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getTIMESTAMPLTZ");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPLTZ");
lbl30:
                // 2 sources

                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block11: {
                block9: {
                    boolean bl2;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            boolean __result__ = datum.booleanValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            bl2 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return bl2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                bl = false;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte getByte(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            byte by;
            block11: {
                block9: {
                    byte by2;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            byte __result__ = datum.byteValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            by2 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return by2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                by = 0;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return by;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            short s2;
            block11: {
                try {
                    long result;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if ((result = this.getLong(columnIndex)) > 65537L || result < -65538L) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 26getShort");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 26, "getShort");
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (short)result);
                        OracleLog.recursiveTrace = false;
                    }
                    s2 = (short)result;
                    if (!TRACE || OracleLog.recursiveTrace) break block11;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return s2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getInt(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            block11: {
                block9: {
                    int n3;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            int __result__ = datum.intValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            n3 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return n3;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                n2 = 0;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getLong(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long l2;
            block11: {
                block9: {
                    long l3;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            long __result__ = datum.longValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            l3 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return l3;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                l2 = 0L;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public float getFloat(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            float f2;
            block11: {
                block9: {
                    float f3;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            float __result__ = datum.floatValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            f3 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return f3;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                f2 = 0.0f;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return f2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public double getDouble(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            double d2;
            block13: {
                block11: {
                    double d3;
                    block12: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block11;
                            double __result__ = datum.doubleValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            d3 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block12;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return d3;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                d2 = 0.0;
                if (!TRACE || OracleLog.recursiveTrace) break block13;
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return d2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BigDecimal bigDecimal;
            block11: {
                block9: {
                    BigDecimal bigDecimal2;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            BigDecimal __result__ = datum.bigDecimalValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            bigDecimal2 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return bigDecimal2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                bigDecimal = null;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl31
                        if (!(datum instanceof RAW)) break block13;
                        __result__ = ((RAW)datum).shareBytes();
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        var5_6 = __result__;
                        if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var5_6;
                }
                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getBytes");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBytes");
lbl31:
                // 2 sources

                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var6_7) {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var6_7;
                    }
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Date getDate(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Date date;
            block11: {
                block9: {
                    Date date2;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            Date __result__ = datum.dateValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            date2 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return date2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                date = null;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Time getTime(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Time time;
            block11: {
                block9: {
                    Time time2;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            Time __result__ = datum.timeValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            time2 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return time2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                time = null;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Timestamp timestamp;
            block11: {
                block9: {
                    Timestamp timestamp2;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            Timestamp __result__ = datum.timestampValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            timestamp2 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return timestamp2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                timestamp = null;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            InputStream inputStream;
            block10: {
                try {
                    Datum datum;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if ((datum = this.getOracleObject(columnIndex)) != null) {
                        datum.asciiStreamValue();
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    inputStream = null;
                    if (!TRACE || OracleLog.recursiveTrace) break block10;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block14: {
                    block13: {
                        try {
                            if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl52
                            dbconv = this.connection.conversion;
                            bytes = datum.shareBytes();
                            if (datum instanceof RAW) {
                                __result__ = dbconv.ConvertStream(new ByteArrayInputStream(bytes), 3);
                                if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                    OracleLog.recursiveTrace = false;
                                }
                                var7_8 = __result__;
                                if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block13;
                                OracleLog.recursiveTrace = true;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (Throwable var8_10) {
                            if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw var8_10;
                        }
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var7_8;
lbl-1000:
                    // 1 sources

                    {
                        if (!(datum instanceof CHAR)) ** GOTO lbl-1000
                        __result__ = dbconv.ConvertStream(new ByteArrayInputStream(bytes), 1);
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        var7_9 = __result__;
                        if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                    }
                    ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return var7_9;
lbl-1000:
                // 1 sources

                {
                    if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getUnicodeStream");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getUnicodeStream");
lbl52:
                    // 2 sources

                    if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    var4_4 = null;
                    if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            InputStream inputStream;
            block11: {
                block9: {
                    InputStream inputStream2;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            InputStream __result__ = datum.binaryStreamValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            inputStream2 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return inputStream2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                inputStream = null;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object object;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    Object __result__ = this.getObject(columnIndex, this.map);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    object = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomDatum getCustomDatum(int columnIndex, CustomDatumFactory factory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CustomDatum customDatum;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(factory));
                        OracleLog.recursiveTrace = false;
                    }
                    Datum d2 = this.getOracleObject(columnIndex);
                    CustomDatum __result__ = factory.create(d2, 0);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    customDatum = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return customDatum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORAData getORAData(int columnIndex, ORADataFactory factory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ORAData oRAData;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(factory));
                        OracleLog.recursiveTrace = false;
                    }
                    Datum d2 = this.getOracleObject(columnIndex);
                    ORAData __result__ = factory.create(d2, 0);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    oRAData = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return oRAData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ResultSetMetaData resultSetMetaData;
            block12: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 10getMetaData");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 10, "getMetaData");
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 23getMetaData");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23, "getMetaData");
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    resultSetMetaData = null;
                    if (!TRACE || OracleLog.recursiveTrace) break block12;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return resultSetMetaData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int findColumn(String columnName) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            block16: {
                block14: {
                    int n3;
                    block15: {
                        block12: {
                            int n4;
                            block13: {
                                try {
                                    if (TRACE && !OracleLog.recursiveTrace) {
                                        OracleLog.recursiveTrace = true;
                                        ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnName));
                                        OracleLog.recursiveTrace = false;
                                    }
                                    if (!columnName.equalsIgnoreCase("index")) break block12;
                                    if (TRACE && !OracleLog.recursiveTrace) {
                                        OracleLog.recursiveTrace = true;
                                        ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 1");
                                        OracleLog.recursiveTrace = false;
                                    }
                                    n4 = 1;
                                    if (!TRACE || OracleLog.recursiveTrace) break block13;
                                    OracleLog.recursiveTrace = true;
                                }
                                catch (Throwable throwable) {
                                    if (TRACE && !OracleLog.recursiveTrace) {
                                        OracleLog.recursiveTrace = true;
                                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                        OracleLog.recursiveTrace = false;
                                    }
                                    throw throwable;
                                }
                                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            return n4;
                        }
                        if (!columnName.equalsIgnoreCase("value")) break block14;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 2");
                            OracleLog.recursiveTrace = false;
                        }
                        n3 = 2;
                        if (!TRACE || OracleLog.recursiveTrace) break block15;
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return n3;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 6get_column_index");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 6, "get_column_index");
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                n2 = 0;
                if (!TRACE || OracleLog.recursiveTrace) break block16;
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement getStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Statement statement;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    statement = null;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return statement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getObject(int columnIndex, Map map) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object var5_7;
            block15: {
                block11: {
                    Object object;
                    block14: {
                        Datum datum;
                        block12: {
                            Object object2;
                            block13: {
                                try {
                                    if (TRACE && !OracleLog.recursiveTrace) {
                                        OracleLog.recursiveTrace = true;
                                        ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(map));
                                        OracleLog.recursiveTrace = false;
                                    }
                                    if ((datum = this.getOracleObject(columnIndex)) == null) break block11;
                                    if (!(datum instanceof STRUCT)) break block12;
                                    Object __result__ = ((STRUCT)datum).toJdbc(map);
                                    if (TRACE && !OracleLog.recursiveTrace) {
                                        OracleLog.recursiveTrace = true;
                                        ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                        OracleLog.recursiveTrace = false;
                                    }
                                    object2 = __result__;
                                    if (!TRACE || OracleLog.recursiveTrace) break block13;
                                    OracleLog.recursiveTrace = true;
                                }
                                catch (Throwable throwable) {
                                    if (TRACE && !OracleLog.recursiveTrace) {
                                        OracleLog.recursiveTrace = true;
                                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                        OracleLog.recursiveTrace = false;
                                    }
                                    throw throwable;
                                }
                                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            return object2;
                        }
                        Object __result__ = datum.toJdbc();
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        object = __result__;
                        if (!TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return object;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var5_7 = null;
                if (!TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var5_7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            REF rEF;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    REF __result__ = this.getREF(columnIndex);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    rEF = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return rEF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BLOB bLOB;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    BLOB __result__ = this.getBLOB(columnIndex);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    bLOB = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CLOB cLOB;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    CLOB __result__ = this.getCLOB(columnIndex);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    cLOB = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return cLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ARRAY aRRAY;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    ARRAY __result__ = this.getARRAY(columnIndex);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    aRRAY = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return aRRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Reader reader;
            block11: {
                block9: {
                    Reader reader2;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            Reader __result__ = datum.characterStreamValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            reader2 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return reader2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                reader = null;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BigDecimal bigDecimal;
            block11: {
                block9: {
                    BigDecimal bigDecimal2;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            BigDecimal __result__ = datum.bigDecimalValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            bigDecimal2 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return bigDecimal2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                bigDecimal = null;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Date date;
            block11: {
                block9: {
                    Date date2;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(cal));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            DATE dateValue = null;
                            dateValue = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
                            if (dateValue == null) break block9;
                            Date __result__ = dateValue.dateValue(cal);
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            date2 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return date2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                date = null;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Time time;
            block11: {
                block9: {
                    Time time2;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(cal));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            DATE dateValue = null;
                            dateValue = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
                            if (dateValue == null) break block9;
                            Time __result__ = dateValue.timeValue(cal);
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            time2 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return time2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                time = null;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Timestamp timestamp;
            block11: {
                block9: {
                    Timestamp timestamp2;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(cal));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            DATE dateValue = null;
                            dateValue = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
                            if (dateValue == null) break block9;
                            Timestamp __result__ = dateValue.timestampValue(cal);
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            timestamp2 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return timestamp2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                timestamp = null;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            URL uRL;
            block10: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing Unsupported Feature: ");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwUnsupportedFeatureSqlException();
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    uRL = null;
                    if (!TRACE || OracleLog.recursiveTrace) break block10;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return uRL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            String string;
            block10: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 23getCursorName");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName");
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    string = null;
                    if (!TRACE || OracleLog.recursiveTrace) break block10;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        block10: {
            block8: {
                block9: {
                    try {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl32
                        if (!(datum instanceof NCLOB)) break block8;
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (NCLOB)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var3_3 = (NCLOB)datum;
                        if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block9;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable var4_5) {
                        if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var4_5;
                    }
                    ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return var3_3;
            }
            if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
lbl32:
            // 2 sources

            if (ArrayDataResultSet.TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            var3_4 = null;
            if (!ArrayDataResultSet.TRACE || OracleLog.recursiveTrace) break block10;
            OracleLog.recursiveTrace = true;
            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return var3_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNString(int columnIndex) throws SQLException {
        String string;
        block9: {
            block7: {
                String string2;
                block8: {
                    try {
                        Datum datum;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) break block7;
                        String __result__ = datum.stringValue();
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        string2 = __result__;
                        if (!TRACE || OracleLog.recursiveTrace) break block8;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return string2;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            string = null;
            if (!TRACE || OracleLog.recursiveTrace) break block9;
            OracleLog.recursiveTrace = true;
            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        Reader reader;
        block9: {
            block7: {
                Reader reader2;
                block8: {
                    try {
                        Datum datum;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) break block7;
                        Reader __result__ = datum.characterStreamValue();
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        reader2 = __result__;
                        if (!TRACE || OracleLog.recursiveTrace) break block8;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return reader2;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            reader = null;
            if (!TRACE || OracleLog.recursiveTrace) break block9;
            OracleLog.recursiveTrace = true;
            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        ROWID rOWID;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                    OracleLog.recursiveTrace = false;
                }
                ROWID __result__ = this.getROWID(columnIndex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                rOWID = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return rOWID;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing Unsupported Feature: ");
            OracleLog.recursiveTrace = false;
        }
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBeforeFirst() throws SQLException {
        boolean bl;
        block5: {
            try {
                boolean __result__;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                boolean bl2 = __result__ = this.currentIndex < 1;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfterLast() throws SQLException {
        boolean bl;
        block5: {
            try {
                boolean __result__;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                boolean bl2 = __result__ = this.currentIndex > this.lastIndex;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFirst() throws SQLException {
        boolean bl;
        block5: {
            try {
                boolean __result__;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                boolean bl2 = __result__ = this.currentIndex == 1;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLast() throws SQLException {
        boolean bl;
        block5: {
            try {
                boolean __result__;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                boolean bl2 = __result__ = this.currentIndex == this.lastIndex;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.currentIndex);
                    OracleLog.recursiveTrace = false;
                }
                n2 = this.currentIndex;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int rows) throws SQLException {
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (rows < 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayDataResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
                } else {
                    this.fetchSize = rows == 0 ? OracleConnection.DEFAULT_ROW_PREFETCH : rows;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchSize() throws SQLException {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.fetchSize);
                    OracleLog.recursiveTrace = false;
                }
                n2 = this.fetchSize;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            ArrayDataResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(OracleLog.TRACE_16, "return: " + this.connection);
                OracleLog.recursiveTrace = false;
            }
            PhysicalConnection physicalConnection = this.connection;
            return physicalConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ArrayDataResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.ArrayDataResultSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

