/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.aq;

import java.util.EventObject;
import java.util.logging.Logger;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.driver.OracleLog;

public abstract class AQNotificationEvent
extends EventObject {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:24_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AQNotificationEvent(Object source) {
        super(source);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                AQNotificationEvent.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(source));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                AQNotificationEvent.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    public abstract AQMessageProperties getMessageProperties();

    public abstract String getRegistration();

    public abstract byte[] getPayload();

    public abstract String getQueueName();

    public abstract byte[] getMessageId();

    public abstract String getConsumerName();

    public abstract String getConnectionInformation();

    public abstract EventType getEventType();

    @Override
    public abstract String toString();

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.aq");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.aq.AQNotificationEvent"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static enum EventType {
        REGULAR(0),
        DEREG(1);

        private final int code;

        private EventType(int _code) {
            this.code = _code;
        }

        public final int getCode() {
            return this.code;
        }
    }
}

