/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.Cursor;
import com.sybase.jdbc4.jdbc.DateObject;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.JdbcDataObject;
import com.sybase.jdbc4.jdbc.LimiterInputStream;
import com.sybase.jdbc4.jdbc.Param;
import com.sybase.jdbc4.jdbc.ParamManager;
import com.sybase.jdbc4.jdbc.ProtocolResultSet;
import com.sybase.jdbc4.jdbc.SybResultSet;
import com.sybase.jdbc4.jdbc.SybStatement;
import com.sybase.jdbc4.tds.SybBigDecimal;
import com.sybase.jdbc4.utils.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;

public class SybCursorResultSet
extends SybResultSet
implements com.sybase.jdbcx.SybCursorResultSet {
    protected Cursor _cursor;
    protected ParamManager _paramMgr;
    protected ParamManager _insertParamMgr;
    protected boolean _rowDeleted = false;
    protected boolean _rowUpdated = false;
    protected boolean _rowInserted = false;
    private int t = -4;

    protected SybCursorResultSet(SybStatement sybStatement, ProtocolResultSet protocolResultSet) throws SQLException {
        super(sybStatement, protocolResultSet);
        this._cursor = this._statement._cursor;
        this._concurType = this._cursor.getConcurrency();
        if (this._concurType != 1007) {
            int n2 = protocolResultSet.getMetaData().getColumnCount();
            this._paramMgr = new ParamManager(n2, sybStatement);
            this._insertParamMgr = new ParamManager(n2, sybStatement);
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        return this._cursor.getName();
    }

    @Override
    public int getConcurrency() throws SQLException {
        if (this._cursor == null) {
            ErrorMessage.raiseError("JZ00D");
        }
        return this._cursor.getConcurrency();
    }

    @Override
    public boolean next() throws SQLException {
        this.checkResultSet();
        this.clearWarnings();
        this.moveToCurrentRow();
        if (this.checkRowIndexBeforeProtocolNext()) {
            return false;
        }
        if (this._paramMgr != null) {
            try {
                this._paramMgr.clearParamArray(true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this._rowDeleted = false;
        this._rowUpdated = false;
        this._rowInserted = false;
        boolean bl = this._prs.next();
        if (!bl) {
            this.prepareForNextFetch();
            this._prs = this._cursor.fetch();
            bl = this._prs == null ? false : this._prs.next();
        }
        if (!bl) {
            if (this._statement != null && this._prs != null) {
                this._statement.setRowCount(this._prs.getCount());
            }
            this.adjustRowIndexesAfterProtocolNext();
        }
        return bl;
    }

    protected void prepareForNextFetch() throws SQLException {
        SQLWarning sQLWarning = this._prs.getWarnings();
        this._prs.clearWarnings();
        if (this._savedWarnings != null) {
            this._savedWarnings.setNextWarning(sQLWarning);
        } else {
            this._savedWarnings = sQLWarning;
        }
        this._prs.close(false);
        if (this._cm != null) {
            this._cm.doneReading();
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (this._rowIndex == -3) {
            this._rowIndex = this.t;
            this._rowInserted = false;
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        if (this._concurType == 1008) {
            if (this._rowIndex != -3) {
                this.t = this._rowIndex;
                this._rowIndex = -3;
                try {
                    this._insertParamMgr.clearParamArray(true);
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseError("JZ006", iOException.getMessage());
                }
            }
        } else {
            ErrorMessage.raiseError("JZ0BT", "moveToInsertRow()", this._concurTypeString);
        }
    }

    @Override
    protected void close(boolean bl) throws SQLException {
        this._cursor.close(true);
        super.close(bl);
    }

    @Override
    public boolean isLanguageCursor() {
        return this._cursor.isLanguageCursor();
    }

    @Override
    public void setFetchSize(int n2) throws SQLException {
        if (n2 == 0) {
            return;
        }
        int n3 = this._statement.getMaxRows();
        if (n2 < 0 || n3 > 0 && n2 > n3) {
            ErrorMessage.raiseError("JZ0BI");
        }
        this._cursor.setFetchSize(n2);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this._cursor.getFetchSize();
    }

    @Override
    public void insertRow() throws SQLException {
        int n2;
        this.checkUpdatability("insertRow()");
        if (this._rowIndex != -3) {
            ErrorMessage.raiseError("JZ0BR", "insertRow()");
        }
        String string = "INSERT INTO " + this._cursor.getTable() + " ";
        ResultSetMetaData resultSetMetaData = this._prs.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        Param[] paramArray = this._insertParamMgr.getParams();
        boolean bl = true;
        for (n2 = 0; n2 < n3; ++n2) {
            if (paramArray[n2]._sqlType == -999) continue;
            string = !bl ? string + ", " : string + "( ";
            string = string + resultSetMetaData.getColumnName(n2 + 1);
            bl = false;
        }
        if (!bl) {
            string = string + " ) ";
            bl = true;
        }
        string = string + "VALUES (";
        n2 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (paramArray[i2]._sqlType == -999) {
                paramArray[i2]._sqlType = -998;
                continue;
            }
            if (!bl) {
                string = string + ", ";
                n2 += 2;
            }
            string = string + "?";
            bl = false;
            paramArray[i2]._paramMarkerOffset = n2++;
        }
        if (1 == this._cursor.insert(this._prs, this._insertParamMgr, string = string + ")")) {
            this._rowInserted = true;
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this._rowUpdated;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this._rowDeleted;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this._rowInserted;
    }

    @Override
    public void updateNull(int n2) throws SQLException {
        this.checkUpdatability("updateNull(int)");
        int n3 = this.getMetaData().getColumnType(n2);
        this.a(n3, n2, null);
    }

    @Override
    public void updateBoolean(int n2, boolean bl) throws SQLException {
        this.checkUpdatability("updateBoolean(int, boolean)");
        Boolean bl2 = new Boolean(bl);
        this.a(-7, n2, bl2);
    }

    @Override
    public void updateByte(int n2, byte by) throws SQLException {
        this.checkUpdatability("updateByte(int, byte)");
        Integer n3 = new Integer(by);
        if (n3 < 0) {
            this.a(5, n2, n3);
        } else {
            this.a(-6, n2, n3);
        }
    }

    @Override
    public void updateShort(int n2, short s2) throws SQLException {
        this.checkUpdatability("updateShort(int, short)");
        Integer n3 = new Integer(s2);
        this.a(5, n2, n3);
    }

    @Override
    public void updateInt(int n2, int n3) throws SQLException {
        this.checkUpdatability("updateInt(int, int)");
        Integer n4 = new Integer(n3);
        this.a(4, n2, n4);
    }

    @Override
    public void updateLong(int n2, long l2) throws SQLException {
        this.checkUpdatability("updateLong(int, long)");
        Long l3 = new Long(l2);
        this.a(-5, n2, l3);
    }

    @Override
    public void updateFloat(int n2, float f2) throws SQLException {
        this.checkUpdatability("updateFloat(int, float)");
        Float f3 = new Float(f2);
        this.a(7, n2, f3);
    }

    @Override
    public void updateDouble(int n2, double d2) throws SQLException {
        this.checkUpdatability("updateDouble(int, double)");
        Double d3 = new Double(d2);
        this.a(8, n2, d3);
    }

    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.checkUpdatability("updateBigDecimal(int, BigDecimal)");
        if (bigDecimal == null) {
            this.a(2, n2, bigDecimal);
        } else {
            this.a(2, n2, bigDecimal, bigDecimal.scale());
        }
    }

    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal, int n3, int n4) throws SQLException {
        this.checkUpdatability("updateBigDecimal(int, BigDecimal, int, int)");
        if (bigDecimal == null) {
            bigDecimal = new BigDecimal("0");
        }
        SybBigDecimal sybBigDecimal = new SybBigDecimal(bigDecimal, n3, n4);
        this.a(2, n2, sybBigDecimal);
    }

    @Override
    public void updateString(int n2, String string) throws SQLException {
        this.checkUpdatability("updateString(int, String)");
        this.a(12, n2, string);
    }

    @Override
    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.checkUpdatability("updateBytes(int, byte[])");
        int n3 = 0;
        if (byArray != null) {
            n3 = byArray.length;
        }
        if (n3 > 255) {
            this.a(-4, n2, byArray);
        } else {
            this.a(-3, n2, byArray);
        }
    }

    @Override
    public void updateDate(int n2, Date date) throws SQLException {
        this.checkUpdatability("updateDate(int, java.sql.Date)");
        this.a(91, n2, new DateObject((Object)date, 91));
    }

    @Override
    public void updateTime(int n2, Time time) throws SQLException {
        this.checkUpdatability("updateTime(int, java.sql.Time)");
        this.a(92, n2, new DateObject((Object)time, 92));
    }

    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.checkUpdatability("updateTimestamp(int, java.sql.Timestamp)");
        this.a(93, n2, new DateObject((Object)timestamp, 93));
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkUpdatability("updateAsciiStream(int, java.io.InputStream, int)");
        try {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new LimiterInputStream(inputStream, n3), "ISO8859_1");
            this.a(-1, n2, inputStreamReader, n3);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkUpdatability("updateBinaryStream(int, java.io.InputStream, int)");
        this.a(-4, n2, inputStream, n3);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.checkUpdatability("updateCharacterStream(int, java.io.Reader, int)");
        this.a(-1, n2, reader, n3);
    }

    @Override
    public void updateObject(int n2, Object object, int n3) throws SQLException {
        this.checkUpdatability("updateObject(int, Object, int)");
        if (object == null) {
            this.updateNull(n2);
        } else if (object instanceof String) {
            this.updateString(n2, (String)object);
        } else if (object instanceof BigDecimal) {
            this.a(2, n2, object, n3);
        } else if (object instanceof Boolean) {
            this.a(-7, n2, object, n3);
        } else if (object instanceof Integer) {
            this.a(4, n2, object, n3);
        } else if (object instanceof Long) {
            this.a(-5, n2, object, n3);
        } else if (object instanceof Float) {
            this.a(7, n2, object, n3);
        } else if (object instanceof Double) {
            this.a(8, n2, object, n3);
        } else if (object instanceof byte[]) {
            this.updateBytes(n2, (byte[])object);
        } else if (object instanceof Date) {
            this.updateDate(n2, (Date)object);
        } else if (object instanceof Time) {
            this.updateTime(n2, (Time)object);
        } else if (object instanceof Timestamp) {
            this.updateTimestamp(n2, (Timestamp)object);
        } else if (object instanceof Serializable) {
            this.a(2000, n2, object, n3);
        } else {
            ErrorMessage.raiseError("JZ0SE");
        }
    }

    @Override
    public void updateObject(int n2, Object object) throws SQLException {
        this.checkUpdatability("updateObject(int, Object)");
        int n3 = 0;
        if (object != null && object instanceof BigDecimal) {
            n3 = ((BigDecimal)object).scale();
        }
        this.updateObject(n2, object, n3);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.checkUpdatability("updateNull(String)");
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.checkUpdatability("updateBoolean(String, boolean)");
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.checkUpdatability("updateByte(String, byte)");
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateShort(String string, short s2) throws SQLException {
        this.checkUpdatability("updateShort(String, short)");
        this.updateShort(this.findColumn(string), s2);
    }

    @Override
    public void updateInt(String string, int n2) throws SQLException {
        this.checkUpdatability("updateInt(String, int)");
        this.updateInt(this.findColumn(string), n2);
    }

    @Override
    public void updateLong(String string, long l2) throws SQLException {
        this.checkUpdatability("updateLong(String, long)");
        this.updateLong(this.findColumn(string), l2);
    }

    @Override
    public void updateFloat(String string, float f2) throws SQLException {
        this.checkUpdatability("updateFloat(String, float)");
        this.updateFloat(this.findColumn(string), f2);
    }

    @Override
    public void updateDouble(String string, double d2) throws SQLException {
        this.checkUpdatability("updateDouble(String, double)");
        this.updateDouble(this.findColumn(string), d2);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.checkUpdatability("updateBigDecimal(String, BigDecimal)");
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal, int n2, int n3) throws SQLException {
        this.checkUpdatability("updateBigDecimal(String, BigDecimal, int, int)");
        this.updateBigDecimal(this.findColumn(string), bigDecimal, n2, n3);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.checkUpdatability("updateString(String, String)");
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.checkUpdatability("updateBytes(String, byte[])");
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.checkUpdatability("updateDate(String, java.sql.Date)");
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.checkUpdatability("updateTime(String, java.sql.Time)");
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.checkUpdatability("updateTimestamp(String, java.sql.Timestamp)");
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.checkUpdatability("updateAsciiStream(String, java.io.InputStream, int)");
        this.updateAsciiStream(this.findColumn(string), inputStream, n2);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.checkUpdatability("updateBinaryStream(String, java.io.InputStream, int)");
        this.updateBinaryStream(this.findColumn(string), inputStream, n2);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.checkUpdatability("updateCharacterStream(String, java.io.Reader, int)");
        this.updateCharacterStream(this.findColumn(string), reader, n2);
    }

    @Override
    public void updateObject(String string, Object object, int n2) throws SQLException {
        this.checkUpdatability("updateObject(String, Object, int)");
        int n3 = 0;
        if (object != null && object instanceof BigDecimal) {
            n3 = ((BigDecimal)object).scale();
        }
        this.updateObject(this.findColumn(string), object, n3);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.checkUpdatability("updateObject(String, Object)");
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public void updateNString(int n2, String string) throws SQLException {
        this.checkUpdatability("updateNString(int, String)");
        this.a(-9, n2, string);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        this.checkUpdatability("updateNString(String, String)");
        this.updateNString(this.findColumn(string), string2);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader) throws SQLException {
        this.checkUpdatability("updateNCharacterStream(int, java.io.Reader)");
        this.a(-1, n2, reader, -1);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.checkUpdatability("updateNCharacterStream(String, java.io.Reader)");
        this.updateNCharacterStream(this.findColumn(string), reader);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.checkUpdatability("updateNCharacterStream(int, java.io.Reader, long)");
        int n3 = this.a(l2);
        this.a(-1, n2, reader, n3);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        this.checkUpdatability("updateNCharacterStream(String, java.io.Reader, long)");
        this.updateNCharacterStream(this.findColumn(string), reader, l2);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream) throws SQLException {
        this.checkUpdatability("updateAsciiStream(int, java.io.InputStream)");
        try {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new LimiterInputStream(inputStream, -1), "ISO8859_1");
            this.a(-1, n2, inputStreamReader, -1);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.checkUpdatability("updateAsciiStream(String, java.io.InputStream)");
        this.updateAsciiStream(this.findColumn(string), inputStream);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.checkUpdatability("updateAsciiStream(int, java.io.InputStream, long)");
        int n3 = this.a(l2);
        try {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new LimiterInputStream(inputStream, n3), "ISO8859_1");
            this.a(-1, n2, inputStreamReader, n3);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        this.checkUpdatability("updateAsciiStream(int, java.io.InputStream, long)");
        this.updateAsciiStream(this.findColumn(string), inputStream, l2);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream) throws SQLException {
        this.checkUpdatability("updateBinaryStream(int, java.io.InputStream)");
        this.a(-4, n2, inputStream, -1);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.checkUpdatability("updateBinaryStream(String, java.io.InputStream)");
        this.updateBinaryStream(this.findColumn(string), inputStream, -1);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.checkUpdatability("updateBinaryStream(int, java.io.InputStream, long)");
        int n3 = this.a(l2);
        this.a(-4, n2, inputStream, n3);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        this.checkUpdatability("updateBinaryStream(int, java.io.InputStream, long)");
        this.updateBinaryStream(this.findColumn(string), inputStream, l2);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader) throws SQLException {
        this.checkUpdatability("updateCharacterStream(int, java.io.Reader)");
        this.a(-1, n2, reader, -1);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.checkUpdatability("updateCharacterStream(int, java.io.Reader)");
        this.updateCharacterStream(this.findColumn(string), reader);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.checkUpdatability("updateCharacterStream(int, java.io.Reader, long)");
        int n3 = this.a(l2);
        this.a(-1, n2, reader, n3);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l2) throws SQLException {
        this.checkUpdatability("updateCharacterStream(int, java.io.Reader, long)");
        this.updateCharacterStream(this.findColumn(string), reader, l2);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkUpdatability("cancelRowUpdates()");
        if (this._rowDeleted || this._rowUpdated || this._rowInserted) {
            ErrorMessage.raiseError("JZ0RM", "cancelRowUpdates");
        }
        try {
            this._paramMgr.clearParamArray(true);
            this._insertParamMgr.clearParamArray(true);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkUpdatability("deleteRow()");
        int n2 = this._cursor.delete(this._prs);
        if (n2 > 0) {
            this._rowDeleted = true;
        }
    }

    @Override
    public void deleteRow(String string) throws SQLException {
        this.checkUpdatability("deleteRow(String)");
        this._cursor.setTable(string);
        int n2 = this._cursor.delete(this._prs);
        if (n2 > 0) {
            this._rowDeleted = true;
        }
    }

    @Override
    public void updateRow() throws SQLException {
        int n2;
        this.checkUpdatability("updateRow()");
        StringBuffer stringBuffer = new StringBuffer("UPDATE " + this._cursor.getTable() + " SET ");
        int n3 = stringBuffer.length();
        ResultSetMetaData resultSetMetaData = this._prs.getMetaData();
        int n4 = resultSetMetaData.getColumnCount();
        Param[] paramArray = this._paramMgr.getParams();
        boolean bl = true;
        for (n2 = 0; n2 < n4; ++n2) {
            if (paramArray[n2]._sqlType == -999) {
                paramArray[n2]._sqlType = -998;
                continue;
            }
            if (paramArray[n2]._sqlType == -998) continue;
            if (!bl) {
                stringBuffer.append(", ");
                n3 += 2;
            }
            String string = resultSetMetaData.getColumnName(n2 + 1);
            n3 += string.length() + 3;
            stringBuffer.append(string + " = ?");
            paramArray[n2]._paramMarkerOffset = n3++;
            bl = false;
        }
        if (bl) {
            ErrorMessage.raiseError("JZ00G");
        }
        if (1 == this._cursor.update(this._prs, this._paramMgr, stringBuffer.toString())) {
            this._rowUpdated = true;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (paramArray[n2]._sqlType != -998) continue;
            paramArray[n2]._sqlType = -999;
        }
    }

    @Override
    public void updateRow(String string) throws SQLException {
        this.checkUpdatability("updateRow(String)");
        this._cursor.setTable(string);
        this.updateRow();
    }

    private void a(int n2, int n3, Object object) throws SQLException {
        this.a(n2, n3, object, 0);
    }

    private void a(int n2, int n3, Object object, int n4) throws SQLException {
        this.checkResultSet();
        if (this._paramMgr != null) {
            if (this._rowIndex != -3) {
                this._paramMgr.setParam(n3, n2, object, n4);
            } else {
                this._insertParamMgr.setParam(n3, n2, object, n4);
                this._rowInserted = false;
            }
        } else {
            ErrorMessage.raiseError("JZ00H");
        }
    }

    @Override
    protected JdbcDataObject getColumn(int n2) throws SQLException {
        this.checkResultSet();
        if (this._rowIndex == -3) {
            Param[] paramArray = this._insertParamMgr.getParams();
            if (n2 < 1 || n2 > paramArray.length) {
                ErrorMessage.raiseError("JZ008", "" + n2);
            }
            this._currentColumn = paramArray[n2 - 1]._sqlType == -999 || paramArray[n2 - 1]._sqlType == -998 ? null : (JdbcDataObject)((Object)paramArray[n2 - 1]);
        } else if (this._paramMgr != null) {
            Param[] paramArray = this._paramMgr.getParams();
            if (n2 < 1 || n2 > paramArray.length) {
                ErrorMessage.raiseError("JZ008", "" + n2);
            }
            this.checkIfReadableRow();
            this._currentColumn = paramArray[n2 - 1]._sqlType == -999 || paramArray[n2 - 1]._sqlType == -998 ? this._prs.getColumn(n2) : (JdbcDataObject)((Object)paramArray[n2 - 1]);
        } else {
            this.checkIfReadableRow();
            this._currentColumn = this._prs.getColumn(n2);
        }
        return this._currentColumn;
    }

    @Override
    protected void checkIfReadableRow() throws SQLException {
        if (this._rowDeleted) {
            ErrorMessage.raiseError("JZ0RD");
        }
        if (this._rowIndex == -1) {
            ErrorMessage.raiseError("JZ0R1");
        } else if (this._rowIndex == -2) {
            ErrorMessage.raiseError("JZ0R5");
        }
    }

    @Override
    protected void checkForScrollability(String string) throws SQLException {
        switch (this._scrollType) {
            case 1003: {
                ErrorMessage.raiseError("JZ0BT", string, "TYPE_FORWARD_ONLY");
                break;
            }
            case 1004: {
                if (!this._cursor.isLanguageCursor()) break;
                ErrorMessage.raiseError("JZ0LC", string);
                break;
            }
            case 1005: {
                Debug.notImplemented(this, string + " for TYPE_SCROLL_SENSITIVE");
                break;
            }
        }
    }

    protected void checkUpdatability(String string) throws SQLException {
        if (this._concurType == 1007) {
            ErrorMessage.raiseError("JZ0BT", string, this._concurTypeString);
        }
    }

    private int a(long l2) {
        int n2;
        if (l2 > Integer.MAX_VALUE) {
            n2 = Integer.MAX_VALUE;
            this._statement._context._conn.chainWarnings(ErrorMessage.createWarning("01S11"));
        } else {
            n2 = (int)l2;
        }
        return n2;
    }
}

