/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.jdbc.DateObject;
import com.sybase.jdbc3.tds.BlobOutputStream;
import com.sybase.jdbc3.tds.DataFormat;
import com.sybase.jdbc3.tds.SrvCapabilityToken;
import com.sybase.jdbc3.tds.SrvDataFormat;
import com.sybase.jdbc3.tds.SrvFormatToken;
import com.sybase.jdbc3.tds.SrvTypeException;
import com.sybase.jdbc3.tds.SrvTypeFormatter;
import com.sybase.jdbc3.tds.SybBigDecimal;
import com.sybase.jdbc3.tds.TdsDateTime;
import com.sybase.jdbc3.tds.TdsNumeric;
import com.sybase.jdbc3.tds.TdsOutputStream;
import com.sybase.jdbc3.tds.Token;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;

public class SrvSQLTypeFormatter
extends SrvTypeFormatter {
    ResultSet _rs = null;
    static Hashtable _formatmap = new Hashtable();

    public SrvSQLTypeFormatter(SrvFormatToken srvFormatToken, SrvCapabilityToken srvCapabilityToken) {
        super(srvFormatToken, srvCapabilityToken);
    }

    public void addFormat(DataFormat dataFormat) {
        this._format.addFormat(dataFormat);
    }

    public DataFormat[] buildDataFormat(ResultSet resultSet) throws IOException {
        DataFormat[] dataFormatArray = null;
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            if (n == 0) {
                throw new SrvTypeException("Cannot format result set with  0 columns");
            }
            dataFormatArray = new SrvDataFormat[n];
            for (int i = 1; i <= n; ++i) {
                int n2;
                Object v = _formatmap.get(new Integer(resultSetMetaData.getColumnType(i)));
                if (v == null) {
                    throw new SrvTypeException("Cannot map JDBC type " + resultSetMetaData.getColumnTypeName(i) + " to TDS type");
                }
                int[] nArray = (int[])v;
                if (this._cap.handlesDataType(nArray[1])) {
                    n2 = 0;
                    if (resultSetMetaData.isNullable(i) == 1) {
                        n2 |= 0x20;
                    }
                    if (resultSetMetaData.isWritable(i)) {
                        n2 |= 0x10;
                    }
                } else {
                    throw new SrvTypeException("Not handling client literal  conversion for JDBC types " + resultSetMetaData.getColumnTypeName(i));
                }
                dataFormatArray[i - 1] = new SrvDataFormat(resultSetMetaData.getColumnName(i), nArray[1], n2, nArray[2], resultSetMetaData.getPrecision(i), resultSetMetaData.getScale(i), null);
            }
        }
        catch (SQLException sQLException) {
            throw new SrvTypeException("SQL to TDS conversion error: " + sQLException);
        }
        return dataFormatArray;
    }

    public void convertData(Token token, ResultSet resultSet) throws IOException {
        this._rs = resultSet;
        this.setFormatter(token, this);
    }

    public void sendDataStream(TdsOutputStream tdsOutputStream) throws IOException {
        try {
            if (this._rs.getMetaData().getColumnCount() != this._format.getFormatCount()) {
                throw new SrvTypeException("Format column count(" + this._format.getFormatCount() + ") does not match row column count (" + this._rs.getMetaData().getColumnCount() + ")");
            }
            block44: for (int i = 1; i <= this._format.getFormatCount(); ++i) {
                DataFormat dataFormat = this._format.formatAt(i - 1);
                switch (dataFormat._datatype) {
                    case 50: {
                        if (this._rs.getBoolean(i)) {
                            tdsOutputStream.writeByte(1);
                            continue block44;
                        }
                        tdsOutputStream.writeByte(0);
                        continue block44;
                    }
                    case 39: 
                    case 47: {
                        byte[] byArray = tdsOutputStream.stringToByte(this._rs.getString(i));
                        if (byArray == null) {
                            tdsOutputStream.writeByte(0);
                            continue block44;
                        }
                        tdsOutputStream.writeByte(byArray.length);
                        tdsOutputStream.write(byArray);
                        continue block44;
                    }
                    case 175: {
                        byte[] byArray = tdsOutputStream.stringToByte(this._rs.getString(i));
                        if (byArray == null) {
                            tdsOutputStream.writeInt(0);
                            continue block44;
                        }
                        tdsOutputStream.writeInt(byArray.length);
                        tdsOutputStream.write(byArray);
                        continue block44;
                    }
                    case 225: {
                        byte[] byArray = this._rs.getBytes(i);
                        if (this._rs.wasNull()) {
                            tdsOutputStream.writeByte(0);
                            continue block44;
                        }
                        tdsOutputStream.writeInt(byArray.length);
                        tdsOutputStream.write(byArray);
                        continue block44;
                    }
                    case 48: {
                        tdsOutputStream.writeByte((int)this._rs.getByte(i));
                        continue block44;
                    }
                    case 52: {
                        tdsOutputStream.writeShort((int)this._rs.getShort(i));
                        continue block44;
                    }
                    case 56: {
                        tdsOutputStream.writeInt(this._rs.getInt(i));
                        continue block44;
                    }
                    case 191: {
                        tdsOutputStream.writeLong(this._rs.getLong(i));
                        continue block44;
                    }
                    case 38: {
                        int n = this._rs.getInt(i);
                        if (this._rs.wasNull()) {
                            tdsOutputStream.writeByte(0);
                            continue block44;
                        }
                        tdsOutputStream.writeByte(dataFormat._length);
                        switch (dataFormat._length) {
                            case 1: {
                                tdsOutputStream.writeByte((int)((byte)n));
                                break;
                            }
                            case 2: {
                                tdsOutputStream.writeShort((int)((short)n));
                                break;
                            }
                            case 4: {
                                tdsOutputStream.writeInt(n);
                                break;
                            }
                            case 8: {
                                tdsOutputStream.writeLong((long)n);
                            }
                        }
                        continue block44;
                    }
                    case 59: {
                        tdsOutputStream.writeFloat(this._rs.getFloat(i));
                        continue block44;
                    }
                    case 62: {
                        tdsOutputStream.writeDouble(this._rs.getDouble(i));
                        continue block44;
                    }
                    case 109: {
                        float f = 0.0f;
                        double d = 0.0;
                        switch (dataFormat._length) {
                            case 4: {
                                f = this._rs.getFloat(i);
                                break;
                            }
                            case 8: {
                                d = this._rs.getDouble(i);
                            }
                        }
                        if (this._rs.wasNull()) {
                            tdsOutputStream.writeByte(0);
                            continue block44;
                        }
                        tdsOutputStream.writeByte(dataFormat._length);
                        switch (dataFormat._length) {
                            case 4: {
                                tdsOutputStream.writeFloat(f);
                                break;
                            }
                            case 8: {
                                tdsOutputStream.writeDouble(d);
                            }
                        }
                        continue block44;
                    }
                    case 37: {
                        byte[] byArray = this._rs.getBytes(i);
                        if (this._rs.wasNull()) {
                            tdsOutputStream.writeByte(0);
                            continue block44;
                        }
                        tdsOutputStream.writeByte(byArray.length);
                        tdsOutputStream.write(byArray);
                        continue block44;
                    }
                    case 106: 
                    case 108: {
                        BigDecimal bigDecimal = this._rs.getBigDecimal(i, dataFormat._scale);
                        if (this._rs.wasNull()) {
                            tdsOutputStream.writeByte(0);
                            continue block44;
                        }
                        bigDecimal = new SybBigDecimal(bigDecimal, dataFormat._precision, dataFormat._scale);
                        Object object = new int[4];
                        Object object2 = TdsNumeric.tdsNumeric((BigDecimal)bigDecimal, (int)dataFormat._scale, (int[])object);
                        tdsOutputStream.writeByte((int)object[1]);
                        if (object[1] <= 0) continue block44;
                        tdsOutputStream.write((byte[])object2);
                        continue block44;
                    }
                    case 111: {
                        Object object = null;
                        switch (this._rs.getMetaData().getColumnType(i)) {
                            case 92: {
                                object = new DateObject((Object)this._rs.getTime(i), 92);
                                break;
                            }
                            case 91: {
                                object = new DateObject((Object)this._rs.getDate(i), 91);
                                break;
                            }
                            case 93: {
                                object = new DateObject((Object)this._rs.getTimestamp(i), 93);
                            }
                        }
                        if (this._rs.wasNull()) {
                            tdsOutputStream.writeByte(0);
                            continue block44;
                        }
                        Object object2 = TdsDateTime.tdsDateTime((DateObject)object);
                        tdsOutputStream.writeByte(8);
                        tdsOutputStream.writeInt((int)object2[0]);
                        tdsOutputStream.writeInt((int)object2[1]);
                        continue block44;
                    }
                    case 49: 
                    case 123: {
                        Object object = null;
                        object = new DateObject((Object)this._rs.getDate(i), 91);
                        if (this._rs.wasNull()) {
                            tdsOutputStream.writeByte(0);
                            continue block44;
                        }
                        Object object2 = TdsDateTime.tdsDateTime((DateObject)object);
                        tdsOutputStream.writeByte(4);
                        tdsOutputStream.writeInt((int)object2[0]);
                        continue block44;
                    }
                    case 51: 
                    case 147: {
                        Object object = null;
                        object = new DateObject((Object)this._rs.getTime(i), 92);
                        if (this._rs.wasNull()) {
                            tdsOutputStream.writeByte(0);
                            continue block44;
                        }
                        Object object2 = TdsDateTime.tdsDateTime((DateObject)object);
                        tdsOutputStream.writeByte(4);
                        tdsOutputStream.writeInt((int)object2[1]);
                        continue block44;
                    }
                    case 36: {
                        Object object2;
                        switch (dataFormat._blobType) {
                            case 1: {
                                object2 = this._rs.getObject(i);
                                tdsOutputStream.writeByte(1);
                                tdsOutputStream.writeShort(0);
                                if (object2 == null) {
                                    tdsOutputStream.writeInt(0);
                                    continue block44;
                                }
                                BlobOutputStream blobOutputStream = new BlobOutputStream((DataOutput)tdsOutputStream);
                                ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)blobOutputStream);
                                objectOutputStream.writeObject(object2);
                                objectOutputStream.close();
                                continue block44;
                            }
                        }
                        throw new SrvTypeException("Unmappable blob data type: " + this._rs.getMetaData().getColumnType(i));
                    }
                    default: {
                        throw new SrvTypeException("Unmappable java data type: " + this._rs.getMetaData().getColumnType(i));
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new SrvTypeException("SQL error on type conversion: " + sQLException);
        }
    }

    static {
        int[][] nArrayArray = new int[][]{{-7, 50, 0, 0, 0}, {-6, 38, 1, 48, 0}, {5, 38, 2, 52, 0}, {4, 38, 4, 56, 0}, {-5, 38, 8, 0, 0}, {7, 109, 4, 0, 0}, {6, 109, 8, 0, 0}, {8, 109, 8, 0, 0}, {2, 108, 33, 0, 0}, {3, 106, 33, 0, 0}, {1, 39, 255, 0, 0}, {12, 39, 255, 0, 0}, {-1, 175, 16384, 0, 0}, {-4, 225, 16384, 0, 0}, {91, 123, 4, 0, 0}, {92, 147, 4, 0, 0}, {93, 111, 8, 0, 0}, {-2, 37, 255, 0, 0}, {-3, 37, 255, 0, 0}, {2000, 9217, 0, 0, 0}};
        for (int i = 0; i < nArrayArray.length; ++i) {
            _formatmap.put(new Integer(nArrayArray[i][0]), nArrayArray[i]);
        }
    }
}

