/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.tds.Dumpable;
import com.sybase.jdbc3.tds.SrvAttentionException;
import com.sybase.jdbc3.utils.DumpFilter;
import com.sybase.jdbc3.utils.DumpInfo;
import java.io.IOException;

public final class SrvPdu
implements Dumpable {
    public static final int NETHDRSIZE = 8;
    int _msgType = 0;
    int _msgStatus = 0;
    int _length = 0;
    int _channel = 0;
    int _packet = 0;
    int _window = 0;
    int _packetSize = 512;
    String _charset = new String("ISO8859_1");
    boolean _eom = false;
    boolean _attention = false;
    boolean _inBulk = false;
    boolean _bulkNotified = true;

    protected void setpdu() {
        this._msgType = 15;
        this._msgStatus = 0;
        this._length = 0;
    }

    protected void setpdu(byte[] byArray, boolean bl, int n, int n2) {
        this._msgType = n2;
        this._msgStatus = bl ? (this._msgStatus |= 1) : (this._msgStatus |= 0);
        this._length = n;
        byArray[0] = (byte)this._msgType;
        byArray[1] = (byte)this._msgStatus;
        byArray[2] = (byte)(this._length >>> 8 & 0xFF);
        byArray[3] = (byte)(this._length & 0xFF);
        byArray[4] = (byte)(this._channel >>> 8 & 0xFF);
        byArray[5] = (byte)(this._channel & 0xFF);
        byArray[6] = (byte)this._packet;
        byArray[7] = (byte)this._window;
    }

    public void setpdu(byte[] byArray) throws SrvAttentionException {
        this._msgType = byArray[0];
        this._msgStatus = byArray[1];
        this._length = ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
        this._channel = ((byArray[4] & 0xFF) << 8) + (byArray[5] & 0xFF);
        this._packet = byArray[6];
        this._window = byArray[7];
        if (this._msgType == 6) {
            throw new SrvAttentionException();
        }
        if (this._msgType == 7 && !this._inBulk) {
            this._inBulk = true;
            this._bulkNotified = false;
        }
    }

    protected boolean bulkOccurred() {
        if (!this._bulkNotified) {
            this._bulkNotified = true;
            return true;
        }
        return false;
    }

    public int dataLength() {
        return this._length - 8;
    }

    protected static int size() {
        return 8;
    }

    protected void init() {
        this._msgStatus = 0;
    }

    public String toString() {
        return "PDU Header: type " + this._msgType + ", status " + this._msgStatus + ", length " + this._length + ", channel " + this._channel + ", window " + this._window + ", packet size " + this._packetSize;
    }

    public int getStatus() {
        return this._msgStatus;
    }

    public int getType() {
        return this._msgType;
    }

    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(256)) {
            dumpInfo = dumpFilter.getDumpInfo();
            dumpInfo.addInfo("Token", 0, "PDU Header");
            String[] stringArray = new String[]{"<unrecognized>", "BUF_LANG", "BUF_LOGIN", "BUF_RPC", "BUF_RESPONSE", "BUF_UNFMT", "BUF_ATTN", "BUF_BULK ", "BUF_SETUP", "BUF_CLOSE ", "BUF_ERROR", "BUF_PROTACK ", "BUF_ECHO", "BUF_LOGOUT", "BUF_ENDPARAM", "BUF_NORMAL", "BUF_URGENT", "BUF_MIGRATE"};
            dumpInfo.addField("TDS Packet Type", 1, this._msgType, stringArray);
            String[] stringArray2 = new String[]{"BUFSTAT_BEGIN", "BUFSTAT_EOM", "BUFSTAT_ATTNACK", "BUFSTAT_ATTN", "BUFSTAT_EVENT"};
            dumpInfo.addBitfield("Status", 1, this._msgStatus, stringArray2);
            dumpInfo.addInt("Length", 2, this._length);
            dumpInfo.addInt("Channel", 2, this._channel);
            dumpInfo.addInt("Packet No.", 1, this._packet);
            dumpInfo.addInt("Window", 1, this._window);
        }
        return dumpInfo;
    }

    public int getTokenType() {
        return 256;
    }
}

