/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.tds.Dumpable;
import com.sybase.jdbc3.tds.EedToken;
import com.sybase.jdbc3.tds.SrvDoneToken;
import com.sybase.jdbc3.tds.TdsInputStream;
import com.sybase.jdbc3.tds.TdsOutputStream;
import com.sybase.jdbc3.utils.DumpFilter;
import com.sybase.jdbc3.utils.DumpInfo;
import com.sybase.jdbc3.utils.HexConverts;
import java.io.IOException;

public class SrvEedToken
extends EedToken
implements Dumpable {
    protected int _totalLen;
    protected int _sqlStateLen;
    protected int _msgLen;
    protected int _serverNameLen;
    protected int _procNameLen;

    public SrvEedToken(TdsInputStream tdsInputStream) throws IOException {
        try {
            this._totalLen = tdsInputStream.readShort();
            this._msgNumber = tdsInputStream.readInt();
            this._state = tdsInputStream.readUnsignedByte();
            this._class = tdsInputStream.readUnsignedByte();
            this._sqlStateLen = tdsInputStream.readUnsignedByte();
            this._sqlState = tdsInputStream.readString(this._sqlStateLen);
            this._status = tdsInputStream.readUnsignedByte();
            this._tranState = tdsInputStream.readShort();
            this._msgLen = tdsInputStream.readShort();
            this._msg = tdsInputStream.readString(this._msgLen);
            this._serverNameLen = tdsInputStream.readUnsignedByte();
            this._serverName = tdsInputStream.readString(this._serverNameLen);
            this._procNameLen = tdsInputStream.readUnsignedByte();
            this._procName = tdsInputStream.readString(this._procNameLen);
            this._lineNum = tdsInputStream.readShort();
            this._params = null;
        }
        catch (IOException iOException) {
            SrvEedToken.readSQE((IOException)iOException);
        }
    }

    public SrvEedToken(int n, int n2, int n3, String string, int n4, String string2, String string3, String string4, int n5) {
        this._msgNumber = n;
        this._state = n2;
        this._class = n3;
        this._sqlState = string == null ? new String() : string;
        this._sqlStateLen = this._sqlState.length();
        this._status = 0;
        this._tranState = n4;
        this._msg = string2 == null ? new String() : string2;
        this._msgLen = this._msg.length();
        this._serverName = string3 == null ? new String() : string3;
        this._serverNameLen = this._serverName.length();
        this._procName = string4 == null ? new String() : string4;
        this._procNameLen = this._procName.length();
        this._lineNum = n5;
        this._params = null;
        this._totalLen = 7 + this._sqlStateLen + 1 + 2 + 2 + this._msgLen + 1 + this._serverNameLen + 1 + this._procNameLen + 2;
    }

    public SrvEedToken(int n, String string, String string2, String string3, int n2) {
        this(n, 0, 11, new String("UNKWN"), 0, string, string2, string3, n2);
    }

    public void send(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeByte(229);
        byte[] byArray = tdsOutputStream.stringToByte(this._sqlState);
        byte[] byArray2 = tdsOutputStream.stringToByte(this._msg);
        byte[] byArray3 = tdsOutputStream.stringToByte(this._serverName);
        byte[] byArray4 = tdsOutputStream.stringToByte(this._procName);
        tdsOutputStream.writeShort(7 + byArray.length + 1 + 2 + 2 + byArray2.length + 1 + byArray3.length + 1 + byArray4.length + 2);
        tdsOutputStream.writeInt(this._msgNumber);
        tdsOutputStream.writeByte(this._state);
        tdsOutputStream.writeByte(this._class);
        tdsOutputStream.writeByte(byArray.length);
        tdsOutputStream.write(byArray);
        tdsOutputStream.writeByte(this._status);
        tdsOutputStream.writeShort(this._tranState);
        tdsOutputStream.writeShort(byArray2.length);
        tdsOutputStream.write(byArray2);
        if (byArray3.length == 0) {
            tdsOutputStream.writeByte(0);
        } else {
            tdsOutputStream.writeByte(byArray3.length);
            tdsOutputStream.write(byArray3);
        }
        if (byArray4.length == 0) {
            tdsOutputStream.writeByte(0);
        } else {
            tdsOutputStream.writeByte(byArray4.length);
            tdsOutputStream.write(byArray4);
        }
        tdsOutputStream.writeShort(this._lineNum);
    }

    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(229)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "EED Token (0x" + HexConverts.hexConvert((int)229, (int)1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "EED Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 2, this._totalLen);
            }
            if (dumpFilter.includesDetail(3) || dumpFilter.includesDetail(10)) {
                dumpInfo.addInt("Message Number", 4, this._msgNumber);
                dumpInfo.addInt("Message State", 1, this._state);
                dumpInfo.addInt("Message Class", 1, this._class);
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("SQL State Length", 1, this._sqlStateLen);
                }
                if (this._sqlStateLen > 0) {
                    dumpInfo.addText("SQL State", this._sqlStateLen, this._sqlState);
                }
                String[] stringArray = new String[]{"NO_EED", "EED_FOLLOWS", "EED_INFO"};
                dumpInfo.addBitfield("Status", 1, this._status, stringArray);
                dumpInfo.addField("Transaction State", 2, this._tranState, SrvDoneToken.TRANSTATE_NAMES);
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("Message Length", 2, this._msgLen);
                }
                if (this._msgLen > 0) {
                    dumpInfo.addText("Message Text", this._msgLen, this._msg);
                }
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("Server Name Length", 1, this._serverNameLen);
                }
                if (this._serverNameLen > 0) {
                    dumpInfo.addText("Server Name", this._serverNameLen, this._serverName);
                }
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("Stored Proc. Name Length", 1, this._procNameLen);
                }
                if (this._procNameLen > 0) {
                    dumpInfo.addText("Stored Proc. Name", this._procNameLen, this._procName);
                }
                dumpInfo.addInt("Line Number", 2, this._lineNum);
            }
        }
        return dumpInfo;
    }

    public int getTokenType() {
        return 229;
    }
}

