package com.idata.etl.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import com.idata.core.dataset.TabularDataSegment;
import com.idata.core.meta.MetaDataException;
import com.idata.core.meta.db.DataItem;
import com.idata.core.meta.db.DestinationMetaData;
import com.idata.core.meta.db.oracle.CommonTableHelper;
import com.idata.etl.TransferSession;
import com.idata.log.IDataLogger;

/**
 * the class represent transfer session that deliver all data into target table,
 * doesn't modify meta data
 * 
 * @author xiafqian
 * 
 */
public class SimpleTransferSession extends TransferSession {

	public SimpleTransferSession() {
		super();
	}

	public SimpleTransferSession(long sessionID, String sessionName) {
		super(sessionID, sessionName);
	}

	private String schema;

	private String targetName;

	private String query;

	private DestinationMetaData destinationMetaData;

	private CommonTableHelper commonTableHelper;

	private long total = 0;

	/**
	 * deliver data page by page
	 */
	public void execute() throws Exception {
		fetcher.init();
		TabularDataSegment ds = null;
		while ((ds = fetcher.fetch()).size() > 0) {
			deliver.deliver(ds);
			logger.info("deliver rows @ " + ds.size());
			total += ds.size();
		}
		fetcher.close();
		deliver.close();

		logger.info("totally deliver rows @ " + total);
	}

	/**
	 * @deprecated
	 * @throws Exception
	 */
	public void simpleExecute() throws Exception {
		init();
		validate();
		deliver.deliver(fetcher.fetch());

	}

	public String getQuery() {
		return query;
	}

	public String getSchema() {
		return schema;
	}

	public String getTargetName() {
		return targetName;
	}

	public void setQuery(String query) {
		this.query = query;
	}

	public void setSchema(String schema) {
		this.schema = schema;
	}

	public void setTargetName(String targetName) {
		this.targetName = targetName;
	}

	public DestinationMetaData getDestinationMetaData() {
		return destinationMetaData;
	}

	public void setDestinationMetaData(DestinationMetaData destinationMetaData) {
		this.destinationMetaData = destinationMetaData;
	}

	@Override
	public void init() throws Exception {
		/*
		 * dataSource = new QueryDataSource(srcConnection, query);
		 * sourceMetaData = dataSource.getSourceMetaData();
		 * 
		 * String provider = DBProvider.getProvider(destConnection);
		 * destinationMetaData =
		 * sourceMetaData.createDestinationMetaData(provider);
		 */
		/*
		 * destinationMetaData.setSchema(schema);
		 * destinationMetaData.setName(targetName);
		 */

		logger = new IDataLogger(sessionName, sessionID);

		srcConnection = dataSource.getConnection();

		dataSource.setIDataLogger(logger);

		commonTableHelper = new CommonTableHelper(destinationMetaData, destConnection);
		commonTableHelper.setIDataLogger(logger);

		fetcher = dataSource.createFetcher();
		fetcher.setIDataLogger(logger);

		deliver = DeliverFactory.getInstance().createDeliver(destinationMetaData, destConnection);
		deliver.setIDataLogger(logger);

		// deliver.setSimpleDDL(commonTableHelper);
		// deliver.setQueryBuilder(commonTableHelper);
		deliver.setColRef(mapColRef());

		logger.info("initalized the session:" + sessionName + "-" + sessionID);

	}

	private ArrayList<Integer> mapColRef() throws MetaDataException {
		ArrayList<Integer> colRef = new ArrayList<Integer>();
		HashMap<String, Integer> map = new HashMap<String, Integer>();
		List<DataItem> smdItems = this.dataSource.getSourceMetaData().getDataItems();

		for (int i = 0; i < smdItems.size(); i++) {
			map.put(smdItems.get(i).getName(), i);
		}

		List<DataItem> dmdItems = destinationMetaData.getDataItems();
		for (DataItem e : dmdItems) {
			Integer i = map.get(e.getName());
			if (i != null) {
				colRef.add(i);
			} else
				throw new MetaDataException(e);
		}
		return colRef;
	}

	@Override
	public boolean validate() throws Exception {
		if (!commonTableHelper.exist()) {
			commonTableHelper.create();
			return true;
		}
		return commonTableHelper.validate();
	}

	public CommonTableHelper getCommonTableHelper() {
		return commonTableHelper;
	}

	public void setCommonTableHelper(CommonTableHelper commonTableHelper) {
		this.commonTableHelper = commonTableHelper;
	}

}
