/**
 * 
 */
package com.idata.etl.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;

import com.idata.core.dataset.DataUtil;
import com.idata.core.dataset.TabularDataSegment;
import com.idata.core.meta.MetaDataException;
import com.idata.core.meta.db.DataItem;
import com.idata.core.meta.db.DestinationMetaData;
import com.idata.core.meta.db.oracle.CommonTableHelper;
import com.idata.etl.Deliver;
import com.idata.etl.PreAction;
import com.idata.log.IDataLogger;

/**
 * @author xiafqian
 * 
 */
public class SimpleDeliver implements Deliver {

	protected IDataLogger logger;

	protected int deliverModel;

	protected DestinationMetaData destinationMetaData;

	protected Connection connection;

	protected DataUtil dataUtil;

	protected ArrayList<PreAction> actions = new ArrayList<PreAction>();

	protected ArrayList<Integer> colRef;

	protected PreparedStatement preparedStatement;

	/**
	 * @param destinationMetaData
	 * @param connection
	 */
	public SimpleDeliver(DestinationMetaData destinationMetaData, Connection connection) {
		this.destinationMetaData = destinationMetaData;
		this.connection = connection;
		this.dataUtil = destinationMetaData.createDataUtil();

	}

	public void prepare() throws Exception {
		connection.setAutoCommit(false);
		CommonTableHelper helper = new CommonTableHelper(destinationMetaData, connection);
		preparedStatement = connection.prepareStatement(helper.insertScript());

	}

	public void executePreActions() throws Exception {
		for (PreAction a : actions) {
			a.execute();
		}
	}

	public void close() throws Exception {
		preparedStatement.close();
		connection.setAutoCommit(true);
	}

	/**
	 * create table with specified name if it doesn't exist.<br/>
	 * , then insert data into table.
	 * 
	 * @throws SQLException
	 * @throws MetaDataException
	 */
	public void deliver(TabularDataSegment tds) throws SQLException {

		connection.setAutoCommit(false);

		ArrayList<Object> rowset = null;
		for (int i = 0; i < tds.getRowsets().size(); i++) {
			rowset = tds.getRowsets().get(i);
			for (int c = 0; c < colRef.size(); c++) {
				DataItem e = destinationMetaData.getDataItems().get(c);
				dataUtil.setValue(preparedStatement, c + 1, e, rowset.get(colRef.get(c).intValue()));
			}
			preparedStatement.executeUpdate();
		}
		connection.commit();

	}

	public Connection getConnection() {
		return connection;
	}

	public int getDeliverModel() {
		return deliverModel;
	}

	public DestinationMetaData getDestinationMetaData() {
		return destinationMetaData;
	}

	public void setConnection(Connection connection) {
		this.connection = connection;
	}

	public void setDeliverModel(int deliverModel) {
		this.deliverModel = deliverModel;
	}

	public void setDestinationMetaData(DestinationMetaData destinationMetaData) {
		this.destinationMetaData = destinationMetaData;
	}

	public void setDilverModel(int model) {
		this.deliverModel = model;

	}

	public DataUtil getDataUtil() {
		return dataUtil;
	}

	public void setDataUtil(DataUtil dataUtil) {
		this.dataUtil = dataUtil;
	}

	public void addPreAction(PreAction action) {
		actions.add(action);
	}

	public ArrayList<PreAction> getActions() {
		return actions;
	}

	public void setActions(ArrayList<PreAction> actions) {
		this.actions = actions;
	}

	public ArrayList<Integer> getColRef() {
		return colRef;
	}

	public void setColRef(ArrayList<Integer> colRef) {
		this.colRef = colRef;
	}

	public IDataLogger getIDataLogger() {
		return logger;
	}

	public void setIDataLogger(IDataLogger logger) {
		this.logger = logger;
	}

}
