package com.idata.etl.impl;

import java.sql.Connection;

import com.idata.config.db.DBProvider;
import com.idata.core.meta.db.DestinationMetaData;
import com.idata.etl.Deliver;

public class DeliverFactory {

	private static DeliverFactory _instance = new DeliverFactory();

	private DeliverFactory() {
	}

	public static DeliverFactory getInstance() {
		return _instance;
	}

	public Deliver createDeliver(DestinationMetaData destinationMetaData, Connection connection) throws Exception {
		Deliver d = null;
		String p = DBProvider.getProvider(connection);
		if (p.equalsIgnoreCase(DBProvider.SYBASE)) {
			d = new SimpleDeliver(destinationMetaData, connection);

		} else {
			d = new BatchDeliver(destinationMetaData, connection);
		}

		d.prepare();

		return d;
	}
}
