/**
 * 
 */
package com.idata.etl.fetcher;

import java.sql.SQLException;
import java.sql.Statement;

import com.idata.core.meta.db.SourceMetaData;
import com.idata.core.meta.db.oracle.CommonTableHelper;
import com.idata.etl.DataSource;

/**
 * @author xiafqian
 * 
 */
public class SybasePagingFetcher extends NativePagingFetcher {

	/**
	 * @param dataSource
	 * @param sourceMetaData
	 */
	public SybasePagingFetcher(DataSource dataSource, SourceMetaData sourceMetaData) {
		super(dataSource, sourceMetaData);
	}

	/**
	 * initialize fetcher query and create temporary table
	 */
	@Override
	public void init() throws SQLException {

		CommonTableHelper cth = new CommonTableHelper(dataSource.getConnection(), sourceMetaData);
		pageQuery = " #SC# FROM #TEMP t WHERE RN>#START# AND RN<=#END#";
		String sc = cth.selectClause();
		pageQuery = pageQuery.replaceAll("#SC#", sc);

		Statement st = dataSource.getConnection().createStatement();
		st.execute("SELECT RN=IDENTITY(12), * INTO #TEMP FROM " + sourceMetaData.getFullName());
		st.close();
		System.out.println("create temporary table!");

	} 

}
