/**
 * 
 */
package com.idata.etl.fetcher;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

import com.idata.core.dataset.DataUtil;
import com.idata.core.dataset.TabularDataSegment;
import com.idata.core.meta.db.DataItem;
import com.idata.core.meta.db.SourceMetaData;
import com.idata.etl.DataSource;
import com.idata.etl.Fetcher;
import com.idata.log.IDataLogger;

/**
 * 
 * fetch all data for query or table one time
 * 
 * @author xiafqian
 * 
 */
public class SimpleFetcher implements Fetcher {

	protected IDataLogger logger;

	protected DataSource dataSource;

	protected SourceMetaData sourceMetaData;

	protected DataUtil du;

	protected ResultSet rs;

	protected Statement stm;

	/**
	 * @param ds
	 * @param smd
	 */
	public SimpleFetcher(DataSource ds, SourceMetaData smd) {
		this.dataSource = ds;
		this.sourceMetaData = smd;
		du = sourceMetaData.createDataUtil();
	}

	public void init() throws SQLException {
		stm = dataSource.getConnection().createStatement();
		String q = dataSource.getFetchQuery();

		logger.info(q);
		rs = stm.executeQuery(dataSource.getFetchQuery());
		logger.info("initialized SimpleFetcher.");
	}

	public void close() throws SQLException {
		rs.close();
		stm.close();
	}

	public DataSource getDataSource() {
		return dataSource;
	}

	public DataUtil getDataUtil() {
		return du;
	}

	public SourceMetaData getSourceMetaData() {
		return sourceMetaData;
	}

	public void setDataSource(DataSource dataSource) {
		this.dataSource = dataSource;
	}

	public void setDataUtil(DataUtil dataUtil) {
		this.du = dataUtil;
	}

	public void setSourceMetaData(SourceMetaData sourceMetaData) {
		this.sourceMetaData = sourceMetaData;
	}

	/**
	 * fetch ResultSet into DataSegment Object<br />
	 * 
	 * @throws SQLException
	 * @throws IOException
	 * 
	 */
	public TabularDataSegment fetch() throws Exception {
		TabularDataSegment tds = new TabularDataSegment();
		tds.setSourceMetaData(sourceMetaData);
		if (!rs.isClosed()) {
			for (int i = 0; i < PAGE_SIZE && rs.next(); i++) {
				ArrayList<Object> rowset = new ArrayList<Object>(sourceMetaData.size());
				for (DataItem e : sourceMetaData.getDataItems()) {
					rowset.add(du.getValue(rs, e));
				}
				tds.addRowSet(rowset);
			}
			if (tds.size() > 0) {
				logger.info("fetch TDS:" + tds + " @ rows " + tds.size());
			}
		}

		return tds;
	}

	public void setIDataLogger(IDataLogger logger) {
		this.logger = logger;

	}

}
