package com.idata.etl.fetcher;

import java.sql.SQLException;

import com.idata.core.meta.db.SourceMetaData;
import com.idata.core.meta.db.oracle.CommonTableHelper;
import com.idata.etl.DataSource;

public class OraclePagingFetcher extends NativePagingFetcher {
	public OraclePagingFetcher(DataSource dataSource, SourceMetaData sourceMetaData) {
		super(dataSource, sourceMetaData);
	}

	@Override
	public void init() throws SQLException {
		CommonTableHelper cth = new CommonTableHelper(dataSource.getConnection(), sourceMetaData);
		pageQuery = " #SC# FROM (#SUB#) t WHERE RN>#START# AND RN<=#END#";
		String sc = cth.selectClause();
		String ic = cth.innerClause() + ", ROWNUM RN FROM " + sourceMetaData.getFullName() + " T";
		pageQuery = pageQuery.replaceAll("#SC#", sc).replaceAll("#SUB#", ic);

	}

	@Override
	public void close() throws SQLException {
		// TODO Auto-generated method stub
		
	}
	
	
}
