/**
 * 
 */
package com.idata.etl.fetcher;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

import com.idata.core.dataset.TabularDataSegment;
import com.idata.core.meta.db.DataItem;
import com.idata.core.meta.db.SourceMetaData;
import com.idata.etl.DataSource;

/**
 * @author xiafqian
 * 
 */
public abstract class NativePagingFetcher extends SimpleFetcher {

	protected long start, end;

	protected String pageQuery;

	public NativePagingFetcher(DataSource dataSource, SourceMetaData sourceMetaData) {
		super(dataSource, sourceMetaData);
		start = 0;
		end = PAGE_SIZE;		
	}

	public abstract void init() throws SQLException;
	
	public TabularDataSegment fetch() throws Exception{
		long s = System.currentTimeMillis();
		
		TabularDataSegment tds = new TabularDataSegment();
		tds.setSourceMetaData(sourceMetaData);
		Statement stm = this.dataSource.getConnection().createStatement();
		String q = pageQuery.replaceAll("#START#", String.valueOf(start)).replaceAll("#END#", String.valueOf(end));
		ResultSet rs = stm.executeQuery(q);
		while (rs.next()) {
			ArrayList<Object> rowset = new ArrayList<Object>(sourceMetaData.size());
			for (DataItem e : sourceMetaData.getDataItems()) {
				rowset.add(du.getValue(rs, e));
			}
			tds.addRowSet(rowset);
		}
		rs.close();
		stm.close();

		end += PAGE_SIZE;
		start += PAGE_SIZE;

		System.out.println(System.currentTimeMillis() -s );
		
		return tds;
	}
	
	public long getStart() {
		return start;
	}

	public void setStart(long start) {
		this.start = start;
	}

	public long getEnd() {
		return end;
	}

	public void setEnd(long end) {
		this.end = end;
	}

	public String getPageQuery() {
		return pageQuery;
	}

	public void setPageQuery(String pageQuery) {
		this.pageQuery = pageQuery;
	}

	 

}
