package com.idata.etl;

import java.sql.Connection;

import com.idata.log.IDataLogger;

public abstract class TransferSession {

	protected long sessionID;

	protected String sessionName;

	protected Connection srcConnection;

	protected Connection destConnection;

	protected DataSource dataSource;

	protected Deliver deliver;

	protected Fetcher fetcher;
	
	protected IDataLogger logger;

	/**
	 * 
	 */
	public TransferSession() {
	}

	/**
	 * @param sessionID
	 * @param sessionName
	 */
	public TransferSession(long sessionID, String sessionName) {
		this.sessionID = sessionID;
		this.sessionName = sessionName;
	}

	/**
	 * Instant SourceMetaData, DestinationMetaDate, Fetcher and Deliver
	 * @throws Exception
	 */
	public abstract void init() throws Exception;
	
	/**
	 * check the target name, validate the destinationMetaData
	 * if target exists, check columns with destinationMetaData
	 * if not, try to create it
	 * @throws Exception
	 */
	public abstract boolean validate() throws Exception;
	
	/**
	 * fetch data and deliver to target database
	 * @throws Exception
	 */
	public abstract void execute() throws Exception;

	public Connection getSrcConnection() {
		return srcConnection;
	}

	public void setSrcConnection(Connection srcConnection) {
		this.srcConnection = srcConnection;
	}

	public Connection getDestConnection() {
		return destConnection;
	}

	public void setDestConnection(Connection destConnection) {
		this.destConnection = destConnection;
	}

	public Deliver getDeliver() {
		return deliver;
	}

	public void setDeliver(Deliver deliver) {
		this.deliver = deliver;
	}

	public Fetcher getFetcher() {
		return fetcher;
	}

	public void setFetcher(Fetcher fetcher) {
		this.fetcher = fetcher;
	}

	public long getSessionID() {
		return sessionID;
	}

	public void setSessionID(long sessionID) {
		this.sessionID = sessionID;
	}

	public DataSource getDataSource() {
		return dataSource;
	}

	public void setDataSource(DataSource dataSource) {
		this.dataSource = dataSource;
	}

	public String getSessionName() {
		return sessionName;
	}

	public void setSessionName(String sessionName) {
		this.sessionName = sessionName;
	}

	public IDataLogger getLogger() {
		return logger;
	}

	public void setLogger(IDataLogger logger) {
		this.logger = logger;
	}

	
	
}
