package com.idata.etl;

import java.sql.Connection;
import java.sql.SQLException;

import com.idata.config.db.TypeConfigException;
import com.idata.core.meta.db.SourceMetaData;
import com.idata.log.IDataLogger;

public abstract class DataSource {

	protected Connection connection;

	protected SourceMetaData sourceMetaData;

	protected String catalog;

	protected String schema;

	protected String tableName;

	protected String fetchQuery;

	protected IDataLogger logger;

	/**
	 * @param connection
	 * @param catalog
	 * @param schema
	 * @param tableName
	 */
	public DataSource(Connection connection, String catalog, String schema, String tableName) {
		this.connection = connection;
		this.catalog = catalog;
		this.schema = schema;
		this.tableName = tableName;
	}

	public SourceMetaData getSourceMetaData() {
		return sourceMetaData;
	}

	protected SourceMetaData getSourceMetaData(String sql) throws SQLException, ParseException, TypeConfigException {
		if (sourceMetaData == null)
			initMetaData();
		return sourceMetaData;
	}

	public abstract void initMetaData() throws SQLException, ParseException, TypeConfigException;

	/**
	 * create simple fetcher
	 * 
	 * @throws TypeConfigException
	 */
	public abstract Fetcher createFetcher() throws SQLException, ParseException, TypeConfigException;

	/**
	 * @param connection
	 */
	public DataSource(Connection connection) {
		this.connection = connection;
	}

	public Connection getConnection() {
		return connection;
	}

	public void setConnection(Connection connection) {
		this.connection = connection;
	}

	public String getFetchQuery() {
		return fetchQuery;
	}

	public String getSchema() {
		return schema;
	}

	public void setSchema(String schema) {
		this.schema = schema;
	}

	public String getTableName() {
		return tableName;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	public String getCatalog() {
		return catalog;
	}

	public void setCatalog(String catalog) {
		this.catalog = catalog;
	}

	public void setSourceMetaData(SourceMetaData sourceMetaData) {
		this.sourceMetaData = sourceMetaData;
	}

	public IDataLogger getIDataLogger() {
		return logger;
	}

	public void setIDataLogger(IDataLogger logger) {
		this.logger = logger;

	}

}
