/**
 * 
 */
package com.idata.core.meta.db.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import com.idata.config.db.DBProvider;
import com.idata.config.db.TypeConfigException;
import com.idata.core.meta.db.DataItem;
import com.idata.core.meta.db.DestinationMetaData;
import com.idata.core.meta.db.MetaData;
import com.idata.core.meta.db.QueryBuilder;
import com.idata.core.meta.db.SimpleDDL;
import com.idata.core.meta.db.SourceMetaData;
import com.idata.etl.DataSource;
import com.idata.etl.DataSourceFactory;
import com.idata.etl.ParseException;
import com.idata.log.IDataLogger;

/**
 * @author xiafqian
 * 
 */
public class CommonTableHelper implements SimpleDDL, QueryBuilder {
	
	private IDataLogger logger;

	private MetaData meta;

	private Connection cnn;

	/**
	 * @param meta
	 * @param cnn
	 */
	public CommonTableHelper(MetaData meta, Connection cnn) {
		this.meta = meta;
		this.cnn = cnn;
	}	

	
	public CommonTableHelper(Connection cnn, MetaData meta) {
		this.meta = meta;
		this.cnn = cnn;
	}

	public String truncateScript() {
		String sql = "TRUNCATE TABLE " + meta.getFullName();
		return sql;
	}

	public boolean exist() throws SQLException {

		String[] types = { "TABLE", "VIEW" };
		String schema = null;
		if (meta.getSchema() != null) {
			schema = meta.getSchema().toUpperCase();
		}
		ResultSet rs = cnn.getMetaData().getTables(null, schema, meta.getName().toUpperCase(), types);
		boolean r = rs.next();
		rs.close();
		return r;

	}

	public String createScript() {
		String sql = "CREATE TABLE " + meta.getFullName() + " (";
		for (DataItem item : meta.getDataItems()) {
			String catalog = item.getCatalog();
			sql += item.getName().toUpperCase() + " " + item.getTypeName().toUpperCase();

			// for Oracle TimeStamp with Time Zone or Local Time Zone
			/*
			 * if (meta.getProvider().equalsIgnoreCase(DBProvider.ORACLE) &&
			 * item.getTypeName().equalsIgnoreCase("TIMESTAMP")) { sql += "(" +
			 * item.getScale() + ")" + item.getAttribute() + ", \n";
			 * 
			 * } else
			 */

			if ("number".equalsIgnoreCase(catalog) || "lob".equalsIgnoreCase(catalog) || "date".equalsIgnoreCase(catalog)
					|| "other".equalsIgnoreCase(catalog)) {

				// sql += ",\n";
			}

			/*
			 * else if (item.getPrecision() > 0 && item.getScale() != 0) { sql
			 * += "(" + item.getPrecision() + "," + item.getScale() + "), \n"; }
			 */
			else if (item.getPrecision() > 0) {
				sql += "(" + item.getPrecision() + ")";

			} else if (item.getLength() > 0) {
				sql += "(" + item.getLength() + ")";
			}

			if (item.getAttribute() != null && item.getAttribute().length() > 1) {
				sql += " " + item.getAttribute();
			}

			sql += ",\n";
		}

		sql = sql.substring(0, sql.lastIndexOf(","));
		sql += ")\n";
		 
		return sql;
	}

	public void create() throws SQLException {
		String sql = createScript();
		Statement statement = this.cnn.createStatement();
		statement.setQueryTimeout(10);
		statement.execute(sql);
		statement.close();
	}

	public void drop() throws SQLException {

		Statement statement = this.cnn.createStatement();
		String sql = "DROP TABLE " + meta.getFullName();
		statement.execute(sql);
		statement.close();

	}

	public void replace() {
		// TODO not implement

	}

	public void alter() {
		// TODO not implement

	}

	public String selectScript() {
		String alias = "t";
		String sql = selectClause();
		sql += "\n FROM " + meta.getFullName() + " " + alias;		
		 
		return sql;
	}

	public String deleteScript() {
		String sql = "DELETE FROM " + meta.getFullName() + " \n where ";
		for (String col : meta.getPrimaryKey()) {
			sql += col + "=?\n and ";
		}
		sql = sql.substring(0, sql.length() - 4);
		return sql.toUpperCase();
	}

	public String updateScript() {
		String sql = "UPDATE " + meta.getFullName() + " \n SET ";
		for (DataItem e : meta.getDataItems()) {
			sql += e.getName() + "=?,";
		}
		sql = sql.substring(0, sql.length() - 1) + " \n where ";

		for (String key : meta.getPrimaryKey()) {
			sql += key + "=?,";
		}
		sql = sql.substring(0, sql.length() - 1);
		return sql.toUpperCase();
	}

	public String insertScript() {
		String sql = "INSERT INTO " + meta.getFullName() + "(";
		String parmsymbol = "";
		for (DataItem item : meta.getDataItems()) {
			sql += item.getName() + ",";
			if (DBProvider.ORACLE.equalsIgnoreCase(meta.getProvider())
					&& ("URITYPE".equalsIgnoreCase(item.getTypeName()) || "SYS.URITYPE".equalsIgnoreCase(item.getTypeName()))) {
				parmsymbol += "SYS.URIFACTORY.GETURI(?),";
			} else {
				parmsymbol += "?,";
			}
		}
		sql = sql.substring(0, sql.length() - 1);
		parmsymbol = parmsymbol.substring(0, parmsymbol.length() - 1);
		sql += "\n ) values (" + parmsymbol + ")";
		 
		return sql.toUpperCase();
	}

	/**
	 * validate the DestinationMetaData in reverse.
	 * 
	 * @return
	 * @throws SQLException
	 * @throws ParseException
	 * @throws TypeConfigException
	 */
	public boolean validate() throws SQLException, ParseException, TypeConfigException {

		DataSource nds = DataSourceFactory.createDataSource(cnn, null, meta.getSchema(), meta.getName().toUpperCase());
		SourceMetaData smd = nds.getSourceMetaData();

		if (smd.getDataItems().size() < meta.getDataItems().size()) {
			logger.info("destination table columns are not enough!");
			return false;
		} else {
			for (DataItem e : meta.getDataItems()) {
				if (smd.get(e.getName()) == null) {
					logger.info("couldn't find the column named " + meta.getName() + " from the destination table");
					return false;
				}
			}
		}
		return true;
	}

	public Connection getConnection() {
		return cnn;

	}

	public void setConnection(Connection cnn) {
		this.cnn = cnn;
	}

	public CommonTableHelper() {

	}

	public CommonTableHelper(DestinationMetaData metadata, Connection connection) {
		this.meta = metadata;
		this.cnn = connection;
	}

	public MetaData getDestinationMetaData() {
		return meta;
	}

	public void setDestinationMetaData(DestinationMetaData destinationMetaData) {
		this.meta = destinationMetaData;
	}

	public String purgeScript() {
		return "DELETE FROM " + meta.getFullName();
	}

	public String innerClause() {
		String alias = "t";
		String clause = "SELECT ";
		for (DataItem item : meta.getDataItems()) {
			clause += " " + alias + "." + item.getName() + ",\n";
		}
		clause = clause.substring(0, clause.lastIndexOf(",\n"));
		return clause;
	}

	public String selectClause() {
		String alias = "t";
		String sql = "SELECT ";
		for (DataItem item : meta.getDataItems()) {
			if (this.meta.getProvider().equalsIgnoreCase(DBProvider.ORACLE)
					&& (item.getTypeName().equalsIgnoreCase("URITYPE") || item.getTypeName().equalsIgnoreCase("SYS.URITYPE"))) {
				sql += " " + alias + "." + item.getName() + ".getURL() as " + item.getName() + ",\n";

			} else {
				sql += " " + alias + "." + item.getName() + ",\n";
			}
		}
		sql = sql.substring(0, sql.lastIndexOf(",\n"));
		return sql;
	}

	public IDataLogger getLogger() {
		return logger;
	}

	public void setIDataLogger(IDataLogger logger) {
		this.logger = logger;
	}
	
	

}
