package com.idata.core.dataset;

import java.util.ArrayList;

import com.idata.core.meta.db.DestinationMetaData;
import com.idata.core.meta.db.SourceMetaData;

public class TabularDataSegment {

	private SourceMetaData sourceMetaData;

	private DestinationMetaData destinationMetaData;

	private ArrayList<ArrayList<Object>> rowsets = new ArrayList<ArrayList<Object>>();

	public DestinationMetaData getDestinationMetaData() {
		return destinationMetaData;
	}

	public void setDestinationMetaData(DestinationMetaData destinationMetaData) {
		this.destinationMetaData = destinationMetaData;
	}

	public SourceMetaData getSourceMetaData() {
		return sourceMetaData;
	}

	public void setSourceMetaData(SourceMetaData sourceMetaData) {
		this.sourceMetaData = sourceMetaData;
	}

	public ArrayList<ArrayList<Object>> getRowsets() {
		return rowsets;
	}

	public void setRowsets(ArrayList<ArrayList<Object>> rowsets) {
		this.rowsets = rowsets;
	}

	public void addRowSet(ArrayList<Object> rowset) {
		rowsets.add(rowset);
	}

	public ArrayList<Object> getRowSet(int index) {
		return rowsets.get(index);
	}

	public void remove(int index) {
		rowsets.remove(index);
	}

	public int size() {
		return rowsets.size();
	}

}
