/**
 * 
 */
package com.idata.config.db;

import java.io.InputStream;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.idata.core.db.type.mapping.Db2Java;
import com.idata.core.db.type.mapping.DbType;
import com.idata.core.db.type.mapping.Java2Db;
import com.idata.core.db.type.mapping.JavaType;

/**
 * @author xiafqian
 * 
 */
public class TypeConfigurationFactory {

	public static String _IBMDB2_CONFIG = "db2.xml";

	public static String _MSSQL_CONFIG = "mssql.xml";

	public static String _MYSQL_CONFIG = "mysql.xml";

	public static String _ORACLE_CONIFIG = "oracle.xml";

	public static String _SYBASE_CONFIG = "sybase.xml";

	private static TypeConfigurationFactory _typeFactory = null;

	private DocumentBuilder _builder;

	private DocumentBuilderFactory _factory;

	private static XPath xp;

	private static XPathFactory xpf;

	public static synchronized TypeConfigurationFactory createInstance() {
		if (_typeFactory == null) {
			_typeFactory = new TypeConfigurationFactory();
		}
		return _typeFactory;
	}

	private TypeConfigurationFactory() {
		xpf = XPathFactory.newInstance();
		xp = xpf.newXPath();
		_factory = DocumentBuilderFactory.newInstance();
		try {
			_builder = _factory.newDocumentBuilder();
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		}
	}

	private void fetchDBtypes(TypeConfiguration config, Node dbtypes) throws TypeConfigException,
			XPathExpressionException {

		NodeList children = (NodeList) xp.evaluate("dbtype", dbtypes, XPathConstants.NODESET);
		for (int i = 0; i < children.getLength(); i++) {
			DbType target = new DbType();
			Node dbtype = children.item(i);
			if ("".equals(xp.evaluate("@reference", dbtype))) {
				target.setName(xp.evaluate("@name", dbtype));
				target.setCatalog(xp.evaluate("@catalog", dbtype));
				target.setConversion(xp.evaluate("@conversion", dbtype));
				if (!"".equals(xp.evaluate("@code", dbtype))) {
					target.setCode(Integer.valueOf(xp.evaluate("@code", dbtype)));
				}
				if (!"".equals(xp.evaluate("@compatible", dbtype))) {
					target.setCompatible(Integer.valueOf(xp.evaluate("@compatible", dbtype)));
				}

				if (!"".equals(xp.evaluate("@code", dbtype))) {
					target.setCode(Integer.valueOf(xp.evaluate("@code", dbtype)));
				}
				if (!"".equals(xp.evaluate("@max-length", dbtype))) {
					target.setMaxLength(Integer.valueOf(xp.evaluate("@max-length", dbtype)));
				}

				// read all db2java types
				NodeList db2javas = (NodeList) xp.evaluate("db2javas/javatype", dbtype, XPathConstants.NODESET);
				ArrayList<Db2Java> list = new ArrayList<Db2Java>();
				for (int j = 0; j < db2javas.getLength(); j++) {
					Node child = db2javas.item(j);
					Db2Java obj = new Db2Java();
					obj.setName(xp.evaluate("@name", child));
					obj.setDefault(xp.evaluate("@default", child));
					list.add(obj);

					if ("yes".equalsIgnoreCase(obj.getDefault())) {
						target.setDefaultDb2Java(obj);
					}
				}

				target.setDb2javas(list);
				if (target.getDefaultDb2Java() == null)
					throw new TypeConfigException(target);

				if ("string".equalsIgnoreCase(target.getCatalog())) {
					config.getStringTypes().put(target.getName(), target);
				} else if ("number".equalsIgnoreCase(target.getCatalog())) {
					config.getNumberTypes().put(target.getName(), target);
				} else if ("lob".equalsIgnoreCase(target.getCatalog())) {
					config.getLobTypes().put(target.getName(), target);
				} else if ("date".equalsIgnoreCase(target.getCatalog())) {
					config.getDateTypes().put(target.getName(), target);
				}
				config.getDbtypes().put(target.getName(), target);
			}
		}
	}

	private void fetchJavaTypes(TypeConfiguration config, Node javatypes) {

		try {
			NodeList nodelist = (NodeList) xp.evaluate("javatype", javatypes, XPathConstants.NODESET);
			for (int i = 0; i < nodelist.getLength(); i++) {
				Node node = nodelist.item(i);
				JavaType javaType = new JavaType();
				javaType.setName(xp.evaluate("@name", node));
				NodeList children = (NodeList) xp.evaluate("java2dbs/dbtype", node, XPathConstants.NODESET);
				ArrayList<Java2Db> java2dbs = new ArrayList<Java2Db>();
				for (int j = 0; j < children.getLength(); j++) {
					Java2Db j2d = new Java2Db();
					j2d.setName(xp.evaluate("@name", children.item(j)));
					j2d.setCatalog(xp.evaluate("@catalog", children.item(j)));
					j2d.setConversion(xp.evaluate("@conversion", children.item(j)));
					j2d.setDefault(xp.evaluate("@default", children.item(j)));
					String p = xp.evaluate("@precision", children.item(j));
					if (p != null && p.length() > 0) {
						j2d.setDefaultPrecision(Integer.parseInt(p));
					}
					java2dbs.add(j2d);
					if ("yes".equalsIgnoreCase(j2d.getDefault())) {
						javaType.setDefaultJava2Db(j2d);
					}
				}
				javaType.setJava2Dbs(java2dbs);

				config.getJavaTypes().put(javaType.getName(), javaType);
			}
		} catch (XPathExpressionException e) {
			e.printStackTrace();
		}

	}

	private void fetchReference(TypeConfiguration config, Node dbtypes) {
		try {
			NodeList children = (NodeList) xp.evaluate("dbtype", dbtypes, XPathConstants.NODESET);
			for (int i = 0; i < children.getLength(); i++) {
				DbType target = new DbType();
				Node dbtype = children.item(i);
				String reference = xp.evaluate("@reference", dbtype);
				if (reference != null && reference.length() > 0) {
					target.setName(xp.evaluate("@name", dbtype));

					DbType reftype = config.getDbtypes().get(reference);
					target.setCatalog(reftype.getCatalog());
					target.setCode(reftype.getCode());
					target.setCompatible(reftype.getCompatible());
					target.setConversion(reftype.getConversion());
					target.setDefaultDb2Java(reftype.getDefaultDb2Java());
					target.setDb2javas(reftype.getDb2javas());

					if ("string".equalsIgnoreCase(target.getCatalog())) {
						config.getStringTypes().put(target.getName(), target);
					} else if ("number".equalsIgnoreCase(target.getCatalog())) {
						config.getNumberTypes().put(target.getName(), target);
					} else if ("lob".equalsIgnoreCase(target.getCatalog())) {
						config.getLobTypes().put(target.getName(), target);
					} else if ("date".equalsIgnoreCase(target.getCatalog())) {
						config.getDateTypes().put(target.getName(), target);
					}

					config.getDbtypes().put(target.getName(), target);
				}
			}

		} catch (XPathExpressionException e) {
			e.printStackTrace();
		}
	}

	public TypeConfiguration readConfig(String fileName) {
		TypeConfiguration config = new TypeConfiguration();
		config.setFileName(fileName);

		InputStream is = TypeConfigurationFactory.class.getResourceAsStream("/config/" + fileName);
		Node node = null;
		try {
			Document doc = _builder.parse(is);
			node = doc.getLastChild();
			node.normalize();

			Node dbtypes = (Node) xp.evaluate("//database/dbtypes", doc, XPathConstants.NODE);
			fetchDBtypes(config, dbtypes);
			fetchReference(config, dbtypes);

			Node javatypes = (Node) xp.evaluate("//database/javatypes", doc, XPathConstants.NODE);
			fetchJavaTypes(config, javatypes);

		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
		return config;
	}

	public TypeConfiguration readProviderConfig(String provider) {
		return readConfig(provider.toLowerCase() + ".xml");

	}

}
