/*
 * Decompiled with CFR 0.152.
 */
package com.idata.research.annotation;

import com.idata.config.annotation.MappingUtil;
import com.idata.core.meta.db.DataItem;
import com.idata.research.annotation.AnnotationTestObject;
import com.idata.research.annotation.TagObject;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathFactory;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class PropertyTest {
    @Test
    public void testAttr1() throws Exception {
        String xml = "<add job='351'><tag>foobar</tag><tag>foobar2</tag></add>";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.parse(new InputSource(new StringReader(xml)));
        MappingUtil util = new MappingUtil(XPathFactory.newInstance().newXPath());
        AnnotationTestObject testObj = (AnnotationTestObject)util.decodeElemeent(AnnotationTestObject.class, document.getLastChild());
        Assert.assertEquals((long)testObj.getJob(), (long)351L);
    }

    @Test
    public void testTags() throws Exception {
        String xml = "<add job='351'><tag>foobar</tag><tag>foobar2</tag></add>";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.parse(new InputSource(new StringReader(xml)));
        MappingUtil util = new MappingUtil(XPathFactory.newInstance().newXPath());
        AnnotationTestObject testObj = (AnnotationTestObject)util.decodeElemeent(AnnotationTestObject.class, document.getLastChild());
    }

    @Test
    public void testInteger() {
        Assert.assertEquals((Object)Integer.class.isPrimitive(), (Object)true);
    }

    @Test
    public void testDeclareClass() throws Exception {
        Class<?>[] classes = AnnotationTestObject.class.getDeclaredClasses();
        Assert.assertEquals((long)classes.length, (long)0L);
        for (int i = 0; i < classes.length; ++i) {
            System.out.println(classes[i].getName());
        }
    }

    @Test
    public void testList() throws Exception {
        AnnotationTestObject obj = new AnnotationTestObject();
        ArrayList<TagObject> list = new ArrayList<TagObject>(0);
        list.add(new TagObject());
        obj.setTags(list);
        Field f = obj.getClass().getDeclaredField("tags");
        Assert.assertEquals((Object)(f.getType().getName().indexOf("List") > 0 ? 1 : 0), (Object)true);
        System.out.println(f.getType().getDeclaringClass().getComponentType().getSimpleName());
        f.getType().getSigners();
    }

    @Test
    public void testExpress() {
        Object s = null;
        String t = s == null ? "s" : "t";
        Assert.assertEquals((Object)t, (Object)"s");
    }

    @Test
    public void testClone() throws CloneNotSupportedException {
        DataItem col = new DataItem();
        col.setName("col1");
        col.setPrecision(128);
        col.setType(1);
        col.setTypeName("VARCHAR2");
        DataItem another = col.clone();
        Assert.assertEquals((Object)another.getName(), (Object)"col1");
    }

    @Test
    public void testClass() throws Exception {
        String s;
        String obj = s = new String("aaaa");
        System.out.println(s.getClass().getName());
        System.out.println(obj.getClass().getName());
        Assert.assertEquals((Object)s.getClass().getName(), (Object)obj.getClass().getName());
        System.out.println(s.getClass().equals(obj.getClass()));
        Assert.assertEquals(s.getClass(), obj.getClass());
    }
}

