/*
 * Decompiled with CFR 0.152.
 */
package com.idata.research;

import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XPathTest {
    private Document document;
    private XPath xp;
    private DocumentBuilderFactory dbf;
    private DocumentBuilder db;

    @Before
    public void setup() throws Exception {
        String xml = "<add job=\"351\"><tag>foobar</tag><tag>foobar2</tag></add>";
        this.dbf = DocumentBuilderFactory.newInstance();
        this.db = this.dbf.newDocumentBuilder();
        this.document = this.db.parse(new InputSource(new StringReader(xml)));
        XPathFactory xpf = XPathFactory.newInstance();
        this.xp = xpf.newXPath();
    }

    @Test
    public void testXPath() throws Exception {
        String text = this.xp.evaluate("//add[@job='351']/tag[position()=1]/text()", this.document.getDocumentElement());
        Assert.assertEquals((Object)"foobar", (Object)text);
    }

    @Test
    public void testJavaTypes() throws Exception {
        InputStream config = this.getClass().getResourceAsStream("/config/oracle.xml");
        this.document = this.db.parse(config);
        NodeList dbtypes = (NodeList)this.xp.evaluate("//database/javatypes/javatype[@name='java.lang.Byte']/java2dbs/dbtype", this.document, XPathConstants.NODESET);
        Assert.assertEquals((long)dbtypes.getLength(), (long)2L);
    }
}

