/*
 * Decompiled with CFR 0.152.
 */
package com.idata.oracle;

import com.idata.core.meta.db.DestinationMetaData;
import com.idata.etl.DataSource;
import com.idata.etl.DataSourceFactory;
import com.idata.etl.impl.SimpleTransferSession;
import com.idata.oracle.OracleConnection;
import org.junit.Test;

public class SimpleTransferSessionTest
extends OracleConnection {
    @Test
    public void nativeTransfer() throws Exception {
        SimpleTransferSession sts = new SimpleTransferSession(System.currentTimeMillis(), "oracle");
        DataSource qds = DataSourceFactory.createDataSource(this.idata, "select * from ALL_DBTYPE_COPY where rownum<2000");
        sts.setDataSource(qds);
        DestinationMetaData dmd = sts.getDataSource().getSourceMetaData().createDestinationMetaData(this.idata);
        sts.setDestConnection(this.idata);
        dmd.setName("ALL_DBTYPE_COPY_Q");
        dmd.setSchema("IDATA");
        sts.setDestinationMetaData(dmd);
        sts.setFetcher(qds.createFetcher());
        sts.init();
        sts.validate();
        sts.execute();
    }

    @Test
    public void transfer2() throws Exception {
        SimpleTransferSession sts = new SimpleTransferSession();
        sts.setSessionID(System.currentTimeMillis());
        sts.setSessionName("oracle");
        DataSource nds = DataSourceFactory.createDataSource(this.idata, null, "IDATA", "ALL_DBTYPE_COPY");
        sts.setDataSource(nds);
        sts.setSrcConnection(this.idata);
        DestinationMetaData dmd = sts.getDataSource().getSourceMetaData().createDestinationMetaData(this.gdc3);
        sts.setDestConnection(this.gdc3);
        dmd.setName("ALL_DBTYPE_COPY_N");
        dmd.setSchema("TEST");
        sts.setDestinationMetaData(dmd);
        sts.setFetcher(nds.createFetcher());
        sts.init();
        sts.validate();
        sts.execute();
    }

    @Test
    public void loopNativeTransfer() throws Exception {
        SimpleTransferSession sts = new SimpleTransferSession();
        sts.setSessionID(System.currentTimeMillis());
        sts.setSessionName("oracle");
        DataSource nds = DataSourceFactory.createDataSource(this.gdc3, "SELECT * FROM HR.EMPLOYEES");
        sts.setDataSource(nds);
        sts.setDestConnection(this.idata);
        DestinationMetaData dmd = nds.getSourceMetaData().createDestinationMetaData(this.idata);
        dmd.setName("EMPLOYEES_c");
        dmd.setSchema("IDATA");
        sts.setDestinationMetaData(dmd);
        sts.init();
        sts.validate();
        sts.execute();
    }
}

