/*
 * Decompiled with CFR 0.152.
 */
package com.idata.log;

import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class IDataLogger {
    private String path = "./logs";
    private String sessionName;
    private long sessionID;
    private Logger logger;
    private FileHandler traceHandler;
    private FileHandler infoHandler;
    private FileHandler errorHandler;

    public IDataLogger(String sessionName, long sessionID) throws SecurityException, IOException {
        Handler[] handlers;
        this.sessionID = sessionID;
        this.sessionName = sessionName;
        this.logger = Logger.getLogger(sessionName);
        for (Handler h : handlers = this.logger.getHandlers()) {
            this.logger.removeHandler(h);
        }
        this.logger.setLevel(Level.ALL);
        String logPath = this.path + "/" + this.sessionName + "-" + this.sessionID;
        File f = new File(logPath);
        if (!f.exists()) {
            f.mkdir();
        }
        this.logger.info("all loger for the session is here:" + logPath);
        this.traceHandler = new FileHandler(logPath + "/trace.log", true);
        this.traceHandler.setFilter(new Filter(){

            @Override
            public boolean isLoggable(LogRecord record) {
                return record.getLevel().intValue() <= Level.FINE.intValue();
            }
        });
        this.traceHandler.setFormatter(new SimpleFormatter());
        this.logger.addHandler(this.traceHandler);
        this.infoHandler = new FileHandler(logPath + "/info.log", true);
        this.infoHandler.setFilter(new Filter(){

            @Override
            public boolean isLoggable(LogRecord record) {
                return record.getLevel().equals(Level.INFO) || record.getLevel().equals(Level.CONFIG);
            }
        });
        this.infoHandler.setFormatter(new SimpleFormatter());
        this.logger.addHandler(this.infoHandler);
        this.errorHandler = new FileHandler(logPath + "/warning.log", true);
        this.errorHandler.setFilter(new Filter(){

            @Override
            public boolean isLoggable(LogRecord record) {
                return record.getLevel().intValue() >= Level.WARNING.intValue();
            }
        });
        this.errorHandler.setFormatter(new SimpleFormatter());
        this.logger.addHandler(this.errorHandler);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public FileHandler getTraceHandler() {
        return this.traceHandler;
    }

    public void setTraceHandler(FileHandler traceHandler) {
        this.traceHandler = traceHandler;
    }

    public FileHandler getInfoHandler() {
        return this.infoHandler;
    }

    public void setInfoHandler(FileHandler infoHandler) {
        this.infoHandler = infoHandler;
    }

    public FileHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(FileHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void trace(String msg) {
        this.logger.fine(msg);
    }

    public void trace(String msg, Throwable throwable) {
        this.logger.fine(msg);
        this.logger.fine(throwable.getMessage());
    }

    public void info(String msg) {
        this.logger.info(msg);
    }

    public void warning(String msg) {
        this.logger.warning(msg);
    }

    public void warning(String msg, Throwable throwable) {
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public long getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(long sessionID) {
        this.sessionID = sessionID;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

