/*
 * Decompiled with CFR 0.152.
 */
package com.idata.etl.fetcher;

import com.idata.core.dataset.DataUtil;
import com.idata.core.dataset.TabularDataSegment;
import com.idata.core.meta.db.DataItem;
import com.idata.core.meta.db.SourceMetaData;
import com.idata.etl.DataSource;
import com.idata.etl.Fetcher;
import com.idata.log.IDataLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class SimpleFetcher
implements Fetcher {
    protected IDataLogger logger;
    protected DataSource dataSource;
    protected SourceMetaData sourceMetaData;
    protected DataUtil du;
    protected ResultSet rs;
    protected Statement stm;

    public SimpleFetcher(DataSource ds, SourceMetaData smd) {
        this.dataSource = ds;
        this.sourceMetaData = smd;
        this.du = this.sourceMetaData.createDataUtil();
    }

    @Override
    public void init() throws SQLException {
        this.stm = this.dataSource.getConnection().createStatement();
        String q = this.dataSource.getFetchQuery();
        this.logger.info(q);
        this.rs = this.stm.executeQuery(this.dataSource.getFetchQuery());
        this.logger.info("initialized SimpleFetcher.");
    }

    @Override
    public void close() throws SQLException {
        this.rs.close();
        this.stm.close();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DataUtil getDataUtil() {
        return this.du;
    }

    public SourceMetaData getSourceMetaData() {
        return this.sourceMetaData;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataUtil(DataUtil dataUtil) {
        this.du = dataUtil;
    }

    public void setSourceMetaData(SourceMetaData sourceMetaData) {
        this.sourceMetaData = sourceMetaData;
    }

    @Override
    public TabularDataSegment fetch() throws Exception {
        TabularDataSegment tds = new TabularDataSegment();
        tds.setSourceMetaData(this.sourceMetaData);
        if (!this.rs.isClosed()) {
            for (int i = 0; i < 500 && this.rs.next(); ++i) {
                ArrayList<Object> rowset = new ArrayList<Object>(this.sourceMetaData.size());
                for (DataItem e : this.sourceMetaData.getDataItems()) {
                    rowset.add(this.du.getValue(this.rs, e));
                }
                tds.addRowSet(rowset);
            }
            if (tds.size() > 0) {
                this.logger.info("fetch TDS:" + tds + " @ rows " + tds.size());
            }
        }
        return tds;
    }

    @Override
    public void setIDataLogger(IDataLogger logger) {
        this.logger = logger;
    }
}

