/*
 * Decompiled with CFR 0.152.
 */
package com.idata.etl.fetcher;

import com.idata.core.dataset.TabularDataSegment;
import com.idata.core.meta.db.DataItem;
import com.idata.core.meta.db.SourceMetaData;
import com.idata.etl.DataSource;
import com.idata.etl.fetcher.SimpleFetcher;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public abstract class NativePagingFetcher
extends SimpleFetcher {
    protected long start = 0L;
    protected long end = 500L;
    protected String pageQuery;

    public NativePagingFetcher(DataSource dataSource, SourceMetaData sourceMetaData) {
        super(dataSource, sourceMetaData);
    }

    @Override
    public abstract void init() throws SQLException;

    @Override
    public TabularDataSegment fetch() throws Exception {
        long s = System.currentTimeMillis();
        TabularDataSegment tds = new TabularDataSegment();
        tds.setSourceMetaData(this.sourceMetaData);
        Statement stm = this.dataSource.getConnection().createStatement();
        String q = this.pageQuery.replaceAll("#START#", String.valueOf(this.start)).replaceAll("#END#", String.valueOf(this.end));
        ResultSet rs = stm.executeQuery(q);
        while (rs.next()) {
            ArrayList<Object> rowset = new ArrayList<Object>(this.sourceMetaData.size());
            for (DataItem e : this.sourceMetaData.getDataItems()) {
                rowset.add(this.du.getValue(rs, e));
            }
            tds.addRowSet(rowset);
        }
        rs.close();
        stm.close();
        this.end += 500L;
        this.start += 500L;
        System.out.println(System.currentTimeMillis() - s);
        return tds;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public long getEnd() {
        return this.end;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public String getPageQuery() {
        return this.pageQuery;
    }

    public void setPageQuery(String pageQuery) {
        this.pageQuery = pageQuery;
    }
}

