/*
 * Decompiled with CFR 0.152.
 */
package com.idata.etl;

import com.idata.config.db.DBProvider;
import com.idata.config.db.TypeConfigException;
import com.idata.config.db.TypeConfiguration;
import com.idata.config.db.TypeConfigurationFactory;
import com.idata.core.db.type.mapping.DbType;
import com.idata.core.meta.db.DataItem;
import com.idata.core.meta.db.SourceMetaData;
import com.idata.etl.DataSource;
import com.idata.etl.Fetcher;
import com.idata.etl.ParseException;
import com.idata.etl.fetcher.SimpleFetcher;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class QueryDataSource
extends DataSource {
    private String query;

    public QueryDataSource(Connection cnn, String query) {
        super(cnn);
        this.query = query;
    }

    public String[] parseName() throws ParseException {
        String[] t = null;
        String q = this.query.toUpperCase();
        if (q.indexOf(" FROM ") < 0 || q.indexOf("SELECT ") < 0) {
            throw new ParseException("invalid query:" + this.query);
        }
        return t;
    }

    public String wrapQuery() throws ParseException {
        String q = this.query.toUpperCase();
        if (q.indexOf(" FROM ") < 0 || q.indexOf("SELECT ") < 0) {
            throw new ParseException("invalid query: " + this.query);
        }
        return "SELECT * FROM (" + this.query + " ) s WHERE 1=0";
    }

    @Override
    public String getFetchQuery() {
        return this.query;
    }

    @Override
    public Fetcher createFetcher() throws SQLException, ParseException, TypeConfigException {
        return new SimpleFetcher(this, this.getSourceMetaData());
    }

    @Override
    public void initMetaData() throws SQLException, ParseException, TypeConfigException {
        this.sourceMetaData = new SourceMetaData();
        this.sourceMetaData.setProvider(DBProvider.getProvider(this.connection));
        TypeConfiguration config = TypeConfigurationFactory.createInstance().readProviderConfig(this.sourceMetaData.getProvider());
        Statement statement = this.connection.createStatement();
        ResultSet rs = statement.executeQuery(this.wrapQuery());
        ResultSetMetaData dbmeta = rs.getMetaData();
        for (int i = 1; i <= dbmeta.getColumnCount(); ++i) {
            DataItem col = new DataItem();
            col.setName(dbmeta.getColumnName(i).toUpperCase());
            col.setPrecision(dbmeta.getPrecision(i));
            col.setScale(dbmeta.getScale(i));
            col.setLength(dbmeta.getColumnDisplaySize(i));
            col.setType(dbmeta.getColumnType(i));
            if (dbmeta.getColumnTypeName(i) == null || dbmeta.getColumnTypeName(i).equals("")) {
                col.setTypeName("VARCHAR2");
            } else {
                col.setTypeName(dbmeta.getColumnTypeName(i).toUpperCase());
            }
            DbType dbtype = config.getDbType(col.getTypeName());
            if (dbtype == null) {
                throw new ParseException("Parse Exception, DB Type Name:[ " + col.getTypeName() + " ]");
            }
            if (col.getPrecision() > dbtype.getMaxLength() && dbtype.getMaxLength() > 0) {
                dbtype = config.getDbType(dbtype.getConversion());
            }
            col.setDbType(dbtype);
            col.setCatalog(dbtype.getCatalog());
            this.sourceMetaData.add(col);
        }
        rs.close();
        statement.close();
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void setConnection(Connection connection) {
        this.connection = connection;
    }
}

