/*
 * Decompiled with CFR 0.152.
 */
package com.idata.etl;

import com.idata.config.db.DBProvider;
import com.idata.config.db.TypeConfigException;
import com.idata.config.db.TypeConfiguration;
import com.idata.config.db.TypeConfigurationFactory;
import com.idata.core.db.type.mapping.DbType;
import com.idata.core.meta.db.DataItem;
import com.idata.core.meta.db.SourceMetaData;
import com.idata.core.meta.db.oracle.CommonTableHelper;
import com.idata.etl.DataSource;
import com.idata.etl.Fetcher;
import com.idata.etl.FetcherFactory;
import com.idata.etl.ParseException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class NativeDataSource
extends DataSource {
    public NativeDataSource(Connection connection, String catalog, String schema, String tableName) {
        super(connection, catalog, schema, tableName);
    }

    @Override
    public void initMetaData() throws SQLException, ParseException, TypeConfigException {
        this.sourceMetaData = new SourceMetaData();
        this.sourceMetaData.setProvider(DBProvider.getProvider(this.connection));
        this.sourceMetaData.setName(this.tableName);
        this.sourceMetaData.setSchema(this.schema);
        TypeConfiguration config = TypeConfigurationFactory.createInstance().readProviderConfig(this.sourceMetaData.getProvider());
        ResultSet columns = this.connection.getMetaData().getColumns(this.catalog, this.schema, this.tableName, null);
        while (columns.next()) {
            DataItem item = new DataItem();
            String t = columns.getString("TYPE_NAME").toUpperCase();
            String name = columns.getString("COLUMN_NAME").toUpperCase();
            item.setName(name);
            if (this.sourceMetaData.getProvider().equalsIgnoreCase("Oracle")) {
                this.fillOracleSpecialType(item, t);
            } else if (this.sourceMetaData.getProvider().equalsIgnoreCase("Mssql")) {
                this.fillMsSqlSpecialType(item, t);
            } else if (this.sourceMetaData.getProvider().equalsIgnoreCase("Sybase")) {
                this.fillSybaseSpecialType(item, t);
            } else {
                item.setTypeName(t);
            }
            DbType dbtype = config.getDbType(item);
            item.setDbType(dbtype);
            this.sourceMetaData.add(item);
        }
        columns.close();
        CommonTableHelper helper = new CommonTableHelper(this.sourceMetaData, this.connection);
        this.fetchQuery = helper.selectScript();
        String warpQuery = this.fetchQuery + " WHERE 1=0";
        Statement stm = this.connection.createStatement();
        ResultSet rs = stm.executeQuery(warpQuery);
        ResultSetMetaData meta = rs.getMetaData();
        for (int i = 0; i < meta.getColumnCount(); ++i) {
            int j = i + 1;
            if (!this.sourceMetaData.get(i).isHasLength()) continue;
            this.sourceMetaData.get(i).setLength(meta.getColumnDisplaySize(j));
            this.sourceMetaData.get(i).setScale(meta.getScale(j));
            this.sourceMetaData.get(i).setPrecision(meta.getPrecision(j));
        }
        rs.close();
        stm.close();
    }

    private void fillSybaseSpecialType(DataItem item, String t) {
        if (t.equalsIgnoreCase("BIT")) {
            item.setAttribute("NOT NULL");
        }
        item.setTypeName(t);
    }

    private void fillMsSqlSpecialType(DataItem item, String t) {
        if (t.equalsIgnoreCase("TIMESTAMP")) {
            item.setTypeName("VARBINARY");
            item.setCatalog("");
        } else if (t.equalsIgnoreCase("UNIQUEIDENTIFIER")) {
            item.setTypeName(t);
            item.setHasLength(true);
        } else {
            item.setTypeName(t);
        }
    }

    private void fillOracleSpecialType(DataItem item, String t) {
        if (t.equalsIgnoreCase("LONG")) {
            item.setTypeName("CLOB");
        } else if (t.indexOf("TIMESTAMP") != -1) {
            item.setTypeName("TIMESTAMP");
            if (t.indexOf(")") > 0) {
                item.setAttribute(t.substring(t.indexOf(")") + 1, t.length()));
            }
        } else {
            item.setTypeName(t);
        }
    }

    @Override
    public Fetcher createFetcher() throws SQLException, ParseException, TypeConfigException {
        return FetcherFactory.newInstance().newFetcher(this, this.sourceMetaData);
    }
}

