/*
 * Decompiled with CFR 0.152.
 */
package com.idata.etl;

import com.idata.config.db.DBProvider;
import com.idata.core.meta.db.SourceMetaData;
import com.idata.etl.DataSource;
import com.idata.etl.Fetcher;
import java.lang.reflect.Constructor;
import java.sql.SQLException;

public class FetcherFactory {
    private static FetcherFactory _instance = new FetcherFactory();

    private FetcherFactory() {
    }

    public static FetcherFactory newInstance() {
        return _instance;
    }

    public Fetcher newFetcher(DataSource ds, SourceMetaData smd) throws SQLException {
        String provider = DBProvider.getProvider(ds.getConnection());
        String qn = this.getClass().getPackage().getName();
        String cn = qn + "." + "fetcher." + provider + "PagingFetcher";
        cn = "com.idata.etl.fetcher.FlatTablePagingFetcher";
        Fetcher fetcher = null;
        Class<?> cls = null;
        try {
            cls = Class.forName(cn);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            try {
                cls = Class.forName("com.idata.etl.impl.SimpleFetcher");
                System.out.println("use default fetcher: com.idata.etl.impl.SimpleFetcher");
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
        }
        try {
            Constructor<?> ct = cls.getConstructor(DataSource.class, SourceMetaData.class);
            fetcher = (Fetcher)ct.newInstance(ds, smd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fetcher;
    }
}

