/*
 * Decompiled with CFR 0.152.
 */
package com.idata.db2;

import com.idata.config.db.TypeConfiguration;
import com.idata.config.db.TypeConfigurationFactory;
import com.idata.core.db.type.mapping.DbType;
import com.idata.core.db.type.mapping.JavaType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DB2ConfigTest {
    private TypeConfiguration config;

    @Before
    public void setUp() {
        TypeConfigurationFactory typefactory = TypeConfigurationFactory.createInstance();
        this.config = typefactory.readConfig(TypeConfigurationFactory._IBMDB2_CONFIG);
    }

    @Test
    public void testINTEGER() {
        DbType integer = this.config.getDbtypes().get("INTEGER");
        Assert.assertEquals((Object)integer.getName(), (Object)"INTEGER");
        Assert.assertEquals((long)integer.getDb2javas().size(), (long)4L);
        Assert.assertEquals((Object)integer.getCatalog(), (Object)"number");
        Assert.assertEquals((Object)integer.getCompatible(), (Object)11);
        Assert.assertEquals((Object)integer.getDefaultDb2Java().getName(), (Object)"java.lang.Integer");
        Assert.assertEquals((Object)integer.getDefaultDb2Java().getDefault(), (Object)"yes");
    }

    @Test
    public void testSMALLINT() {
        DbType smallint = this.config.getDbtypes().get("SMALLINT");
        Assert.assertEquals((Object)smallint.getName(), (Object)"SMALLINT");
        Assert.assertEquals((long)smallint.getDb2javas().size(), (long)4L);
    }

    @Test
    public void testJava2DB() {
        JavaType str = this.config.getJavaTypes().get("java.lang.String");
        Assert.assertEquals((Object)str.getName(), (Object)"java.lang.String");
        Assert.assertEquals((long)str.getJava2Dbs().size(), (long)2L);
        Assert.assertEquals((Object)str.getDefaultJava2Db().getName(), (Object)"VARCHAR");
        Assert.assertEquals((Object)str.getDefaultJava2Db().getCatalog(), (Object)"string");
        Assert.assertEquals((Object)str.getDefaultJava2Db().getConversion(), (Object)"implicit");
    }
}

