/*
 * Decompiled with CFR 0.152.
 */
package com.idata.core.meta.db.oracle;

import com.idata.config.db.TypeConfigException;
import com.idata.core.meta.db.DataItem;
import com.idata.core.meta.db.DestinationMetaData;
import com.idata.core.meta.db.MetaData;
import com.idata.core.meta.db.QueryBuilder;
import com.idata.core.meta.db.SimpleDDL;
import com.idata.core.meta.db.SourceMetaData;
import com.idata.etl.DataSource;
import com.idata.etl.DataSourceFactory;
import com.idata.etl.ParseException;
import com.idata.log.IDataLogger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CommonTableHelper
implements SimpleDDL,
QueryBuilder {
    private IDataLogger logger;
    private MetaData meta;
    private Connection cnn;

    public CommonTableHelper(MetaData meta, Connection cnn) {
        this.meta = meta;
        this.cnn = cnn;
    }

    public CommonTableHelper(Connection cnn, MetaData meta) {
        this.meta = meta;
        this.cnn = cnn;
    }

    @Override
    public String truncateScript() {
        String sql = "TRUNCATE TABLE " + this.meta.getFullName();
        return sql;
    }

    @Override
    public boolean exist() throws SQLException {
        String[] types = new String[]{"TABLE", "VIEW"};
        String schema = null;
        if (this.meta.getSchema() != null) {
            schema = this.meta.getSchema().toUpperCase();
        }
        ResultSet rs = this.cnn.getMetaData().getTables(null, schema, this.meta.getName().toUpperCase(), types);
        boolean r = rs.next();
        rs.close();
        return r;
    }

    @Override
    public String createScript() {
        String sql = "CREATE TABLE " + this.meta.getFullName() + " (";
        for (DataItem item : this.meta.getDataItems()) {
            String catalog = item.getCatalog();
            sql = sql + item.getName().toUpperCase() + " " + item.getTypeName().toUpperCase();
            if (!("number".equalsIgnoreCase(catalog) || "lob".equalsIgnoreCase(catalog) || "date".equalsIgnoreCase(catalog) || "other".equalsIgnoreCase(catalog))) {
                if (item.getPrecision() > 0) {
                    sql = sql + "(" + item.getPrecision() + ")";
                } else if (item.getLength() > 0) {
                    sql = sql + "(" + item.getLength() + ")";
                }
            }
            if (item.getAttribute() != null && item.getAttribute().length() > 1) {
                sql = sql + " " + item.getAttribute();
            }
            sql = sql + ",\n";
        }
        sql = sql.substring(0, sql.lastIndexOf(","));
        sql = sql + ")\n";
        return sql;
    }

    @Override
    public void create() throws SQLException {
        String sql = this.createScript();
        Statement statement = this.cnn.createStatement();
        statement.setQueryTimeout(10);
        statement.execute(sql);
        statement.close();
    }

    @Override
    public void drop() throws SQLException {
        Statement statement = this.cnn.createStatement();
        String sql = "DROP TABLE " + this.meta.getFullName();
        statement.execute(sql);
        statement.close();
    }

    @Override
    public void replace() {
    }

    @Override
    public void alter() {
    }

    @Override
    public String selectScript() {
        String alias = "t";
        String sql = this.selectClause();
        sql = sql + "\n FROM " + this.meta.getFullName() + " " + alias;
        return sql;
    }

    @Override
    public String deleteScript() {
        String sql = "DELETE FROM " + this.meta.getFullName() + " \n where ";
        for (String col : this.meta.getPrimaryKey()) {
            sql = sql + col + "=?\n and ";
        }
        sql = sql.substring(0, sql.length() - 4);
        return sql.toUpperCase();
    }

    @Override
    public String updateScript() {
        String sql = "UPDATE " + this.meta.getFullName() + " \n SET ";
        for (DataItem e : this.meta.getDataItems()) {
            sql = sql + e.getName() + "=?,";
        }
        sql = sql.substring(0, sql.length() - 1) + " \n where ";
        for (String key : this.meta.getPrimaryKey()) {
            sql = sql + key + "=?,";
        }
        sql = sql.substring(0, sql.length() - 1);
        return sql.toUpperCase();
    }

    @Override
    public String insertScript() {
        String sql = "INSERT INTO " + this.meta.getFullName() + "(";
        String parmsymbol = "";
        for (DataItem item : this.meta.getDataItems()) {
            sql = sql + item.getName() + ",";
            if ("Oracle".equalsIgnoreCase(this.meta.getProvider()) && ("URITYPE".equalsIgnoreCase(item.getTypeName()) || "SYS.URITYPE".equalsIgnoreCase(item.getTypeName()))) {
                parmsymbol = parmsymbol + "SYS.URIFACTORY.GETURI(?),";
                continue;
            }
            parmsymbol = parmsymbol + "?,";
        }
        sql = sql.substring(0, sql.length() - 1);
        parmsymbol = parmsymbol.substring(0, parmsymbol.length() - 1);
        sql = sql + "\n ) values (" + parmsymbol + ")";
        return sql.toUpperCase();
    }

    public boolean validate() throws SQLException, ParseException, TypeConfigException {
        DataSource nds = DataSourceFactory.createDataSource(this.cnn, null, this.meta.getSchema(), this.meta.getName().toUpperCase());
        SourceMetaData smd = nds.getSourceMetaData();
        if (smd.getDataItems().size() < this.meta.getDataItems().size()) {
            this.logger.info("destination table columns are not enough!");
            return false;
        }
        for (DataItem e : this.meta.getDataItems()) {
            if (smd.get(e.getName()) != null) continue;
            this.logger.info("couldn't find the column named " + this.meta.getName() + " from the destination table");
            return false;
        }
        return true;
    }

    public Connection getConnection() {
        return this.cnn;
    }

    public void setConnection(Connection cnn) {
        this.cnn = cnn;
    }

    public CommonTableHelper() {
    }

    public CommonTableHelper(DestinationMetaData metadata, Connection connection) {
        this.meta = metadata;
        this.cnn = connection;
    }

    public MetaData getDestinationMetaData() {
        return this.meta;
    }

    public void setDestinationMetaData(DestinationMetaData destinationMetaData) {
        this.meta = destinationMetaData;
    }

    @Override
    public String purgeScript() {
        return "DELETE FROM " + this.meta.getFullName();
    }

    public String innerClause() {
        String alias = "t";
        String clause = "SELECT ";
        for (DataItem item : this.meta.getDataItems()) {
            clause = clause + " " + alias + "." + item.getName() + ",\n";
        }
        clause = clause.substring(0, clause.lastIndexOf(",\n"));
        return clause;
    }

    @Override
    public String selectClause() {
        String alias = "t";
        String sql = "SELECT ";
        for (DataItem item : this.meta.getDataItems()) {
            if (this.meta.getProvider().equalsIgnoreCase("Oracle") && (item.getTypeName().equalsIgnoreCase("URITYPE") || item.getTypeName().equalsIgnoreCase("SYS.URITYPE"))) {
                sql = sql + " " + alias + "." + item.getName() + ".getURL() as " + item.getName() + ",\n";
                continue;
            }
            sql = sql + " " + alias + "." + item.getName() + ",\n";
        }
        sql = sql.substring(0, sql.lastIndexOf(",\n"));
        return sql;
    }

    public IDataLogger getLogger() {
        return this.logger;
    }

    public void setIDataLogger(IDataLogger logger) {
        this.logger = logger;
    }
}

