/*
 * Decompiled with CFR 0.152.
 */
package com.idata.config.db;

import com.idata.config.db.TypeConfigException;
import com.idata.core.db.type.mapping.Db2Java;
import com.idata.core.db.type.mapping.DbType;
import com.idata.core.db.type.mapping.JavaType;
import com.idata.core.meta.db.DataItem;
import java.util.Hashtable;

public class TypeConfiguration {
    private String fileName;
    private Hashtable<String, DbType> dbtypes = new Hashtable(0);
    private Hashtable<String, JavaType> javaTypes = new Hashtable(0);
    private Hashtable<String, DbType> stringTypes = new Hashtable(0);
    private Hashtable<String, DbType> numberTypes = new Hashtable(0);
    private Hashtable<String, DbType> dateTypes = new Hashtable(0);
    private Hashtable<String, DbType> lobTypes = new Hashtable(0);

    public DataItem convertDateType(DataItem e) throws TypeConfigException {
        String typeName;
        DataItem r = e.clone();
        Db2Java db2java = e.getDbType().getDefaultDb2Java();
        JavaType javaType = this.javaTypes.get(db2java.getName());
        if (javaType == null) {
            for (Db2Java t : e.getDbType().getDb2javas()) {
                if ("yes".equalsIgnoreCase(t.getDefault()) || this.javaTypes.get(t.getName()) == null) continue;
                javaType = this.javaTypes.get(t.getName());
                typeName = javaType.getDefaultJava2Db().getName();
                break;
            }
        }
        if (javaType == null) {
            throw new TypeConfigException("cannot find java type [" + db2java.getName() + "] for dbtype: [" + e.getTypeName() + "] in config " + this.fileName);
        }
        typeName = javaType.getDefaultJava2Db().getName();
        DbType dbtype = this.dbtypes.get(typeName);
        if (dbtype == null) {
            throw new TypeConfigException("cannot find DB type for [" + typeName + "]");
        }
        if (e.getPrecision() > dbtype.getMaxLength() && dbtype.getMaxLength() > 0) {
            dbtype = this.dbtypes.get(dbtype.getConversion());
        }
        if (dbtype.getCatalog().equalsIgnoreCase("string") && e.getPrecision() <= 0) {
            r.setPrecision(javaType.getDefaultJava2Db().getDefaultPrecision());
            r.setScale(0);
        }
        if (dbtype.getCatalog().equalsIgnoreCase("number")) {
            r.setPrecision(0);
            r.setScale(0);
        }
        if (dbtype.getCatalog().equalsIgnoreCase("lob")) {
            r.setPrecision(0);
            r.setScale(0);
        }
        r.setTypeName(dbtype.getName());
        r.setCatalog(dbtype.getCatalog());
        return r;
    }

    public String convertType(String src) {
        Db2Java db2Java = this.dbtypes.get(src).getDefaultDb2Java();
        JavaType javaType = this.javaTypes.get(db2Java.getName());
        return javaType == null ? null : javaType.getDefaultJava2Db().getName();
    }

    public String findCatalog(String type) {
        DbType dbtype = this.dbtypes.get(type);
        return dbtype == null ? null : dbtype.getCatalog();
    }

    public Hashtable<String, DbType> getDbtypes() {
        return this.dbtypes;
    }

    public void setDbtypes(Hashtable<String, DbType> dbtypes) {
        this.dbtypes = dbtypes;
    }

    public Hashtable<String, JavaType> getJavaTypes() {
        return this.javaTypes;
    }

    public void setJavaTypes(Hashtable<String, JavaType> javaTypes) {
        this.javaTypes = javaTypes;
    }

    public Hashtable<String, DbType> getStringTypes() {
        return this.stringTypes;
    }

    public void setStringTypes(Hashtable<String, DbType> stringTypes) {
        this.stringTypes = stringTypes;
    }

    public Hashtable<String, DbType> getNumberTypes() {
        return this.numberTypes;
    }

    public void setNumberTypes(Hashtable<String, DbType> numberTypes) {
        this.numberTypes = numberTypes;
    }

    public Hashtable<String, DbType> getDateTypes() {
        return this.dateTypes;
    }

    public void setDateTypes(Hashtable<String, DbType> dateTypes) {
        this.dateTypes = dateTypes;
    }

    public Hashtable<String, DbType> getLobTypes() {
        return this.lobTypes;
    }

    public void setLobTypes(Hashtable<String, DbType> lobTypes) {
        this.lobTypes = lobTypes;
    }

    public DbType getDbType(DataItem item) throws TypeConfigException {
        if (item.getTypeName().equalsIgnoreCase("TIMESTAMP") && item.getAttribute() != null && item.getAttribute().length() == 0) {
            return this.getDbType(item.getTypeName() + item.getAttribute());
        }
        return this.getDbType(item.getTypeName());
    }

    public DbType getDbType(String type) throws TypeConfigException {
        DbType t = this.dbtypes.get(type.toUpperCase());
        if (t == null) {
            throw new TypeConfigException("cannot find database type: [" + type + "] in config " + this.fileName);
        }
        return this.dbtypes.get(type.toUpperCase());
    }

    public JavaType getJavaType(String name) {
        return this.javaTypes.get(name);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

