/*
 * Decompiled with CFR 0.152.
 */
package com.idata.config.db;

import com.idata.config.db.TypeConfiguration;
import com.idata.config.db.TypeConfigurationFactory;
import com.idata.core.db.type.mapping.DbType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TypeCfgFactoryTest {
    private TypeConfiguration config;

    @Before
    public void setUp() {
        TypeConfigurationFactory typefactory = TypeConfigurationFactory.createInstance();
        this.config = typefactory.readConfig(TypeConfigurationFactory._ORACLE_CONIFIG);
    }

    @Test
    public void testINT() {
        DbType dbtype = this.config.getDbtypes().get("INT");
        Assert.assertEquals((Object)dbtype.getName(), (Object)"INT");
        Assert.assertEquals((Object)dbtype.getDefaultDb2Java().getName(), (Object)"java.lang.Integer");
        Assert.assertEquals((long)dbtype.getDb2javas().size(), (long)4L);
    }

    @Test
    public void testReadConfig() {
        DbType dbtype = this.config.getDbtypes().get("SMALLINT");
        Assert.assertEquals((Object)dbtype.getCatalog(), (Object)"number");
    }

    @Test
    public void testStringCatalog() {
        Assert.assertEquals((long)this.config.getStringTypes().size(), (long)9L);
    }

    @Test
    public void testNumberCatalog() {
        Assert.assertEquals((long)this.config.getNumberTypes().size(), (long)9L);
    }

    @Test
    public void testDateCatalog() {
        Assert.assertEquals((Object)this.config.getDateTypes().get("DATE").getDefaultDb2Java().getName(), (Object)"java.util.Date");
    }

    @Test
    public void testDefaultType() {
        Assert.assertEquals((long)this.config.getDateTypes().size(), (long)5L);
        Assert.assertEquals((long)this.config.getDateTypes().get("DATE").getCompatible().intValue(), (long)10L);
    }

    public TypeConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(TypeConfiguration config) {
        this.config = config;
    }
}

