.TH INDXBIB 1 "4 November 2014" "Groff Version 1.22.3"
.SH NAME
indxbib \- make inverted index for bibliographic databases
.
.
.de co
Copyright \[co] 1989-2014 Free Software Foundation, Inc.

Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.

Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
..
.
.\" --------------------------------------------------------------------
.SH SYNOPSIS
.\" --------------------------------------------------------------------
.
.nr a \n(.j
.ad l
.nr i \n(.i
.in +\w'\fBindxbib 'u
.ti \niu
.B indxbib
.de OP
.ie \\n(.$-1 .RI "[\ \fB\\$1\fP" "\\$2" "\ ]"
.el .RB "[\ " "\\$1" "\ ]"
..
.OP \-vw
.OP \-c file
.OP \-d dir
.OP \-f file
.OP \-h n
.OP \-i string
.OP \-k n
.OP \-l n
.OP \-n n
.OP \-o file
.OP \-t n
.RI [\  filename \|.\|.\|.\ ]
.ad \na
.
.
.\" --------------------------------------------------------------------
.SH DESCRIPTION
.\" --------------------------------------------------------------------
.
.B indxbib
makes an inverted index for the bibliographic databases in
.IR filename \|.\|.\|.
for use with
.BR refer (1),
.BR lookbib (1),
and
.BR lkbib (1).
.
The index will be named
.IB filename .i\fR;
the index is written to a temporary file which is then renamed to
this.
.
If no filenames are given on the command line because the
.B \-f
option has been used, and no
.B \-o
option is given, the index will be named
.BR Ind.i .
.
.
.LP
Bibliographic databases are divided into records by blank lines.
Within a record, each fields starts with a
.B %
character at the beginning of a line.
.
Fields have a one letter name which follows the
.B %
character.
.
.
.LP
The values set by the
.BR \-c ,
.BR \-n ,
.BR \-l
and
.B \-t
options are stored in the index;
when the index is searched, keys will be discarded and truncated in a
manner appropriate to these options;
the original keys will be used for verifying that any record
found using the index actually contains the keys.
.
This means that a user of an index need not know whether these
options were used in the creation of the index,
provided that not all the keys to be searched for
would have been discarded during indexing
and that the user supplies at least the part of each key
that would have remained after being truncated during indexing.
.
The value set by the
.B \-i
option is also stored in the index
and will be used in verifying records found using the index.
.
.
.\" --------------------------------------------------------------------
.SH OPTIONS
.\" --------------------------------------------------------------------
.
It is possible to have whitespace between a command line option and its
parameter.
.
.TP
.B \-v
Print the version number.
.
.TP
.B \-w
Index whole files.
.
Each file is a separate record.
.
.TP
.BI \-c file
Read the list of common words from
.I file
instead of
.BR d:/usr/share/groff/1.22.3/eign .
.
.TP
.BI \-d dir
Use
.I dir
as the pathname of the current working directory to store in the index,
instead of the path printed by
.BR pwd (1).
.
Usually
.I dir
will be a symbolic link that points to the directory printed by
.BR pwd (1).
.
.TP
.BI \-f file
Read the files to be indexed from
.IR file .
.
If
.I file
is
.BR \- ,
files will be read from the standard input.
The
.B \-f
option can be given at most once.
.
.TP
.BI \-i string
Don\[aq]t index the contents of fields whose names are in
.IR string .
.
Initially
.I string
is
.BR XYZ .
.
.TP
.BI \-h n
Use the first prime greater than or equal to
.I n
for the size of the hash table.
.
Larger values of
.I n
will usually make searching faster,
but will make the index larger
and
.B indxbib
use more memory.
.
Initially
.I n
is 997.
.
.TP
.BI \-k n
Use at most
.I n
keys per input record.
.
Initially
.I n
is 100.
.
.TP
.BI \-l n
Discard keys that are shorter than
.IR n .
.
Initially
.I n
is 3.
.
.TP
.BI \-n n
Discard the
.I n
most common words.
.
Initially
.I n
is 100.
.
.TP
.BI \-o basename
The index should be named
.IB basename .i\fR.
.
.TP
.BI \-t n
Truncate keys to
.IR n .
.
Initially
.I n
is 6.
.
.
.\" --------------------------------------------------------------------
.SH FILES
.\" --------------------------------------------------------------------
.
.TP \w'\fBindxbib\fIXXXXXX'u+2n
.IB filename .i
Index.
.
.TP
.B Ind.i
Default index name.
.
.TP
.B d:/usr/share/groff/1.22.3/eign
List of common words.
.
.TP
.BI indxbib XXXXXX
Temporary file.
.
.
.\" --------------------------------------------------------------------
.SH "SEE ALSO"
.\" --------------------------------------------------------------------
.BR refer (1),
.BR lkbib (1),
.BR lookbib (1)
.
.
.\" --------------------------------------------------------------------
.SH COPYING
.\" --------------------------------------------------------------------
.co
.
.
.\" Local Variables:
.\" mode: nroff
.\" End:
