.TH AFMTODIT 1 "4 November 2014" "Groff Version 1.22.3"
.SH NAME
afmtodit \- create font files for use with groff \-Tps and \-Tpdf
.
.
.\" --------------------------------------------------------------------
.\" Leagal Terms
.
.de co
Copyright \[co] 1989-2014 Free Software Foundation, Inc.

Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.

Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
..
.
.\" --------------------------------------------------------------------
.\" Definitions
.
.\" Like TP, but if specified indent is more than half
.\" the current line-length - indent, use the default indent.
.de Tp
.  ie \\n(.$=0:((0\\$1)*2u>(\\n(.lu-\\n(.iu)) .TP
.  el .TP "\\$1"
..
.
.de OP
.  ie \\n(.$-1 .RI "[\ \fB\\$1\fP\ " "\\$2" "\ ]"
.  el .RB "[\ " "\\$1" "\ ]"
..
.
.\" --------------------------------------------------------------------
.SH SYNOPSIS
.\" --------------------------------------------------------------------
.
.nr a \n(.j
.ad l
.nr i \n(.i
.in +\w'\fBafmtodit 'u
.ti \niu
.B afmtodit
.OP \-ckmnsvx
.OP \-a n
.OP \-d desc_file
.OP \-e enc_file
.OP \-f internal_name
.OP \-i n
.OP \-o out_file
.I afm_file
.I map_file
.I font
.br
.ad \na
.
.
.LP
The whitespace between a command line option and its argument is optional.
.
.
.\" --------------------------------------------------------------------
.SH DESCRIPTION
.\" --------------------------------------------------------------------
.
.B afmtodit
creates a font file for use with groff,
.BR grops ,
and
.BR gropdf .
.
.B afmtodit
is written in perl;
you must have perl version 5.004 or newer installed in order to run
.BR afmtodit .
.
.
.LP
.I afm_file
is the AFM (Adobe Font Metric) file for the font.
.
.
.LP
.I map_file
is a file that says which groff character names map onto
each PostScript character name;
this file should contain a sequence of lines of the form
.IP
.I
ps_char groff_char
.LP
where
.I ps_char
is the PostScript name of the character and
.I groff_char
is the groff name of the character (as used in the groff font file).
.
The same
.I ps_char
can occur multiple times in the file;
each
.I groff_char
must occur at most once.
.
Lines starting with
.B #
and blank lines are ignored.
.
If the file isn\[aq]t found in the current directory, it is searched
in the \[oq]devps/generate\[cq] subdirectory of the default font
directory.
.
.
.LP
If a PostScript character is not mentioned in
.IR map_file ,
and a generic groff glyph name can't be deduced using the Adobe Glyph
List (AGL, built into
.BR afmtodit ),
then
.B afmtodit
puts the PostScript character into the groff font file as an unnamed
character which can only be accessed by the
.B \eN
escape sequence in
.BR troff .
.
In particular, this is true for glyph variants like \[oq]foo.bar\[cq];
all glyph names containing one or more periods are mapped to unnamed
entities.
.
If option
.B \-e
is not specified, the encoding defined in the AFM file (i.e., entries
with non-negative character codes) is used.
.
Please refer to section \[oq]Using Symbols\[cq] in the groff info file
which describes how groff glyph names are constructed.
.
.
.LP
Characters not encoded in the AFM file (i.e., entries which have \-1
as the character code) are still available in groff; they get glyph
index values greater than 255 (or greater than the biggest character
code used in the AFM file in the unlikely case that it is greater than
255) in the groff font file.
.
Glyph indices of unencoded characters don\[aq]t have a specific order;
it is best to access them with glyph names only.
.
.
.LP
The groff font file will be output to a file called
.IR font ,
unless the
.B \-o
option is used.
.
.
.LP
If there is a downloadable font file for the font, it may be listed in
the file
.BR d:/usr/share/groff/1.22.3/font/devps/download ;
see
.BR grops (1).
.
.
.LP
If the
.B \-i
option is used,
.B afmtodit
will automatically generate an italic correction,
a left italic correction and a subscript correction
for each character
(the significance of these parameters is explained in
.BR groff_font (5));
these parameters may be specified for individual characters by
adding to the
.I afm_file
lines of the form:
.IP
.BI italicCorrection\  ps_char\ n
.br
.BI leftItalicCorrection\  ps_char\ n
.br
.BI subscriptCorrection\  ps_char\ n
.LP
where
.I ps_char
is the PostScript name of the character,
and
.I n
is the desired value of the corresponding parameter in thousandths of an em.
.
These parameters are normally needed only for italic (or oblique) fonts.
.
.
.\" --------------------------------------------------------------------
.SH OPTIONS
.\" --------------------------------------------------------------------
.
.TP
.BI \-a n
Use
.I n
as the slant parameter in the font file;
this is used by groff in the positioning of accents.
.
By default
.B afmtodit
uses the negative of the ItalicAngle specified in the afm file;
with true italic fonts it is sometimes desirable to use
a slant that is less than this.
.
If you find that characters from an italic font have accents
placed too far to the right over them,
then use the
.B \-a
option to give the font a smaller slant.
.
.TP
.B \-c
Include comments in the font file in order to identify the PS font.
.
.TP
.BI \-d desc_file
The device description file is
.I desc_file
rather than the default
.BR DESC .
.
If not found in the current directory, the \[oq]devps\[qc]
subdirectory of the default font directory is searched (this is true
for both the default device description file and a file given with
option
.BR \-d ).
.
.TP
.BI \-e enc_file
The PostScript font should be reencoded to use the encoding described
in enc_file.
.
The format of
.I enc_file
is described in
.BR grops (1).
.
If not found in the current directory, the \[oq]devps\[cq]
subdirectory of the default font directory is searched.
.
.TP
.BI \-f name
The internal name of the groff font is set to
.IR name .
.
.TP
.BI \-i n
Generate an italic correction for each character so that the
character's width plus the character's italic correction is equal to
.I n
thousandths of an em
plus the amount by which the right edge of the character's bounding box
is to the right of the character\[aq]s origin.
.
If this would result in a negative italic correction, use a zero
italic correction instead.
.
.IP
Also generate a subscript correction equal to the
product of the tangent of the slant of the font and
four fifths of the x-height of the font.
.
If this would result in a subscript correction greater than the italic
correction, use a subscript correction equal to the italic correction
instead.
.
.IP
Also generate a left italic correction for each character
equal to
.I n
thousandths of an em
plus the amount by which the left edge of the character's bounding box
is to the left of the character\[aq]s origin.
.
The left italic correction may be negative unless option
.B \-m
is given.
.
.IP
This option is normally needed only with italic (or oblique) fonts.
.
The font files distributed with groff were created using an option of
.B \-i50
for italic fonts.
.
.TP
.BI \-o out_file
The output file is
.I out_file
instead of
.IR font .
.
.TP
.B \-k
Omit any kerning data from the groff font.
.
This should be used only for mono-spaced fonts.
.
.TP
.B \-m
Prevent negative left italic correction values.
.
Roman font files distributed with groff were created with
.B \-i0\ \-m
to improve spacing with
.BR eqn (1).
.
.TP
.B \-n
Don't output a
.B ligatures
command for this font.
.
Use this with constant-width fonts.
.
.TP
.B \-s
The font is special.
.
The effect of this option is to add the
.B special
command to the font file.
.
.TP
.B \-v
Print version.
.
.TP
.B \-x
Don't use the built-in Adobe Glyph List.
.
.
.\" --------------------------------------------------------------------
.SH FILES
.\" --------------------------------------------------------------------
.
.Tp \w'\fBd:/usr/share/groff/1.22.3/font/devps/download'u+2n
.B d:/usr/share/groff/1.22.3/font/devps/DESC
Device description file.
.
.TP
.BI d:/usr/share/groff/1.22.3/font/devps/ F
Font description file for font
.IR F .
.
.TP
.B d:/usr/share/groff/1.22.3/font/devps/download
List of downloadable fonts.
.
.TP
.B d:/usr/share/groff/1.22.3/font/devps/text.enc
Encoding used for text fonts.
.
.TP
.B d:/usr/share/groff/1.22.3/font/devps/generate/textmap
Standard mapping.
.
.
.\" --------------------------------------------------------------------
.SH "SEE ALSO"
.\" --------------------------------------------------------------------
.
.BR groff (1),
.BR grops (1),
.BR groff_font (5),
.BR perl (1)
.
.
.LP
The groff info file, section \[oq]Using Symbols\[cq].
.
.
.\" --------------------------------------------------------------------
.SH COPYING
.\" --------------------------------------------------------------------
.co
.
.
.\" Local Variables:
.\" mode: nroff
.\" End:
