.TH EQN 1 "4 November 2014" "Groff Version 1.22.3"
.SH NAME
eqn \- format equations for troff or MathML
.
.
.\" license (copying)
.de co
Copyright \[co] 1989-2014 Free Software Foundation, Inc.

Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.

Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
..
.
.ie \n(.V<\n(.v \
.  ds tx T\h'-.1667m'\v'.224m'E\v'-.224m'\h'-.125m'X
.el \
.  ds tx TeX
.
.
.\" Like TP, but if specified indent is more than half
.\" the current line-length - indent, use the default indent.
.de Tp
.  ie \\n(.$=0:((0\\$1)*2u>(\\n(.lu-\\n(.iu)) .TP
.  el .TP "\\$1"
..
.
.\" The BSD man macros can't handle " in arguments to font change macros,
.\" so use \(ts instead of ".
.tr \(ts"\""
.
.
.\" --------------------------------------------------------------------
.SH SYNOPSIS
.\" --------------------------------------------------------------------
.
.SY eqn
.OP \-rvCNR
.OP \-d xy
.OP \-T name
.OP \-M dir
.OP \-f F
.OP \-s n
.OP \-p n
.OP \-m n
.RI [ files\|.\|.\|. ]
.YS
.
.
.\" --------------------------------------------------------------------
.SH DESCRIPTION
.\" --------------------------------------------------------------------
.
This manual page describes the GNU version of
.BR eqn ,
which is part of the groff document formatting system.
.
.B eqn
compiles descriptions of equations embedded within
.B troff
input files into commands that are understood by
.BR troff .
.
Normally, it should be invoked using the
.B \-e
option of
.BR groff .
.
The syntax is quite compatible with Unix eqn.
.
The output of GNU
.B eqn
cannot be processed with Unix troff;
it must be processed with GNU troff.
.
If no files are given on the command line, the standard input is read.
.
A filename of
.B \-
causes the standard input to be read.
.
.
.LP
.B eqn
searches for the file
.B eqnrc
in the directories given with the
.B \-M
option first, then in
.BR d:/usr/lib/groff/site-tmac ,
.BR d:/usr/share/groff/site-tmac ,
and finally in the standard macro directory
.BR d:/usr/share/groff/1.22.3/tmac .
.
If it exists,
.B eqn
processes it before the other input files.
.
The
.B \-R
option prevents this.
.
.
.LP
GNU
.B eqn
does not provide the functionality of neqn:
it does not support low-resolution, typewriter-like devices
(although it may work adequately for very simple input).
.
.
.\" --------------------------------------------------------------------
.SH OPTIONS
.\" --------------------------------------------------------------------
.
.LP
It is possible to have whitespace between a command line option and its
parameter.
.
.TP
.BI \-d xy
Specify delimiters
.I x
and\~\c
.I y
for the left and right end, respectively, of in-line equations.
.
Any
.B delim
statements in the source file overrides this.
.
.TP
.B \-C
Recognize
.B .EQ
and
.B .EN
even when followed by a character other than space or newline.
.
Also, the statement
.RB \[oq] "delim on" \[cq]
is not handled specially.
.
.TP
.B \-N
Don\[aq]t allow newlines within delimiters.
.
This option allows
.B eqn
to recover better from missing closing delimiters.
.
.TP
.B \-v
Print the version number.
.
.TP
.B \-r
Only one size reduction.
.
.TP
.BI \-m n
The minimum point-size is\~\c
.IR n .
.
.B eqn
does not reduce the size of subscripts or superscripts to
a smaller size than\~\c
.IR n .
.
.TP
.BI \-T name
The output is for device
.IR name .
.
Normally, the only effect of this is to define a macro
.I name
with a value of\~\c
.BR 1 ;
.B eqnrc
uses this to provide definitions appropriate for the output device.
.
However, if the specified device is \[lq]MathML\[rq], the output is
MathML markup rather than troff commands, and
.B eqnrc
is not loaded at all.
.
The default output device is
.BR ps .
.
.TP
.BI \-M dir
Search
.I dir
for
.B eqnrc
before the default directories.
.
.TP
.B \-R
Don\[aq]t load
.BR eqnrc .
.
.TP
.BI \-f F
This is equivalent to a
.BI gfont\  F
command.
.
.TP
.BI \-s n
This is equivalent to a
.BI gsize\  n
command.
.
This option is deprecated.
.B eqn
normally sets equations at whatever the current point size
is when the equation is encountered.
.
.TP
.BI \-p n
This says that subscripts and superscripts should be
.I n\~\c
points smaller than the surrounding text.
.
This option is deprecated.
.
Normally
.B eqn
sets subscripts and superscripts at 70% of the size of the surrounding
text.
.
.
.\" --------------------------------------------------------------------
.SH USAGE
.\" --------------------------------------------------------------------
.
Only the differences between GNU
.B eqn
and Unix eqn are described here.
.
.
.LP
GNU
.B eqn
emits Presentation MathML output when invoked with the
.B "-T\~MathML"
option.
.
.
.LP
GNU eqn sets the input token
.B \&"..."
as three periods or low dots, rather than the three centered dots of
classic eqn.  To get three centered dots, write
.B "cdots"
or
.BR "cdot cdot cdot".
.
.
.LP
Most of the new features of the GNU
.B eqn
input language are based on \*(tx.
.
There are some references to the differences between \*(tx and GNU
.B eqn
below;
these may safely be ignored if you do not know \*(tx.
.
.
.\" --------------------------------------------------------------------
.SS Controlling delimiters
.\" --------------------------------------------------------------------
.
If not in compatibility mode,
.B eqn
recognizes
.
.RS
.LP
.B delim on
.RE
.
.LP
to restore the delimiters which have been previously disabled
with a call to
.RB \[oq] "delim off" \[cq].
.
If delimiters haven\[aq]t been specified, the call has no effect.
.
.
.\" --------------------------------------------------------------------
.SS Automatic spacing
.\" --------------------------------------------------------------------
.
.B eqn
gives each component of an equation a type, and adjusts the spacing
between components using that type.
.
Possible types are:
.
.RS
.TP \w'punctuation'u+2n
ordinary an ordinary character such as \[oq]1\[cq] or \[oq]\c
.IR x \[cq];
.
.TP
operator
a large operator such as
.ds Su \[oq]\s+5\(*S\s0\[cq]
.if \n(.g .if !c\(*S .ds Su the summation operator
\*(Su;
.
.TP
binary
a binary operator such as \[oq]\[pl]\[cq];
.
.TP
relation
a relation such as \[oq]=\[cq];
.
.TP
opening
a opening bracket such as \[oq](\[cq];
.
.TP
closing
a closing bracket such as \[oq])\[cq];
.
.TP
punctuation
a punctuation character such as \[oq],\[cl];
.
.TP
inner
a subformula contained within brackets;
.
.TP
suppress spacing
that suppresses automatic spacing adjustment.
.RE
.
.
.LP
Components of an equation
get a type in one of two ways.
.
.TP
.BI type\  t\ e
This yields an equation component that contains\~\c
.I e
but that has type\~\c
.IR t ,
where
.I t
is one of the types mentioned above.
.
For example,
.B times
is defined as
.
.RS
.IP
.B
type "binary" \e(mu
.RE
.
.IP
The name of the type doesn\[aq]t have to be quoted, but quoting protects
from macro expansion.
.
.TP
.BI chartype\  t\ text
Unquoted groups of characters are split up into individual characters,
and the type of each character is looked up;
this changes the type that is stored for each character;
it says that the characters in
.I text
from now on have type\~\c
.IR t .
For example,
.
.RS
.IP
.B
chartype "punctuation" .,;:
.RE
.
.IP
would make the characters \[oq].,;:\[cq] have type punctuation
whenever they subsequently appeared in an equation.
.
The type\~\c
.I t
can also be
.B letter
or
.BR digit ;
in these cases
.B chartype
changes the font type of the characters.
.
See the
.B Fonts
subsection.
.
.
.\" --------------------------------------------------------------------
.SS New primitives
.\" --------------------------------------------------------------------
.
.TP
.BI big\  e
Enlarges the expression it modifies; intended to have semantics like
CSS \[oq]large\[cq].
.
In troff output, the point size is increased by\~5; in MathML output,
the expression uses
.
.RS
.IP
.EX
<mstyle \%mathsize='big'>
.EE
.RE
.
.TP
.IB e1\  smallover\  e2
This is similar to
.BR over ;
.B smallover
reduces the size of
.I e1
and
.IR e2 ;
it also puts less vertical space between
.I e1
or
.I e2
and the fraction bar.
.
The
.B over
primitive corresponds to the \*(tx
.B \eover
primitive in display styles;
.B smallover
corresponds to
.B \eover
in non-display styles.
.
.TP
.BI vcenter\  e
This vertically centers
.I e
about the math axis.
.
The math axis is the vertical position about which characters such as
\[oq]\[pl]\[]cq and \[oq]\[mi]\[cq] are centered; also it is the
vertical position used for the bar of fractions.
.
For example,
.B sum
is defined as
.
.RS
.IP
.B
{ type "operator" vcenter size +5 \e(*S }
.RE
.
.IP
(Note that vcenter is silently ignored when generating MathML.)
.
.TP
.IB e1\  accent\  e2
This sets
.I e2
as an accent over
.IR e1 .
.I e2
is assumed to be at the correct height for a lowercase letter;
.I e2
is moved down according to whether
.I e1
is taller or shorter than a lowercase letter.
.
For example,
.B hat
is defined as
.
.RS
.IP
.B
accent { "^" }
.RE
.
.IP
.BR dotdot ,
.BR dot ,
.BR tilde ,
.BR vec ,
and
.B dyad
are also defined using the
.B accent
primitive.
.
.TP
.IB e1\  uaccent\  e2
This sets
.I e2
as an accent under
.IR e1 .
.I e2
is assumed to be at the correct height for a character without a descender;
.I e2
is moved down if
.I e1
has a descender.
.
.B utilde
is pre-defined using
.B uaccent
as a tilde accent below the baseline.
.
.TP
.BI split\ \(ts text \(ts
This has the same effect as simply
.
.RS
.IP
.I text
.RE
.
.IP
but
.I text
is not subject to macro expansion because it is quoted;
.I text
is split up and the spacing between individual characters is adjusted.
.
.TP
.BI nosplit\  text
This has the same effect as
.
.RS
.IP
.BI \(ts text \(ts
.RE
.
.IP
but because
.I text
is not quoted it is subject to macro expansion;
.I text
is not split up
and the spacing between individual characters is not adjusted.
.
.TP
.IB e\  opprime
This is a variant of
.B prime
that acts as an operator on\~\c
.IR e .
.
It produces a different result from
.B prime
in a case such as
.BR A\ opprime\ sub\ 1 :
with
.B opprime
the\~\c
.B 1
is tucked under the prime as a subscript to the\~\c
.B A
(as is conventional in mathematical typesetting),
whereas with
.B prime
the\~\c
.B 1
is a subscript to the prime character.
.
The precedence of
.B opprime
is the same as that of
.B bar
and
.BR under ,
which is higher than that of everything except
.B accent
and
.BR uaccent .
.
In unquoted text a\~\c
.B \[aq]
that is not the first character is treated like
.BR opprime .
.
.TP
.BI special\  text\ e
This constructs a new object from\~\c
.I e
using a
.BR troff (1)
macro named
.IR text .
.
When the macro is called,
the string
.B 0s
contains the output for\~\c
.IR e ,
and the number registers
.BR 0w ,
.BR 0h ,
.BR 0d ,
.BR 0skern ,
and
.BR 0skew
contain the width, height, depth, subscript kern, and skew of\~\c
.IR e .
.
(The
.I "subscript kern"
of an object says how much a subscript on that object should be tucked in;
the
.I skew
of an object says how far to the right of the center of the object an
accent over the object should be placed.)
.
The macro must modify
.B 0s
so that it outputs the desired result with its origin at the current
point, and increase the current horizontal position by the width
of the object.
.
The number registers must also be modified so that they correspond to the
result.
.
.IP
For example, suppose you wanted a construct that \[oq]cancels\[cq] an
expression by drawing a diagonal line through it.
.
.RS
.IP
.ft B
.if t .ne 6+\n(.Vu
.br
\&.EQ
.br
define cancel 'special Ca'
.br
\&.EN
.br
\&.de Ca
.br
\&.\ \ ds 0s \e
.br
\eZ'\e\e*(0s'\e
.br
\ev'\e\en(0du'\e
.br
\eD'l \e\en(0wu -\e\en(0hu-\e\en(0du'\e
.br
\ev'\e\en(0hu'
.br
\&..
.ft
.RE
.
.IP
Then you could cancel an expression\~\c
.I e
with
.BI \%cancel\ {\  e\  }
.
.IP
Here\[aq]s a more complicated construct that draws a box round an
expression:
.
.RS
.IP
.ft B
.if t .ne 11+\n(.Vu
\&.EQ
.br
define box 'special Bx'
.br
\&.EN
.br
\&.de Bx
.br
\&.\ \ ds 0s \e
.br
\eZ'\eh'1n'\e\e*(0s'\e
.br
\eZ'\e
.br
\ev'\e\en(0du+1n'\e
.br
\eD'l \e\en(0wu+2n 0'\e
.br
\eD'l 0 -\e\en(0hu-\e\en(0du-2n'\e
.br
\eD'l -\e\en(0wu-2n 0'\e
.br
\eD'l 0 \e\en(0hu+\e\en(0du+2n'\e
.br
\&'\e
.br
\eh'\e\en(0wu+2n'
.br
\&.\ \ nr 0w +2n
.br
\&.\ \ nr 0d +1n
.br
\&.\ \ nr 0h +1n
.br
\&..
.ft
.RE
.
.TP
.BI space\  n
A positive value of the integer\~\c
.I n
(in hundredths of an em) sets the vertical spacing before the
equation, a negative value sets the spacing after the equation,
replacing the default values.
.
This primitive provides an interface to
.BR groff \[aq]s
.B \ex
escape (but with opposite sign).
.
.IP
This keyword has no effect if the equation is part of a
.B pic
picture.
.
.
.\" --------------------------------------------------------------------
.SS Extended primitives
.\" --------------------------------------------------------------------
.
.TP
.BI col\  n\  {\  .\|.\|.\  }
.TQ
.BI ccol\  n\  {\  .\|.\|.\  }
.TQ
.BI lcol\  n\  {\  .\|.\|.\  }
.TQ
.BI rcol\  n\  {\  .\|.\|.\  }
.TQ
.BI pile\  n\  {\  .\|.\|.\  }
.TQ
.BI cpile\  n\  {\  .\|.\|.\  }
.TQ
.BI lpile\  n\  {\  .\|.\|.\  }
.TQ
.BI rpile\  n\  {\  .\|.\|.\  }
The integer value\~\c
.I n
(in hundredths of an em) increases the vertical spacing between rows,
using
.BR groff \[aq]s
.B \ex
escape (the value has no effect in MathML mode).
Negative values are possible but have no effect.
If there is more than a single value given in a matrix, the biggest one
is used.
.
.
.\" --------------------------------------------------------------------
.SS Customization
.\" --------------------------------------------------------------------
.
When
.B eqn
is generating troff markup, the appearance of equations is controlled
by a large number of parameters.
.
They have no effect when generating MathML mode, which pushes
typesetting and fine motions downstream to a MathML rendering engine.
.
These parameters can be set using the
.B set
command.
.
.TP
.BI set\  p\ n
This sets parameter\~\c
.I p
to value\~\c
.IR n ;
.I n\~\c
is an integer.
.
For example,
.
.RS
.IP
.B
set x_height 45
.RE
.
.IP
says that
.B eqn
should assume an x\~height of 0.45\~ems.
.
.
.RS
.LP
Possible parameters are as follows.
.
Values are in units of hundredths of an em unless otherwise stated.
.
These descriptions are intended to be expository rather than
definitive.
.
.ie t \
.  TP \w'\fBdefault_rule_thickness'u+2n
.el \
.  TP
.B minimum_size
.B eqn
doesn\[aq]t set anything at a smaller point-size than this.
.
The value is in points.
.
.TP
.B fat_offset
The
.B fat
primitive emboldens an equation by overprinting two copies of the
equation horizontally offset by this amount.
.
This parameter is not used in MathML mode; instead, fat text uses
.
.RS
.IP
.EX
<mstyle mathvariant='double-struck'>
.EE
.RE
.
.TP
.B over_hang
A fraction bar is longer by twice this amount than
the maximum of the widths of the numerator and denominator;
in other words, it overhangs the numerator and
denominator by at least this amount.
.
.TP
.B accent_width
When
.B bar
or
.B under
is applied to a single character,
the line is this long.
.
Normally,
.B bar
or
.B under
produces a line whose length is the width of the object to which it applies;
in the case of a single character,
this tends to produce a line that looks too long.
.
.TP
.B delimiter_factor
Extensible delimiters produced with the
.B left
and
.B right
primitives have a combined height and depth of at least this many
thousandths of twice the maximum amount by which the sub-equation that
the delimiters enclose extends away from the axis.
.
.TP
.B delimiter_shortfall
Extensible delimiters produced with the
.B left
and
.B right
primitives have a combined height and depth not less than the
difference of twice the maximum amount by which the sub-equation that
the delimiters enclose extends away from the axis and this amount.
.
.TP
.B null_delimiter_space
This much horizontal space is inserted on each side of a fraction.
.
.TP
.B script_space
The width of subscripts and superscripts is increased by this amount.
.
.TP
.B thin_space
This amount of space is automatically inserted after punctuation
characters.
.
.TP
.B medium_space
This amount of space is automatically inserted on either side of
binary operators.
.
.TP
.B thick_space
This amount of space is automatically inserted on either side of
relations.
.
.TP
.B x_height
The height of lowercase letters without ascenders such as \[oq]x\[cq].
.
.TP
.B axis_height
The height above the baseline of the center of characters such as
\[oq]\[pl]\[cq] and \[oq]\[mi]\[cq].
.
It is important that this value is correct for the font
you are using.
.
.TP
.B default_rule_thickness
This should set to the thickness of the
.B \e(ru
character, or the thickness of horizontal lines produced with the
.B \eD
escape sequence.
.
.TP
.B num1
The
.B over
command shifts up the numerator by at least this amount.
.
.TP
.B num2
The
.B smallover
command shifts up the numerator by at least this amount.
.
.TP
.B denom1
The
.B over
command shifts down the denominator by at least this amount.
.
.TP
.B denom2
The
.B smallover
command shifts down the denominator by at least this amount.
.
.TP
.B sup1
Normally superscripts are shifted up by at least this amount.
.
.TP
.B sup2
Superscripts within superscripts or upper limits
or numerators of
.B smallover
fractions are shifted up by at least this amount.
.
This is usually less than sup1.
.
.TP
.B sup3
Superscripts within denominators or square roots
or subscripts or lower limits are shifted up by at least
this amount.
.
This is usually less than sup2.
.
.TP
.B sub1
Subscripts are normally shifted down by at least this amount.
.
.TP
.B sub2
When there is both a subscript and a superscript, the subscript is
shifted down by at least this amount.
.
.TP
.B sup_drop
The baseline of a superscript is no more than this much amount below
the top of the object on which the superscript is set.
.
.TP
.B sub_drop
The baseline of a subscript is at least this much below the bottom of
the object on which the subscript is set.
.
.TP
.B big_op_spacing1
The baseline of an upper limit is at least this much above the top of
the object on which the limit is set.
.
.TP
.B big_op_spacing2
The baseline of a lower limit is at least this much below the bottom
of the object on which the limit is set.
.
.TP
.B big_op_spacing3
The bottom of an upper limit is at least this much above the top of
the object on which the limit is set.
.
.TP
.B big_op_spacing4
The top of a lower limit is at least this much below the bottom of the
object on which the limit is set.
.
.TP
.B big_op_spacing5
This much vertical space is added above and below limits.
.
.TP
.B baseline_sep
The baselines of the rows in a pile or matrix are normally this far
apart.
.
In most cases this should be equal to the sum of
.B num1
and
.BR denom1 .
.
.TP
.B shift_down
The midpoint between the top baseline and the bottom baseline in a
matrix or pile is shifted down by this much from the axis.
.
In most cases this should be equal to
.BR axis_height .
.
.TP
.B column_sep
This much space is added between columns in a matrix.
.
.TP
.B matrix_side_sep
This much space is added at each side of a matrix.
.
.TP
.B draw_lines
If this is non-zero, lines are drawn using the
.B \eD
escape sequence, rather than with the
.B \el
escape sequence and the
.B \e(ru
character.
.
.TP
.B body_height
The amount by which the height of the equation exceeds this is added
as extra space before the line containing the equation (using
.BR \ex ).
.
The default value is 85.
.
.TP
.B body_depth
The amount by which the depth of the equation exceeds this is added as
extra space after the line containing the equation (using
.BR \ex ).
.
The default value is 35.
.
.TP
.B nroff
If this is non-zero,
then
.B ndefine
behaves like
.B define
and
.B tdefine
is ignored, otherwise
.B tdefine
behaves like
.B define
and
.B ndefine
is ignored.
.
The default value is\~0 (This is typically changed to\~1 by the
.B eqnrc
file for the
.BR ascii ,
.BR latin1 ,
.BR utf8 ,
and
.B cp1047
devices.)
.
.
.LP
A more precise description of the role of many of these
parameters can be found in Appendix\~H of
.IR "The \*(txbook" .
.RE
.
.
.\" --------------------------------------------------------------------
.SS Macros
.\" --------------------------------------------------------------------
.
Macros can take arguments.
.
In a macro body,
.BI $ n
where
.I n
is between 1 and\~9, is replaced by the
.IR n-th
argument if the macro is called with arguments;
if there are fewer than
.I n\~\c
arguments, it is replaced by nothing.
.
A word containing a left parenthesis where the part of the word
before the left parenthesis has been defined using the
.B define
command is recognized as a macro call with arguments; characters
following the left parenthesis up to a matching right parenthesis are
treated as comma-separated arguments; commas inside nested parentheses
do not terminate an argument.
.
.TP
.BI sdefine\  name\ X\ anything\ X
This is like the
.B define
command, but
.I name
is not recognized if called with arguments.
.
.TP
.BI include\ \(ts file \(ts
.TQ
.BI copy\ \(ts file \(ts
Include the contents of
.I file
.RB ( include
and
.B copy
are synonyms).
.
Lines of
.I file
beginning with
.B .EQ
or
.B .EN
are ignored.
.
.TP
.BI ifdef\  name\ X\ anything\ X
If
.I name
has been defined by
.B define
(or has been automatically defined because
.I name
is the output device) process
.IR anything ;
otherwise ignore
.IR anything .
.
.I X
can be any character not appearing in
.IR anything .
.
.TP
.BI undef\  name
Remove definition of
.IR name ,
making it undefined.
.
.
.LP
Besides the macros mentioned above, the following definitions are available:
.BR Alpha ,
.BR Beta ,
\&.\|.\|.,
.B Omega
(this is the same as
.BR ALPHA ,
.BR BETA ,
\&.\|.\|.,
.BR OMEGA ),
.B ldots
(three dots on the base line), and
.BR dollar .
.
.
.\" --------------------------------------------------------------------
.SS Fonts
.\" --------------------------------------------------------------------
.
.B eqn
normally uses at least two fonts to set an equation:
an italic font for letters,
and a roman font for everything else.
.
The existing
.B gfont
command
changes the font that is used as the italic font.
.
By default this is\~\c
.BR I .
The font that is used as the roman font can be changed using the new
.B grfont
command.
.
.TP
.BI grfont\  f
Set the roman font to\~\c
.IR f .
.
.
.LP
The
.B italic
primitive uses the current italic font set by
.BR gfont ;
the
.B roman
primitive uses the current roman font set by
.BR grfont .
.
There is also a new
.B gbfont
command, which changes the font used by the
.B bold
primitive.
.
If you only use the
.BR roman ,
.B italic
and
.B bold
primitives to changes fonts within an equation, you can change all the
fonts used by your equations just by using
.BR gfont ,
.B grfont
and
.B gbfont
commands.
.
.
.LP
You can control which characters are treated as letters
(and therefore set in italics) by using the
.B chartype
command described above.
.
A type of
.B letter
causes a character to be set in italic type.
.
A type of
.B digit
causes a character to be set in roman type.
.
.
.\" --------------------------------------------------------------------
.SH FILES
.\" --------------------------------------------------------------------
.
.Tp \w'\fBd:/usr/share/groff/1.22.3/tmac/eqnrc'u+2n
.B d:/usr/share/groff/1.22.3/tmac/eqnrc
Initialization file.
.
.
.\" --------------------------------------------------------------------
.SH MATHML MODE LIMITATIONS
.\" --------------------------------------------------------------------
.
MathML is designed on the assumption that it cannot know the exact
physical characteristics of the media and devices on which it will
be rendered.
.
It does not support fine control of motions and sizes to the same
degree troff does.
.
Thus:
.
.IP *
.B eqn
parameters have no effect on the generated MathML.
.
.IP *
The
.BR special,
.BR up ,
.BR down ,
.BR fwd ,
and
.B back
operations cannot be implemented, and yield a MathML
\[oq]<merror>\[cq] message instead.
.
.IP *
The
.B vcenter
keyword is silently ignored, as centering on the math axis is the
MathML default.
.
.IP *
Characters that
.B eqn
over troff sets extra large \(en notably the integral sign \(en may
appear too small and need to have their \[oq]<mstyle>\[cq] wrappers
adjusted by hand.
.
.
.LP
As in its troff mode,
.B eqn
in MathML mode leaves the
.B .EQ
and
.B .EN
delimiters in place for displayed equations, but emits no explicit
delimiters around inline equations.
.
They can, however, be recognized as strings that begin with
\[oq]<math>\[cq] and end with \[oq]</math>\[cq] and do not cross line
boundaries.
.
.
.LP
See the
.B BUGS
section for translation limits specific to
.BR eqn .
.
.
.\" --------------------------------------------------------------------
.SH BUGS
.\" --------------------------------------------------------------------
.
Inline equations are set at the point size that is current at the
beginning of the input line.
.
.
.LP
In MathML mode, the
.B mark
and
.B lineup
features don\[aq]t work.
.
These could, in theory, be implemented with \[oq]<maligngroup>\[cq]
elements.
.
.
.LP
In MathML mode, each digit of a numeric literal gets a separate
\[oq]<mn>\:</mn>\[cq] pair, and decimal points are tagged with
\[oq]<mo>\:</mo>\[cq].
.
This is allowed by the specification, but inefficient.
.
.
.\" --------------------------------------------------------------------
.SH "SEE ALSO"
.\" --------------------------------------------------------------------
.
.BR groff (1),
.BR troff (1),
.BR pic (1),
.BR groff_font (5),
.I The\ \*[tx]book
.
.
.\" --------------------------------------------------------------------
.SH COPYING
.\" --------------------------------------------------------------------
.
.co
.
.
.\" Local Variables:
.\" mode: nroff
.\" End:
