// -*- C++ -*-
/* Copyright (C) 2002-2014  Free Software Foundation, Inc.
     Written by Werner Lemberg <wl@gnu.org>

This file is part of groff.

groff is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation, either version 3 of the License, or
(at your option) any later version.

groff is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>. */

// This code has been algorithmically derived from the file
// UnicodeData.txt, version 4.1.0, available from unicode.org,
// on 2005-12-09.

#include "stringclass.h"
#include "lib.h"
#include "ptable.h"

#include "unicode.h"

struct unicode_decompose {
  char *value;
};

declare_ptable(unicode_decompose)
implement_ptable(unicode_decompose)

PTABLE(unicode_decompose) unicode_decompose_table;

// the first digit in the composite string gives the number of composites

struct S {
  const char *key;
  const char *value;
} unicode_decompose_list[] = {
  { "00C0", "20041_0300" },
  { "00C1", "20041_0301" },
  { "00C2", "20041_0302" },
  { "00C3", "20041_0303" },
  { "00C4", "20041_0308" },
  { "00C5", "20041_030A" },
  { "00C7", "20043_0327" },
  { "00C8", "20045_0300" },
  { "00C9", "20045_0301" },
  { "00CA", "20045_0302" },
  { "00CB", "20045_0308" },
  { "00CC", "20049_0300" },
  { "00CD", "20049_0301" },
  { "00CE", "20049_0302" },
  { "00CF", "20049_0308" },
  { "00D1", "2004E_0303" },
  { "00D2", "2004F_0300" },
  { "00D3", "2004F_0301" },
  { "00D4", "2004F_0302" },
  { "00D5", "2004F_0303" },
  { "00D6", "2004F_0308" },
  { "00D9", "20055_0300" },
  { "00DA", "20055_0301" },
  { "00DB", "20055_0302" },
  { "00DC", "20055_0308" },
  { "00DD", "20059_0301" },
  { "00E0", "20061_0300" },
  { "00E1", "20061_0301" },
  { "00E2", "20061_0302" },
  { "00E3", "20061_0303" },
  { "00E4", "20061_0308" },
  { "00E5", "20061_030A" },
  { "00E7", "20063_0327" },
  { "00E8", "20065_0300" },
  { "00E9", "20065_0301" },
  { "00EA", "20065_0302" },
  { "00EB", "20065_0308" },
  { "00EC", "20069_0300" },
  { "00ED", "20069_0301" },
  { "00EE", "20069_0302" },
  { "00EF", "20069_0308" },
  { "00F1", "2006E_0303" },
  { "00F2", "2006F_0300" },
  { "00F3", "2006F_0301" },
  { "00F4", "2006F_0302" },
  { "00F5", "2006F_0303" },
  { "00F6", "2006F_0308" },
  { "00F9", "20075_0300" },
  { "00FA", "20075_0301" },
  { "00FB", "20075_0302" },
  { "00FC", "20075_0308" },
  { "00FD", "20079_0301" },
  { "00FF", "20079_0308" },
  { "0100", "20041_0304" },
  { "0101", "20061_0304" },
  { "0102", "20041_0306" },
  { "0103", "20061_0306" },
  { "0104", "20041_0328" },
  { "0105", "20061_0328" },
  { "0106", "20043_0301" },
  { "0107", "20063_0301" },
  { "0108", "20043_0302" },
  { "0109", "20063_0302" },
  { "010A", "20043_0307" },
  { "010B", "20063_0307" },
  { "010C", "20043_030C" },
  { "010D", "20063_030C" },
  { "010E", "20044_030C" },
  { "010F", "20064_030C" },
  { "0112", "20045_0304" },
  { "0113", "20065_0304" },
  { "0114", "20045_0306" },
  { "0115", "20065_0306" },
  { "0116", "20045_0307" },
  { "0117", "20065_0307" },
  { "0118", "20045_0328" },
  { "0119", "20065_0328" },
  { "011A", "20045_030C" },
  { "011B", "20065_030C" },
  { "011C", "20047_0302" },
  { "011D", "20067_0302" },
  { "011E", "20047_0306" },
  { "011F", "20067_0306" },
  { "0120", "20047_0307" },
  { "0121", "20067_0307" },
  { "0122", "20047_0327" },
  { "0123", "20067_0327" },
  { "0124", "20048_0302" },
  { "0125", "20068_0302" },
  { "0128", "20049_0303" },
  { "0129", "20069_0303" },
  { "012A", "20049_0304" },
  { "012B", "20069_0304" },
  { "012C", "20049_0306" },
  { "012D", "20069_0306" },
  { "012E", "20049_0328" },
  { "012F", "20069_0328" },
  { "0130", "20049_0307" },
  { "0134", "2004A_0302" },
  { "0135", "2006A_0302" },
  { "0136", "2004B_0327" },
  { "0137", "2006B_0327" },
  { "0139", "2004C_0301" },
  { "013A", "2006C_0301" },
  { "013B", "2004C_0327" },
  { "013C", "2006C_0327" },
  { "013D", "2004C_030C" },
  { "013E", "2006C_030C" },
  { "0143", "2004E_0301" },
  { "0144", "2006E_0301" },
  { "0145", "2004E_0327" },
  { "0146", "2006E_0327" },
  { "0147", "2004E_030C" },
  { "0148", "2006E_030C" },
  { "014C", "2004F_0304" },
  { "014D", "2006F_0304" },
  { "014E", "2004F_0306" },
  { "014F", "2006F_0306" },
  { "0150", "2004F_030B" },
  { "0151", "2006F_030B" },
  { "0154", "20052_0301" },
  { "0155", "20072_0301" },
  { "0156", "20052_0327" },
  { "0157", "20072_0327" },
  { "0158", "20052_030C" },
  { "0159", "20072_030C" },
  { "015A", "20053_0301" },
  { "015B", "20073_0301" },
  { "015C", "20053_0302" },
  { "015D", "20073_0302" },
  { "015E", "20053_0327" },
  { "015F", "20073_0327" },
  { "0160", "20053_030C" },
  { "0161", "20073_030C" },
  { "0162", "20054_0327" },
  { "0163", "20074_0327" },
  { "0164", "20054_030C" },
  { "0165", "20074_030C" },
  { "0168", "20055_0303" },
  { "0169", "20075_0303" },
  { "016A", "20055_0304" },
  { "016B", "20075_0304" },
  { "016C", "20055_0306" },
  { "016D", "20075_0306" },
  { "016E", "20055_030A" },
  { "016F", "20075_030A" },
  { "0170", "20055_030B" },
  { "0171", "20075_030B" },
  { "0172", "20055_0328" },
  { "0173", "20075_0328" },
  { "0174", "20057_0302" },
  { "0175", "20077_0302" },
  { "0176", "20059_0302" },
  { "0177", "20079_0302" },
  { "0178", "20059_0308" },
  { "0179", "2005A_0301" },
  { "017A", "2007A_0301" },
  { "017B", "2005A_0307" },
  { "017C", "2007A_0307" },
  { "017D", "2005A_030C" },
  { "017E", "2007A_030C" },
  { "01A0", "2004F_031B" },
  { "01A1", "2006F_031B" },
  { "01AF", "20055_031B" },
  { "01B0", "20075_031B" },
  { "01CD", "20041_030C" },
  { "01CE", "20061_030C" },
  { "01CF", "20049_030C" },
  { "01D0", "20069_030C" },
  { "01D1", "2004F_030C" },
  { "01D2", "2006F_030C" },
  { "01D3", "20055_030C" },
  { "01D4", "20075_030C" },
  { "01D5", "30055_0308_0304" },
  { "01D6", "30075_0308_0304" },
  { "01D7", "30055_0308_0301" },
  { "01D8", "30075_0308_0301" },
  { "01D9", "30055_0308_030C" },
  { "01DA", "30075_0308_030C" },
  { "01DB", "30055_0308_0300" },
  { "01DC", "30075_0308_0300" },
  { "01DE", "30041_0308_0304" },
  { "01DF", "30061_0308_0304" },
  { "01E0", "30041_0307_0304" },
  { "01E1", "30061_0307_0304" },
  { "01E2", "200C6_0304" },
  { "01E3", "200E6_0304" },
  { "01E6", "20047_030C" },
  { "01E7", "20067_030C" },
  { "01E8", "2004B_030C" },
  { "01E9", "2006B_030C" },
  { "01EA", "2004F_0328" },
  { "01EB", "2006F_0328" },
  { "01EC", "3004F_0328_0304" },
  { "01ED", "3006F_0328_0304" },
  { "01EE", "201B7_030C" },
  { "01EF", "20292_030C" },
  { "01F0", "2006A_030C" },
  { "01F4", "20047_0301" },
  { "01F5", "20067_0301" },
  { "01F8", "2004E_0300" },
  { "01F9", "2006E_0300" },
  { "01FA", "30041_030A_0301" },
  { "01FB", "30061_030A_0301" },
  { "01FC", "200C6_0301" },
  { "01FD", "200E6_0301" },
  { "01FE", "200D8_0301" },
  { "01FF", "200F8_0301" },
  { "0200", "20041_030F" },
  { "0201", "20061_030F" },
  { "0202", "20041_0311" },
  { "0203", "20061_0311" },
  { "0204", "20045_030F" },
  { "0205", "20065_030F" },
  { "0206", "20045_0311" },
  { "0207", "20065_0311" },
  { "0208", "20049_030F" },
  { "0209", "20069_030F" },
  { "020A", "20049_0311" },
  { "020B", "20069_0311" },
  { "020C", "2004F_030F" },
  { "020D", "2006F_030F" },
  { "020E", "2004F_0311" },
  { "020F", "2006F_0311" },
  { "0210", "20052_030F" },
  { "0211", "20072_030F" },
  { "0212", "20052_0311" },
  { "0213", "20072_0311" },
  { "0214", "20055_030F" },
  { "0215", "20075_030F" },
  { "0216", "20055_0311" },
  { "0217", "20075_0311" },
  { "0218", "20053_0326" },
  { "0219", "20073_0326" },
  { "021A", "20054_0326" },
  { "021B", "20074_0326" },
  { "021E", "20048_030C" },
  { "021F", "20068_030C" },
  { "0226", "20041_0307" },
  { "0227", "20061_0307" },
  { "0228", "20045_0327" },
  { "0229", "20065_0327" },
  { "022A", "3004F_0308_0304" },
  { "022B", "3006F_0308_0304" },
  { "022C", "3004F_0303_0304" },
  { "022D", "3006F_0303_0304" },
  { "022E", "2004F_0307" },
  { "022F", "2006F_0307" },
  { "0230", "3004F_0307_0304" },
  { "0231", "3006F_0307_0304" },
  { "0232", "20059_0304" },
  { "0233", "20079_0304" },
  { "0340", "10300" },
  { "0341", "10301" },
  { "0343", "10313" },
  { "0344", "20308_0301" },
  { "0374", "102B9" },
  { "037E", "1003B" },
  { "0385", "200A8_0301" },
  { "0386", "20391_0301" },
  { "0387", "100B7" },
  { "0388", "20395_0301" },
  { "0389", "20397_0301" },
  { "038A", "20399_0301" },
  { "038C", "2039F_0301" },
  { "038E", "203A5_0301" },
  { "038F", "203A9_0301" },
  { "0390", "303B9_0308_0301" },
  { "03AA", "20399_0308" },
  { "03AB", "203A5_0308" },
  { "03AC", "203B1_0301" },
  { "03AD", "203B5_0301" },
  { "03AE", "203B7_0301" },
  { "03AF", "203B9_0301" },
  { "03B0", "303C5_0308_0301" },
  { "03CA", "203B9_0308" },
  { "03CB", "203C5_0308" },
  { "03CC", "203BF_0301" },
  { "03CD", "203C5_0301" },
  { "03CE", "203C9_0301" },
  { "03D3", "203D2_0301" },
  { "03D4", "203D2_0308" },
  { "0400", "20415_0300" },
  { "0401", "20415_0308" },
  { "0403", "20413_0301" },
  { "0407", "20406_0308" },
  { "040C", "2041A_0301" },
  { "040D", "20418_0300" },
  { "040E", "20423_0306" },
  { "0419", "20418_0306" },
  { "0439", "20438_0306" },
  { "0450", "20435_0300" },
  { "0451", "20435_0308" },
  { "0453", "20433_0301" },
  { "0457", "20456_0308" },
  { "045C", "2043A_0301" },
  { "045D", "20438_0300" },
  { "045E", "20443_0306" },
  { "0476", "20474_030F" },
  { "0477", "20475_030F" },
  { "04C1", "20416_0306" },
  { "04C2", "20436_0306" },
  { "04D0", "20410_0306" },
  { "04D1", "20430_0306" },
  { "04D2", "20410_0308" },
  { "04D3", "20430_0308" },
  { "04D6", "20415_0306" },
  { "04D7", "20435_0306" },
  { "04DA", "204D8_0308" },
  { "04DB", "204D9_0308" },
  { "04DC", "20416_0308" },
  { "04DD", "20436_0308" },
  { "04DE", "20417_0308" },
  { "04DF", "20437_0308" },
  { "04E2", "20418_0304" },
  { "04E3", "20438_0304" },
  { "04E4", "20418_0308" },
  { "04E5", "20438_0308" },
  { "04E6", "2041E_0308" },
  { "04E7", "2043E_0308" },
  { "04EA", "204E8_0308" },
  { "04EB", "204E9_0308" },
  { "04EC", "2042D_0308" },
  { "04ED", "2044D_0308" },
  { "04EE", "20423_0304" },
  { "04EF", "20443_0304" },
  { "04F0", "20423_0308" },
  { "04F1", "20443_0308" },
  { "04F2", "20423_030B" },
  { "04F3", "20443_030B" },
  { "04F4", "20427_0308" },
  { "04F5", "20447_0308" },
  { "04F8", "2042B_0308" },
  { "04F9", "2044B_0308" },
  { "0622", "20627_0653" },
  { "0623", "20627_0654" },
  { "0624", "20648_0654" },
  { "0625", "20627_0655" },
  { "0626", "2064A_0654" },
  { "06C0", "206D5_0654" },
  { "06C2", "206C1_0654" },
  { "06D3", "206D2_0654" },
  { "0929", "20928_093C" },
  { "0931", "20930_093C" },
  { "0934", "20933_093C" },
  { "0958", "20915_093C" },
  { "0959", "20916_093C" },
  { "095A", "20917_093C" },
  { "095B", "2091C_093C" },
  { "095C", "20921_093C" },
  { "095D", "20922_093C" },
  { "095E", "2092B_093C" },
  { "095F", "2092F_093C" },
  { "09CB", "209C7_09BE" },
  { "09CC", "209C7_09D7" },
  { "09DC", "209A1_09BC" },
  { "09DD", "209A2_09BC" },
  { "09DF", "209AF_09BC" },
  { "0A33", "20A32_0A3C" },
  { "0A36", "20A38_0A3C" },
  { "0A59", "20A16_0A3C" },
  { "0A5A", "20A17_0A3C" },
  { "0A5B", "20A1C_0A3C" },
  { "0A5E", "20A2B_0A3C" },
  { "0B48", "20B47_0B56" },
  { "0B4B", "20B47_0B3E" },
  { "0B4C", "20B47_0B57" },
  { "0B5C", "20B21_0B3C" },
  { "0B5D", "20B22_0B3C" },
  { "0B94", "20B92_0BD7" },
  { "0BCA", "20BC6_0BBE" },
  { "0BCB", "20BC7_0BBE" },
  { "0BCC", "20BC6_0BD7" },
  { "0C48", "20C46_0C56" },
  { "0CC0", "20CBF_0CD5" },
  { "0CC7", "20CC6_0CD5" },
  { "0CC8", "20CC6_0CD6" },
  { "0CCA", "20CC6_0CC2" },
  { "0CCB", "30CC6_0CC2_0CD5" },
  { "0D4A", "20D46_0D3E" },
  { "0D4B", "20D47_0D3E" },
  { "0D4C", "20D46_0D57" },
  { "0DDA", "20DD9_0DCA" },
  { "0DDC", "20DD9_0DCF" },
  { "0DDD", "30DD9_0DCF_0DCA" },
  { "0DDE", "20DD9_0DDF" },
  { "0F43", "20F42_0FB7" },
  { "0F4D", "20F4C_0FB7" },
  { "0F52", "20F51_0FB7" },
  { "0F57", "20F56_0FB7" },
  { "0F5C", "20F5B_0FB7" },
  { "0F69", "20F40_0FB5" },
  { "0F73", "20F71_0F72" },
  { "0F75", "20F71_0F74" },
  { "0F76", "20FB2_0F80" },
  { "0F78", "20FB3_0F80" },
  { "0F81", "20F71_0F80" },
  { "0F93", "20F92_0FB7" },
  { "0F9D", "20F9C_0FB7" },
  { "0FA2", "20FA1_0FB7" },
  { "0FA7", "20FA6_0FB7" },
  { "0FAC", "20FAB_0FB7" },
  { "0FB9", "20F90_0FB5" },
  { "1026", "21025_102E" },
  { "1E00", "20041_0325" },
  { "1E01", "20061_0325" },
  { "1E02", "20042_0307" },
  { "1E03", "20062_0307" },
  { "1E04", "20042_0323" },
  { "1E05", "20062_0323" },
  { "1E06", "20042_0331" },
  { "1E07", "20062_0331" },
  { "1E08", "30043_0327_0301" },
  { "1E09", "30063_0327_0301" },
  { "1E0A", "20044_0307" },
  { "1E0B", "20064_0307" },
  { "1E0C", "20044_0323" },
  { "1E0D", "20064_0323" },
  { "1E0E", "20044_0331" },
  { "1E0F", "20064_0331" },
  { "1E10", "20044_0327" },
  { "1E11", "20064_0327" },
  { "1E12", "20044_032D" },
  { "1E13", "20064_032D" },
  { "1E14", "30045_0304_0300" },
  { "1E15", "30065_0304_0300" },
  { "1E16", "30045_0304_0301" },
  { "1E17", "30065_0304_0301" },
  { "1E18", "20045_032D" },
  { "1E19", "20065_032D" },
  { "1E1A", "20045_0330" },
  { "1E1B", "20065_0330" },
  { "1E1C", "30045_0327_0306" },
  { "1E1D", "30065_0327_0306" },
  { "1E1E", "20046_0307" },
  { "1E1F", "20066_0307" },
  { "1E20", "20047_0304" },
  { "1E21", "20067_0304" },
  { "1E22", "20048_0307" },
  { "1E23", "20068_0307" },
  { "1E24", "20048_0323" },
  { "1E25", "20068_0323" },
  { "1E26", "20048_0308" },
  { "1E27", "20068_0308" },
  { "1E28", "20048_0327" },
  { "1E29", "20068_0327" },
  { "1E2A", "20048_032E" },
  { "1E2B", "20068_032E" },
  { "1E2C", "20049_0330" },
  { "1E2D", "20069_0330" },
  { "1E2E", "30049_0308_0301" },
  { "1E2F", "30069_0308_0301" },
  { "1E30", "2004B_0301" },
  { "1E31", "2006B_0301" },
  { "1E32", "2004B_0323" },
  { "1E33", "2006B_0323" },
  { "1E34", "2004B_0331" },
  { "1E35", "2006B_0331" },
  { "1E36", "2004C_0323" },
  { "1E37", "2006C_0323" },
  { "1E38", "3004C_0323_0304" },
  { "1E39", "3006C_0323_0304" },
  { "1E3A", "2004C_0331" },
  { "1E3B", "2006C_0331" },
  { "1E3C", "2004C_032D" },
  { "1E3D", "2006C_032D" },
  { "1E3E", "2004D_0301" },
  { "1E3F", "2006D_0301" },
  { "1E40", "2004D_0307" },
  { "1E41", "2006D_0307" },
  { "1E42", "2004D_0323" },
  { "1E43", "2006D_0323" },
  { "1E44", "2004E_0307" },
  { "1E45", "2006E_0307" },
  { "1E46", "2004E_0323" },
  { "1E47", "2006E_0323" },
  { "1E48", "2004E_0331" },
  { "1E49", "2006E_0331" },
  { "1E4A", "2004E_032D" },
  { "1E4B", "2006E_032D" },
  { "1E4C", "3004F_0303_0301" },
  { "1E4D", "3006F_0303_0301" },
  { "1E4E", "3004F_0303_0308" },
  { "1E4F", "3006F_0303_0308" },
  { "1E50", "3004F_0304_0300" },
  { "1E51", "3006F_0304_0300" },
  { "1E52", "3004F_0304_0301" },
  { "1E53", "3006F_0304_0301" },
  { "1E54", "20050_0301" },
  { "1E55", "20070_0301" },
  { "1E56", "20050_0307" },
  { "1E57", "20070_0307" },
  { "1E58", "20052_0307" },
  { "1E59", "20072_0307" },
  { "1E5A", "20052_0323" },
  { "1E5B", "20072_0323" },
  { "1E5C", "30052_0323_0304" },
  { "1E5D", "30072_0323_0304" },
  { "1E5E", "20052_0331" },
  { "1E5F", "20072_0331" },
  { "1E60", "20053_0307" },
  { "1E61", "20073_0307" },
  { "1E62", "20053_0323" },
  { "1E63", "20073_0323" },
  { "1E64", "30053_0301_0307" },
  { "1E65", "30073_0301_0307" },
  { "1E66", "30053_030C_0307" },
  { "1E67", "30073_030C_0307" },
  { "1E68", "30053_0323_0307" },
  { "1E69", "30073_0323_0307" },
  { "1E6A", "20054_0307" },
  { "1E6B", "20074_0307" },
  { "1E6C", "20054_0323" },
  { "1E6D", "20074_0323" },
  { "1E6E", "20054_0331" },
  { "1E6F", "20074_0331" },
  { "1E70", "20054_032D" },
  { "1E71", "20074_032D" },
  { "1E72", "20055_0324" },
  { "1E73", "20075_0324" },
  { "1E74", "20055_0330" },
  { "1E75", "20075_0330" },
  { "1E76", "20055_032D" },
  { "1E77", "20075_032D" },
  { "1E78", "30055_0303_0301" },
  { "1E79", "30075_0303_0301" },
  { "1E7A", "30055_0304_0308" },
  { "1E7B", "30075_0304_0308" },
  { "1E7C", "20056_0303" },
  { "1E7D", "20076_0303" },
  { "1E7E", "20056_0323" },
  { "1E7F", "20076_0323" },
  { "1E80", "20057_0300" },
  { "1E81", "20077_0300" },
  { "1E82", "20057_0301" },
  { "1E83", "20077_0301" },
  { "1E84", "20057_0308" },
  { "1E85", "20077_0308" },
  { "1E86", "20057_0307" },
  { "1E87", "20077_0307" },
  { "1E88", "20057_0323" },
  { "1E89", "20077_0323" },
  { "1E8A", "20058_0307" },
  { "1E8B", "20078_0307" },
  { "1E8C", "20058_0308" },
  { "1E8D", "20078_0308" },
  { "1E8E", "20059_0307" },
  { "1E8F", "20079_0307" },
  { "1E90", "2005A_0302" },
  { "1E91", "2007A_0302" },
  { "1E92", "2005A_0323" },
  { "1E93", "2007A_0323" },
  { "1E94", "2005A_0331" },
  { "1E95", "2007A_0331" },
  { "1E96", "20068_0331" },
  { "1E97", "20074_0308" },
  { "1E98", "20077_030A" },
  { "1E99", "20079_030A" },
  { "1E9B", "2017F_0307" },
  { "1EA0", "20041_0323" },
  { "1EA1", "20061_0323" },
  { "1EA2", "20041_0309" },
  { "1EA3", "20061_0309" },
  { "1EA4", "30041_0302_0301" },
  { "1EA5", "30061_0302_0301" },
  { "1EA6", "30041_0302_0300" },
  { "1EA7", "30061_0302_0300" },
  { "1EA8", "30041_0302_0309" },
  { "1EA9", "30061_0302_0309" },
  { "1EAA", "30041_0302_0303" },
  { "1EAB", "30061_0302_0303" },
  { "1EAC", "30041_0323_0302" },
  { "1EAD", "30061_0323_0302" },
  { "1EAE", "30041_0306_0301" },
  { "1EAF", "30061_0306_0301" },
  { "1EB0", "30041_0306_0300" },
  { "1EB1", "30061_0306_0300" },
  { "1EB2", "30041_0306_0309" },
  { "1EB3", "30061_0306_0309" },
  { "1EB4", "30041_0306_0303" },
  { "1EB5", "30061_0306_0303" },
  { "1EB6", "30041_0323_0306" },
  { "1EB7", "30061_0323_0306" },
  { "1EB8", "20045_0323" },
  { "1EB9", "20065_0323" },
  { "1EBA", "20045_0309" },
  { "1EBB", "20065_0309" },
  { "1EBC", "20045_0303" },
  { "1EBD", "20065_0303" },
  { "1EBE", "30045_0302_0301" },
  { "1EBF", "30065_0302_0301" },
  { "1EC0", "30045_0302_0300" },
  { "1EC1", "30065_0302_0300" },
  { "1EC2", "30045_0302_0309" },
  { "1EC3", "30065_0302_0309" },
  { "1EC4", "30045_0302_0303" },
  { "1EC5", "30065_0302_0303" },
  { "1EC6", "30045_0323_0302" },
  { "1EC7", "30065_0323_0302" },
  { "1EC8", "20049_0309" },
  { "1EC9", "20069_0309" },
  { "1ECA", "20049_0323" },
  { "1ECB", "20069_0323" },
  { "1ECC", "2004F_0323" },
  { "1ECD", "2006F_0323" },
  { "1ECE", "2004F_0309" },
  { "1ECF", "2006F_0309" },
  { "1ED0", "3004F_0302_0301" },
  { "1ED1", "3006F_0302_0301" },
  { "1ED2", "3004F_0302_0300" },
  { "1ED3", "3006F_0302_0300" },
  { "1ED4", "3004F_0302_0309" },
  { "1ED5", "3006F_0302_0309" },
  { "1ED6", "3004F_0302_0303" },
  { "1ED7", "3006F_0302_0303" },
  { "1ED8", "3004F_0323_0302" },
  { "1ED9", "3006F_0323_0302" },
  { "1EDA", "3004F_031B_0301" },
  { "1EDB", "3006F_031B_0301" },
  { "1EDC", "3004F_031B_0300" },
  { "1EDD", "3006F_031B_0300" },
  { "1EDE", "3004F_031B_0309" },
  { "1EDF", "3006F_031B_0309" },
  { "1EE0", "3004F_031B_0303" },
  { "1EE1", "3006F_031B_0303" },
  { "1EE2", "3004F_031B_0323" },
  { "1EE3", "3006F_031B_0323" },
  { "1EE4", "20055_0323" },
  { "1EE5", "20075_0323" },
  { "1EE6", "20055_0309" },
  { "1EE7", "20075_0309" },
  { "1EE8", "30055_031B_0301" },
  { "1EE9", "30075_031B_0301" },
  { "1EEA", "30055_031B_0300" },
  { "1EEB", "30075_031B_0300" },
  { "1EEC", "30055_031B_0309" },
  { "1EED", "30075_031B_0309" },
  { "1EEE", "30055_031B_0303" },
  { "1EEF", "30075_031B_0303" },
  { "1EF0", "30055_031B_0323" },
  { "1EF1", "30075_031B_0323" },
  { "1EF2", "20059_0300" },
  { "1EF3", "20079_0300" },
  { "1EF4", "20059_0323" },
  { "1EF5", "20079_0323" },
  { "1EF6", "20059_0309" },
  { "1EF7", "20079_0309" },
  { "1EF8", "20059_0303" },
  { "1EF9", "20079_0303" },
  { "1F00", "203B1_0313" },
  { "1F01", "203B1_0314" },
  { "1F02", "303B1_0313_0300" },
  { "1F03", "303B1_0314_0300" },
  { "1F04", "303B1_0313_0301" },
  { "1F05", "303B1_0314_0301" },
  { "1F06", "303B1_0313_0342" },
  { "1F07", "303B1_0314_0342" },
  { "1F08", "20391_0313" },
  { "1F09", "20391_0314" },
  { "1F0A", "30391_0313_0300" },
  { "1F0B", "30391_0314_0300" },
  { "1F0C", "30391_0313_0301" },
  { "1F0D", "30391_0314_0301" },
  { "1F0E", "30391_0313_0342" },
  { "1F0F", "30391_0314_0342" },
  { "1F10", "203B5_0313" },
  { "1F11", "203B5_0314" },
  { "1F12", "303B5_0313_0300" },
  { "1F13", "303B5_0314_0300" },
  { "1F14", "303B5_0313_0301" },
  { "1F15", "303B5_0314_0301" },
  { "1F18", "20395_0313" },
  { "1F19", "20395_0314" },
  { "1F1A", "30395_0313_0300" },
  { "1F1B", "30395_0314_0300" },
  { "1F1C", "30395_0313_0301" },
  { "1F1D", "30395_0314_0301" },
  { "1F20", "203B7_0313" },
  { "1F21", "203B7_0314" },
  { "1F22", "303B7_0313_0300" },
  { "1F23", "303B7_0314_0300" },
  { "1F24", "303B7_0313_0301" },
  { "1F25", "303B7_0314_0301" },
  { "1F26", "303B7_0313_0342" },
  { "1F27", "303B7_0314_0342" },
  { "1F28", "20397_0313" },
  { "1F29", "20397_0314" },
  { "1F2A", "30397_0313_0300" },
  { "1F2B", "30397_0314_0300" },
  { "1F2C", "30397_0313_0301" },
  { "1F2D", "30397_0314_0301" },
  { "1F2E", "30397_0313_0342" },
  { "1F2F", "30397_0314_0342" },
  { "1F30", "203B9_0313" },
  { "1F31", "203B9_0314" },
  { "1F32", "303B9_0313_0300" },
  { "1F33", "303B9_0314_0300" },
  { "1F34", "303B9_0313_0301" },
  { "1F35", "303B9_0314_0301" },
  { "1F36", "303B9_0313_0342" },
  { "1F37", "303B9_0314_0342" },
  { "1F38", "20399_0313" },
  { "1F39", "20399_0314" },
  { "1F3A", "30399_0313_0300" },
  { "1F3B", "30399_0314_0300" },
  { "1F3C", "30399_0313_0301" },
  { "1F3D", "30399_0314_0301" },
  { "1F3E", "30399_0313_0342" },
  { "1F3F", "30399_0314_0342" },
  { "1F40", "203BF_0313" },
  { "1F41", "203BF_0314" },
  { "1F42", "303BF_0313_0300" },
  { "1F43", "303BF_0314_0300" },
  { "1F44", "303BF_0313_0301" },
  { "1F45", "303BF_0314_0301" },
  { "1F48", "2039F_0313" },
  { "1F49", "2039F_0314" },
  { "1F4A", "3039F_0313_0300" },
  { "1F4B", "3039F_0314_0300" },
  { "1F4C", "3039F_0313_0301" },
  { "1F4D", "3039F_0314_0301" },
  { "1F50", "203C5_0313" },
  { "1F51", "203C5_0314" },
  { "1F52", "303C5_0313_0300" },
  { "1F53", "303C5_0314_0300" },
  { "1F54", "303C5_0313_0301" },
  { "1F55", "303C5_0314_0301" },
  { "1F56", "303C5_0313_0342" },
  { "1F57", "303C5_0314_0342" },
  { "1F59", "203A5_0314" },
  { "1F5B", "303A5_0314_0300" },
  { "1F5D", "303A5_0314_0301" },
  { "1F5F", "303A5_0314_0342" },
  { "1F60", "203C9_0313" },
  { "1F61", "203C9_0314" },
  { "1F62", "303C9_0313_0300" },
  { "1F63", "303C9_0314_0300" },
  { "1F64", "303C9_0313_0301" },
  { "1F65", "303C9_0314_0301" },
  { "1F66", "303C9_0313_0342" },
  { "1F67", "303C9_0314_0342" },
  { "1F68", "203A9_0313" },
  { "1F69", "203A9_0314" },
  { "1F6A", "303A9_0313_0300" },
  { "1F6B", "303A9_0314_0300" },
  { "1F6C", "303A9_0313_0301" },
  { "1F6D", "303A9_0314_0301" },
  { "1F6E", "303A9_0313_0342" },
  { "1F6F", "303A9_0314_0342" },
  { "1F70", "203B1_0300" },
  { "1F71", "203B1_0301" },
  { "1F72", "203B5_0300" },
  { "1F73", "203B5_0301" },
  { "1F74", "203B7_0300" },
  { "1F75", "203B7_0301" },
  { "1F76", "203B9_0300" },
  { "1F77", "203B9_0301" },
  { "1F78", "203BF_0300" },
  { "1F79", "203BF_0301" },
  { "1F7A", "203C5_0300" },
  { "1F7B", "203C5_0301" },
  { "1F7C", "203C9_0300" },
  { "1F7D", "203C9_0301" },
  { "1F80", "303B1_0313_0345" },
  { "1F81", "303B1_0314_0345" },
  { "1F82", "403B1_0313_0300_0345" },
  { "1F83", "403B1_0314_0300_0345" },
  { "1F84", "403B1_0313_0301_0345" },
  { "1F85", "403B1_0314_0301_0345" },
  { "1F86", "403B1_0313_0342_0345" },
  { "1F87", "403B1_0314_0342_0345" },
  { "1F88", "30391_0313_0345" },
  { "1F89", "30391_0314_0345" },
  { "1F8A", "40391_0313_0300_0345" },
  { "1F8B", "40391_0314_0300_0345" },
  { "1F8C", "40391_0313_0301_0345" },
  { "1F8D", "40391_0314_0301_0345" },
  { "1F8E", "40391_0313_0342_0345" },
  { "1F8F", "40391_0314_0342_0345" },
  { "1F90", "303B7_0313_0345" },
  { "1F91", "303B7_0314_0345" },
  { "1F92", "403B7_0313_0300_0345" },
  { "1F93", "403B7_0314_0300_0345" },
  { "1F94", "403B7_0313_0301_0345" },
  { "1F95", "403B7_0314_0301_0345" },
  { "1F96", "403B7_0313_0342_0345" },
  { "1F97", "403B7_0314_0342_0345" },
  { "1F98", "30397_0313_0345" },
  { "1F99", "30397_0314_0345" },
  { "1F9A", "40397_0313_0300_0345" },
  { "1F9B", "40397_0314_0300_0345" },
  { "1F9C", "40397_0313_0301_0345" },
  { "1F9D", "40397_0314_0301_0345" },
  { "1F9E", "40397_0313_0342_0345" },
  { "1F9F", "40397_0314_0342_0345" },
  { "1FA0", "303C9_0313_0345" },
  { "1FA1", "303C9_0314_0345" },
  { "1FA2", "403C9_0313_0300_0345" },
  { "1FA3", "403C9_0314_0300_0345" },
  { "1FA4", "403C9_0313_0301_0345" },
  { "1FA5", "403C9_0314_0301_0345" },
  { "1FA6", "403C9_0313_0342_0345" },
  { "1FA7", "403C9_0314_0342_0345" },
  { "1FA8", "303A9_0313_0345" },
  { "1FA9", "303A9_0314_0345" },
  { "1FAA", "403A9_0313_0300_0345" },
  { "1FAB", "403A9_0314_0300_0345" },
  { "1FAC", "403A9_0313_0301_0345" },
  { "1FAD", "403A9_0314_0301_0345" },
  { "1FAE", "403A9_0313_0342_0345" },
  { "1FAF", "403A9_0314_0342_0345" },
  { "1FB0", "203B1_0306" },
  { "1FB1", "203B1_0304" },
  { "1FB2", "303B1_0300_0345" },
  { "1FB3", "203B1_0345" },
  { "1FB4", "303B1_0301_0345" },
  { "1FB6", "203B1_0342" },
  { "1FB7", "303B1_0342_0345" },
  { "1FB8", "20391_0306" },
  { "1FB9", "20391_0304" },
  { "1FBA", "20391_0300" },
  { "1FBB", "20391_0301" },
  { "1FBC", "20391_0345" },
  { "1FBE", "103B9" },
  { "1FC1", "200A8_0342" },
  { "1FC2", "303B7_0300_0345" },
  { "1FC3", "203B7_0345" },
  { "1FC4", "303B7_0301_0345" },
  { "1FC6", "203B7_0342" },
  { "1FC7", "303B7_0342_0345" },
  { "1FC8", "20395_0300" },
  { "1FC9", "20395_0301" },
  { "1FCA", "20397_0300" },
  { "1FCB", "20397_0301" },
  { "1FCC", "20397_0345" },
  { "1FCD", "21FBF_0300" },
  { "1FCE", "21FBF_0301" },
  { "1FCF", "21FBF_0342" },
  { "1FD0", "203B9_0306" },
  { "1FD1", "203B9_0304" },
  { "1FD2", "303B9_0308_0300" },
  { "1FD3", "303B9_0308_0301" },
  { "1FD6", "203B9_0342" },
  { "1FD7", "303B9_0308_0342" },
  { "1FD8", "20399_0306" },
  { "1FD9", "20399_0304" },
  { "1FDA", "20399_0300" },
  { "1FDB", "20399_0301" },
  { "1FDD", "21FFE_0300" },
  { "1FDE", "21FFE_0301" },
  { "1FDF", "21FFE_0342" },
  { "1FE0", "203C5_0306" },
  { "1FE1", "203C5_0304" },
  { "1FE2", "303C5_0308_0300" },
  { "1FE3", "303C5_0308_0301" },
  { "1FE4", "203C1_0313" },
  { "1FE5", "203C1_0314" },
  { "1FE6", "203C5_0342" },
  { "1FE7", "303C5_0308_0342" },
  { "1FE8", "203A5_0306" },
  { "1FE9", "203A5_0304" },
  { "1FEA", "203A5_0300" },
  { "1FEB", "203A5_0301" },
  { "1FEC", "203A1_0314" },
  { "1FED", "200A8_0300" },
  { "1FEE", "200A8_0301" },
  { "1FEF", "10060" },
  { "1FF2", "303C9_0300_0345" },
  { "1FF3", "203C9_0345" },
  { "1FF4", "303C9_0301_0345" },
  { "1FF6", "203C9_0342" },
  { "1FF7", "303C9_0342_0345" },
  { "1FF8", "2039F_0300" },
  { "1FF9", "2039F_0301" },
  { "1FFA", "203A9_0300" },
  { "1FFB", "203A9_0301" },
  { "1FFC", "203A9_0345" },
  { "1FFD", "100B4" },
  { "2000", "12002" },
  { "2001", "12003" },
  { "2126", "103A9" },
  { "212A", "1004B" },
  { "212B", "20041_030A" },
  { "219A", "22190_0338" },
  { "219B", "22192_0338" },
  { "21AE", "22194_0338" },
  { "21CD", "221D0_0338" },
  { "21CE", "221D4_0338" },
  { "21CF", "221D2_0338" },
  { "2204", "22203_0338" },
  { "2209", "22208_0338" },
  { "220C", "2220B_0338" },
  { "2224", "22223_0338" },
  { "2226", "22225_0338" },
  { "2241", "2223C_0338" },
  { "2244", "22243_0338" },
  { "2247", "22245_0338" },
  { "2249", "22248_0338" },
  { "2260", "2003D_0338" },
  { "2262", "22261_0338" },
  { "226D", "2224D_0338" },
  { "226E", "2003C_0338" },
  { "226F", "2003E_0338" },
  { "2270", "22264_0338" },
  { "2271", "22265_0338" },
  { "2274", "22272_0338" },
  { "2275", "22273_0338" },
  { "2278", "22276_0338" },
  { "2279", "22277_0338" },
  { "2280", "2227A_0338" },
  { "2281", "2227B_0338" },
  { "2284", "22282_0338" },
  { "2285", "22283_0338" },
  { "2288", "22286_0338" },
  { "2289", "22287_0338" },
  { "22AC", "222A2_0338" },
  { "22AD", "222A8_0338" },
  { "22AE", "222A9_0338" },
  { "22AF", "222AB_0338" },
  { "22E0", "2227C_0338" },
  { "22E1", "2227D_0338" },
  { "22E2", "22291_0338" },
  { "22E3", "22292_0338" },
  { "22EA", "222B2_0338" },
  { "22EB", "222B3_0338" },
  { "22EC", "222B4_0338" },
  { "22ED", "222B5_0338" },
  { "2329", "13008" },
  { "232A", "13009" },
  { "2ADC", "22ADD_0338" },
  { "304C", "2304B_3099" },
  { "304E", "2304D_3099" },
  { "3050", "2304F_3099" },
  { "3052", "23051_3099" },
  { "3054", "23053_3099" },
  { "3056", "23055_3099" },
  { "3058", "23057_3099" },
  { "305A", "23059_3099" },
  { "305C", "2305B_3099" },
  { "305E", "2305D_3099" },
  { "3060", "2305F_3099" },
  { "3062", "23061_3099" },
  { "3065", "23064_3099" },
  { "3067", "23066_3099" },
  { "3069", "23068_3099" },
  { "3070", "2306F_3099" },
  { "3071", "2306F_309A" },
  { "3073", "23072_3099" },
  { "3074", "23072_309A" },
  { "3076", "23075_3099" },
  { "3077", "23075_309A" },
  { "3079", "23078_3099" },
  { "307A", "23078_309A" },
  { "307C", "2307B_3099" },
  { "307D", "2307B_309A" },
  { "3094", "23046_3099" },
  { "309E", "2309D_3099" },
  { "30AC", "230AB_3099" },
  { "30AE", "230AD_3099" },
  { "30B0", "230AF_3099" },
  { "30B2", "230B1_3099" },
  { "30B4", "230B3_3099" },
  { "30B6", "230B5_3099" },
  { "30B8", "230B7_3099" },
  { "30BA", "230B9_3099" },
  { "30BC", "230BB_3099" },
  { "30BE", "230BD_3099" },
  { "30C0", "230BF_3099" },
  { "30C2", "230C1_3099" },
  { "30C5", "230C4_3099" },
  { "30C7", "230C6_3099" },
  { "30C9", "230C8_3099" },
  { "30D0", "230CF_3099" },
  { "30D1", "230CF_309A" },
  { "30D3", "230D2_3099" },
  { "30D4", "230D2_309A" },
  { "30D6", "230D5_3099" },
  { "30D7", "230D5_309A" },
  { "30D9", "230D8_3099" },
  { "30DA", "230D8_309A" },
  { "30DC", "230DB_3099" },
  { "30DD", "230DB_309A" },
  { "30F4", "230A6_3099" },
  { "30F7", "230EF_3099" },
  { "30F8", "230F0_3099" },
  { "30F9", "230F1_3099" },
  { "30FA", "230F2_3099" },
  { "30FE", "230FD_3099" },
  { "F900", "18C48" },
  { "F901", "166F4" },
  { "F902", "18ECA" },
  { "F903", "18CC8" },
  { "F904", "16ED1" },
  { "F905", "14E32" },
  { "F906", "153E5" },
  { "F907", "19F9C" },
  { "F908", "19F9C" },
  { "F909", "15951" },
  { "F90A", "191D1" },
  { "F90B", "15587" },
  { "F90C", "15948" },
  { "F90D", "161F6" },
  { "F90E", "17669" },
  { "F90F", "17F85" },
  { "F910", "1863F" },
  { "F911", "187BA" },
  { "F912", "188F8" },
  { "F913", "1908F" },
  { "F914", "16A02" },
  { "F915", "16D1B" },
  { "F916", "170D9" },
  { "F917", "173DE" },
  { "F918", "1843D" },
  { "F919", "1916A" },
  { "F91A", "199F1" },
  { "F91B", "14E82" },
  { "F91C", "15375" },
  { "F91D", "16B04" },
  { "F91E", "1721B" },
  { "F91F", "1862D" },
  { "F920", "19E1E" },
  { "F921", "15D50" },
  { "F922", "16FEB" },
  { "F923", "185CD" },
  { "F924", "18964" },
  { "F925", "162C9" },
  { "F926", "181D8" },
  { "F927", "1881F" },
  { "F928", "15ECA" },
  { "F929", "16717" },
  { "F92A", "16D6A" },
  { "F92B", "172FC" },
  { "F92C", "190CE" },
  { "F92D", "14F86" },
  { "F92E", "151B7" },
  { "F92F", "152DE" },
  { "F930", "164C4" },
  { "F931", "16AD3" },
  { "F932", "17210" },
  { "F933", "176E7" },
  { "F934", "18001" },
  { "F935", "18606" },
  { "F936", "1865C" },
  { "F937", "18DEF" },
  { "F938", "19732" },
  { "F939", "19B6F" },
  { "F93A", "19DFA" },
  { "F93B", "1788C" },
  { "F93C", "1797F" },
  { "F93D", "17DA0" },
  { "F93E", "183C9" },
  { "F93F", "19304" },
  { "F940", "19E7F" },
  { "F941", "18AD6" },
  { "F942", "158DF" },
  { "F943", "15F04" },
  { "F944", "17C60" },
  { "F945", "1807E" },
  { "F946", "17262" },
  { "F947", "178CA" },
  { "F948", "18CC2" },
  { "F949", "196F7" },
  { "F94A", "158D8" },
  { "F94B", "15C62" },
  { "F94C", "16A13" },
  { "F94D", "16DDA" },
  { "F94E", "16F0F" },
  { "F94F", "17D2F" },
  { "F950", "17E37" },
  { "F951", "1964B" },
  { "F952", "152D2" },
  { "F953", "1808B" },
  { "F954", "151DC" },
  { "F955", "151CC" },
  { "F956", "17A1C" },
  { "F957", "17DBE" },
  { "F958", "183F1" },
  { "F959", "19675" },
  { "F95A", "18B80" },
  { "F95B", "162CF" },
  { "F95C", "16A02" },
  { "F95D", "18AFE" },
  { "F95E", "14E39" },
  { "F95F", "15BE7" },
  { "F960", "16012" },
  { "F961", "17387" },
  { "F962", "17570" },
  { "F963", "15317" },
  { "F964", "178FB" },
  { "F965", "14FBF" },
  { "F966", "15FA9" },
  { "F967", "14E0D" },
  { "F968", "16CCC" },
  { "F969", "16578" },
  { "F96A", "17D22" },
  { "F96B", "153C3" },
  { "F96C", "1585E" },
  { "F96D", "17701" },
  { "F96E", "18449" },
  { "F96F", "18AAA" },
  { "F970", "16BBA" },
  { "F971", "18FB0" },
  { "F972", "16C88" },
  { "F973", "162FE" },
  { "F974", "182E5" },
  { "F975", "163A0" },
  { "F976", "17565" },
  { "F977", "14EAE" },
  { "F978", "15169" },
  { "F979", "151C9" },
  { "F97A", "16881" },
  { "F97B", "17CE7" },
  { "F97C", "1826F" },
  { "F97D", "18AD2" },
  { "F97E", "191CF" },
  { "F97F", "152F5" },
  { "F980", "15442" },
  { "F981", "15973" },
  { "F982", "15EEC" },
  { "F983", "165C5" },
  { "F984", "16FFE" },
  { "F985", "1792A" },
  { "F986", "195AD" },
  { "F987", "19A6A" },
  { "F988", "19E97" },
  { "F989", "19ECE" },
  { "F98A", "1529B" },
  { "F98B", "166C6" },
  { "F98C", "16B77" },
  { "F98D", "18F62" },
  { "F98E", "15E74" },
  { "F98F", "16190" },
  { "F990", "16200" },
  { "F991", "1649A" },
  { "F992", "16F23" },
  { "F993", "17149" },
  { "F994", "17489" },
  { "F995", "179CA" },
  { "F996", "17DF4" },
  { "F997", "1806F" },
  { "F998", "18F26" },
  { "F999", "184EE" },
  { "F99A", "19023" },
  { "F99B", "1934A" },
  { "F99C", "15217" },
  { "F99D", "152A3" },
  { "F99E", "154BD" },
  { "F99F", "170C8" },
  { "F9A0", "188C2" },
  { "F9A1", "18AAA" },
  { "F9A2", "15EC9" },
  { "F9A3", "15FF5" },
  { "F9A4", "1637B" },
  { "F9A5", "16BAE" },
  { "F9A6", "17C3E" },
  { "F9A7", "17375" },
  { "F9A8", "14EE4" },
  { "F9A9", "156F9" },
  { "F9AA", "15BE7" },
  { "F9AB", "15DBA" },
  { "F9AC", "1601C" },
  { "F9AD", "173B2" },
  { "F9AE", "17469" },
  { "F9AF", "17F9A" },
  { "F9B0", "18046" },
  { "F9B1", "19234" },
  { "F9B2", "196F6" },
  { "F9B3", "19748" },
  { "F9B4", "19818" },
  { "F9B5", "14F8B" },
  { "F9B6", "179AE" },
  { "F9B7", "191B4" },
  { "F9B8", "196B8" },
  { "F9B9", "160E1" },
  { "F9BA", "14E86" },
  { "F9BB", "150DA" },
  { "F9BC", "15BEE" },
  { "F9BD", "15C3F" },
  { "F9BE", "16599" },
  { "F9BF", "16A02" },
  { "F9C0", "171CE" },
  { "F9C1", "17642" },
  { "F9C2", "184FC" },
  { "F9C3", "1907C" },
  { "F9C4", "19F8D" },
  { "F9C5", "16688" },
  { "F9C6", "1962E" },
  { "F9C7", "15289" },
  { "F9C8", "1677B" },
  { "F9C9", "167F3" },
  { "F9CA", "16D41" },
  { "F9CB", "16E9C" },
  { "F9CC", "17409" },
  { "F9CD", "17559" },
  { "F9CE", "1786B" },
  { "F9CF", "17D10" },
  { "F9D0", "1985E" },
  { "F9D1", "1516D" },
  { "F9D2", "1622E" },
  { "F9D3", "19678" },
  { "F9D4", "1502B" },
  { "F9D5", "15D19" },
  { "F9D6", "16DEA" },
  { "F9D7", "18F2A" },
  { "F9D8", "15F8B" },
  { "F9D9", "16144" },
  { "F9DA", "16817" },
  { "F9DB", "17387" },
  { "F9DC", "19686" },
  { "F9DD", "15229" },
  { "F9DE", "1540F" },
  { "F9DF", "15C65" },
  { "F9E0", "16613" },
  { "F9E1", "1674E" },
  { "F9E2", "168A8" },
  { "F9E3", "16CE5" },
  { "F9E4", "17406" },
  { "F9E5", "175E2" },
  { "F9E6", "17F79" },
  { "F9E7", "188CF" },
  { "F9E8", "188E1" },
  { "F9E9", "191CC" },
  { "F9EA", "196E2" },
  { "F9EB", "1533F" },
  { "F9EC", "16EBA" },
  { "F9ED", "1541D" },
  { "F9EE", "171D0" },
  { "F9EF", "17498" },
  { "F9F0", "185FA" },
  { "F9F1", "196A3" },
  { "F9F2", "19C57" },
  { "F9F3", "19E9F" },
  { "F9F4", "16797" },
  { "F9F5", "16DCB" },
  { "F9F6", "181E8" },
  { "F9F7", "17ACB" },
  { "F9F8", "17B20" },
  { "F9F9", "17C92" },
  { "F9FA", "172C0" },
  { "F9FB", "17099" },
  { "F9FC", "18B58" },
  { "F9FD", "14EC0" },
  { "F9FE", "18336" },
  { "F9FF", "1523A" },
  { "FA00", "15207" },
  { "FA01", "15EA6" },
  { "FA02", "162D3" },
  { "FA03", "17CD6" },
  { "FA04", "15B85" },
  { "FA05", "16D1E" },
  { "FA06", "166B4" },
  { "FA07", "18F3B" },
  { "FA08", "1884C" },
  { "FA09", "1964D" },
  { "FA0A", "1898B" },
  { "FA0B", "15ED3" },
  { "FA0C", "15140" },
  { "FA0D", "155C0" },
  { "FA10", "1585A" },
  { "FA12", "16674" },
  { "FA15", "151DE" },
  { "FA16", "1732A" },
  { "FA17", "176CA" },
  { "FA18", "1793C" },
  { "FA19", "1795E" },
  { "FA1A", "17965" },
  { "FA1B", "1798F" },
  { "FA1C", "19756" },
  { "FA1D", "17CBE" },
  { "FA1E", "17FBD" },
  { "FA20", "18612" },
  { "FA22", "18AF8" },
  { "FA25", "19038" },
  { "FA26", "190FD" },
  { "FA2A", "198EF" },
  { "FA2B", "198FC" },
  { "FA2C", "19928" },
  { "FA2D", "19DB4" },
  { "FA30", "14FAE" },
  { "FA31", "150E7" },
  { "FA32", "1514D" },
  { "FA33", "152C9" },
  { "FA34", "152E4" },
  { "FA35", "15351" },
  { "FA36", "1559D" },
  { "FA37", "15606" },
  { "FA38", "15668" },
  { "FA39", "15840" },
  { "FA3A", "158A8" },
  { "FA3B", "15C64" },
  { "FA3C", "15C6E" },
  { "FA3D", "16094" },
  { "FA3E", "16168" },
  { "FA3F", "1618E" },
  { "FA40", "161F2" },
  { "FA41", "1654F" },
  { "FA42", "165E2" },
  { "FA43", "16691" },
  { "FA44", "16885" },
  { "FA45", "16D77" },
  { "FA46", "16E1A" },
  { "FA47", "16F22" },
  { "FA48", "1716E" },
  { "FA49", "1722B" },
  { "FA4A", "17422" },
  { "FA4B", "17891" },
  { "FA4C", "1793E" },
  { "FA4D", "17949" },
  { "FA4E", "17948" },
  { "FA4F", "17950" },
  { "FA50", "17956" },
  { "FA51", "1795D" },
  { "FA52", "1798D" },
  { "FA53", "1798E" },
  { "FA54", "17A40" },
  { "FA55", "17A81" },
  { "FA56", "17BC0" },
  { "FA57", "17DF4" },
  { "FA58", "17E09" },
  { "FA59", "17E41" },
  { "FA5A", "17F72" },
  { "FA5B", "18005" },
  { "FA5C", "181ED" },
  { "FA5D", "18279" },
  { "FA5E", "18279" },
  { "FA5F", "18457" },
  { "FA60", "18910" },
  { "FA61", "18996" },
  { "FA62", "18B01" },
  { "FA63", "18B39" },
  { "FA64", "18CD3" },
  { "FA65", "18D08" },
  { "FA66", "18FB6" },
  { "FA67", "19038" },
  { "FA68", "196E3" },
  { "FA69", "197FF" },
  { "FA6A", "1983B" },
  { "FA70", "14E26" },
  { "FA71", "151B5" },
  { "FA72", "15168" },
  { "FA73", "14F80" },
  { "FA74", "15145" },
  { "FA75", "15180" },
  { "FA76", "152C7" },
  { "FA77", "152FA" },
  { "FA78", "1559D" },
  { "FA79", "15555" },
  { "FA7A", "15599" },
  { "FA7B", "155E2" },
  { "FA7C", "1585A" },
  { "FA7D", "158B3" },
  { "FA7E", "15944" },
  { "FA7F", "15954" },
  { "FA80", "15A62" },
  { "FA81", "15B28" },
  { "FA82", "15ED2" },
  { "FA83", "15ED9" },
  { "FA84", "15F69" },
  { "FA85", "15FAD" },
  { "FA86", "160D8" },
  { "FA87", "1614E" },
  { "FA88", "16108" },
  { "FA89", "1618E" },
  { "FA8A", "16160" },
  { "FA8B", "161F2" },
  { "FA8C", "16234" },
  { "FA8D", "163C4" },
  { "FA8E", "1641C" },
  { "FA8F", "16452" },
  { "FA90", "16556" },
  { "FA91", "16674" },
  { "FA92", "16717" },
  { "FA93", "1671B" },
  { "FA94", "16756" },
  { "FA95", "16B79" },
  { "FA96", "16BBA" },
  { "FA97", "16D41" },
  { "FA98", "16EDB" },
  { "FA99", "16ECB" },
  { "FA9A", "16F22" },
  { "FA9B", "1701E" },
  { "FA9C", "1716E" },
  { "FA9D", "177A7" },
  { "FA9E", "17235" },
  { "FA9F", "172AF" },
  { "FAA0", "1732A" },
  { "FAA1", "17471" },
  { "FAA2", "17506" },
  { "FAA3", "1753B" },
  { "FAA4", "1761D" },
  { "FAA5", "1761F" },
  { "FAA6", "176CA" },
  { "FAA7", "176DB" },
  { "FAA8", "176F4" },
  { "FAA9", "1774A" },
  { "FAAA", "17740" },
  { "FAAB", "178CC" },
  { "FAAC", "17AB1" },
  { "FAAD", "17BC0" },
  { "FAAE", "17C7B" },
  { "FAAF", "17D5B" },
  { "FAB0", "17DF4" },
  { "FAB1", "17F3E" },
  { "FAB2", "18005" },
  { "FAB3", "18352" },
  { "FAB4", "183EF" },
  { "FAB5", "18779" },
  { "FAB6", "18941" },
  { "FAB7", "18986" },
  { "FAB8", "18996" },
  { "FAB9", "18ABF" },
  { "FABA", "18AF8" },
  { "FABB", "18ACB" },
  { "FABC", "18B01" },
  { "FABD", "18AFE" },
  { "FABE", "18AED" },
  { "FABF", "18B39" },
  { "FAC0", "18B8A" },
  { "FAC1", "18D08" },
  { "FAC2", "18F38" },
  { "FAC3", "19072" },
  { "FAC4", "19199" },
  { "FAC5", "19276" },
  { "FAC6", "1967C" },
  { "FAC7", "196E3" },
  { "FAC8", "19756" },
  { "FAC9", "197DB" },
  { "FACA", "197FF" },
  { "FACB", "1980B" },
  { "FACC", "1983B" },
  { "FACD", "19B12" },
  { "FACE", "19F9C" },
  { "FACF", "12284A" },
  { "FAD0", "122844" },
  { "FAD1", "1233D5" },
  { "FAD2", "13B9D" },
  { "FAD3", "14018" },
  { "FAD4", "14039" },
  { "FAD5", "125249" },
  { "FAD6", "125CD0" },
  { "FAD7", "127ED3" },
  { "FAD8", "19F43" },
  { "FAD9", "19F8E" },
  { "FB1D", "205D9_05B4" },
  { "FB1F", "205F2_05B7" },
  { "FB2A", "205E9_05C1" },
  { "FB2B", "205E9_05C2" },
  { "FB2C", "305E9_05BC_05C1" },
  { "FB2D", "305E9_05BC_05C2" },
  { "FB2E", "205D0_05B7" },
  { "FB2F", "205D0_05B8" },
  { "FB30", "205D0_05BC" },
  { "FB31", "205D1_05BC" },
  { "FB32", "205D2_05BC" },
  { "FB33", "205D3_05BC" },
  { "FB34", "205D4_05BC" },
  { "FB35", "205D5_05BC" },
  { "FB36", "205D6_05BC" },
  { "FB38", "205D8_05BC" },
  { "FB39", "205D9_05BC" },
  { "FB3A", "205DA_05BC" },
  { "FB3B", "205DB_05BC" },
  { "FB3C", "205DC_05BC" },
  { "FB3E", "205DE_05BC" },
  { "FB40", "205E0_05BC" },
  { "FB41", "205E1_05BC" },
  { "FB43", "205E3_05BC" },
  { "FB44", "205E4_05BC" },
  { "FB46", "205E6_05BC" },
  { "FB47", "205E7_05BC" },
  { "FB48", "205E8_05BC" },
  { "FB49", "205E9_05BC" },
  { "FB4A", "205EA_05BC" },
  { "FB4B", "205D5_05B9" },
  { "FB4C", "205D1_05BF" },
  { "FB4D", "205DB_05BF" },
  { "FB4E", "205E4_05BF" },
  { "1D15E", "21D157_1D165" },
  { "1D15F", "21D158_1D165" },
  { "1D160", "31D158_1D165_1D16E" },
  { "1D161", "31D158_1D165_1D16F" },
  { "1D162", "31D158_1D165_1D170" },
  { "1D163", "31D158_1D165_1D171" },
  { "1D164", "31D158_1D165_1D172" },
  { "1D1BB", "21D1B9_1D165" },
  { "1D1BC", "21D1BA_1D165" },
  { "1D1BD", "31D1B9_1D165_1D16E" },
  { "1D1BE", "31D1BA_1D165_1D16E" },
  { "1D1BF", "31D1B9_1D165_1D16F" },
  { "1D1C0", "31D1BA_1D165_1D16F" },
  { "2F800", "14E3D" },
  { "2F801", "14E38" },
  { "2F802", "14E41" },
  { "2F803", "120122" },
  { "2F804", "14F60" },
  { "2F805", "14FAE" },
  { "2F806", "14FBB" },
  { "2F807", "15002" },
  { "2F808", "1507A" },
  { "2F809", "15099" },
  { "2F80A", "150E7" },
  { "2F80B", "150CF" },
  { "2F80C", "1349E" },
  { "2F80D", "12063A" },
  { "2F80E", "1514D" },
  { "2F80F", "15154" },
  { "2F810", "15164" },
  { "2F811", "15177" },
  { "2F812", "12051C" },
  { "2F813", "134B9" },
  { "2F814", "15167" },
  { "2F815", "1518D" },
  { "2F816", "12054B" },
  { "2F817", "15197" },
  { "2F818", "151A4" },
  { "2F819", "14ECC" },
  { "2F81A", "151AC" },
  { "2F81B", "151B5" },
  { "2F81C", "1291DF" },
  { "2F81D", "151F5" },
  { "2F81E", "15203" },
  { "2F81F", "134DF" },
  { "2F820", "1523B" },
  { "2F821", "15246" },
  { "2F822", "15272" },
  { "2F823", "15277" },
  { "2F824", "13515" },
  { "2F825", "152C7" },
  { "2F826", "152C9" },
  { "2F827", "152E4" },
  { "2F828", "152FA" },
  { "2F829", "15305" },
  { "2F82A", "15306" },
  { "2F82B", "15317" },
  { "2F82C", "15349" },
  { "2F82D", "15351" },
  { "2F82E", "1535A" },
  { "2F82F", "15373" },
  { "2F830", "1537D" },
  { "2F831", "1537F" },
  { "2F832", "1537F" },
  { "2F833", "1537F" },
  { "2F834", "120A2C" },
  { "2F835", "17070" },
  { "2F836", "153CA" },
  { "2F837", "153DF" },
  { "2F838", "120B63" },
  { "2F839", "153EB" },
  { "2F83A", "153F1" },
  { "2F83B", "15406" },
  { "2F83C", "1549E" },
  { "2F83D", "15438" },
  { "2F83E", "15448" },
  { "2F83F", "15468" },
  { "2F840", "154A2" },
  { "2F841", "154F6" },
  { "2F842", "15510" },
  { "2F843", "15553" },
  { "2F844", "15563" },
  { "2F845", "15584" },
  { "2F846", "15584" },
  { "2F847", "15599" },
  { "2F848", "155AB" },
  { "2F849", "155B3" },
  { "2F84A", "155C2" },
  { "2F84B", "15716" },
  { "2F84C", "15606" },
  { "2F84D", "15717" },
  { "2F84E", "15651" },
  { "2F84F", "15674" },
  { "2F850", "15207" },
  { "2F851", "158EE" },
  { "2F852", "157CE" },
  { "2F853", "157F4" },
  { "2F854", "1580D" },
  { "2F855", "1578B" },
  { "2F856", "15832" },
  { "2F857", "15831" },
  { "2F858", "158AC" },
  { "2F859", "1214E4" },
  { "2F85A", "158F2" },
  { "2F85B", "158F7" },
  { "2F85C", "15906" },
  { "2F85D", "1591A" },
  { "2F85E", "15922" },
  { "2F85F", "15962" },
  { "2F860", "1216A8" },
  { "2F861", "1216EA" },
  { "2F862", "159EC" },
  { "2F863", "15A1B" },
  { "2F864", "15A27" },
  { "2F865", "159D8" },
  { "2F866", "15A66" },
  { "2F867", "136EE" },
  { "2F868", "136FC" },
  { "2F869", "15B08" },
  { "2F86A", "15B3E" },
  { "2F86B", "15B3E" },
  { "2F86C", "1219C8" },
  { "2F86D", "15BC3" },
  { "2F86E", "15BD8" },
  { "2F86F", "15BE7" },
  { "2F870", "15BF3" },
  { "2F871", "121B18" },
  { "2F872", "15BFF" },
  { "2F873", "15C06" },
  { "2F874", "15F53" },
  { "2F875", "15C22" },
  { "2F876", "13781" },
  { "2F877", "15C60" },
  { "2F878", "15C6E" },
  { "2F879", "15CC0" },
  { "2F87A", "15C8D" },
  { "2F87B", "121DE4" },
  { "2F87C", "15D43" },
  { "2F87D", "121DE6" },
  { "2F87E", "15D6E" },
  { "2F87F", "15D6B" },
  { "2F880", "15D7C" },
  { "2F881", "15DE1" },
  { "2F882", "15DE2" },
  { "2F883", "1382F" },
  { "2F884", "15DFD" },
  { "2F885", "15E28" },
  { "2F886", "15E3D" },
  { "2F887", "15E69" },
  { "2F888", "13862" },
  { "2F889", "122183" },
  { "2F88A", "1387C" },
  { "2F88B", "15EB0" },
  { "2F88C", "15EB3" },
  { "2F88D", "15EB6" },
  { "2F88E", "15ECA" },
  { "2F88F", "12A392" },
  { "2F890", "15EFE" },
  { "2F891", "122331" },
  { "2F892", "122331" },
  { "2F893", "18201" },
  { "2F894", "15F22" },
  { "2F895", "15F22" },
  { "2F896", "138C7" },
  { "2F897", "1232B8" },
  { "2F898", "1261DA" },
  { "2F899", "15F62" },
  { "2F89A", "15F6B" },
  { "2F89B", "138E3" },
  { "2F89C", "15F9A" },
  { "2F89D", "15FCD" },
  { "2F89E", "15FD7" },
  { "2F89F", "15FF9" },
  { "2F8A0", "16081" },
  { "2F8A1", "1393A" },
  { "2F8A2", "1391C" },
  { "2F8A3", "16094" },
  { "2F8A4", "1226D4" },
  { "2F8A5", "160C7" },
  { "2F8A6", "16148" },
  { "2F8A7", "1614C" },
  { "2F8A8", "1614E" },
  { "2F8A9", "1614C" },
  { "2F8AA", "1617A" },
  { "2F8AB", "1618E" },
  { "2F8AC", "161B2" },
  { "2F8AD", "161A4" },
  { "2F8AE", "161AF" },
  { "2F8AF", "161DE" },
  { "2F8B0", "161F2" },
  { "2F8B1", "161F6" },
  { "2F8B2", "16210" },
  { "2F8B3", "1621B" },
  { "2F8B4", "1625D" },
  { "2F8B5", "162B1" },
  { "2F8B6", "162D4" },
  { "2F8B7", "16350" },
  { "2F8B8", "122B0C" },
  { "2F8B9", "1633D" },
  { "2F8BA", "162FC" },
  { "2F8BB", "16368" },
  { "2F8BC", "16383" },
  { "2F8BD", "163E4" },
  { "2F8BE", "122BF1" },
  { "2F8BF", "16422" },
  { "2F8C0", "163C5" },
  { "2F8C1", "163A9" },
  { "2F8C2", "13A2E" },
  { "2F8C3", "16469" },
  { "2F8C4", "1647E" },
  { "2F8C5", "1649D" },
  { "2F8C6", "16477" },
  { "2F8C7", "13A6C" },
  { "2F8C8", "1654F" },
  { "2F8C9", "1656C" },
  { "2F8CA", "12300A" },
  { "2F8CB", "165E3" },
  { "2F8CC", "166F8" },
  { "2F8CD", "16649" },
  { "2F8CE", "13B19" },
  { "2F8CF", "16691" },
  { "2F8D0", "13B08" },
  { "2F8D1", "13AE4" },
  { "2F8D2", "15192" },
  { "2F8D3", "15195" },
  { "2F8D4", "16700" },
  { "2F8D5", "1669C" },
  { "2F8D6", "180AD" },
  { "2F8D7", "143D9" },
  { "2F8D8", "16717" },
  { "2F8D9", "1671B" },
  { "2F8DA", "16721" },
  { "2F8DB", "1675E" },
  { "2F8DC", "16753" },
  { "2F8DD", "1233C3" },
  { "2F8DE", "13B49" },
  { "2F8DF", "167FA" },
  { "2F8E0", "16785" },
  { "2F8E1", "16852" },
  { "2F8E2", "16885" },
  { "2F8E3", "12346D" },
  { "2F8E4", "1688E" },
  { "2F8E5", "1681F" },
  { "2F8E6", "16914" },
  { "2F8E7", "13B9D" },
  { "2F8E8", "16942" },
  { "2F8E9", "169A3" },
  { "2F8EA", "169EA" },
  { "2F8EB", "16AA8" },
  { "2F8EC", "1236A3" },
  { "2F8ED", "16ADB" },
  { "2F8EE", "13C18" },
  { "2F8EF", "16B21" },
  { "2F8F0", "1238A7" },
  { "2F8F1", "16B54" },
  { "2F8F2", "13C4E" },
  { "2F8F3", "16B72" },
  { "2F8F4", "16B9F" },
  { "2F8F5", "16BBA" },
  { "2F8F6", "16BBB" },
  { "2F8F7", "123A8D" },
  { "2F8F8", "121D0B" },
  { "2F8F9", "123AFA" },
  { "2F8FA", "16C4E" },
  { "2F8FB", "123CBC" },
  { "2F8FC", "16CBF" },
  { "2F8FD", "16CCD" },
  { "2F8FE", "16C67" },
  { "2F8FF", "16D16" },
  { "2F900", "16D3E" },
  { "2F901", "16D77" },
  { "2F902", "16D41" },
  { "2F903", "16D69" },
  { "2F904", "16D78" },
  { "2F905", "16D85" },
  { "2F906", "123D1E" },
  { "2F907", "16D34" },
  { "2F908", "16E2F" },
  { "2F909", "16E6E" },
  { "2F90A", "13D33" },
  { "2F90B", "16ECB" },
  { "2F90C", "16EC7" },
  { "2F90D", "123ED1" },
  { "2F90E", "16DF9" },
  { "2F90F", "16F6E" },
  { "2F910", "123F5E" },
  { "2F911", "123F8E" },
  { "2F912", "16FC6" },
  { "2F913", "17039" },
  { "2F914", "1701E" },
  { "2F915", "1701B" },
  { "2F916", "13D96" },
  { "2F917", "1704A" },
  { "2F918", "1707D" },
  { "2F919", "17077" },
  { "2F91A", "170AD" },
  { "2F91B", "120525" },
  { "2F91C", "17145" },
  { "2F91D", "124263" },
  { "2F91E", "1719C" },
  { "2F91F", "1243AB" },
  { "2F920", "17228" },
  { "2F921", "17235" },
  { "2F922", "17250" },
  { "2F923", "124608" },
  { "2F924", "17280" },
  { "2F925", "17295" },
  { "2F926", "124735" },
  { "2F927", "124814" },
  { "2F928", "1737A" },
  { "2F929", "1738B" },
  { "2F92A", "13EAC" },
  { "2F92B", "173A5" },
  { "2F92C", "13EB8" },
  { "2F92D", "13EB8" },
  { "2F92E", "17447" },
  { "2F92F", "1745C" },
  { "2F930", "17471" },
  { "2F931", "17485" },
  { "2F932", "174CA" },
  { "2F933", "13F1B" },
  { "2F934", "17524" },
  { "2F935", "124C36" },
  { "2F936", "1753E" },
  { "2F937", "124C92" },
  { "2F938", "17570" },
  { "2F939", "12219F" },
  { "2F93A", "17610" },
  { "2F93B", "124FA1" },
  { "2F93C", "124FB8" },
  { "2F93D", "125044" },
  { "2F93E", "13FFC" },
  { "2F93F", "14008" },
  { "2F940", "176F4" },
  { "2F941", "1250F3" },
  { "2F942", "1250F2" },
  { "2F943", "125119" },
  { "2F944", "125133" },
  { "2F945", "1771E" },
  { "2F946", "1771F" },
  { "2F947", "1771F" },
  { "2F948", "1774A" },
  { "2F949", "14039" },
  { "2F94A", "1778B" },
  { "2F94B", "14046" },
  { "2F94C", "14096" },
  { "2F94D", "12541D" },
  { "2F94E", "1784E" },
  { "2F94F", "1788C" },
  { "2F950", "178CC" },
  { "2F951", "140E3" },
  { "2F952", "125626" },
  { "2F953", "17956" },
  { "2F954", "12569A" },
  { "2F955", "1256C5" },
  { "2F956", "1798F" },
  { "2F957", "179EB" },
  { "2F958", "1412F" },
  { "2F959", "17A40" },
  { "2F95A", "17A4A" },
  { "2F95B", "17A4F" },
  { "2F95C", "12597C" },
  { "2F95D", "125AA7" },
  { "2F95E", "125AA7" },
  { "2F95F", "17AEE" },
  { "2F960", "14202" },
  { "2F961", "125BAB" },
  { "2F962", "17BC6" },
  { "2F963", "17BC9" },
  { "2F964", "14227" },
  { "2F965", "125C80" },
  { "2F966", "17CD2" },
  { "2F967", "142A0" },
  { "2F968", "17CE8" },
  { "2F969", "17CE3" },
  { "2F96A", "17D00" },
  { "2F96B", "125F86" },
  { "2F96C", "17D63" },
  { "2F96D", "14301" },
  { "2F96E", "17DC7" },
  { "2F96F", "17E02" },
  { "2F970", "17E45" },
  { "2F971", "14334" },
  { "2F972", "126228" },
  { "2F973", "126247" },
  { "2F974", "14359" },
  { "2F975", "1262D9" },
  { "2F976", "17F7A" },
  { "2F977", "12633E" },
  { "2F978", "17F95" },
  { "2F979", "17FFA" },
  { "2F97A", "18005" },
  { "2F97B", "1264DA" },
  { "2F97C", "126523" },
  { "2F97D", "18060" },
  { "2F97E", "1265A8" },
  { "2F97F", "18070" },
  { "2F980", "12335F" },
  { "2F981", "143D5" },
  { "2F982", "180B2" },
  { "2F983", "18103" },
  { "2F984", "1440B" },
  { "2F985", "1813E" },
  { "2F986", "15AB5" },
  { "2F987", "1267A7" },
  { "2F988", "1267B5" },
  { "2F989", "123393" },
  { "2F98A", "12339C" },
  { "2F98B", "18201" },
  { "2F98C", "18204" },
  { "2F98D", "18F9E" },
  { "2F98E", "1446B" },
  { "2F98F", "18291" },
  { "2F990", "1828B" },
  { "2F991", "1829D" },
  { "2F992", "152B3" },
  { "2F993", "182B1" },
  { "2F994", "182B3" },
  { "2F995", "182BD" },
  { "2F996", "182E6" },
  { "2F997", "126B3C" },
  { "2F998", "182E5" },
  { "2F999", "1831D" },
  { "2F99A", "18363" },
  { "2F99B", "183AD" },
  { "2F99C", "18323" },
  { "2F99D", "183BD" },
  { "2F99E", "183E7" },
  { "2F99F", "18457" },
  { "2F9A0", "18353" },
  { "2F9A1", "183CA" },
  { "2F9A2", "183CC" },
  { "2F9A3", "183DC" },
  { "2F9A4", "126C36" },
  { "2F9A5", "126D6B" },
  { "2F9A6", "126CD5" },
  { "2F9A7", "1452B" },
  { "2F9A8", "184F1" },
  { "2F9A9", "184F3" },
  { "2F9AA", "18516" },
  { "2F9AB", "1273CA" },
  { "2F9AC", "18564" },
  { "2F9AD", "126F2C" },
  { "2F9AE", "1455D" },
  { "2F9AF", "14561" },
  { "2F9B0", "126FB1" },
  { "2F9B1", "1270D2" },
  { "2F9B2", "1456B" },
  { "2F9B3", "18650" },
  { "2F9B4", "1865C" },
  { "2F9B5", "18667" },
  { "2F9B6", "18669" },
  { "2F9B7", "186A9" },
  { "2F9B8", "18688" },
  { "2F9B9", "1870E" },
  { "2F9BA", "186E2" },
  { "2F9BB", "18779" },
  { "2F9BC", "18728" },
  { "2F9BD", "1876B" },
  { "2F9BE", "18786" },
  { "2F9BF", "145D7" },
  { "2F9C0", "187E1" },
  { "2F9C1", "18801" },
  { "2F9C2", "145F9" },
  { "2F9C3", "18860" },
  { "2F9C4", "18863" },
  { "2F9C5", "127667" },
  { "2F9C6", "188D7" },
  { "2F9C7", "188DE" },
  { "2F9C8", "14635" },
  { "2F9C9", "188FA" },
  { "2F9CA", "134BB" },
  { "2F9CB", "1278AE" },
  { "2F9CC", "127966" },
  { "2F9CD", "146BE" },
  { "2F9CE", "146C7" },
  { "2F9CF", "18AA0" },
  { "2F9D0", "18AED" },
  { "2F9D1", "18B8A" },
  { "2F9D2", "18C55" },
  { "2F9D3", "127CA8" },
  { "2F9D4", "18CAB" },
  { "2F9D5", "18CC1" },
  { "2F9D6", "18D1B" },
  { "2F9D7", "18D77" },
  { "2F9D8", "127F2F" },
  { "2F9D9", "120804" },
  { "2F9DA", "18DCB" },
  { "2F9DB", "18DBC" },
  { "2F9DC", "18DF0" },
  { "2F9DD", "1208DE" },
  { "2F9DE", "18ED4" },
  { "2F9DF", "18F38" },
  { "2F9E0", "1285D2" },
  { "2F9E1", "1285ED" },
  { "2F9E2", "19094" },
  { "2F9E3", "190F1" },
  { "2F9E4", "19111" },
  { "2F9E5", "12872E" },
  { "2F9E6", "1911B" },
  { "2F9E7", "19238" },
  { "2F9E8", "192D7" },
  { "2F9E9", "192D8" },
  { "2F9EA", "1927C" },
  { "2F9EB", "193F9" },
  { "2F9EC", "19415" },
  { "2F9ED", "128BFA" },
  { "2F9EE", "1958B" },
  { "2F9EF", "14995" },
  { "2F9F0", "195B7" },
  { "2F9F1", "128D77" },
  { "2F9F2", "149E6" },
  { "2F9F3", "196C3" },
  { "2F9F4", "15DB2" },
  { "2F9F5", "19723" },
  { "2F9F6", "129145" },
  { "2F9F7", "12921A" },
  { "2F9F8", "14A6E" },
  { "2F9F9", "14A76" },
  { "2F9FA", "197E0" },
  { "2F9FB", "12940A" },
  { "2F9FC", "14AB2" },
  { "2F9FD", "129496" },
  { "2F9FE", "1980B" },
  { "2F9FF", "1980B" },
  { "2FA00", "19829" },
  { "2FA01", "1295B6" },
  { "2FA02", "198E2" },
  { "2FA03", "14B33" },
  { "2FA04", "19929" },
  { "2FA05", "199A7" },
  { "2FA06", "199C2" },
  { "2FA07", "199FE" },
  { "2FA08", "14BCE" },
  { "2FA09", "129B30" },
  { "2FA0A", "19B12" },
  { "2FA0B", "19C40" },
  { "2FA0C", "19CFD" },
  { "2FA0D", "14CCE" },
  { "2FA0E", "14CED" },
  { "2FA0F", "19D67" },
  { "2FA10", "12A0CE" },
  { "2FA11", "14CF8" },
  { "2FA12", "12A105" },
  { "2FA13", "12A20E" },
  { "2FA14", "12A291" },
  { "2FA15", "19EBB" },
  { "2FA16", "14D56" },
  { "2FA17", "19EF9" },
  { "2FA18", "19EFE" },
  { "2FA19", "19F05" },
  { "2FA1A", "19F0F" },
  { "2FA1B", "19F16" },
  { "2FA1C", "19F3B" },
  { "2FA1D", "12A600" },
};

// global constructor

static struct unicode_decompose_init {
  unicode_decompose_init();
} _unicode_decompose_init;

unicode_decompose_init::unicode_decompose_init()
{
  for (unsigned int i = 0;
       i < sizeof(unicode_decompose_list)/sizeof(unicode_decompose_list[0]);
       i++) {
    unicode_decompose *dec = new unicode_decompose[1];
    dec->value = (char *)unicode_decompose_list[i].value;
    unicode_decompose_table.define(unicode_decompose_list[i].key, dec);
  }
}

const char *decompose_unicode(const char *s)
{
  unicode_decompose *result = unicode_decompose_table.lookup(s);
  return result ? result->value : 0;
}
