'\" t
.TH GROFF 7 "4 November 2014" "Groff Version 1.22.3"
.SH NAME
groff \- a short reference for the GNU roff language
.
.\" Before installation: <top-groff-source>/man/groff.man
.\" After installation:  </usr or /usr/local>/share/man/man7/groff.7
.
.\" --------------------------------------------------------------------
.\" Legalese
.\" --------------------------------------------------------------------
.
.de co
This file is part of groff, the GNU roff type-setting system.

Copyright \[co] 2000-2014 Free Software Foundation, Inc.

Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.3 or
any later version published by the Free Software Foundation; with no
Front-Cover Texts, and with no Back-Cover Texts.

A copy of the Free Documentation License is included as a file called
FDL in the main directory of the groff source package.  It is also
available in the internet at
.UR http://\:www.gnu.org/\:copyleft/\:fdl.html
.UE .
..
.
.de au
This documentation was written by
.MT groff-bernd.warken-72@web.de
Bernd Warken
.ME
and is appended and maintained by
.MT wl@gnu.org
Werner Lemberg
.ME .
..
.
.\" --------------------------------------------------------------------
.\" Setup
.\" --------------------------------------------------------------------
.
.do nr groff_C \n[.C]
.cp 0
.
.\" --------------------------------------------------------------------
.\" start of macro definitions
.
.de TPx
.  TP 10n
..
.\" ---------------------------------------------------------------------
.\" .Text anything ...
.\"
.\" All arguments are printed as text.
.\"
.de Text
.  nop \)\\$*
..
.
.\" --------- command line option ---------
.
.de option
.  Text \f[CB]\\$*
.  ft P
..
.
.\" --------- characters ---------
.
.de squoted_char
.  Text \[oq]\f[CB]\\$1\f[]\[cq]\\$2
..
.de dquoted_char
.  Text \[lq]\f[CB]\\$1\f[]\[rq]\\$2
..
.\" --------- requests ---------
.
.\" synopsis of a request
.de REQ
.  ie \n[.$]=1 \{\
.    Text \f[CB]\\$1\f[]
.  \}
.  el \{\
.    Text \f[CB]\\$1\~\f[]\f[I]\\$2\f[]
.  \}
..
.
.\" reference of a request
.de request
.  BR \\$*
..
.
.\" --------- numerical elements ---------
.
.\" number with a trailing unit
.de scalednumber
.  Text \\$1\^\f[CB]\\$2\f[]\\$3\f[R]
.  ft P
..
.
.\" representation of units within the text
.de scaleindicator
.  Text \f[CB]\\$1\f[]\\$2\f[R]
.  ft P
..
.
.\" representation of mathematical operators within the text
.de operator
.  squoted_char \\$@
..
.
.
.\" --------- escape sequences ---------
.
.\" ---------------------------------------------------------------------
.\" .ESC name [arg]
.\"
.\" Synopsis of an escape sequence, optionally with argument
.\" Args   : 1 or 2; `name' obligatory, `arg' optional
.\"   name : suitable name for an escape sequence (c, (xy, [long])
.\"   arg  : arbitrary word
.\" Result : prints \namearg, where `name' is in CB, `arg' in I
.\"
.de ESC
.  Text "\f[CB]\e\\$1\,\f[I]\\$2\/\fR"
..
.\" ---------------------------------------------------------------------
.\" .ESC[] name arg
.\"
.\" Synopsis for escape sequence with a bracketed long argument
.\" Args   : 2 obligatory
.\"   name : suitable name for an escape sequence (c, (xy, [long])
.\"   arg  : arbitrary text
.\" Result : prints \name[arg], where `name' is in CB, `arg' in I
.\"
.de ESC[]
.  Text "\f[CB]\e\\$1\[lB]\f[]\,\f[I]\\$2\/\f[]\f[CB]\[rB]\f[]"
..
.\" ---------------------------------------------------------------------
.\" .ESCq name arg
.\"
.\" Synopsis for escape sequence with a bracketed long argument
.\" Args   : 2 obligatory
.\"   name : suitable name for an escape sequence (c, (xy, [long])
.\"   arg  : arbitrary text
.\" Result : prints \name'arg', where `name' is in CB, `arg' in I
.\"
.de ESCq
.  Text "\f[CB]\e\\$1\[cq]\f[]\,\f[I]\\$2\/\f[]\f[CB]\[cq]\f[]"
..
.\" ---------------------------------------------------------------------
.\" .ESC? arg
.\"
.\" Synopsis for escape sequence with a bracketed long argument
.\" Args   : 1 obligatory
.\"   arg  : arbitrary text
.\" Result : prints `\?arg?', where the `?' are in CB, `arg' in I
.\"
.de ESC?
.  Text "\f[CB]\e?\,\f[I]\\$1\/\f[CB]?\f[R]"
..
.\" ---------------------------------------------------------------------
.\" .esc name [punct]
.\"
.\" Reference of an escape sequence (no args), possibly punctuation
.\" Args    : 1 obligatory
.\"   name  : suitable name for an escape sequence (c, (xy, [long])
.\"   punct : arbitrary
.\" Result  : prints \name, where `name' is in B, `punct' in R
.\"
.de esc
.  BR "\e\\$1" \\$2
..
.\" ---------------------------------------------------------------------
.\" .escarg name arg [punct]
.\"
.\" Reference of an escape sequence (no args)
.\" Args    : 1 obligatory, 1 optional
.\"   name  : suitable name for an escape sequence (c, (xy, [long])
.\"   arg   : arbitrary word
.\" Result  : prints \namearg, where
.\"           `name' is in B, `arg' in I
.\"
.de escarg
.  Text \f[B]\e\\$1\f[]\,\f[I]\\$2\/\f[]\\$3
..
.\" ---------------------------------------------------------------------
.\" .esc[] name arg [punct]
.\"
.\" Reference for escape sequence with a bracketed long argument
.\" Args   : 2 obligatory
.\"   name : suitable name for an escape sequence (c, (xy, [long])
.\"   arg  : arbitrary text
.\" Result : prints \name[arg], where `name' is in CB, `arg' in CI
.\"
.de esc[]
.  Text \f[CB]\e\\$1\[lB]\f[]\,\f[CI]\\$2\/\f[]\f[CB]\[rB]\f[]\\$3
..
.
.\" ---------------------------------------------------------------------
.\" .escq name arg
.\"
.\" Reference for escape sequence with a bracketed long argument
.\" Args   : 2 obligatory
.\"   name : suitable name for an escape sequence (c, (xy, [long])
.\"   arg  : arbitrary text
.\" Result : prints \name'arg', where `name' is in CB, `arg' in CI
.\"
.de escq
.  Text \f[CB]\e\\$1\[cq]\f[]\,\f[CI]\\$2\/\f[]\f[CB]\[cq]\f[]\\$3
..
.
.\" --------- strings ---------
.
.\" synopsis for string, with \*[]
.de STRING
.  Text \[rs]*[\f[CB]\\$1\f[]] \\$2
..
.\" synopsis for a long string
.de string
.  if \n[.$]=0 \
.    return
.  Text \f[CB]\[rs]*\[lB]\\$1\[rB]\f[]\\$2
..
.
.\" --------- registers ---------
.
.\" synopsis for registers, with \n[]
.de REG
.  Text \[rs]n[\f[CB]\\$1\f[]]
..
.\" reference of a register, without decoration
.de register
.  Text register
.  BR \\$*
..
.
.\" end of macro definitions
.
.
.\" --------------------------------------------------------------------
.SH DESCRIPTION
.\" --------------------------------------------------------------------
.
The name
.I groff
stands for
.I GNU roff
and is the free implementation of the roff type-setting system.
.
See
.BR roff (7)
for a survey and the background of the groff system.
.
.
.P
This document gives only short descriptions of the predefined roff
language elements as used in groff.
.
Both the classical features and the groff extensions are provided.
.
.
.P
Historically, the
.I roff language
was called
.IR troff .
.I groff
is compatible with the classical system and provides proper
extensions.
.
So in GNU, the terms
.IR roff ,
.IR troff ,
and
.I groff language
could be used as synonyms.
.
However
.I troff
slightly tends to refer more to the classical aspects, whereas
.I groff
emphasizes the GNU extensions, and
.I roff
is the general term for the language.
.
.
.P
This file is only a short version of the complete documentation that
is found in the
.I groff
.BR info (1)
file, which contains more detailed, actual, and concise information.
.
.P
The general syntax for writing groff documents is relatively easy, but
writing extensions to the roff language can be a bit harder.
.
.
.P
The roff language is line-oriented.
.
There are only two kinds of lines, control lines and text lines.
.
The control lines start with a control character, by default a period
.dquoted_char .
or a single quote
.dquoted_char \[aq] ;
all other lines are text lines.
.
.
.P
.B Control lines
represent commands, optionally with arguments.
.
They have the following syntax.
.
The leading control character can be followed by a command name;
arguments, if any, are separated by spaces (but not tab characters)
from the command name and among themselves, for example,
.RS
.P
.Text .command_name arg1 arg2
.RE
.
.
.P
For indentation, any number of space or tab characters can be inserted
between the leading control character and the command name, but the
control character must be on the first position of the line.
.
.
.P
.B Text lines
represent the parts that is printed.
They can be modified by escape sequences, which are recognized by a
leading backslash
.squoted_char \[rs] .
These are in-line or even in-word formatting elements or functions.
.
Some of these take arguments separated by single quotes
.dquoted_char \[aq] ,
others are regulated by a length encoding introduced by an open
parenthesis
.squoted_char (
or enclosed in brackets
.squoted_char [
and
.squoted_char ] .
.
.
.P
The roff language provides flexible instruments for writing language
extension, such as macros.
.
When interpreting macro definitions, the roff system enters a special
operating mode, called the
.BR "copy mode" .
.
.
.P
The copy mode behaviour can be quite tricky, but there are some rules
that ensure a safe usage.
.
.IP 1.
Printable backslashes must be denoted as
.esc e .
To be more precise,
.esc e
represents the current escape character.
.
To get a backslash glyph, use
.esc (rs
or
.esc [rs] .
.IP 2.
Double all backslashes.
.IP 3.
Begin all text lines with the special non-spacing character
.esc & .
.
.
.P
This does not produce the most efficient code, but it should work as a
first measure.
.
For better strategies, see the groff info file and
.BR groff_tmac (5).
.
.
.P
Reading roff source files is easier, just reduce all double backslashes
to a single one in all macro definitions.
.
.
.\" --------------------------------------------------------------------
.SH "GROFF ELEMENTS"
.\" --------------------------------------------------------------------
.
The roff language elements add formatting information to a text file.
.
The fundamental elements are predefined commands and variables that
make roff a full-blown programming language.
.
.
.P
There are two kinds of roff commands, possibly with arguments.
.B Requests
are written on a line of their own starting with a dot
.squoted_char .
or a
.dquoted_char \[aq] ,
whereas
.B Escape sequences
are in-line functions and in-word formatting elements starting with a
backslash
.squoted_char \[rs] .
.
.
.P
The user can define her own formatting commands using the
.request de
request.
.
These commands are called
.BR macros ,
but they are used exactly like requests.
.
Macro packages are pre-defined sets of macros written in the groff
language.
.
A user\[aq]s possibilities to create escape sequences herself is very
limited, only special characters can be mapped.
.
.
.P
The groff language provides several kinds of variables with
different interfaces.
.
There are pre-defined variables, but the user can define her own
variables as well.
.
.
.P
.B String
variables store character sequences.
.
They are set with the
.request ds
request and retrieved by the
.esc *
escape sequences.
.
Strings can have variables.
.
.
.P
.B Register
variables can store numerical values, numbers with a scale unit, and
occasionally string-like objects.
.
They are set with the
.request nr
request and retrieved by the
.esc n
escape sequences.
.
.
.P
.B Environments
allow the user to temporarily store global formatting parameters like
line length, font size, etc.\& for later reuse.
.
This is done by the
.request ev
request.
.
.
.P
.B Fonts
are identified either by a name or by an internal number.
.
The current font is chosen by the
.request ft
request or by the
.esc f
escape sequences.
.
Each device has special fonts, but the following fonts are available
for all devices.
.B R
is the standard font Roman.
.B B
is its
.B bold
counterpart.
.
The
.I italic
font is called
.B I
and is available everywhere, but on text devices it is displayed as an
underlined Roman font.
.
For the graphical output devices, there exist constant-width pendants
of these fonts,
.BR CR ,
.BR CI ,
and
.BR CB .
On text devices, all glyphs have a constant width anyway.
.
.
.P
.B Glyphs
are visual representation forms of
.BR characters .
In groff, the distinction between those two elements is not always
obvious (and a full discussion is beyond the scope of this man page).
.
A first approximation is that glyphs have a specific size and
colour and are taken from a specific font; they can\[aq]t be modified any
more \[en] characters are the input, and glyphs are the output.
.
As soon as an output line has been generated, it no longer contains
characters but glyphs.
.
In this man page, we use either \[oq]glyph\[cq] or
\[oq]character\[cq], whatever is more appropriate.
.
.
.P
Moreover, there are some advanced roff elements.
.
A
.B diversion
stores (formatted) information into a macro for later usage.
.
A
.B trap
is a positional condition like a certain number of lines from page top
or in a diversion or in the input.
.
Some action can be prescribed to be run automatically when the
condition is met.
.
.
.P
More detailed information and examples can be found in the groff info
file.
.
.
.\" --------------------------------------------------------------------
.SH "CONTROL CHARACTERS"
.\" --------------------------------------------------------------------
.
There is a small set of characters that have a special controlling
task in certain conditions.
.
.TP
\&\f[CB].\f[]
A dot is only special at the beginning of a line or after the
condition in the requests
.request if ,
.request ie ,
.request el ,
and
.request while .
There it is the control character that introduces a request (or macro).
.
By using the
.request cc
request, the control character can be set to a different character,
making the dot
.squoted_char .
a non-special character.
.
.IP ""
In all other positions, it just means a dot character.
.
In text paragraphs, it is advantageous to start each sentence at a
line of its own.
.
.TP
\&\f[CB]\[aq]\f[]
The single quote has two controlling tasks.
.
At the beginning of a line and in the conditional requests it is the
non-breaking control character.
.
That means that it introduces a request like the dot, but with the
additional property that this request doesn\[aq]t cause a linebreak.
.
By using the
.request c2
request, the non-break control character can be set to a different
character.
.
.IP ""
As a second task, it is the most commonly used argument separator in
some functional escape sequences (but any pair of characters not part
of the argument do work).
.
In all other positions, it denotes the single quote or apostrophe
character.
.
Groff provides a printable representation with the
.esc (cq
escape sequence.
.
.TP
\&\f[CB]\[dq]\f[]
The double quote is used to enclose arguments in macros (but not in
requests and strings).
.
In the
.request ds
and
.request as
requests, a leading double quote in the argument is stripped off,
making everything else afterwards the string to be defined (enabling
leading whitespace).
.
The escaped double quote
.esc \[dq]
introduces a comment.
.
Otherwise, it is not special.
.
Groff provides a printable representation with the
.esc (dq
escape sequence.
.
.TP
\&\f[CB]\e\f[]
The backslash usually introduces an escape sequence (this can be
changed with the
.request ec
request).
.
A printed version of the escape character is the
.esc e
escape; a backslash glyph can be obtained by
.esc (rs .
.
.TP
\&\f[CB](\f[]
The open parenthesis is only special in escape sequences when
introducing an escape name or argument consisting of exactly two
characters.
.
In groff, this behaviour can be replaced by the \f[CB][]\f[] construct.
.
.TP
\&\f[CB][\f[]
The opening bracket is only special in groff escape sequences; there
it is used to introduce a long escape name or long escape argument.
.
Otherwise, it is non-special, e.g.\& in macro calls.
.
.TP
\&\f[CB]]\f[]
The closing bracket is only special in groff escape sequences; there
it terminates a long escape name or long escape argument.
.
Otherwise, it is non-special.
.
.TP
\f[CI]space\f[]
Space characters are only functional characters.
.
They separate the arguments in requests, macros, and strings, and the words
in text lines.
.
They are subject to groff\[aq]s horizontal spacing calculations.
.
To get a defined space width, escape sequences like
.squoted_char "\[rs]\ "
(this is the escape character followed by a space),
.esc | ,
.esc ^ ,
or
.esc h
should be used.
.
.IP \f[CI]newline\f[]
In text paragraphs, newlines mostly behave like space characters.
.
Continuation lines can be specified by an escaped newline, i.e., by
specifying a backslash
.squoted_char \[rs]
as the last character of a line.
.
.IP \f[CI]tab\f[]
If a tab character occurs during text the interpreter makes a
horizontal jump to the next pre-defined tab position.
.
There is a sophisticated interface for handling tab positions.
.
.
.\" --------------------------------------------------------------------
.SH "NUMERICAL EXPRESSIONS"
.\" --------------------------------------------------------------------
.
A
.B numerical value
is a signed or unsigned integer or float with or without an appended
scaling indicator.
.
A
.B scaling indicator
is a one-character abbreviation for a unit of measurement.
.
A number followed by a scaling indicator signifies a size value.
.
By default, numerical values do not have a scaling indicator, i.e., they
are normal numbers.
.
.
.P
The
.I roff
language defines the following scaling indicators.
.
.
.P
.PD 0
.RS
.
.TPx
.B c
Centimeter
.
.TPx
.B i
Inch
.
.TPx
.B P
Pica\ \[eq]\ 1/6\ inch
.
.TPx
.B p
Point\ \[eq]\ 1/72\ inch
.
.TPx
.B m
Em\ \[eq]\ \f[R]the font size in points (approx.\& width of letter
\[oq]\f[CR]m\f[R]\[cq])
.
.TPx
.B M
100\^th \f[R]of an \f[CR]Em
.
.TPx
.B n
En\ \[eq]\ Em/2
.
.TPx
.B u
Basic unit for actual output device
.
.TPx
.B v
Vertical line space in basic units
scaled point\ \[eq]\ 1/\f[CI]sizescale\f[R] of a point (defined in
font \f[I]DESC\f[] file)
.
.TPx
.B f
Scale by 65536.
.RE
.PD
.
.
.P
.B Numerical expressions
are combinations of the numerical values defined above with the
following arithmetical operators already defined in classical troff.
.
.
.P
.PD 0
.RS
.
.TPx
.B +
Addition
.
.TPx
.B \-
Subtraction
.
.TPx
.B *
Multiplication
.
.TPx
.B /
Division
.
.TPx
.B %
Modulo
.
.TPx
.B =
Equals
.
.TPx
.B ==
Equals
.
.TPx
.B <
Less than
.
.TPx
.B >
Greater than
.
.TPx
.B <=
Less or equal
.
.TPx
.B >=
Greater or equal
.
.TPx
.B &
Logical and
.
.TPx
.B :
Logical or
.
.TPx
.B !
Logical not
.
.TPx
.B (
Grouping of expressions
.
.TPx
.B )
Close current grouping
.
.RE
.PD
.
.
.P
Moreover,
.I groff
added the following operators for numerical expressions:
.
.
.P
.PD 0
.RS
.
.TPx
\f[I]e1\/\f[CB]>?\,\f[I]e2\f[R]
The maximum of
.I e1
and
.IR e2 .
.
.TPx
\f[I]e1\/\f[CB]<?\,\f[I]e2\f[R]
The minimum of
.I e1
and
.IR e2 .
.
.TPx
\f[CB](\,\f[I]c\/\f[CB];\,\f[I]e\/\f[CB])\f[R]
Evaluate
.I e
using
.I c
as the default scaling indicator.
.
.RE
.PD
.
.
.P
For details see the groff info file.
.
.
.\" --------------------------------------------------------------------
.SH CONDITIONS
.\" --------------------------------------------------------------------
.
.B Conditions
occur in tests raised by the
.request if ,
.request ie ,
and the
.request while
requests.
.
The following table characterizes the different types of conditions.
.
.P
.
.PD 0
.RS
.
.TPx
.I N
A numerical expression
.I N
yields true if its value is greater than\~0.
.
.TPx
.BI ! N
True if the value of
.I N
is\~0 (see below).
.
.TPx
.BI \[aq] s1 \[aq] s2 \[aq]
True if string\~\c
.I s1
is identical to string\~\c
.IR s2 .
.
.TPx
.BI !\[aq] s1 \[aq] s2 \[aq]
True if string\~\c
.I s1
is not identical to string\~\c
.I s2
(see below).
.
.TPx
.BI c ch
True if there is a glyph\~\c
.I ch
available.
.
.TPx
.BI d name
True if there is a string, macro, diversion, or request called
.IR name .
.
.TPx
.B e
Current page number is even.
.
.TPx
.B o
Current page number is odd.
.
.TPx
.BI m name
True if there is a color called
.IR name .
.
.TPx
.B n
Formatter is
.BR nroff .
.
.TPx
.BI r reg
True if there is a register named
.IR reg .
.
.TPx
.B t
Formatter is
.BR troff .
.
.TPx
.BI F font
True if there exists a font named
.IR font .
.
.TPx
.BI S style
True if a style named
.I style
has been registered.
.
.RE
.PD
.
.
.P
Note that the
.B !
operator may only appear at the beginning of an expression,
and negates the entire expression.
This maintains bug-compatibility with AT&T
.IR troff .
.
.
.\" --------------------------------------------------------------------
.SH REQUESTS
.\" --------------------------------------------------------------------
.
This section provides a short reference for the predefined requests.
.
In groff, request, macro, and string names can be arbitrarily long.
.
No bracketing or marking of long names is needed.
.
.
.P
Most requests take one or more arguments.
.
The arguments are separated by space characters (no tabs!); there is
no inherent limit for their length or number.
.
.
.P
Some requests have optional arguments with a different behaviour.
.
Not all of these details are outlined here.
.
Refer to the groff info file and
.BR groff_diff (7)
for all details.
.
.
.P
In the following request specifications, most argument names were
chosen to be descriptive.
.
Only the following denotations need clarification.
.
.
.P
.PD 0
.RS
.
.TPx
.I c
denotes a single character.
.
.TPx
.I font
a font either specified as a font name or a font number.
.
.TPx
.I anything
all characters up to the end of the line or within
.esc {
and
.esc } .
.
.TPx
.I n
is a numerical expression that evaluates to an integer value.
.
.TPx
.I N
is an arbitrary numerical expression, signed or unsigned.
.
.TPx
.I \[+-]N
has three meanings depending on its sign, described below.
.
.RE
.PD
.
.
.P
If an expression defined as
.I \[+-]N
starts with a
.squoted_char +
sign the resulting value of the expression is added to an already
existing value inherent to the related request, e.g.\& adding to a number
register.
.
If the expression starts with a
.squoted_char -
the value of the expression is subtracted from the request value.
.
.
.P
Without a sign,
.I N
replaces the existing value directly.
.
To assign a negative number either prepend\~0 or enclose the negative
number in parentheses.
.
.
.\" --------------------------------------------------------------------
.SS "Request Short Reference"
.\" --------------------------------------------------------------------
.
.PD 0
.
.TPx
.REQ .
Empty line, ignored.
.
Useful for structuring documents.
.
.TPx
.REQ .\e\[dq] "anything"
Complete line is a comment.
.
.TPx
.REQ .ab "string"
Print
.I string
on standard error, exit program.
.
.TPx
.REQ .ad
Begin line adjustment for output lines in current adjust mode.
.
.TPx
.REQ .ad "c"
Start line adjustment in mode
.I c
(\f[CI]c\/\f[]\f[CR]\|\^\[eq]\|l,r,c,b,n\f[]).
.
.TPx
.REQ .af "register c"
Assign format
.I c
to
.I register
(\f[CI]c\/\f[]\f[CR]\|\^\[eq]\|l,i,I,a,A\f[]).
.
.TPx
.REQ .aln "alias register"
Create alias name for
.IR register .
.
.TPx
.REQ .als "alias object"
Create alias name for request, string, macro, or diversion
.IR object .
.
.TPx
.REQ .am "macro"
Append to
.I macro
until
.B ..\&
is encountered.
.
.TPx
.REQ .am "macro end"
Append to
.I macro
until
.BI . end
is called.
.
.TPx
.REQ .am1 "macro"
Same as
.request .am
but with compatibility mode switched off during macro expansion.
.
.TPx
.REQ .am1 "macro end"
Same as
.request .am
but with compatibility mode switched off during macro expansion.
.
.TPx
.REQ .ami "macro"
Append to a macro whose name is contained in the string register
.I macro
until
.B ..\&
is encountered.
.
.TPx
.REQ .ami "macro end"
Append to a macro indirectly.
.I macro
and
.I end
are string registers whose contents are interpolated for the macro name
and the end macro, respectively.
.
.TPx
.REQ .ami1 "macro"
Same as
.request .ami
but with compatibility mode switched off during macro expansion.
.
.TPx
.REQ .ami1 "macro end"
Same as
.request .ami
but with compatibility mode switched off during macro expansion.
.
.TPx
.REQ .as "stringvar anything"
Append
.I anything
to
.IR stringvar .
.
.TPx
.REQ .as1 "stringvar anything"
Same as
.request .as
but with compatibility mode switched off during string expansion.
.
.TPx
.REQ .asciify "diversion"
Unformat ASCII characters, spaces, and some escape sequences in
.IR diversion .
.
.TPx
.REQ .backtrace
Print a backtrace of the input on stderr.
.
.TPx
.REQ .bd "font N"
Embolden
.I font
by
.IR N \\-1
units.
.
.TPx
.REQ .bd "S font N"
Embolden Special Font
.I S
when current font is
.IR font .
.
.TPx
.REQ .blm
Unset the blank line macro.
.
.TPx
.REQ .blm "macro"
Set the blank line macro to
.IR macro .
.
.TPx
.REQ .box
End current diversion.
.
.TPx
.REQ .box "macro"
Divert to
.IR macro ,
omitting a partially filled line.
.
.TPx
.REQ .boxa
End current diversion.
.
.TPx
.REQ .boxa "macro"
Divert and append to
.IR macro ,
omitting a partially filled line.
.
.TPx
.REQ .bp
Eject current page and begin new page.
.
.TPx
.REQ .bp "\[+-]N"
Eject current page; next page number
.IR \[+-]N .
.
.TPx
.REQ .br
Line break.
.
.TPx
.REQ .brp
Break and spread output line.
Same as
.esc p .
.
.TPx
.REQ .break
Break out of a while loop.
.
.TPx
.REQ .c2
Reset no-break control character to
.dquoted_char \[aq] .
.
.TPx
.REQ .c2 "c"
Set no-break control character to
.IR c .
.
.TPx
.REQ .cc
Reset control character to
.squoted_char . .
.
.TPx
.REQ .cc "c"
Set control character to
.IR c .
.
.TPx
.REQ .ce
Center the next input line.
.
.TPx
.REQ .ce "N"
Center following
.I N
input lines.
.
.TPx
.REQ .cf "filename"
Copy contents of file
.I filename
unprocessed to stdout or to the diversion.
.
.TPx
.REQ .cflags "mode c1 c2 .\|.\|.\&"
Treat characters
.IR c1 ,
.IR c2 ,
.I .\|.\|.\&
according to
.I mode
number.
.
.TPx
.REQ .ch "trap N"
Change
.I trap
location
to
.IR N .
.
.TPx
.REQ .char "c anything"
Define entity
.I c
as string
.IR anything .
.
.TPx
.REQ .chop "object"
Chop the last character off macro, string, or diversion
.IR object .
.
.TPx
.REQ .class "name c1 c2 .\|.\|.\&"
Assign a set of characters, character ranges, or classes
.IR c1 ,
.IR c2 ,
.I .\|.\|.\&
to
.IR name .
.
.TPx
.REQ .close "stream"
Close the
.IR stream .
.
.TPx
.REQ .color
Enable colors.
.
.TPx
.REQ .color "N"
If
.I N
is zero disable colors, otherwise enable them.
.
.TPx
.REQ .composite "from to"
Map glyph name
.I from
to glyph name
.I to
while constructing a composite glyph name.
.
.TPx
.REQ .continue
Finish the current iteration of a while loop.
.
.TPx
.REQ .cp
Enable compatibility mode.
.
.TPx
.REQ .cp "N"
If
.I N
is zero disable compatibility mode, otherwise enable it.
.
.TPx
.REQ .cs "font N M"
Set constant character width mode for
.I font
to
.IR N /36
ems with em
.IR M .
.
.TPx
.REQ .cu "N"
Continuous underline in nroff, like
.request .ul
in troff.
.
.TPx
.REQ .da
End current diversion.
.
.TPx
.REQ .da "macro"
Divert and append to
.IR macro .
.
.TPx
.REQ .de "macro"
Define or redefine
.I macro
until
.B ..\&
is encountered.
.
.TPx
.REQ .de "macro end"
Define or redefine
.I macro
until
.BI . end
is called.
.
.TPx
.REQ .de1 "macro"
Same as
.request .de
but with compatibility mode switched off during macro expansion.
.
.TPx
.REQ .de1 "macro end"
Same as
.request .de
but with compatibility mode switched off during macro expansion.
.
.TPx
.REQ .defcolor "color scheme component"
Define or redefine a color with name
.IR color .
.I scheme
can be
.BR rgb ,
.BR cym ,
.BR cymk ,
.BR gray ,
or
.BR grey .
.I component
can be single components specified as fractions in the range 0 to 1
(default scaling indicator\~\c
.scaleindicator f ),
as a string of two-digit hexadecimal color components with a leading
.BR # ,
or as a string of four-digit hexadecimal components with two leading
.BR # .
The color
.B default
can\[aq]t be redefined.
.
.TPx
.REQ .dei "macro"
Define or redefine a macro whose name is contained in the string register
.I macro
until
.B ..\&
is encountered.
.
.TPx
.REQ .dei "macro end"
Define or redefine a macro indirectly.
.I macro
and
.I end
are string registers whose contents are interpolated for the macro name
and the end macro, respectively.
.
.TPx
.REQ .dei1 "macro"
Same as
.request .dei
but with compatibility mode switched off during macro expansion.
.
.TPx
.REQ .dei1 "macro end"
Same as
.request .dei
but with compatibility mode switched off during macro expansion.
.
.TPx
.REQ .device "anything"
Write
.I anything
to the intermediate output as a device control function.
.
.TPx
.REQ .devicem "name"
Write contents of macro or string
.I name
uninterpreted to the intermediate output as a device control function.
.
.TPx
.REQ .di
End current diversion.
.
.TPx
.REQ .di "macro"
Divert to
.IR macro .
.
.TPx
.REQ .do "name"
Interpret
.BI . name
with compatibility mode disabled.
.
.TPx
.REQ .ds "stringvar anything"
Set
.I stringvar
to
.IR anything .
.
.TPx
.REQ .ds1 "stringvar anything"
Same as
.request .ds
but with compatibility mode switched off during string expansion.
.
.TPx
.REQ .dt "N trap"
Set diversion trap to position
.I N
(default scaling indicator\~\c
.scaleindicator v ).
.
.TPx
.REQ .ec
Reset escape character to
.squoted_char \[rs] .
.
.TPx
.REQ .ec "c"
Set escape character to
.IR c .
.
.TPx
.REQ .ecr
Restore escape character saved with
.request .ecs .
.
.TPx
.REQ .ecs
Save current escape character.
.
.TPx
.REQ .el "anything"
Else part for if-else (\c
.request ie )
request.
.
.TPx
.REQ .em "macro"
The
.I macro
is run after the end of input.
.
.TPx
.REQ .eo
Turn off escape character mechanism.
.
.TPx
.REQ .ev
Switch to previous environment and pop it off the stack.
.
.TPx
.REQ .ev "env"
Push down environment number or name
.I env
to the stack and switch to it.
.
.TPx
.REQ .evc "env"
Copy the contents of environment
.I env
to the current environment.
No pushing or popping.
.
.TPx
.REQ .ex
Exit from roff processing.
.
.TPx
.REQ .fam
Return to previous font family.
.
.TPx
.REQ .fam "name"
Set the current font family to
.IR name .
.
.TPx
.REQ .fc
Disable field mechanism.
.
.TPx
.REQ .fc "a"
Set field delimiter to\~\c
.I a
and pad glyph to space.
.
.TPx
.REQ .fc "a b"
Set field delimiter to\~\c
.I a
and pad glyph to\~\c
.IR b .
.
.TPx
.REQ .fchar "c anything"
Define fallback character (or glyph)
.I c
as string
.IR anything .
.
.TPx
.REQ .fcolor
Set fill color to previous fill color.
.
.TPx
.REQ .fcolor "c"
Set fill color to
.IR c .
.
.TPx
.REQ .fi
Fill output lines.
.
.TPx
.REQ .fl
Flush output buffer.
.
.TPx
.REQ .fp "n font"
Mount
.I font
on position
.IR n .
.
.TPx
.REQ .fp "n internal external"
Mount font with long
.I external
name to short
.I internal
name on position
.IR n .
.
.TPx
.REQ .fschar "f c anything"
Define fallback character (or glyph)
.I c
for font
.I f
as string
.IR anything .
.
.TPx
.REQ .fspecial "font"
Reset list of special fonts for
.I font
to be empty.
.
.TPx
.REQ .fspecial "font s1 s2 .\|.\|.\&"
When the current font is
.IR font ,
then the fonts
.IR s1 ,
.IR s2 ,
.I .\|.\|.\&
are special.
.
.TPx
.REQ .ft
Return to previous font.
Same as
.request \[rs]f[]
or
.request \[rs]fP .
.
.TPx
.REQ .ft "font"
Change to font name or number
.IR font ;
same as
.esc[] f font
escape sequence.
.
.TPx
.REQ .ftr "font1 font2"
Translate
.I font1
to
.IR font2 .
.
.TPx
.REQ .fzoom "font"
Don\[aq]t magnify
.IR font .
.
.TPx
.REQ .fzoom "font zoom"
Set zoom factor for
.I font
(in multiples of 1/1000th).
.
.TPx
.REQ .gcolor
Set glyph color to previous glyph color.
.
.TPx
.REQ .gcolor "c"
Set glyph color to
.IR c .
.
.TPx
.REQ .hc
Remove additional hyphenation indicator character.
.
.TPx
.REQ .hc "c"
Set up additional hyphenation indicator character\~\c
.IR c .
.
.TPx
.REQ .hcode "c1 code1 c2 code2 .\|.\|.\&"
Set the hyphenation code of character
.I c1
to
.IR code1 ,
that of
.I c2
to
.IR code2 ,
etc.
.
.TPx
.REQ .hla "lang"
Set the current hyphenation language to
.IR lang .
.
.TPx
.REQ .hlm "n"
Set the maximum number of consecutive hyphenated lines to
.IR n .
.
.TPx
.REQ .hpf "file"
Read hyphenation patterns from
.IR file .
.
.TPx
.REQ .hpfa "file"
Append hyphenation patterns from
.IR file .
.
.TPx
.REQ .hpfcode "a b c d .\|.\|.\&"
Set input mapping for
.request .hpf .
.
.TPx
.REQ .hw "words"
List of
.I words
with exceptional hyphenation.
.
.TPx
.REQ .hy "N"
Switch to hyphenation mode
.IR N .
.
.TPx
.REQ .hym "n"
Set the hyphenation margin to
.I n
(default scaling indicator\~\c
.scaleindicator m ).
.
.TPx
.REQ .hys "n"
Set the hyphenation space to
.IR n .
.
.TPx
.REQ .ie "cond anything"
If
.I cond
then
.I anything
else goto
.request .el .
.
.TPx
.REQ .if "cond anything"
If
.I cond
then
.IR anything ;
otherwise do nothing.
.
.TPx
.REQ .ig
Ignore text until
.B ..\&
is encountered.
.
.TPx
.REQ .ig "end"
Ignore text until
.BI . end
is called.
.
.TPx
.REQ .in
Change to previous indentation value.
.
.TPx
.REQ .in "\[+-]N"
Change indentation according to
.I \[+-]N
(default scaling indicator\~\c
.scaleindicator m ).
.
.TPx
.REQ .it "N trap"
Set an input-line count trap for the next
.I N
lines.
.
.TPx
.REQ .itc "N trap"
Same as
.request .it
but count lines interrupted with
.esc c
as one line.
.
.TPx
.REQ .kern
Enable pairwise kerning.
.
.TPx
.REQ .kern "n"
If
.I n
is zero, disable pairwise kerning, otherwise enable it.
.
.TPx
.REQ .lc
Remove leader repetition glyph.
.
.TPx
.REQ .lc "c"
Set leader repetition glyph to\~\c
.IR c .
.
.TPx
.REQ .length "register anything"
Write the length of the string
.I anything
to
.IR register .
.
.TPx
.REQ .linetabs
Enable line-tabs mode (i.e., calculate tab positions relative to output
line).
.
.TPx
.REQ .linetabs "n"
If
.I n
is zero, disable line-tabs mode, otherwise enable it.
.
.TPx
.REQ .lf "N"
Set input line number to
.IR N .
.
.TPx
.REQ .lf "N file"
Set input line number to
.I N
and filename to
.IR file .
.
.TPx
.REQ .lg "N"
Ligature mode on if
.IR N >0.
.
.TPx
.REQ .ll
Change to previous line length.
.
.TPx
.REQ .ll "\[+-]N"
Set line length according to
.I \[+-]N
(default length
.scalednumber 6.5 i ,
default scaling indicator\~\c
.scaleindicator m ).
.
.TPx
.REQ .lsm
Unset the leading spaces macro.
.
.TPx
.REQ .lsm "macro"
Set the leading spaces macro to
.IR macro .
.
.TPx
.REQ .ls
Change to the previous value of additional intra-line skip.
.
.TPx
.REQ .ls "N"
Set additional intra-line skip value to
.IR N ,
i.e.,
.IR N \\-1
blank lines are inserted after each text output line.
.
.TPx
.REQ .lt "\[+-]N"
Length of title (default scaling indicator\~\c
.scaleindicator m ).
.
.TPx
.REQ .mc
Margin glyph off.
.
.TPx
.REQ .mc "c"
Print glyph\~\c
.I c
after each text line at actual distance from right margin.
.
.TPx
.REQ .mc "c N"
Set margin glyph to\~\c
.I c
and distance to\~\c
.I N
from right margin (default scaling indicator\~\c
.scaleindicator m ).
.
.TPx
.REQ .mk "register"
Mark current vertical position in
.IR register .
.
.TPx
.REQ .mso "file"
The same as
.request .so
except that
.I file
is searched in the tmac directories.
.
.TPx
.REQ .na
No output-line adjusting.
.
.TPx
.REQ .ne
Need a one-line vertical space.
.
.TPx
.REQ .ne "N"
Need
.I N
vertical space (default scaling indicator\~\c
.scaleindicator v ).
.
.TPx
.REQ .nf
No filling or adjusting of output-lines.
.
.TPx
.REQ .nh
No hyphenation.
.
.TPx
.REQ .nm
Number mode off.
.
.TPx
.REQ .nm "\[+-]N \fR[\fPM \fR[\fPS \fR[\fPI\fR]]]\fP"
In line number mode, set number, multiple, spacing, and indentation.
.
.TPx
.REQ .nn
Do not number next line.
.
.TPx
.REQ .nn "N"
Do not number next
.I N
lines.
.
.TPx
.REQ .nop "anything"
Always process
.IR anything .
.
.TPx
.REQ .nr "register \[+-]N \fR[\fPM\fR]\fP"
Define or modify
.I register
using
.I \[+-]N
with auto-increment
.IR M .
.
.TPx
.REQ .nroff
Make the built-in conditions
.B n
true and
.B t
false.
.
.TPx
.REQ .ns
Turn on no-space mode.
.
.TPx
.REQ .nx
Immediately jump to end of current file.
.
.TPx
.REQ .nx "filename"
Immediately continue processing with file
.IR file .
.
.TPx
.REQ .open "stream filename"
Open
.I filename
for writing and associate the stream named
.I stream
with it.
.
.TPx
.REQ .opena "stream filename"
Like
.request .open
but append to it.
.
.TPx
.REQ .os
Output vertical distance that was saved by the
.request sv
request.
.
.TPx
.REQ .output "string"
Emit
.I string
directly to intermediate output, allowing leading whitespace if
.I string
starts with
\&\f[CB]\[dq]\f[]
(which is stripped off).
.
.TPx
.REQ .pc
Reset page number character to\~\c
.squoted_char % .
.
.TPx
.REQ .pc "c"
Page number character.
.
.TPx
.REQ .pev
Print the current environment and each defined environment
state to stderr.
.
.TPx
.REQ .pi "program"
Pipe output to
.I program
(nroff only).
.
.TPx
.REQ .pl
Set page length to default
.scalednumber 11 i .
The current page length is stored in
.register .p .
.
.TPx
.REQ .pl "\[+-]N"
Change page length to
.I \[+-]N
(default scaling indicator\~\c
.scaleindicator v ).
.
.TPx
.REQ .pm
Print macro names and sizes (number of blocks of 128 bytes).
.
.TPx
.REQ .pm "t"
Print only total of sizes of macros (number of 128 bytes blocks).
.
.TPx
.REQ .pn "\[+-]N"
Next page number
.IR N .
.
.TPx
.REQ .pnr
Print the names and contents of all currently defined number registers
on stderr.
.
.TPx
.REQ .po
Change to previous page offset.
.
The current page offset is available in
.register .o .
.
.TPx
.REQ .po "\[+-]N"
Page offset
.IR N .
.
.TPx
.REQ .ps
Return to previous point size.
.TPx
.REQ .ps "\[+-]N"
Point size; same as
.esc[] s \[+-]N .
.
.TPx
.REQ .psbb "filename"
Get the bounding box of a PostScript image
.IR filename .
.
.TPx
.REQ .pso "command"
This behaves like the
.request so
request except that input comes from the standard output of
.IR command .
.
.TPx
.REQ .ptr
Print the names and positions of all traps (not including input line
traps and diversion traps) on stderr.
.
.TPx
.REQ .pvs
Change to previous post-vertical line spacing.
.
.TPx
.REQ .pvs "\[+-]N"
Change post-vertical line spacing according to
.I \[+-]N
(default scaling indicator\~\c
.scaleindicator p ).
.
.TPx
.REQ .rchar "c1 c2 .\|.\|.\&"
Remove the definitions of entities
.IR c1 ,
.IR c2 ,
.I .\|.\|.\&
.
.TPx
.REQ .rd "prompt"
Read insertion.
.
.TPx
.REQ .return
Return from a macro.
.
.TPx
.REQ .return "anything"
Return twice, namely from the macro at the current level and from the macro
one level higher.
.
.TPx
.REQ .rfschar "f c1 c2 .\|.\|.\&"
Remove the definitions of entities
.IR c1 ,
.IR c2 ,
.I .\|.\|.\&
for font
.IR f .
.
.TPx
.REQ .rj "n"
Right justify the next
.I n
input lines.
.
.TPx
.REQ .rm "name"
Remove request, macro, or string
.IR name .
.
.TPx
.REQ .rn "old new"
Rename request, macro, or string
.I old
to
.IR new .
.
.TPx
.REQ .rnn "reg1 reg2"
Rename register
.I reg1
to
.IR reg2 .
.
.TPx
.REQ .rr "register"
Remove
.IR register .
.
.TPx
.REQ .rs
Restore spacing; turn no-space mode off.
.
.TPx
.REQ .rt "\[+-]N"
Return
.I (upward only)
to marked vertical place (default scaling indicator\~\c
.scaleindicator v ).
.
.TPx
.REQ .schar "c anything"
Define global fallback character (or glyph)\~\c
.I c
as string
.IR anything .
.
.TPx
.REQ .shc
Reset soft hyphen glyph to
.esc (hy .
.
.TPx
.REQ .shc "c"
Set the soft hyphen glyph to\~\c
.IR c .
.
.TPx
.REQ .shift "n"
In a macro, shift the arguments by
.IR n \~\c
positions.
.
.TPx
.REQ .sizes "s1 s2 .\|.\|.\& sn \fB[0]\fP"
Set available font sizes similar to the
.B sizes
command in a
.B DESC
file.
.
.TPx
.REQ .so "filename"
Include source file.
.
.TPx
.REQ .sp
Skip one line vertically.
.
.TPx
.REQ .sp "N"
Space vertical distance
.I N
up or down according to sign of
.I N
(default scaling indicator\~\c
.scaleindicator v ).
.
.TPx
.REQ .special
Reset global list of special fonts to be empty.
.
.TPx
.REQ .special "s1 s2 .\|.\|.\&"
Fonts
.IR s1 ,
.IR s2 ,
etc.\& are special and are searched for glyphs not in the
current font.
.
.TPx
.REQ .spreadwarn
Toggle the spread warning on and off without changing its value.
.
.TPx
.REQ .spreadwarn "limit"
Emit a warning if each space in an output line is widened by
.I limit
or more (default scaling indicator\~\c
.scaleindicator m ).
.
.TPx
.REQ .ss "N"
Set space glyph size to
.IR N /12
of the space width in the current font.
.
.TPx
.REQ .ss "N M"
Set space glyph size to
.IR N /12
and sentence space size set to
.IR M /12
of the space width in the current font.
.
.TPx
.REQ .sty "n style"
Associate
.I style
with font position
.IR n .
.
.TPx
.REQ .substring "xx n1 n2"
Replace the string named
.I xx
with the substring defined by the indices
.I n1
and
.IR n2 .
.
.TPx
.REQ .sv
Save
.scalednumber "1 v"
of vertical space.
.TPx
.REQ .sv "N"
Save the vertical distance
.I N
for later output with
.request os
request (default scaling indicator\~\c
.scaleindicator v ).
.
.TPx
.REQ .sy "command-line"
Execute program
.IR command-line .
.
.TPx
.REQ .ta "T N"
Set tabs after every position that is a multiple of
.I N
(default scaling indicator\~\c
.scaleindicator m ).
.TPx
.REQ .ta "n1 n2 .\|.\|.\& nn \f[CB]T\f[] r1 r2 .\|.\|.\& rn"
Set tabs at positions
.IR n1 ,
.IR n2 ,
.Text .\|.\|.,
.IR nn ,
then set tabs at
.IR nn + r1 ,
.IR nn + r2 ,
.Text .\|.\|.,
.IR nn + rn ,
then at
.IR nn + rn + r1 ,
.IR nn + rn + r2 ,
.Text .\|.\|.,
.IR nn + rn + rn ,
and so on.
.
.\".TPx
.\".REQ .tar
.\"Restore internally saved tab positions.
.\".
.\".TPx
.\".REQ .tas
.\"Save tab positions internally.
.
.TPx
.REQ .tc
Remove tab repetition glyph.
.TPx
.REQ .tc "c"
Set tab repetition glyph to\~\c
.IR c .
.
.TPx
.REQ .ti "\[+-]N"
Temporary indent next line (default scaling indicator\~\c
.scaleindicator m ).
.
.TPx
.REQ .tkf "font s1 n1 s2 n2"
Enable track kerning for
.IR font .
.
.TPx
.REQ .tl "\f[CB]\[cq]\f[]left\f[CB]\[cq]\f[]center\f[CB]\[cq]\f[]right\f[CB]\[cq]\f[]"
Three-part title.
.
.TPx
.REQ .tm "anything"
Print
.I anything
on stdout.
.
.TPx
.REQ .tm1 "anything"
Print
.I anything
on stdout, allowing leading whitespace if
.I anything
starts with
\&\f[CB]\[dq]\f[]
(which is stripped off).
.
.TPx
.REQ .tmc "anything"
Similar to
.request .tm1
without emitting a final newline.
.
.TPx
.REQ .tr "abcd.\|.\|.\&"
Translate
.I a
to
.IR b ,
.I c
to
.IR d ,
etc.\& on output.
.
.TPx
.REQ .trf "filename"
Transparently output the contents of file
.IR filename .
.
.TPx
.REQ .trin "abcd.\|.\|.\&"
This is the same as the
.request tr
request except that the
.B asciify
request uses the character code (if any) before the character
translation.
.
.TPx
.REQ .trnt "abcd.\|.\|.\&"
This is the same as the
.request tr
request except that the translations do not apply to text that is
transparently throughput into a diversion with
.esc ! .
.
.TPx
.REQ .troff
Make the built-in conditions
.B t
true and
.B n
false.
.
.TPx
.REQ .uf "font"
Set underline font to
.I font
(to be switched to by
.request .ul ).
.
.TPx
.REQ .ul "N"
Underline (italicize in troff)
.I N
input lines.
.
.TPx
.REQ .unformat "diversion"
Unformat space characters and tabs in
.IR diversion ,
preserving font information.
.TPx
.REQ .vpt "n"
Enable vertical position traps if
.I n
is non-zero, disable them otherwise.
.
.TPx
.REQ .vs
Change to previous vertical base line spacing.
.
.TPx
.REQ .vs "\[+-]N"
Set vertical base line spacing to
.I \[+-]N
(default scaling indicator\~\c
.scaleindicator p ).
.
.TPx
.REQ .warn "n"
Set warnings code to
.IR n .
.
.TPx
.REQ .warnscale "si"
Set scaling indicator used in warnings to
.IR si .
.
.TPx
.REQ .wh "N"
Remove (first) trap at position
.IR N .
.
.TPx
.REQ .wh "N trap"
Set location trap; negative means from page bottom.
.
.TPx
.REQ .while "cond anything"
While condition
.I cond
is true, accept
.I anything
as input.
.
.TPx
.REQ .write "stream anything"
Write
.I anything
to the stream named
.IR stream .
.
.TPx
.REQ .writec "stream anything"
Similar to
.request .write
without emitting a final newline.
.
.TPx
.REQ .writem "stream xx"
Write contents of macro or string
.I xx
to the stream named
.IR stream .
.
.PD
.
.
.P
Besides these standard groff requests, there might be further macro
calls.
They can originate from a macro package (see
.BR roff (7)
for an overview) or from a preprocessor.
.
.
.P
Preprocessor macros are easy to be recognized.
.
They enclose their code into a pair of characteristic macros.
.
.
.P
.TS
box, center, tab (@);
c | c | c
CfCB | CfCB | CfCB.
preprocessor@start macro@ end macro
=
chem@.cstart@.cend
eqn@.EQ@.EN
gideal@.IS@.IE
grap@.G1@.G2
grn@.GS@.GE
@@.IF
pic@.PS@.PE
refer@.R1@.R2
soelim@\f[I]none@\f[I]none
tbl@.TS@.TE
_
glilypond@.lilypond start@.lilypond stop
gperl@.Perl start@.Perl stop
gpinyin@.pinyin start@.pinyin stop
.TE
.
.
.P
Note that the \[oq]ideal\[cq] preprocessor is not available in groff yet.
.
.
.\" --------------------------------------------------------------------
.SH "ESCAPE SEQUENCES"
.\" --------------------------------------------------------------------
.
Escape sequences are in-line language elements usually introduced by a
backslash
.squoted_char \[rs]
and followed by an escape name and sometimes by a required argument.
.
Input processing is continued directly after the escaped character or
the argument (without an intervening separation character).
.
So there must be a way to determine the end of the escape name and the
end of the argument.
.
.
.P
This is done by enclosing names (escape name and arguments consisting
of a variable name) by a pair of brackets
.BI \[lB] name \[rB] 
and constant arguments (number expressions and characters) by
apostrophes (ASCII 0x27) like
.BI \[cq] constant \[cq] \f[R].
.
.
.P
There are abbreviations for short names.
.
Two-character escape names can be specified by an opening parenthesis
like
.esc ( xy
or
.esc *( xy
without a closing counterpart.
.
And all one-character names different from the special characters
.squoted_char [
and
.squoted_char (
can even be specified without a marker, for example
.esc n c
or
.esc $ c.
.
.
.P
Constant arguments of length\~1 can omit the marker apostrophes, too,
but there is no two-character analogue.
.
.
.P
While one-character escape sequences are mainly used for in-line
functions and system related tasks, the two-letter names following the
.esc (
construct are glyphs predefined by the roff system; these are called
\[oq]Special Characters\[cq] in the classical documentation.
.
Escapes sequences of the form
.esc[] "" name
denote glyphs too.
.
.
.\" --------------------------------------------------------------------
.SS "Single-Character Escapes"
.\" --------------------------------------------------------------------
.
.PD 0
.
.\" --------- comments ---------
.
.TP
.ESC \[dq]
Start of a comment.
.
Everything up to the end of the line is ignored.
.
.TP
.ESC #
Everything up to and including the next newline is ignored.
.
This is interpreted in copy mode.
.
This is like
.esc \[dq]
except that the terminating newline is ignored as well.
.
.\" --------- strings ---------
.
.TP
.ESC * s
The string stored in the string variable with one-character name\~\c
.IR s .
.
.TP
.ESC *( st
The string stored in the string variable with two-character name
.IR st .
.
.TP
.ESC[] * string
The string stored in the string variable with name
.I string
(with arbitrary length).
.
.TP
.ESC[] * "stringvar arg1 arg2 .\|.\|."
The string stored in the string variable with arbitrarily long name
.IR stringvar ,
taking
.IR arg1 ,
.IR arg2 ,
.I .\|.\|.\&
as arguments.
.
.\" --------- macro arguments ---------
.
.TP
.ESC $0
The name by which the current macro was invoked.
.
The
.request als
request can make a macro have more than one name.
.
.TP
.ESC $ x
Macro or string argument with one-digit number\~\c
.I x
in the range 1 to\~9.
.
.TP
.ESC $( xy
Macro or string argument with two-digit number
.I xy
(larger than zero).
.
.TP
.ESC[] $ nexp
Macro or string argument with number
.IR nexp ,
where
.I nexp
is a numerical expression evaluating to an integer \[>=]1.
.
.TP
.ESC $*
In a macro or string, the concatenation of all the arguments separated
by spaces.
.
.TP
.ESC $@
In a macro or string, the concatenation of all the arguments with each
surrounded by double quotes, and separated by spaces.
.
.TP
.ESC $^
In a macro, the representation of all parameters as if they were an
argument to the
.request ds
request.
.
.\" --------- escaped characters ---------
.
.TP
.ESC \e
reduces to a single backslash; useful to delay its interpretation as
escape character in copy mode.
.
For a printable backslash, use
.esc e ,
or even better
.esc [rs] ,
to be independent from the current escape character.
.
.TP
.ESC \[aa]
The acute accent \[aa]; same as
.esc (aa .
Unescaped: apostrophe, right quotation mark, single quote (ASCII 0x27).
.
.TP
.ESC \[ga]
The grave accent \[ga]; same as
.esc (ga .
Unescaped: left quote, backquote (ASCII 0x60).
.
.TP
.ESC -
The \- (minus) sign in the current font.
.
.TP
.ESC _
The same as
.esc (ul ,
the underline character.
.
.TP
.ESC .
The same as a dot (\[oq].\[cq]).  Necessary in nested macro
definitions so that \[oq]\[rs]\[rs]..\[cq] expands to \[oq]..\[cq].
.
.TP
.ESC %
Default optional hyphenation character.
.
.TP
.ESC !
Transparent line indicator.
.
.TP
.ESC? anything
In a diversion, this transparently embeds
.I anything
in the diversion.
.I anything
is read in copy mode.
.
See also the escape sequences
.esc !
and
.esc ? .
.
.
.\" --------- spacing ---------
.
.TP
.ESC \& space
Unpaddable space size space glyph (no line break).
.
.TP
.ESC 0
Digit-width space.
.
.TP
.ESC |
1/6\ em narrow space glyph; zero width in nroff.
.
.TP
.ESC ^
1/12\ em half-narrow space glyph; zero width in nroff.
.
.TP
.ESC &
Non-printable, zero-width glyph.
.
.TP
.ESC )
Like
.esc &
except that it behaves like a glyph declared with the
.request cflags
request to be transparent for the purposes of end-of-sentence
recognition.
.
.TP
.ESC /
Increases the width of the preceding glyph so that the spacing
between that glyph and the following glyph is correct if
the following glyph is a roman glyph.
.
.TP
.ESC ,
Modifies the spacing of the following glyph so that the spacing
between that glyph and the preceding glyph is correct if the
preceding glyph is a roman glyph.
.
.TP
.ESC ~
Unbreakable space that stretches like a normal inter-word space when a
line is adjusted.
.
.TP
.ESC :
Inserts a zero-width break point (similar to
.esc %
but without a soft hyphen character).
.
.TP
.ESC "" newline
Ignored newline, for continuation lines.
.
.\" --------- structuring ---------
.
.TP
.ESC {
Begin conditional input.
.
.TP
.ESC }
End conditional input.
.
.\" --------- longer escape names ---------
.
.TP
.ESC ( sc
A glyph with two-character name
.IR sc ;
see section
.BR "Special Characters" .
.
.TP
.ESC[] "" name
A glyph with name
.I name
(of arbitrary length).
.
.TP
.ESC[] "" "comp1 comp2 .\|.\|."
A composite glyph with components
.IR comp1 ,
.IR comp2 ,
.I .\|.\|.
.
.\" --------- alphabetical escapes ---------
.
.TP
.ESC a
Non-interpreted leader character.
.
.TP
.ESCq A anything
If
.I anything
is acceptable as a name of a string, macro, diversion, register,
environment or font it expands to\~1, and to\~0 otherwise.
.
.TP
.ESCq b abc.\|.\|.\&
Bracket building function.
.
.TP
.ESCq B anything
If
.I anything
is acceptable as a valid numeric expression it expands to\~1, and
to\~0 otherwise.
.
.TP
.ESC c
Interrupt text processing.
.
.TP
.ESCq C glyph
The glyph called
.IR glyph ;
same as
.esc[] "" glyph ,
but compatible to other roff versions.
.
.TP
.ESC d
Forward (down) 1/2 em (1/2 line in nroff).
.
.TP
.ESCq D charseq
Draw a graphical element defined by the characters in
.IR charseq ;
see the groff info file for details.
.
.TP
.ESC e
Printable version of the current escape character.
.
.TP
.ESC E
Equivalent to an escape character, but is not interpreted in copy mode.
.
.TP
.ESC f F
Change to font with one-character name or one-digit number\~\c
.IR F .
.
.TP
.ESC fP
Switch back to previous font.
.
.TP
.ESC f( fo
Change to font with two-character name or two-digit number
.IR fo .
.
.TP
.ESC[] f font
Change to font with arbitrarily long name or number expression
.IR font .
.
.TP
.ESC[] f ""
Switch back to previous font.
.
.TP
.ESC F f
Change to font family with one-character name\~\c
.IR f .
.
.TP
.ESC F( fm
Change to font family with two-character name
.IR fm .
.
.TP
.ESC[] F fam
Change to font family with arbitrarily long name
.IR fam .
.
.TP
.ESC[] F ""
Switch back to previous font family.
.
.TP
.ESC g r
Return format of register with one-character name\~\c
.I r
suitable for
.request af
request.
.
.TP
.ESC g( rg
Return format of register with two-character name
.I rg
suitable for
.request af
request.
.
.TP
.ESC[] g reg
Return format of register with arbitrarily long name
.I reg
suitable for
.request af
request.
.
.TP
.ESCq h N
Local horizontal motion; move right
.I N
(left if negative).
.
.TP
.ESCq H N
Set height of current font to
.IR N .
.
.TP
.ESC k r
Mark horizontal input place in one-character register\~\c
.IR r .
.
.TP
.ESC k( rg
Mark horizontal input place in two-character register
.IR rg .
.
.TP
.ESC[] k reg
Mark horizontal input place in register with arbitrarily long name
.IR reg .
.
.TP
.ESCq l Nc
Horizontal line drawing function (optionally using character
.IR c ).
.
.TP
.ESCq L Nc
Vertical line drawing function (optionally using character
.IR c ).
.
.TP
.ESC m c
Change to color with one-character name\~\c
.IR c .
.
.TP
.ESC m( cl
Change to color with two-character name
.IR cl .
.
.TP
.ESC[] m color
Change to color with arbitrarily long name
.IR color .
.
.TP
.ESC[] m ""
Switch back to previous color.
.
.TP
.ESC M c
Change filling color for closed drawn objects to color with
one-character name\~\c
.IR c .
.
.TP
.ESC M( cl
Change filling color for closed drawn objects to color with
two-character name
.IR cl .
.
.TP
.ESC[] M color
Change filling color for closed drawn objects to color with
arbitrarily long name
.IR color .
.
.TP
.ESC[] M ""
Switch to previous fill color.
.
.TP
.ESC n r
The numerical value stored in the register variable with the
one-character name\~\c
.IR r .
.
.TP
.ESC n( re
The numerical value stored in the register variable with the
two-character name
.IR re .
.
.TP
.ESC[] n reg
The numerical value stored in the register variable with arbitrarily
long name
.IR reg .
.
.TP
.ESCq N n
Typeset the glyph with index\~\c
.I n
in the current font.
.
No special fonts are searched.
.
Useful for adding (named) entities to a document using the
.request char
request and friends.
.
.TP
.ESCq o abc.\|.\|.\&
Overstrike glyphs
.IR a ,
.IR b ,
.IR c ,
etc.
.
.TP
.ESC O0
Disable glyph output.
.
Mainly for internal use.
.
.TP
.ESC O1
Enable glyph output.
.
Mainly for internal use.
.
.TP
.ESC p
Break and spread output line.
.
.TP
.ESC r
Reverse 1\ em vertical motion (reverse line in nroff).
.
.TP
.ESCq R "name\~\[+-]n"
The same as
.request .nr
.I name
.IR \[+-]n .
.
.TP
.ESC s \[+-]N
Set/increase/decrease the point size to/by
.I N
scaled points;
.I N
is a one-digit number in the range 1 to\~9.
.
Same as
.request ps
request.
.
.TP
.ESC s( \[+-]N
.TQ
.ESC s\[+-]( N
Set/increase/decrease the point size to/by
.I N
scaled points;
.I N
is a two-digit number \[>=]1.
.
Same as
.request ps
request.
.
.TP
.ESC[] s \[+-]N
.TQ
.ESC[] s\[+-] N
.TQ
.ESCq s \[+-]N
.TQ
.ESCq s\[+-] N
Set/increase/decrease the point size to/by
.I N
scaled points.
.
Same as
.request ps
request.
.
.TP
.ESCq S N
Slant output by
.I N
degrees.
.
.TP
.ESC t
Non-interpreted horizontal tab.
.
.TP
.ESC u
Reverse (up) 1/2 em vertical motion (1/2 line in nroff).
.
.TP
.ESCq v N
Local vertical motion; move down
.I N
(up if negative).
.
.TP
.ESC V e
The contents of the environment variable with one-character
name\~\c
.IR e .
.
.TP
.ESC V( ev
The contents of the environment variable with two-character name
.IR ev .
.
.TP
.ESC[] V env
The contents of the environment variable with arbitrarily long name
.IR env .
.
.TP
.ESCq w string
The width of the glyph sequence
.IR string .
.
.TP
.ESCq x N
Extra line-space function (negative before, positive after).
.
.TP
.ESCq X string
Output
.I string
as device control function.
.
.TP
.ESC Y n
Output string variable or macro with one-character name\~\c
.I n
uninterpreted as device control function.
.
.TP
.ESC Y( nm
Output string variable or macro with two-character name
.I nm
uninterpreted as device control function.
.
.TP
.ESC[] Y name
Output string variable or macro with arbitrarily long name
.I name
uninterpreted as device control function.
.
.TP
.ESC z c
Print
.I c
with zero width (without spacing).
.
.TP
.ESCq Z anything
Print
.I anything
and then restore the horizontal and vertical position;
.I anything
may not contain tabs or leaders.
.
.
.PD
.P
The escape sequences
.esc e ,
.esc . ,
.esc \[dq] ,
.esc $ ,
.esc * ,
.esc a ,
.esc n ,
.esc t ,
.esc g ,
and
.escarg \& newline
are interpreted in copy mode.
.
.
.P
Escape sequences starting with
.esc (
or
.esc [
do not represent single character escape sequences, but introduce escape
names with two or more characters.
.
.
.P
If a backslash is followed by a character that does not constitute a
defined escape sequence, the backslash is silently ignored and the
character maps to itself.
.
.
.\" --------------------------------------------------------------------
.SS "Special Characters"
.\" --------------------------------------------------------------------
.
[Note: \[oq]Special Characters\[cq] is a misnomer; those entities are
(output) glyphs, not (input) characters.]
.
.
.P
Common special characters are predefined by escape sequences of the
form
.BI \e( xy
with characters
.I x
and
.IR y .
.
In
.IR groff ,
it is also possible to use the writing
.BI \e[ xy ]
as well.
.
.
.P
Some of these special characters exist in the usual font while most of
them are only available in the special font.
.
Below you can see a small selection of the most important glyphs; a
complete list can be found in
.BR groff_char (7).
.RS
.P
.PD 0
.
.TP
.ESC (Do
Dollar
.B \(Do
.
.TP
.ESC (Eu
Euro
.B \(Eu
.
.TP
.ESC (Po
British pound sterling
.B \(Po
.
.TP
.ESC (aq
Apostrophe quote
.B \(aq
.
.TP
.ESC (bu
Bullet sign
.B \(bu
.
.TP
.ESC (co
Copyright
.B \(co
.
.TP
.ESC (cq
Single closing quote (right)
.B \(cq
.TP
.ESC (ct
Cent
.B \(ct
.
.TP
.ESC (dd
Double dagger
.B  \(dd
.
.TP
.ESC (de
Degree
.B \(de
.
.TP
.ESC (dg
Dagger
.B \(dg
.
.TP
.ESC (dq
Double quote (ASCII 34)
.B \(dq
.
.TP
.ESC (em
Em-dash
.B \(em
.
.TP
.ESC (en
En-dash
.B \(en
.
.TP
.ESC (hy
Hyphen
.B \(hy
.
.TP
.ESC (lq
Double quote left
.B \(lq
.
.TP
.ESC (oq
Single opening quote (left)
.B \(oq
.
.TP
.ESC (rg
Registered sign
.B \(rg
.
.TP
.ESC (rq
Double quote right
.B \(rq
.
.TP
.ESC (rs
Printable backslash character
.B \(rs
.
.TP
.ESC (sc
Section sign
.B \(sc
.
.TP
.ESC (tm
Trademark symbol
.B  \(tm
.
.TP
.ESC (ul
Underline character
.B  \(ul
.
.TP
.ESC (==
Identical
.B \(==
.
.TP
.ESC (>=
Larger or equal
.B \(>=
.
.TP
.ESC (<=
Less or equal
.B \(<=
.
.TP
.ESC (!=
Not equal
.B \(!=
.
.TP
.ESC (->
Right arrow
.B \(->
.
.TP
.ESC (<-
Left arrow
.B \(<-
.
.TP
.ESC (+-
Plus-minus sign
.B \(+-
.
.PD
.RE
.
.
.\" --------------------------------------------------------------------
.SS "Unicode Characters"
.\" --------------------------------------------------------------------
.
There is the extended escape
.B u
that allows to include all available Unicode characters into some
.I roff
file.
.
.
.TP
.BI \e[u xxxx ]
.B u
is the escape name.
.
.I xxxx
is a hexadecimal number of 4 hex digits, such as
.B 0041
for the letter
.BR A ,
see
.BR \e[u0041] .
. 
.
.TP
.BI \e[u yyyyy ]
.B u
is the escape name.
.
.I yyyyy
is a hexadecimal number of 5 hex digits, such as
.B 2FA1A
for a Chinese looking character for
.IR "CJK Compatibility Ideographs Supplement" ,
see
.BR \e[u2FA1A] .
.
.
.P
Both hexadecimal collections mean the corresponding Unicode code for a
character.
.
.
.TP
.BI \e[u hex1 _ hex2 ]
.TQ
.BI \e[u hex1 _ hex2 _ hex3 ]
.IR hex1 ,
.IR hex2 ,
and
.I hex3
are all Unicode hexadecimal codes (4 or 5 hex digits) that are used
for overstriking, e.g.
.B \e[u0041_0301]
is
.I "A acute"
.BR \['A] .
.
.
.P
The availability of the Unicode characters depends on the used font.
.
For text mode, the device
.B -Tutf8
is quite complete, for
.I troff
modes it might happen that some or many characters will not be
displayed.
.
Please check your fonts.
.
.
.\" --------------------------------------------------------------------
.SS "Strings"
.\" --------------------------------------------------------------------
.
Strings are defined by the
.request ds
request and can be retrieved by the
.esc *
escape sequence.
.
.
.P
Strings share their name space with macros.
.
So strings and macros without arguments are roughly equivalent; it is
possible to call a string like a macro and vice-versa, but this often
leads to unpredictable results.
.
The following string is the only one predefined in groff.
.
.TPx
.STRING .T
The name of the current output device as specified by the
.option \-T
command line option.
.
.
.\" --------------------------------------------------------------------
.SH REGISTERS
.\" --------------------------------------------------------------------
.
Registers are variables that store a value.
In groff, most registers store numerical values (see section
.B NUMERICAL EXPRESSIONS
above), but some can also hold a string value.
.
.
.P
Each register is given a name.
Arbitrary registers can be defined and set with the
.request nr
request.
.
.
.P
The value stored in a register can be retrieved by the escape sequences
introduced by
.esc n .
.
.
.P
Most useful are predefined registers.
.
In the following the notation
.I name
is used to refer to
.register name
to make clear that we speak about registers.
.
Please keep in mind that the
.esc[] n ""
decoration is not part of the register name.
.
.
.\" --------------------------------------------------------------------
.SS "Read-only Registers"
.\" --------------------------------------------------------------------
.
The following registers have predefined values that should not be
modified by the user (usually, registers starting with a dot are
read-only).
.
Mostly, they provide information on the current settings or store
results from request calls.
.
.
.P
.PD 0
.
.TPx
.REG $$
The process ID of
.BR troff .
.
.TPx
.REG .$
Number of arguments in the current macro or string.
.
.TPx
.REG .a
Post-line extra line-space most recently utilized using
.esc x .
.
.TPx
.REG .A
Set to\~1 in
.B troff
if option
.option \-A
is used; always\~1 in
.BR nroff .
.
.TPx
.REG .b
The emboldening offset while
.request .bd
is active.
.
.TPx
.REG .br
Within a macro, set to\~1 if macro called with the \[oq]normal\[cq]
control character, and to\~0 otherwise.
.
.TPx
.REG .c
Current input line number.
.
.TPx
.REG .C
1\~if compatibility mode is in effect, 0\~otherwise.
.
.TPx
.REG .cdp
The depth of the last glyph added to the current environment.
.
It is positive if the glyph extends below the baseline.
.
.TPx
.REG .ce
The number of lines remaining to be centered, as set by the
.request ce
request.
.
.TPx
.REG .cht
The height of the last glyph added to the current environment.
.
It is positive if the glyph extends above the baseline.
.
.TPx
.REG .color
1\~if colors are enabled, 0\~otherwise.
.
.TPx
.REG .csk
The skew of the last glyph added to the current environment.
.
The skew of a glyph is how far to the right of the center of a glyph
the center of an accent over that glyph should be placed.
.
.TPx
.REG .d
Current vertical place in current diversion; equal to
.register nl .
.
.TPx
.REG .ev
The name or number of the current environment (string-valued).
.
.TPx
.REG .f
Current font number.
.
.TPx
.REG .F
The name of the current input file (string-valued).
.
.TPx
.REG .fam
The current font family (string-valued).
.
.TPx
.REG .fn
The current (internal) real font name (string-valued).
.
.TPx
.REG .fp
The number of the next free font position.
.
.TPx
.REG .g
Always 1 in GNU troff.
.
Macros should use it to test if running under groff.
.
.TPx
.REG .h
Text base-line high-water mark on current page or diversion.
.
.TPx
.REG .H
Available horizontal resolution in basic units.
.
.TPx
.REG .height
The current font height as set with
.request \[rs]H .
.
.TPx
.REG .hla
The current hyphenation language as set by the
.request hla
request.
.
.TPx
.REG .hlc
The number of immediately preceding consecutive hyphenated lines.
.
.TPx
.REG .hlm
The maximum allowed number of consecutive hyphenated lines, as set by
the
.request hlm
request.
.
.TPx
.REG .hy
The current hyphenation flags (as set by the
.request hy
request).
.
.TPx
.REG .hym
The current hyphenation margin (as set by the
.request hym
request).
.
.TPx
.REG .hys
The current hyphenation space (as set by the
.request hys
request).
.
.TPx
.REG .i
Current indentation.
.
.TPx
.REG .in
The indentation that applies to the current output line.
.
.TPx
.REG .int
Positive if last output line contains
.esc c .
.
.TPx
.REG .j
The current adjustment mode.
It can be stored and used to set adjustment.
(n\ =\ 1, b\ =\ 1, l\ =\ 0, r\ =\ 5, c\ =\ 3).
.
.TPx
.REG .k
The current horizontal output position (relative to the current indentation).
.TPx
.REG .kern
1\~if pairwise kerning is enabled, 0\~otherwise.
.
.TPx
.REG .l
Current line length.
.
.TPx
.REG .L
The current line spacing setting as set by
.request .ls .
.
.TPx
.REG .lg
The current ligature mode (as set by the
.request lg
request).
.
.TPx
.REG .linetabs
The current line-tabs mode (as set by the
.request linetabs
request).
.
.TPx
.REG .ll
The line length that applies to the current output line.
.
.TPx
.REG .lt
The title length (as set by the
.request lt
request).
.
.TPx
.REG .m
The current drawing color (string-valued).
.
.TPx
.REG .M
The current background color (string-valued).
.
.TPx
.REG .n
Length of text portion on previous output line.
.
.TPx
.REG .ne
The amount of space that was needed in the last
.request ne
request that caused a trap to be sprung.
.
Useful in conjunction with
.register .trunc .
.
.TPx
.REG .ns
1\~if in no-space mode, 0\~otherwise.
.
.TPx
.REG .o
Current page offset.
.
.TPx
.REG .O
The suppression nesting level (see
.esc O ).
.
.TPx
.REG .p
Current page length.
.
.TPx
.REG .P
1\~if the current page is being printed, 0\~otherwise (as determined by the
.option \-o
command line option).
.
.TPx
.REG .pe
1\~during page ejection, 0\~otherwise.
.
.TPx
.REG .pn
The number of the next page: either the value set by a
.request pn
request, or the number of the current page plus\ 1.
.
.TPx
.REG .ps
The current point size in scaled points.
.
.TPx
.REG .psr
The last-requested point size in scaled points.
.
.TPx
.REG .pvs
The current post-vertical line spacing.
.
.TPx
.REG .R
The number of unused number registers.
Always 10000 in GNU troff.
.
.TPx
.REG .rj
The number of lines to be right-justified as set by the
.request rj
request.
.
.TPx
.REG .s
Current point size as a decimal fraction.
.
.TPx
.REG .slant
The slant of the current font as set with
.request \eS .
.
.TPx
.REG .sr
The last requested point size in points as a decimal fraction
(string-valued).
.
.TPx
.REG .ss
The value of the parameters set by the first argument of the
.request ss
request.
.
.TPx
.REG .sss
The value of the parameters set by the second argument of the
.request ss
request.
.
.TPx
.REG .sty
The current font style (string-valued).
.
.TPx
.REG .t
Vertical distance to the next trap.
.
.TPx
.REG .T
Set to\~1
if option
.option \-T
is used.
.
.TPx
.REG .tabs
A string representation of the current tab settings suitable for use
as an argument to the
.request ta
request.
.
.TPx
.REG .trunc
The amount of vertical space truncated by the most recently sprung
vertical position trap, or, if the trap was sprung by a
.request ne
request, minus the amount of vertical motion produced by
.request .ne .
.
Useful in conjunction with the
.register .ne .
.
.TPx
.REG .u
Equal to 1 in fill mode and 0 in no-fill mode.
.
.TPx
.REG .U
Equal to 1 in safer mode and 0 in unsafe mode.
.
.TPx
.REG .v
Current vertical line spacing.
.
.TPx
.REG .V
Available vertical resolution in basic units.
.
.TPx
.REG .vpt
1\~if vertical position traps are enabled, 0\~otherwise.
.
.TPx
.REG .w
Width of previous glyph.
.
.TPx
.REG .warn
The sum of the number codes of the currently enabled warnings.
.
.TPx
.REG .x
The major version number.
.
.TPx
.REG .y
The minor version number.
.
.TPx
.REG .Y
The revision number of groff.
.
.TPx
.REG .z
Name of current diversion.
.
.TPx
.REG .zoom
Zoom factor for current font (in multiples of 1/1000th; zero if no
magnification).
.PD
.
.
.\" --------------------------------------------------------------------
.SS "Writable Registers"
.\" --------------------------------------------------------------------
.
The following registers can be read and written by the user.
They have predefined default values, but these can be modified for
customizing a document.
.
.
.P
.PD 0
.TPx
.REG %
Current page number.
.
.TPx
.REG c.
Current input line number.
.
.TPx
.REG ct
Character type (set by width function
.esc w ).
.
.TPx
.REG dl
Maximal width of last completed diversion.
.
.TPx
.REG dn
Height of last completed diversion.
.
.TPx
.REG dw
Current day of week (1\(en7).
.
.TPx
.REG dy
Current day of month (1\(en31).
.
.TPx
.REG hours
The number of hours past midnight.
.
Initialized at start-up.
.
.TPx
.REG hp
Current horizontal position at input line.
.
.TPx
.REG llx
Lower left x-coordinate (in PostScript units) of a given PostScript
image (set by
.request .psbb ).
.
.TPx
.REG lly
Lower left y-coordinate (in PostScript units) of a given PostScript
image (set by
.request .psbb ).
.
.TPx
.REG ln
Output line number.
.
.TPx
.REG lsn
The number of leading spaces of an input line.
.
.TPx
.REG lss
The horizontal space corresponding to the leading spaces of an input
line.
.
.TPx
.REG minutes
The number of minutes after the hour.
.
Initialized at start-up.
.
.TPx
.REG mo
Current month (1\(en12).
.
.TPx
.REG nl
Vertical position of last printed text base-line.
.
.TPx
.REG opmaxx
.TPx
.REG opmaxy
.TPx
.REG opminx
.TPx
.REG opminy
These four registers mark the top left and bottom right hand corners of a box
which encompasses all written glyphs.
They are reset to \-1 by
.escarg O 0
or
.escarg O 1 .
.
.TPx
.REG rsb
Like
.register sb ,
but takes account of the heights and depths of glyphs.
.
.TPx
.REG rst
Like
.register st ,
but takes account of the heights and depths of glyphs.
.
.TPx
.REG sb
Depth of string below base line (generated by width function
.esc w ).
.
.TPx
.REG seconds
The number of seconds after the minute.
.
Initialized at start-up.
.
.TPx
.REG skw
Right skip width from the center of the last glyph in the
.esc w
argument.
.
.TPx
.REG slimit
If greater than 0, the maximum number of objects on the input stack.
.
If \[<=]0 there is no limit, i.e., recursion can continue until virtual
memory is exhausted.
.
.TPx
.REG ssc
The amount of horizontal space (possibly negative) that should be
added to the last glyph before a subscript (generated by width
function
.esc w ).
.
.TPx
.REG st
Height of string above base line (generated by width function
.esc w ).
.
.TPx
.REG systat
The return value of the
.I system()
function executed by the last
.request sy
request.
.
.TPx
.REG urx
Upper right x-coordinate (in PostScript units) of a given PostScript
image (set by
.request .psbb ).
.
.TPx
.REG ury
Upper right y-coordinate (in PostScript units) of a given PostScript
image (set by
.request .psbb ).
.
.TPx
.REG year
The current year (year 2000 compliant).
.
.TPx
.REG yr
Current year minus 1900.
.
For Y2K compliance use
.register year
instead.
.
.PD
.
.
.\" --------------------------------------------------------------------
.SH UNDERLINING
.\" --------------------------------------------------------------------
.
In the
.I RUNOFF
language, the underlining was quite easy.
.
But in
.I roff
this is much more difficult.
.
.
.\" --------------------------------------------------------------------
.SS Underlining with .ul
.\" --------------------------------------------------------------------
.
There exists a
.I groff
request
.B .ul
(see above) that can underline the next or further source lines in
.BR nroff ,
but in
.B troff
it produces only a font change into
.IR italic .
.
So this request is not really useful.
.
.
.\" --------------------------------------------------------------------
.SS Underlining with .UL from ms
.\" --------------------------------------------------------------------
.
In the \[oq]ms\[cq] macro package in tmac/s.tmac
.BR groff_ms (7),
there is the macro
.BR .UL .
.
But this works only in
.BR troff ,
not in
.BR nroff .
.
.
.\" --------------------------------------------------------------------
.SS Underlining macro definitions
.\" --------------------------------------------------------------------
.
So one can use the
.I italic
.B nroff
idea from
.B .ul
and the
.B troff
definition
in
.I ms
for writing a useful new macro, something like
.
.RS
.EX
\&.de UNDERLINE
\&. ie n \[rs]\[rs]$1\[rs]f[I]\[rs]\[rs]$2\[rs]f[P]\[rs]\[rs]$3
\&. el \[rs]\[rs]$1\[rs]Z\[aq]\[rs]\[rs]$2\[aq]\[rs]v\[aq].25m\[aq]\
\[rs]D\[aq]l \[rs]w\[aq]\[rs]\[rs]$2\[aq]u 0\[aq]\[rs]v\[aq]-.25m\
\[aq]\\[rs]\[rs]$3
\&..
.EE
.RE
.
If
.B doclifter (1)
makes trouble, change the macro name
.B UNDERLINE
into some 2-letter word, like
.BR Ul .
.
Moreover change the font writing from
.B \[rs]f[P]
to
.BR \[rs]fP .
.
.
.\" --------------------------------------------------------------------
.SS Underlining without macro definitions
.\" --------------------------------------------------------------------
.
If one does not want to use macro definitions, e.g. when
.B doclifter
gets lost, use the following:
.
.RS
.EX
\&.ds u1 before
\&.ds u2 in
\&.ds u3 after
\&.ie n \[rs]*[u1]\[rs]f[I]\[rs]*[u2]\[rs]f[P]\[rs]*[u3]
\&.el \[rs]*[u1]\[rs]Z\[aq]\[rs]*[u2]\[aq]\[rs]v\[aq].25m\[aq]\[rs]D\
\[aq]l \[rs]w\[aq]\[rs]*[u2]\[aq]u 0\[aq]\[rs]v\[aq]-.25m\[aq]\[rs]*[u3]
.EE
.RE
.
Due to
.BR doclifter ,
it might be necessary to change the variable writing
.B \e[xy]
and
.B \e*[xy]
into the strange ancient writing
.B \e*(xy
and
.BR \e(xy ,
and so on.
.
.
.P
Then these lines could look like
.RS
.EX
\&.ds u1 before
\&.ds u2 in
\&.ds u3 after
\&.ie n \[rs]*[u1]\[rs]fI\[rs]*(u2\[rs]fP\[rs]*(u3
\&.el \[rs]*(u1\[rs]Z\[aq]\[rs]*(u2\[aq]\[rs]v\[aq].25m'\[rs]D\[aq]l \
\[rs]w\[aq]\[rs]*(u2\[aq]u 0\[aq]\[rs]v\[aq]-.25m\[aq]\[rs]*(u3
.EE
.RE
.
.
.P
The result looks like
.RS
.ft CR
before
\z\[ul]i\
\z\[ul]n
after
.ft R
.RE
.
.
.\" --------------------------------------------------------------------
.SS Underlining with Overstriking \ez and \e(ul
.\" --------------------------------------------------------------------
.
There is another possibility for underlining by using overstriking
with
.BI \ez c
(print
.I c
with zero width without spacing) and
.B \e(ul
(underline character).
.
This produces the underlining of 1 character, both in
.B nroff
and in
.BR troff .
.
.
.P
For example the underlining of a character say
.B t
looks like
.B \ez\e[ul]t
or
.B \ez\e(ult
.
.
.P
Longer words look then a bit strange, but a useful mode is to write
each character into a whole own line.
.
To underlines the 3 character part "tar" of the word "start":
.
.RS
.EX
.br
before s\[rs]
\[rs]z\[rs][ul]t\[rs]
\[rs]z\[rs][ul]a\[rs]
\[rs]z\[rs][ul]r\[rs]
t after
.EE
.RE
.
or
.
.RS
.EX
.br
before s\[rs]
\[rs]z\[rs](ult\[rs]
\[rs]z\[rs](ula\[rs]
\[rs]z\[rs](ulr\[rs]
t after
.EE
.RE
.
.
.P
The result looks like
.RS
.ft CR
before s\
\z\[ul]t\
\z\[ul]a\
\z\[ul]r\
t after
.ft R
.RE
.
.\" --------------------------------------------------------------------
.SH COMPATIBILITY
.\" --------------------------------------------------------------------
.
The differences of the groff language in comparison to classical troff
as defined by
.I [CSTR\~#54]
are documented in
.BR groff_diff (7).
.
.
.P
The groff system provides a compatibility mode, see
.BR groff (1)
on how to invoke this.
.
.
.\" --------------------------------------------------------------------
.SH BUGS
.\" --------------------------------------------------------------------
.
Report bugs to the
.MT bug-groff@gnu.org
groff bug mailing list
.ME .
Include a complete, self-contained example that will allow the bug to
be reproduced, and say which version of groff you are using.
.
.
.\" --------------------------------------------------------------------
.SH "SEE ALSO"
.\" --------------------------------------------------------------------
.
The main source of information for the groff language is the
.B groff
.BR info (1)
file.
.
Besides the gory details, it contains many examples.
.
.TP
.BR groff (1)
the usage of the groff program and pointers to the documentation and
availability of the groff system.
.
.TP
.BR groff_diff (7)
the differences of the groff language as compared to classical roff.
.
This is the authoritative document for the predefined language
elements that are specific to groff.
.
.TP
.BR groff_char (7)
the predefined groff special characters (glyphs).
.
.TP
.BR groff_font (5)
the specification of fonts and the DESC file.
.
.TP
.BR roff (7)
the history of roff, the common parts shared by all roff systems, and
pointers to further documentation.
.
.TP
.I [CSTR\~#54]
.UR http://\:cm.bell-labs.com/\:cm/\:cs/\:cstr/\:54.ps.gz
Nroff/\:Troff User\[aq]s Manual by Ossanna & Kernighan
.UE
\[em] the bible for classical troff.
.
.
.\" --------------------------------------------------------------------
.SH COPYING
.\" --------------------------------------------------------------------
.co
.\" --------------------------------------------------------------------
.SH AUTHORS
.\" --------------------------------------------------------------------
.au
.
.cp \n[groff_C]
.
.
.\" --------------------------------------------------------------------
.\" Emacs Setup
.\" --------------------------------------------------------------------
.
.\" Local Variables:
.\" mode: nroff
.\" End:
