.TH PIC2GRAPH 1 "4 November 2014" "Groff Version 1.22.3"
.SH NAME
pic2graph \- convert a PIC diagram into a cropped image
.
.
.\" --------------------------------------------------------------------
.\" Legalese
.\" --------------------------------------------------------------------
.
.de co
This documentation is released to the public domain.
..
.
.de au
.ME esr@thyrsus.com
Eric S.\& Raymond
.UE ,
based on a recipe by W.\& Richard Stevens.
..
.
.\" --------------------------------------------------------------------
.SH SYNOPSIS
.\" --------------------------------------------------------------------
.
.B pic2graph
[
.B \-unsafe
]
[
.BI "\-format " fmt
]
[
.BI "\-eqn " delim
]
.
.
.\" --------------------------------------------------------------------
.SH DESCRIPTION
.\" --------------------------------------------------------------------
.
Reads a PIC program as input; produces an image file (by default in
Portable Network Graphics format) suitable for the Web as output.
.
Also translates
.BR eqn (1)
constructs, so it can be used for generating images of mathematical
formulae.
.
.
.P
PIC is a rather expressive graphics minilanguage suitable for
producing box-and-arrow diagrams of the kind frequently used in
technical papers and textbooks.
.
The language is sufficiently flexible to be quite useful for state
charts, Petri-net diagrams, flow charts, simple circuit schematics,
jumper layouts, and other kinds of illustration involving repetitive
uses of simple geometric forms and splines.
.
Because PIC descriptions are procedural and object-based, they are
both compact and easy to modify.
.
.
.P
The PIC language is fully documented in
.IR "Making Pictures With GNU PIC" ,
a document which is part of the
.BR groff (1)
distribution.
.
.
.P
Your input PIC code should
.I not
be wrapped with the \&.PS and \&.PE macros that normally guard it within
.BR groff (1)
macros.
.
.
.P
The output image will be clipped to the smallest possible bounding box
that contains all the black pixels.
.
Older versions of
.BR \%convert (1)
will produce a black-on-white graphic; newer ones may produce a
black-on-transparent graphic.
.
By specifying command-line options to be passed to
.BR \%convert (1)
you can give it a border, force the background transparent, set the
image\[aq]s pixel density, or perform other useful transformations.
.
.
.P
This program uses
.BR pic (1),
.BR eqn (1),
.BR groff (1),
.BR gs (1),
and the ImageMagick
.BR \%convert (1)
program.
These programs must be installed on your system and accessible on your
$PATH for
.B pic2graph
to work.
.
.
.\" --------------------------------------------------------------------
.SH OPTIONS
.\" --------------------------------------------------------------------
.
.TP
.B \-unsafe
Run
.BR pic (1)
and
.BR groff (1)
in the \[oq]unsafe\[cq] mode enabling the PIC macro
.B sh
to execute arbitrary commands.
.
The default is to forbid this.
.
.TP
.BI "\-format " fmt
Specify an output format; the default is PNG (Portable Network Graphics).
.
Any format that
.BR \%convert (1)
can emit is supported.
.
.TP
.BI "\-eqn " delim
Change the fencepost characters that delimit
.BR eqn (1)
directives
.RB ( $
and
.BR $ ,
by default).
.
This option requires an argument, but an empty string is accepted as a
directive to disable
.BR eqn (1)
processing.
.
.
.PP
Command-line switches and arguments not listed above are passed to
.BR \%convert (1).
.
.
.\" --------------------------------------------------------------------
.SH FILES
.\" --------------------------------------------------------------------
.
.TP \w'\fBd:/usr/share/groff/1.22.3/tmac/eqnrc'u+2n
.B d:/usr/share/groff/1.22.3/tmac/eqnrc
The
.BR eqn (1)
initialization file.
.
.
.\" --------------------------------------------------------------------
.SH ENVIRONMENT
.\" --------------------------------------------------------------------
.
.TP
.B GROFF_TMPDIR
The directory in which temporary files will be created.
.
If this is not set
.B pic2graph
searches the environment variables
.BR \%TMPDIR ,
.BR TMP ,
and
.B TEMP
(in that order).
.
Otherwise, temporary files will be created in
.BR /tmp .
.
.
.\" --------------------------------------------------------------------
.SH BUGS
.\" --------------------------------------------------------------------
.
Due to changes in the behavior of ImageMagick
.BR \%convert (1)
that are both forward and backward-incompatible,
mismatches between your
.B pic2graph
and
.BR \%convert (1)
versions may produce zero-sized or untrimmed output images.
.
For this version of
.B pic2graph
you will need a version of
.BR \%convert (1)
that supports the
.B \-trim
option; older versions of
.B pic2graph
used
.BR \-crop\~0x0 ,
which no longer has trimming behavior.
.
.
.\" --------------------------------------------------------------------
.SH "SEE ALSO"
.\" --------------------------------------------------------------------
.
.BR eqn2graph (1),
.BR grap2graph (1),
.BR pic (1),
.BR eqn (1),
.BR groff (1),
.BR gs (1),
.BR \%convert (1).
.
.
.\" --------------------------------------------------------------------
.SH COPYING
.\" --------------------------------------------------------------------
.co
.\" --------------------------------------------------------------------
.SH AUTHORS
.\" --------------------------------------------------------------------
.au
.
.
.\" Local Variables:
.\" mode: nroff
.\" End:
