.TH roff2x 1 "7 November 2014" "Groff Version 1.22.3"
.SH NAME
roff2x \- transform roff code into x mode
.
.\" roff2x.1 - man page for roff2x (section 1).
.
.\" Source file position: <groff_source_top>/contrib/groffer/roff2.man
.\" Installed position:   $prefix/share/man/man1/roff2x.1
.
.
.\" --------------------------------------------------------------------
.\" Legalese
.\" --------------------------------------------------------------------
.
.de co
Copyright \[co] 2006-2014 Free Software Foundation, Inc.

This file is part of groffer, which is part of GNU groff, a free
software project.

You can redistribute it and/or modify it under the terms of the GNU
General Public License version 2 (GPL2) as published by the Free
Software Foundation.

The license text is available in the internet at
.UR http://www.gnu.org/licenses/gpl-2.0.html
.UE .
..
.
.de au
This file was written by
.MT groff-bernd.warken-72@web.de
Bernd Warken
.ME .
..
.
.\" --------------------------------------------------------------------
.\" Characters
.\" --------------------------------------------------------------------
.
.\" Ellipsis ...
.ie t .ds EL \fS\N'188'\fP
.el .ds EL \&.\|.\|.\&\
.\" called with \*(EL
.
.
.\" --------------------------------------------------------------------
.SH "SYNOPSIS"
.\" --------------------------------------------------------------------
.
.SY roff2x
.OP \& "\%groffer_option \*(EL"
.OP \-\-
.OP \& "\%filespec \*(EL"
.YS
.
.SY roff2x
.BR \-h | \-\-help
.YS
.
.SY roff2x
.BR \-v | \-\-version
.YS
.
.P
The options
.B \-v
and
.B \%\-\-version
print the version information of the program to standard output and exit.
.
The options
.B \-h
and
.B \-\-help
print a usage information of the program to standard output and stop
the program instantly.
.
.
.P
All other options are assumed to be
.B \%groffer
options.
.
They are internally passed to
.BR \%groffer .
They override the behavior of the program.
.
The options are optional, they can be omitted.
.
.
.P
The
.I \%filespec
arguments correspond to the
.I \%filespec
arguments of
.BR \%groffer .
So they are either the names of existing, readable files or
.B \-
for standard input, or the name of a man page or a
.BR \%groffer (1)
man page search pattern.
.
If no
.I \%filespec
is specified standard input is assumed automatically.
.
.
.\" --------------------------------------------------------------------
.SH DESCRIPTION
.
.B \%roff2x
transforms
.I roff
code into
.ie 'x'x' \{\
.  I X
mode corresponding to the
.  I groff
devices
.  BR X *;
this mode is suitable for
.  BR \%gxditview (1).
.\}
.el \{\
.  I \%x
mode.
.\}
.
Print the result to standard output.
.
.
.P
There are more of these programs for generating other formats of
.I \%roff
input.
.
.if !'x'dvi' \{\
.  TP
.  BR \%roff2dvi (1)
is for
.  I dvi
mode.
.\}
.
.if !'x'html' \{\
.  TP
.  BR \%roff2html (1)
generates
.  I html
output.
.\}
.
.if !'x'pdf' \{\
.  TP
.  BR \%roff2pdf (1)
outputs
.  I pdf
mode.
.\}
.
.if !'x'ps' \{\
.  TP
.  BR \%roff2ps (1)
prints
.  I \%PostScript
format to standard output.
.\}
.
.if !'x'text' \{\
.  TP
.  BR \%roff2text (1)
generates text output in the
.  B groff
device
.  IR latin1 .
.\}
.
.if !'x'x' \{\
.  TP
.  BR \%roff2x (1)
prints the output in the
.  B groff
device
.  B X
that is suitable for programs like
.  BR \%gxditview (1)
or
.  BR \%xditview (1).
.\}
.
.
.\" --------------------------------------------------------------------
.SH "SEE ALSO"
.\" --------------------------------------------------------------------
.
.BR \%groff (1),
.BR \%groffer (1),
.if !'x'dvi' \
.  BR \%roff2dvi (1),
.if !'x'html' \
.  BR \%roff2html (1),
.if !'x'pdf' \
.  BR \%roff2pdf (1),
.if !'x'ps' \
.  BR \%roff2ps (1),
.if !'x'text' \
.  BR \%roff2text (1),
.if !'x'x' \
.  BR \%roff2x (1),
.BR \%gxditview (1).
.
.
.\" --------------------------------------------------------------------
.SH "COPYING"
.\" --------------------------------------------------------------------
.co
.\" --------------------------------------------------------------------
.SH "AUTHOR"
.\" --------------------------------------------------------------------
.au
.
.
.\" --------------------------------------------------------------------
.\" Emacs settings
.\" --------------------------------------------------------------------
.
.\" Local Variables:
.\" mode: nroff
.\" End:
