.TH GRAP2GRAPH 1 "4 November 2014" "Groff Version 1.22.3"
.SH NAME
grap2graph \- convert a grap diagram into a cropped bitmap image
.
.
.\" --------------------------------------------------------------------
.SH SYNOPSIS
.\" --------------------------------------------------------------------
.
.B grap2graph
[
.B \-unsafe
]
[
.BI \-resolution\  M\fR\^|\^\fPMxN
]
[
.BI \-format\  fmt
]
.
.
.\" --------------------------------------------------------------------
.SH DESCRIPTION
.\" --------------------------------------------------------------------
.
Reads a grap program as input; produces an image file (by default in
Portable Network Graphics format) suitable for the Web as output.
.
For a description of the grap language, see
.BR grap (1).
.
.
.P
Your graph specification should \fInot\fR be wrapped with the \&.G1 and
\&.G2 macros that normally guard it within
.BR groff (1)
macros.
.
.
.P
The output image will be a black-on-white graphic clipped to the
smallest possible bounding box that contains all the black pixels.
.
By specifying command-line options to be passed to
.BR convert (1)
you can give it a border, set the background transparent, set the
image's pixel density, or perform other useful transformations.
.
.
.P
This program uses
.BR grap (1),
.BR pic (1),
.BR groff (1),
and the ImageMagick
.BR convert (1)
program.
.
These programs must be installed on your system and accessible on your
$PATH for \fBgrap2graph\fR to work.
.
.
.\" --------------------------------------------------------------------
.SH OPTIONS
.\" --------------------------------------------------------------------
.
.TP
.B \-unsafe
Run
.BR pic (1)
and
.BR groff (1)
in the `unsafe' mode enabling the PIC macro
.B sh
to execute arbitrary commands.
.
The default is to forbid this.
.
.TP
.BI \-format\  fmt
Specify an output format; the default is PNG (Portable Network Graphics).
.
Any format that
.BR convert (1)
can emit is supported.
.
.
.PP
Command-line switches and arguments not listed above are passed to
.BR convert (1).
.
.
.\" --------------------------------------------------------------------
.SH ENVIRONMENT
.\" --------------------------------------------------------------------
.
.TP
.B GROFF_TMPDIR
The directory in which temporary files will be created.
.
If this is not set
.B grap2graph
searches the environment variables
.BR \%TMPDIR ,
.BR TMP ,
and
.B TEMP
(in that order).
.
Otherwise, temporary files will be created in
.BR /tmp .
.
.
.\" --------------------------------------------------------------------
.na
.SH "SEE ALSO"
.\" --------------------------------------------------------------------
.
.BR pic2graph (1),
.BR eqn2graph (1),
.BR pic (1),
.BR groff (1),
.BR gs (1),
.BR convert (1).
.
.
.\" --------------------------------------------------------------------
.SH COPYING
.\" --------------------------------------------------------------------
.
This documentation is released to the public domain.
.
.\" --------------------------------------------------------------------
.SH AUTHORS
.\" --------------------------------------------------------------------
.
This document was written by
.MT esr@thyrsus.com
Eric S.\& Raymond
.ME .
.
.
.\" Local Variables:
.\" mode: nroff
.\" End:
