# Jul/Nov 2012, Erwin Waterlander <waterlan@xs4all.nl>

.PHONY: install

export PATH:=/c/mingw64/bin:${PATH}
DESTDIR=/c/win64
prefix=/usr
mandir=$(prefix)/share/man
RELEASE=4

help:
	@echo "   build : build"
	@echo "   strip : strip executables"
	@echo " install : install in DESTDIR/prefix"
	@echo "     zip : create bin zip file"
	@echo "   clean : cleanup"
	@echo "     all : build strip install zip"

all: build strip install zip

build:
	$(MAKE) CC=x86_64-w64-mingw32-gcc \
     CPP="x86_64-w64-mingw32-gcc -E" \
     RANLIB=x86_64-w64-mingw32-ranlib \
     AR=x86_64-w64-mingw32-ar \
     WINDRES=x86_64-w64-mingw32-windres \
     prefix=$(prefix) \
     mandir=$(prefix)/share/man \
     host=x86_64-w64-mingw32 \
     host_triplet=x86_64-w64-mingw32 \
     build_alias=x86_64-w64-mingw32 \
     build_triplet=x86_64-w64-mingw32 \
     target_alias=x86_64-w64-mingw32 \
     build_cpu=x86_64 \
     CFLAGS="-Wall -gdwarf-2 -g3 -O2 -fms-extensions -fno-exceptions"

strip:
	x86_64-w64-mingw32-strip */*.exe

install:
	$(MAKE) install DESTDIR=${DESTDIR} mkdir_p="mkdir -p" \
	INSTALL="install -cp" \
	INSTALL_DATA="install -cp" \
	INSTALL_PROGRAM="install -cp" \
	mandir=$(prefix)/share/man

zip:
	cd ${DESTDIR}$(prefix); zip -r findutils-4.2.30-${RELEASE}-w64-bin.zip *

clean:
	find . -name '*.o' -exec rm {} \;
	find . -name '*.a' -exec rm {} \;
	find . -name '*.exe' -exec rm {} \;
	find . -name '*.bak' -exec rm {} \;
	find . -name '*.log' -exec rm {} \;
	find . -name '*~' -exec rm {} \;
	find . -name tmp -exec rm -rf {} \;

