/* Return the canonical absolute name of a given file.
   Copyright (C) 1996-2005 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.  */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "canonicalize.h"
#include "dirname.h"

#ifdef STDC_HEADERS
# include <stdlib.h>
#else
void free ();
#endif

#if defined STDC_HEADERS || defined HAVE_STRING_H
# include <string.h>
#else
# include <strings.h>
#endif

#if HAVE_SYS_PARAM_H
# include <sys/param.h>
#endif

#include <sys/stat.h>

#if HAVE_UNISTD_H
# include <unistd.h>
#endif

#include <errno.h>
#include <stddef.h>

#if defined(__MINGW32__) || defined(_MSC_VER)
# define _WIN32_WINNT 0x0500
# include <windows.h>
# if defined(_MSC_VER) && _MSC_VER >= 1400
#  define __set_errno(Val) _set_errno(Val)
# endif
# define lstat stat
# include <winerror.h>

struct w32err_data {
  DWORD w32err;
  int errno_val;
};

static int
w32err_cmp (const void *entry1, const void *entry2)
{
  struct w32err_data *e1 = (struct w32err_data *)entry1;
  struct w32err_data *e2 = (struct w32err_data *)entry2;

  if (e1->w32err < e2->w32err)
    return -1;
  else if (e1->w32err > e2->w32err)
    return 1;
  return 0;
}
int
w32_to_errno (DWORD w32err)
{

  /* Produced from winerror.h with the following Sed script:
      sed -e "s/^#define \([^ ]*\)  *\([^ ]*\)/{\1 \/\* \2 *\/, E  },/"
     The respective errno values added manually.  */
  static struct w32err_data errno_map[] = {
    {ERROR_SUCCESS /* 0L */, 0  },
    {ERROR_INVALID_FUNCTION /* 1L */, EPERM  },
    {ERROR_FILE_NOT_FOUND /* 2L */, ENOENT  },
    {ERROR_PATH_NOT_FOUND /* 3L */, ENOENT  },
    {ERROR_TOO_MANY_OPEN_FILES /* 4L */, EMFILE  },
    {ERROR_ACCESS_DENIED /* 5L */, EACCES  },
    {ERROR_INVALID_HANDLE /* 6L */, EBADF  },
    {ERROR_ARENA_TRASHED /* 7L */, EFAULT  },
    {ERROR_NOT_ENOUGH_MEMORY /* 8L */, ENOMEM },
    {ERROR_INVALID_BLOCK /* 9L */, EFAULT  },
    {ERROR_BAD_ENVIRONMENT /* 10L */, ENOEXEC  },
    {ERROR_BAD_FORMAT /* 11L */, ENOEXEC  },
    {ERROR_INVALID_ACCESS /* 12L */, EACCES  },
    {ERROR_INVALID_DATA /* 13L */, EIO  },
    {ERROR_OUTOFMEMORY /* 14L */, ENOMEM  },
    {ERROR_INVALID_DRIVE /* 15L */, ENODEV  },
    {ERROR_CURRENT_DIRECTORY /* 16L */, EBUSY  },
    {ERROR_NOT_SAME_DEVICE /* 17L */, EXDEV  },
    {ERROR_NO_MORE_FILES /* 18L */, ENFILE  },
    {ERROR_WRITE_PROTECT /* 19L */, EROFS  },
    {ERROR_BAD_UNIT /* 20L */, ENXIO  },
    {ERROR_NOT_READY /* 21L */, EAGAIN  },
    {ERROR_BAD_COMMAND /* 22L */, EINVAL  },
    {ERROR_CRC /* 23L */, EILSEQ  },
    {ERROR_BAD_LENGTH /* 24L */, EINVAL  },
    {ERROR_SEEK /* 25L */, EIO  },
    {ERROR_NOT_DOS_DISK /* 26L */, ENOTDIR  },
    {ERROR_SECTOR_NOT_FOUND /* 27L */, EFAULT  },
    {ERROR_OUT_OF_PAPER /* 28L */, EAGAIN  },
    {ERROR_WRITE_FAULT /* 29L */, EIO  },
    {ERROR_READ_FAULT /* 30L */, EIO  },
    {ERROR_GEN_FAILURE /* 31L */, EACCES  },
    {ERROR_SHARING_VIOLATION /* 32L */, EBUSY  },
    {ERROR_LOCK_VIOLATION /* 33L */, EACCES  },
    {ERROR_WRONG_DISK /* 34L */, ENODEV  },
    {ERROR_SHARING_BUFFER_EXCEEDED /* 36L */, EMFILE  },
    {ERROR_HANDLE_EOF /* 38L */, EINVAL  },
    {ERROR_HANDLE_DISK_FULL /* 39L */, ENOSPC  },
    {ERROR_NOT_SUPPORTED /* 50L */, ENOSYS  },
    {ERROR_REM_NOT_LIST /* 51L */, ENOENT  },
    {ERROR_DUP_NAME /* 52L */, EFAULT  },
    {ERROR_BAD_NETPATH /* 53L */, EIO  },
    {ERROR_NETWORK_BUSY /* 54L */, EBUSY  },
    {ERROR_DEV_NOT_EXIST /* 55L */, ENXIO  },
    {ERROR_TOO_MANY_CMDS /* 56L */, EAGAIN  },
    {ERROR_ADAP_HDW_ERR /* 57L */, EIO  },
    {ERROR_BAD_NET_RESP /* 58L */, EPERM  },
    {ERROR_UNEXP_NET_ERR /* 59L */, EIO  },
    {ERROR_BAD_REM_ADAP /* 60L */, EIO  },
    {ERROR_PRINTQ_FULL /* 61L */, EAGAIN  },
    {ERROR_NO_SPOOL_SPACE /* 62L */, ENOSPC  },
    {ERROR_PRINT_CANCELLED /* 63L */, ESRCH  },
    {ERROR_NETNAME_DELETED /* 64L */, ENXIO  },
    {ERROR_NETWORK_ACCESS_DENIED /* 65L */, EACCES  },
    {ERROR_BAD_DEV_TYPE /* 66L */, ENXIO  },
    {ERROR_BAD_NET_NAME /* 67L */, ENOENT  },
    {ERROR_TOO_MANY_NAMES /* 68L */, EAGAIN  },
    {ERROR_TOO_MANY_SESS /* 69L */, EAGAIN  },
    {ERROR_SHARING_PAUSED /* 70L */, EAGAIN  },
    {ERROR_REQ_NOT_ACCEP /* 71L */, EAGAIN  },
    {ERROR_REDIR_PAUSED /* 72L */, EAGAIN  },
    {ERROR_FILE_EXISTS /* 80L */, EEXIST  },
    {ERROR_CANNOT_MAKE /* 82L */, EPERM  },
    {ERROR_FAIL_I24 /* 83L */, EIO  },
    {ERROR_OUT_OF_STRUCTURES /* 84L */, ENOMEM  },
    {ERROR_ALREADY_ASSIGNED /* 85L */, EBUSY  },
    {ERROR_INVALID_PASSWORD /* 86L */, EPERM  },
    {ERROR_INVALID_PARAMETER /* 87L */, EINVAL  },
    {ERROR_NET_WRITE_FAULT /* 88L */, EIO  },
    {ERROR_NO_PROC_SLOTS /* 89L */, EAGAIN  },
    {ERROR_TOO_MANY_SEMAPHORES /* 100L */, EAGAIN  },
    {ERROR_EXCL_SEM_ALREADY_OWNED /* 101L */, EACCES  },
    {ERROR_SEM_IS_SET /* 102L */, EPERM  },
    {ERROR_TOO_MANY_SEM_REQUESTS /* 103L */, EAGAIN  },
    {ERROR_INVALID_AT_INTERRUPT_TIME /* 104L */, EINVAL  },
    {ERROR_SEM_OWNER_DIED /* 105L */, ESRCH  },
    {ERROR_SEM_USER_LIMIT /* 106L */, EAGAIN  },
    {ERROR_DISK_CHANGE /* 107L */, ENODEV  },
    {ERROR_DRIVE_LOCKED /* 108L */, EBUSY  },
    {ERROR_BROKEN_PIPE /* 109L */, EPIPE  },
    {ERROR_OPEN_FAILED /* 110L */, ENOTDIR  },
    {ERROR_BUFFER_OVERFLOW /* 111L */, ENAMETOOLONG  },
    {ERROR_DISK_FULL /* 112L */, ENOSPC  },
    {ERROR_NO_MORE_SEARCH_HANDLES /* 113L */, ENFILE  },
    {ERROR_INVALID_TARGET_HANDLE /* 114L */, EBADF  },
    {ERROR_INVALID_CATEGORY /* 117L */, ENOTTY  },
    {ERROR_INVALID_VERIFY_SWITCH /* 118L */, EINVAL  },
    {ERROR_BAD_DRIVER_LEVEL /* 119L */, ENOSYS  },
    {ERROR_CALL_NOT_IMPLEMENTED /* 120L */, ENOSYS  },
    {ERROR_SEM_TIMEOUT /* 121L */, EINTR  },
    {ERROR_INSUFFICIENT_BUFFER /* 122L */, ENOMEM  },
    {ERROR_INVALID_NAME /* 123L */, EINVAL  },
    {ERROR_INVALID_LEVEL /* 124L */, EFAULT  },
    {ERROR_NO_VOLUME_LABEL /* 125L */, ENOENT  },
    {ERROR_MOD_NOT_FOUND /* 126L */, EINVAL  },
    {ERROR_PROC_NOT_FOUND /* 127L */, EINVAL  },
    {ERROR_WAIT_NO_CHILDREN /* 128L */, ECHILD  },
    {ERROR_CHILD_NOT_COMPLETE /* 129L */, ENOEXEC  },
    {ERROR_DIRECT_ACCESS_HANDLE /* 130L */, EBADF  },
    {ERROR_NEGATIVE_SEEK /* 131L */, EINVAL  },
    {ERROR_SEEK_ON_DEVICE /* 132L */, EPERM  },
    {ERROR_IS_JOIN_TARGET /* 133L */, EPERM  },
    {ERROR_IS_JOINED /* 134L */, EPERM  },
    {ERROR_IS_SUBSTED /* 135L */, EPERM  },
    {ERROR_NOT_JOINED /* 136L */, EINVAL  },
    {ERROR_NOT_SUBSTED /* 137L */, EINVAL  },
    {ERROR_JOIN_TO_JOIN /* 138L */, EPERM  },
    {ERROR_SUBST_TO_SUBST /* 139L */, EPERM  },
    {ERROR_JOIN_TO_SUBST /* 140L */, EPERM  },
    {ERROR_SUBST_TO_JOIN /* 141L */, EPERM  },
    {ERROR_BUSY_DRIVE /* 142L */, EAGAIN  },
    {ERROR_SAME_DRIVE /* 143L */, EPERM  },
    {ERROR_DIR_NOT_ROOT /* 144L */, EPERM  },
    {ERROR_DIR_NOT_EMPTY /* 145L */, ENOTEMPTY  },
    {ERROR_IS_SUBST_PATH /* 146L */, EBUSY  },
    {ERROR_IS_JOIN_PATH /* 147L */, EAGAIN  },
    {ERROR_PATH_BUSY /* 148L */, EBUSY  },
    {ERROR_IS_SUBST_TARGET /* 149L */, EBUSY  },
    {ERROR_SYSTEM_TRACE /* 150L */, EPERM  },
    {ERROR_INVALID_EVENT_COUNT /* 151L */, EINVAL  },
    {ERROR_TOO_MANY_MUXWAITERS /* 152L */, EAGAIN  },
    {ERROR_INVALID_LIST_FORMAT /* 153L */, EINVAL  },
    {ERROR_LABEL_TOO_LONG /* 154L */, ENAMETOOLONG  },
    {ERROR_TOO_MANY_TCBS /* 155L */, EAGAIN  },
    {ERROR_SIGNAL_REFUSED /* 156L */, EPERM  },
    {ERROR_DISCARDED /* 157L */, EINVAL  },
    {ERROR_NOT_LOCKED /* 158L */, ENOLCK  },
    {ERROR_BAD_THREADID_ADDR /* 159L */, EFAULT  },
    {ERROR_BAD_ARGUMENTS /* 160L */, EINVAL  },
    {ERROR_BAD_PATHNAME /* 161L */, ENOENT  },
    {ERROR_SIGNAL_PENDING /* 162L */, EBUSY  },
    {ERROR_MAX_THRDS_REACHED /* 164L */, EAGAIN  },
    {ERROR_LOCK_FAILED /* 167L */, ENOLCK  },
    {ERROR_BUSY /* 170L */, EBUSY  },
    {ERROR_CANCEL_VIOLATION /* 173L */, EINVAL  },
    {ERROR_ATOMIC_LOCKS_NOT_SUPPORTED /* 174L */, ENOSYS  },
    {ERROR_INVALID_SEGMENT_NUMBER /* 180L */, EINVAL  },
    {ERROR_INVALID_ORDINAL /* 182L */, EINVAL  },
    {ERROR_ALREADY_EXISTS /* 183L */, EEXIST  },
    {ERROR_INVALID_FLAG_NUMBER /* 186L */, EINVAL  },
    {ERROR_SEM_NOT_FOUND /* 187L */, EINVAL  },
    {ERROR_INVALID_STARTING_CODESEG /* 188L */, EINVAL  },
    {ERROR_INVALID_STACKSEG /* 189L */, EINVAL  },
    {ERROR_INVALID_MODULETYPE /* 190L */, EINVAL  },
    {ERROR_INVALID_EXE_SIGNATURE /* 191L */, ENOEXEC  },
    {ERROR_EXE_MARKED_INVALID /* 192L */, ENOEXEC  },
    {ERROR_BAD_EXE_FORMAT /* 193L */, ENOEXEC  },
    {ERROR_ITERATED_DATA_EXCEEDS_64k /* 194L */, ENOEXEC  },
    {ERROR_INVALID_MINALLOCSIZE /* 195L */, ENOEXEC  },
    {ERROR_DYNLINK_FROM_INVALID_RING /* 196L */, ENOEXEC  },
    {ERROR_IOPL_NOT_ENABLED /* 197L */, ENOEXEC  },
    {ERROR_INVALID_SEGDPL /* 198L */, ENOEXEC  },
    {ERROR_AUTODATASEG_EXCEEDS_64k /* 199L */, ENOEXEC  },
    {ERROR_RING2SEG_MUST_BE_MOVABLE /* 200L */, ENOEXEC  },
    {ERROR_RELOC_CHAIN_XEEDS_SEGLIM /* 201L */, ENOEXEC  },
    {ERROR_INFLOOP_IN_RELOC_CHAIN /* 202L */, ENOEXEC  },
    {ERROR_ENVVAR_NOT_FOUND /* 203L */, EINVAL  },
    {ERROR_NO_SIGNAL_SENT /* 205L */, EINVAL  },
    {ERROR_FILENAME_EXCED_RANGE /* 206L */, ENAMETOOLONG  },
    {ERROR_RING2_STACK_IN_USE /* 207L */, EBUSY  },
    {ERROR_META_EXPANSION_TOO_LONG /* 208L */, EINVAL  },
    {ERROR_INVALID_SIGNAL_NUMBER /* 209L */, EINVAL  },
    {ERROR_THREAD_1_INACTIVE /* 210L */, EINVAL  },
    {ERROR_LOCKED /* 212L */, EPERM  },
    {ERROR_TOO_MANY_MODULES /* 214L */, EAGAIN  },
    {ERROR_NESTING_NOT_ALLOWED /* 215L */, EPERM  },
    {ERROR_EXE_MACHINE_TYPE_MISMATCH /* 216L */, ENOEXEC  },
    {ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY /* 217L */, ENOEXEC  },
    {ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY /* 218L */, ENOEXEC  },
    {ERROR_BAD_PIPE /* 230L */, EPIPE  },
    {ERROR_PIPE_BUSY /* 231L */, EBUSY  },
    {ERROR_NO_DATA /* 232L */, EPIPE  },
    {ERROR_PIPE_NOT_CONNECTED /* 233L */, EPIPE  },
    {ERROR_MORE_DATA /* 234L */, EAGAIN  },
    {ERROR_VC_DISCONNECTED /* 240L */, EINTR  },
    {ERROR_INVALID_EA_NAME /* 254L */, EINVAL  },
    {ERROR_EA_LIST_INCONSISTENT /* 255L */, EINVAL  },
    {WAIT_TIMEOUT /* 258L */, EINTR  },
    {ERROR_NO_MORE_ITEMS /* 259L */, ENOSPC  },
    {ERROR_CANNOT_COPY /* 266L */, EPERM  },
    {ERROR_DIRECTORY /* 267L */, EINVAL  },
    {ERROR_EAS_DIDNT_FIT /* 275L */, ENOMEM  },
    {ERROR_EA_FILE_CORRUPT /* 276L */, EIO  },
    {ERROR_EA_TABLE_FULL /* 277L */, EAGAIN  },
    {ERROR_INVALID_EA_HANDLE /* 278L */, EBADF  },
    {ERROR_EAS_NOT_SUPPORTED /* 282L */, ENOSYS  },
    {ERROR_NOT_OWNER /* 288L */, EACCES  },
    {ERROR_TOO_MANY_POSTS /* 298L */, EAGAIN  },
    {ERROR_PARTIAL_COPY /* 299L */, EIO  },
    {ERROR_OPLOCK_NOT_GRANTED /* 300L */, EACCES  },
    {ERROR_INVALID_OPLOCK_PROTOCOL /* 301L */, EINVAL  },
    {ERROR_DISK_TOO_FRAGMENTED /* 302L */, EAGAIN  },
    {ERROR_DELETE_PENDING /* 303L */, ENOENT  },
    {ERROR_MR_MID_NOT_FOUND /* 317L */, EINVAL  },
    {ERROR_SCOPE_NOT_FOUND /* 318L */, EINVAL  },
    {ERROR_INVALID_ADDRESS /* 487L */, EFAULT  },
    {ERROR_ARITHMETIC_OVERFLOW /* 534L */, ERANGE  },
    {ERROR_PIPE_CONNECTED /* 535L */, EPIPE  },
    {ERROR_PIPE_LISTENING /* 536L */, EPIPE  },
    {ERROR_EA_ACCESS_DENIED /* 994L */, EACCES  },
    {ERROR_OPERATION_ABORTED /* 995L */, EPERM  },
    {ERROR_IO_INCOMPLETE /* 996L */, EAGAIN  },
    {ERROR_IO_PENDING /* 997L */, EAGAIN  },
    {ERROR_NOACCESS /* 998L */, EFAULT  },
    {ERROR_SWAPERROR /* 999L */, EFAULT  },
    {ERROR_STACK_OVERFLOW /* 1001L */, EFAULT  },
    {ERROR_INVALID_MESSAGE /* 1002L */, EINVAL  },
    {ERROR_CAN_NOT_COMPLETE /* 1003L */, EAGAIN  },
    {ERROR_INVALID_FLAGS /* 1004L */, EINVAL  },
    {ERROR_UNRECOGNIZED_VOLUME /* 1005L */, EIO  },
    {ERROR_FILE_INVALID /* 1006L */, EINVAL  },
    {ERROR_FULLSCREEN_MODE /* 1007L */, EPERM  },
    {ERROR_NO_TOKEN /* 1008L */, EINVAL  },
    {ERROR_BADDB /* 1009L */, EIO  },
    {ERROR_BADKEY /* 1010L */, EINVAL  },
    {ERROR_CANTOPEN /* 1011L */, EIO  },
    {ERROR_CANTREAD /* 1012L */, EIO  },
    {ERROR_CANTWRITE /* 1013L */, EIO  },
    {ERROR_REGISTRY_RECOVERED /* 1014L */, EFAULT  },
    {ERROR_REGISTRY_CORRUPT /* 1015L */, EIO  },
    {ERROR_REGISTRY_IO_FAILED /* 1016L */, EIO  },
    {ERROR_NOT_REGISTRY_FILE /* 1017L */, EFAULT  },
    {ERROR_KEY_DELETED /* 1018L */, EIO  },
    {ERROR_NO_LOG_SPACE /* 1019L */, ENOSPC  },
    {ERROR_KEY_HAS_CHILDREN /* 1020L */, EAGAIN  },
    {ERROR_CHILD_MUST_BE_VOLATILE /* 1021L */, EPERM  },
    {ERROR_NOTIFY_ENUM_DIR /* 1022L */, EAGAIN  },
    {ERROR_DEPENDENT_SERVICES_RUNNING /* 1051L */, EAGAIN  },
    {ERROR_INVALID_SERVICE_CONTROL /* 1052L */, EINVAL  },
    {ERROR_SERVICE_REQUEST_TIMEOUT /* 1053L */, EAGAIN  },
    {ERROR_SERVICE_NO_THREAD /* 1054L */, EAGAIN  },
    {ERROR_SERVICE_DATABASE_LOCKED /* 1055L */, EBUSY  },
    {ERROR_SERVICE_ALREADY_RUNNING /* 1056L */, EEXIST  },
    {ERROR_INVALID_SERVICE_ACCOUNT /* 1057L */, EINVAL  },
    {ERROR_SERVICE_DISABLED /* 1058L */, EPERM  },
    {ERROR_CIRCULAR_DEPENDENCY /* 1059L */, EINVAL  },
    {ERROR_SERVICE_DOES_NOT_EXIST /* 1060L */, ENOENT  },
    {ERROR_SERVICE_CANNOT_ACCEPT_CTRL /* 1061L */, EAGAIN  },
    {ERROR_SERVICE_NOT_ACTIVE /* 1062L */, EPERM  },
    {ERROR_FAILED_SERVICE_CONTROLLER_CONNECT /* 1063L */, EIO  },
    {ERROR_EXCEPTION_IN_SERVICE /* 1064L */, EFAULT  },
    {ERROR_DATABASE_DOES_NOT_EXIST /* 1065L */, ENOENT  },
    {ERROR_SERVICE_SPECIFIC_ERROR /* 1066L */, EINVAL  },
    {ERROR_PROCESS_ABORTED /* 1067L */, EFAULT  },
    {ERROR_SERVICE_DEPENDENCY_FAIL /* 1068L */, EIO  },
    {ERROR_SERVICE_LOGON_FAILED /* 1069L */, EIO  },
    {ERROR_SERVICE_START_HANG /* 1070L */, EAGAIN  },
    {ERROR_INVALID_SERVICE_LOCK /* 1071L */, EINVAL  },
    {ERROR_SERVICE_MARKED_FOR_DELETE /* 1072L */, ENOENT  },
    {ERROR_SERVICE_EXISTS /* 1073L */, EEXIST  },
    {ERROR_ALREADY_RUNNING_LKG /* 1074L */, EPERM  },
    {ERROR_SERVICE_DEPENDENCY_DELETED /* 1075L */, ENOENT  },
    {ERROR_BOOT_ALREADY_ACCEPTED /* 1076L */, EPERM  },
    {ERROR_SERVICE_NEVER_STARTED /* 1077L */, ENOENT  },
    {ERROR_DUPLICATE_SERVICE_NAME /* 1078L */, EEXIST  },
    {ERROR_DIFFERENT_SERVICE_ACCOUNT /* 1079L */, EPERM  },
    {ERROR_CANNOT_DETECT_DRIVER_FAILURE /* 1080L */, EPERM  },
    {ERROR_CANNOT_DETECT_PROCESS_ABORT /* 1081L */, EPERM  },
    {ERROR_NO_RECOVERY_PROGRAM /* 1082L */, ENOENT  },
    {ERROR_SERVICE_NOT_IN_EXE /* 1083L */, ENOEXEC  },
    {ERROR_NOT_SAFEBOOT_SERVICE /* 1084L */, EPERM  },
    {ERROR_END_OF_MEDIA /* 1100L */, ENOSPC  },
    {ERROR_FILEMARK_DETECTED /* 1101L */, EACCES  },
    {ERROR_BEGINNING_OF_MEDIA /* 1102L */, ENOSPC  },
    {ERROR_SETMARK_DETECTED /* 1103L */, ENOSPC  },
    {ERROR_NO_DATA_DETECTED /* 1104L */, EIO  },
    {ERROR_PARTITION_FAILURE /* 1105L */, EIO  },
    {ERROR_INVALID_BLOCK_LENGTH /* 1106L */, EINVAL  },
    {ERROR_DEVICE_NOT_PARTITIONED /* 1107L */, EIO  },
    {ERROR_UNABLE_TO_LOCK_MEDIA /* 1108L */, EIO  },
    {ERROR_UNABLE_TO_UNLOAD_MEDIA /* 1109L */, EIO  },
    {ERROR_MEDIA_CHANGED /* 1110L */, ENODEV  },
    {ERROR_BUS_RESET /* 1111L */, EIO  },
    {ERROR_NO_MEDIA_IN_DRIVE /* 1112L */, ENODEV  },
    {ERROR_NO_UNICODE_TRANSLATION /* 1113L */, EPERM  },
    {ERROR_DLL_INIT_FAILED /* 1114L */, ENOEXEC  },
    {ERROR_SHUTDOWN_IN_PROGRESS /* 1115L */, EPERM  },
    {ERROR_NO_SHUTDOWN_IN_PROGRESS /* 1116L */, EINVAL  },
    {ERROR_IO_DEVICE /* 1117L */, EIO  },
    {ERROR_SERIAL_NO_DEVICE /* 1118L */, ENODEV  },
    {ERROR_IRQ_BUSY /* 1119L */, EBUSY  },
    {ERROR_MORE_WRITES /* 1120L */, EAGAIN  },
    {ERROR_COUNTER_TIMEOUT /* 1121L */, EAGAIN  },
    {ERROR_FLOPPY_ID_MARK_NOT_FOUND /* 1122L */, ENODEV  },
    {ERROR_FLOPPY_WRONG_CYLINDER /* 1123L */, EIO  },
    {ERROR_FLOPPY_UNKNOWN_ERROR /* 1124L */, EIO  },
    {ERROR_FLOPPY_BAD_REGISTERS /* 1125L */, EIO  },
    {ERROR_DISK_RECALIBRATE_FAILED /* 1126L */, EIO  },
    {ERROR_DISK_OPERATION_FAILED /* 1127L */, EIO  },
    {ERROR_DISK_RESET_FAILED /* 1128L */, EIO  },
    {ERROR_EOM_OVERFLOW /* 1129L */, EIO  },
    {ERROR_NOT_ENOUGH_SERVER_MEMORY /* 1130L */, ENOMEM  },
    {ERROR_POSSIBLE_DEADLOCK /* 1131L */, EDEADLOCK  },
    {ERROR_MAPPED_ALIGNMENT /* 1132L */, EFAULT  },
    {ERROR_SET_POWER_STATE_VETOED /* 1140L */, EPERM  },
    {ERROR_SET_POWER_STATE_FAILED /* 1141L */, EPERM  },
    {ERROR_TOO_MANY_LINKS /* 1142L */, EMLINK  },
    {ERROR_OLD_WIN_VERSION /* 1150L */, ENOSYS  },
    {ERROR_APP_WRONG_OS /* 1151L */, ENOEXEC  },
    {ERROR_SINGLE_INSTANCE_APP /* 1152L */, EPERM  },
    {ERROR_RMODE_APP /* 1153L */, ENOEXEC  },
    {ERROR_INVALID_DLL /* 1154L */, ENOEXEC  },
    {ERROR_NO_ASSOCIATION /* 1155L */, ENOSYS  },
    {ERROR_DDE_FAIL /* 1156L */, EINVAL  },
    {ERROR_DLL_NOT_FOUND /* 1157L */, ENOENT  },
    {ERROR_NO_MORE_USER_HANDLES /* 1158L */, EMFILE  },
    {ERROR_MESSAGE_SYNC_ONLY /* 1159L */, EPERM  },
    {ERROR_SOURCE_ELEMENT_EMPTY /* 1160L */, ENODEV  },
    {ERROR_DESTINATION_ELEMENT_FULL /* 1161L */, ENOSPC  },
    {ERROR_ILLEGAL_ELEMENT_ADDRESS /* 1162L */, EFAULT  },
    {ERROR_MAGAZINE_NOT_PRESENT /* 1163L */, EFAULT  },
    {ERROR_DEVICE_REINITIALIZATION_NEEDED /* 1164L */, EIO  },
    {ERROR_DEVICE_REQUIRES_CLEANING /* 1165L */, EIO  },
    {ERROR_DEVICE_DOOR_OPEN /* 1166L */, EIO  },
    {ERROR_DEVICE_NOT_CONNECTED /* 1167L */, ENODEV  },
    {ERROR_NOT_FOUND /* 1168L */, ENOENT  },
    {ERROR_NO_MATCH /* 1169L */, ESRCH  },
    {ERROR_SET_NOT_FOUND /* 1170L */, EFAULT  },
    {ERROR_POINT_NOT_FOUND /* 1171L */, EFAULT  },
    {ERROR_NO_TRACKING_SERVICE /* 1172L */, EPERM  },
    {ERROR_NO_VOLUME_ID /* 1173L */, ENOENT  },
    {ERROR_UNABLE_TO_REMOVE_REPLACED /* 1175L */, EPERM  },
    {ERROR_UNABLE_TO_MOVE_REPLACEMENT /* 1176L */, EPERM  },
    {ERROR_UNABLE_TO_MOVE_REPLACEMENT_2 /* 1177L */, EPERM  },
    {ERROR_JOURNAL_DELETE_IN_PROGRESS /* 1178L */, EAGAIN  },
    {ERROR_JOURNAL_NOT_ACTIVE /* 1179L */, EPERM  },
    {ERROR_POTENTIAL_FILE_FOUND /* 1180L */, ESRCH  },
    {ERROR_JOURNAL_ENTRY_DELETED /* 1181L */, ENOENT  },
    {ERROR_BAD_DEVICE /* 1200L */, ENODEV  },
    {ERROR_CONNECTION_UNAVAIL /* 1201L */, ENODEV  },
    {ERROR_DEVICE_ALREADY_REMEMBERED /* 1202L */, EPERM  },
    {ERROR_NO_NET_OR_BAD_PATH /* 1203L */, ENOENT  },
    {ERROR_BAD_PROVIDER /* 1204L */, ENOENT  },
    {ERROR_CANNOT_OPEN_PROFILE /* 1205L */, EIO  },
    {ERROR_BAD_PROFILE /* 1206L */, EIO  },
    {ERROR_NOT_CONTAINER /* 1207L */, EPERM  },
    {ERROR_EXTENDED_ERROR /* 1208L */, EINVAL  },
    {ERROR_INVALID_GROUPNAME /* 1209L */, EINVAL  },
    {ERROR_INVALID_COMPUTERNAME /* 1210L */, EINVAL  },
    {ERROR_INVALID_EVENTNAME /* 1211L */, EINVAL  },
    {ERROR_INVALID_DOMAINNAME /* 1212L */, EINVAL  },
    {ERROR_INVALID_SERVICENAME /* 1213L */, EINVAL  },
    {ERROR_INVALID_NETNAME /* 1214L */, EINVAL  },
    {ERROR_INVALID_SHARENAME /* 1215L */, EINVAL  },
    {ERROR_INVALID_PASSWORDNAME /* 1216L */, EINVAL  },
    {ERROR_INVALID_MESSAGENAME /* 1217L */, EINVAL  },
    {ERROR_INVALID_MESSAGEDEST /* 1218L */, EINVAL  },
    {ERROR_SESSION_CREDENTIAL_CONFLICT /* 1219L */, EAGAIN  },
    {ERROR_REMOTE_SESSION_LIMIT_EXCEEDED /* 1220L */, EAGAIN  },
    {ERROR_DUP_DOMAINNAME /* 1221L */, EAGAIN  },
    {ERROR_NO_NETWORK /* 1222L */, ENOENT  },
    {ERROR_CANCELLED /* 1223L */, EPERM  },
    {ERROR_USER_MAPPED_FILE /* 1224L */, EPERM  },
    {ERROR_CONNECTION_REFUSED /* 1225L */, EACCES  },
    {ERROR_GRACEFUL_DISCONNECT /* 1226L */, EINVAL  },
    {ERROR_ADDRESS_ALREADY_ASSOCIATED /* 1227L */, EAGAIN  },
    {ERROR_ADDRESS_NOT_ASSOCIATED /* 1228L */, EINVAL  },
    {ERROR_CONNECTION_INVALID /* 1229L */, EINVAL  },
    {ERROR_CONNECTION_ACTIVE /* 1230L */, EINVAL  },
    {ERROR_NETWORK_UNREACHABLE /* 1231L */, EAGAIN  },
    {ERROR_HOST_UNREACHABLE /* 1232L */, EAGAIN  },
    {ERROR_PROTOCOL_UNREACHABLE /* 1233L */, EAGAIN  },
    {ERROR_PORT_UNREACHABLE /* 1234L */, EINVAL  },
    {ERROR_REQUEST_ABORTED /* 1235L */, EFAULT  },
    {ERROR_CONNECTION_ABORTED /* 1236L */, EAGAIN  },
    {ERROR_RETRY /* 1237L */, EAGAIN  },
    {ERROR_CONNECTION_COUNT_LIMIT /* 1238L */, EAGAIN  },
    {ERROR_LOGIN_TIME_RESTRICTION /* 1239L */, EAGAIN  },
    {ERROR_LOGIN_WKSTA_RESTRICTION /* 1240L */, EAGAIN  },
    {ERROR_INCORRECT_ADDRESS /* 1241L */, EFAULT  },
    {ERROR_ALREADY_REGISTERED /* 1242L */, EINVAL  },
    {ERROR_SERVICE_NOT_FOUND /* 1243L */, ESRCH  },
    {ERROR_NOT_AUTHENTICATED /* 1244L */, EACCES  },
    {ERROR_NOT_LOGGED_ON /* 1245L */, EPERM  },
    {ERROR_CONTINUE /* 1246L */, EAGAIN  },
    {ERROR_ALREADY_INITIALIZED /* 1247L */, EINVAL  },
    {ERROR_NO_MORE_DEVICES /* 1248L */, ENODEV  },
    {ERROR_NO_SUCH_SITE /* 1249L */, ENOENT  },
    {ERROR_DOMAIN_CONTROLLER_EXISTS /* 1250L */, EINVAL  },
    {ERROR_ONLY_IF_CONNECTED /* 1251L */, EPERM  },
    {ERROR_OVERRIDE_NOCHANGES /* 1252L */, EPERM  },
    {ERROR_BAD_USER_PROFILE /* 1253L */, EFAULT  },
    {ERROR_NOT_SUPPORTED_ON_SBS /* 1254L */, ENOSYS  },
    {ERROR_SERVER_SHUTDOWN_IN_PROGRESS /* 1255L */, EPERM  },
    {ERROR_HOST_DOWN /* 1256L */, EAGAIN  },
    {ERROR_NON_ACCOUNT_SID /* 1257L */, EINVAL  },
    {ERROR_NON_DOMAIN_SID /* 1258L */, EINVAL  },
    {ERROR_APPHELP_BLOCK /* 1259L */, EINTR  },
    {ERROR_ACCESS_DISABLED_BY_POLICY /* 1260L */, EPERM  },
    {ERROR_REG_NAT_CONSUMPTION /* 1261L */, EINVAL  },
    {ERROR_CSCSHARE_OFFLINE /* 1262L */, ENOENT  },
    {ERROR_PKINIT_FAILURE /* 1263L */, EINVAL  },
    {ERROR_SMARTCARD_SUBSYSTEM_FAILURE /* 1264L */, EINVAL  },
    {ERROR_DOWNGRADE_DETECTED /* 1265L */, EPERM  },
    {SEC_E_SMARTCARD_CERT_REVOKED /* 1266L */, EPERM  },
    {SEC_E_ISSUING_CA_UNTRUSTED /* 1267L */, EPERM  },
    {SEC_E_REVOCATION_OFFLINE_C /* 1268L */, EAGAIN  },
#ifdef SEC_E_PKINIT_CLIENT_FAILUR
    {SEC_E_PKINIT_CLIENT_FAILUR /* 1269L */, EPERM  },
#endif
    {SEC_E_SMARTCARD_CERT_EXPIRED /* 1270L */, EPERM  },
    {ERROR_MACHINE_LOCKED /* 1271L */, EPERM  },
    {ERROR_CALLBACK_SUPPLIED_INVALID_DATA /* 1273L */, EINVAL  },
    {ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED /* 1274L */, EAGAIN  },
    {ERROR_DRIVER_BLOCKED /* 1275L */, EIO  },
    {ERROR_INVALID_IMPORT_OF_NON_DLL /* 1276L */, EFAULT  },
    {ERROR_ACCESS_DISABLED_WEBBLADE /* 1277L */, EPERM  },
    {ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER /* 1278L */, EPERM  },
    {ERROR_RECOVERY_FAILURE /* 1279L */, EIO  },
    {ERROR_ALREADY_FIBER /* 1280L */, EPERM  },
    {ERROR_ALREADY_THREAD /* 1281L */, EPERM  },
    {ERROR_STACK_BUFFER_OVERRUN /* 1282L */, EFAULT  },
    {ERROR_PARAMETER_QUOTA_EXCEEDED /* 1283L */, EAGAIN  },
    {ERROR_DEBUGGER_INACTIVE /* 1284L */, EINVAL  },
    {ERROR_NOT_ALL_ASSIGNED /* 1300L */, EINVAL  },
    {ERROR_SOME_NOT_MAPPED /* 1301L */, EINVAL  },
    {ERROR_NO_QUOTAS_FOR_ACCOUNT /* 1302L */, EINVAL  },
    {ERROR_LOCAL_USER_SESSION_KEY /* 1303L */, EPERM  },
    {ERROR_NULL_LM_PASSWORD /* 1304L */, EPERM  },
    {ERROR_UNKNOWN_REVISION /* 1305L */, EINVAL  },
    {ERROR_REVISION_MISMATCH /* 1306L */, EINVAL  },
    {ERROR_INVALID_OWNER /* 1307L */, EINVAL  },
    {ERROR_INVALID_PRIMARY_GROUP /* 1308L */, EINVAL  },
    {ERROR_NO_IMPERSONATION_TOKEN /* 1309L */, EINVAL  },
    {ERROR_CANT_DISABLE_MANDATORY /* 1310L */, EPERM  },
    {ERROR_NO_LOGON_SERVERS /* 1311L */, EPERM  },
    {ERROR_NO_SUCH_LOGON_SESSION /* 1312L */, EINVAL  },
    {ERROR_NO_SUCH_PRIVILEGE /* 1313L */, EINVAL  },
    {ERROR_PRIVILEGE_NOT_HELD /* 1314L */, EPERM  },
    {ERROR_INVALID_ACCOUNT_NAME /* 1315L */, EINVAL  },
    {ERROR_USER_EXISTS /* 1316L */, EEXIST  },
    {ERROR_NO_SUCH_USER /* 1317L */, ENOENT  },
    {ERROR_GROUP_EXISTS /* 1318L */, EEXIST  },
    {ERROR_NO_SUCH_GROUP /* 1319L */, ENOENT  },
    {ERROR_MEMBER_IN_GROUP /* 1320L */, EBUSY  },
    {ERROR_MEMBER_NOT_IN_GROUP /* 1321L */, EINVAL  },
    {ERROR_LAST_ADMIN /* 1322L */, EBUSY  },
    {ERROR_WRONG_PASSWORD /* 1323L */, EINVAL  },
    {ERROR_ILL_FORMED_PASSWORD /* 1324L */, EPERM  },
    {ERROR_PASSWORD_RESTRICTION /* 1325L */, EPERM  },
    {ERROR_LOGON_FAILURE /* 1326L */, EINVAL  },
    {ERROR_ACCOUNT_RESTRICTION /* 1327L */, EPERM  },
    {ERROR_INVALID_LOGON_HOURS /* 1328L */, EPERM  },
    {ERROR_INVALID_WORKSTATION /* 1329L */, EPERM  },
    {ERROR_PASSWORD_EXPIRED /* 1330L */, EPERM  },
    {ERROR_ACCOUNT_DISABLED /* 1331L */, EPERM  },
    {ERROR_NONE_MAPPED /* 1332L */, EINVAL  },
    {ERROR_TOO_MANY_LUIDS_REQUESTED /* 1333L */, EAGAIN  },
    {ERROR_LUIDS_EXHAUSTED /* 1334L */, EAGAIN  },
    {ERROR_INVALID_SUB_AUTHORITY /* 1335L */, EPERM  },
    {ERROR_INVALID_ACL /* 1336L */, EINVAL  },
    {ERROR_INVALID_SID /* 1337L */, EINVAL  },
    {ERROR_INVALID_SECURITY_DESCR /* 1338L */, EINVAL  },
    {ERROR_BAD_INHERITANCE_ACL /* 1340L */, EINVAL  },
    {ERROR_SERVER_DISABLED /* 1341L */, EPERM  },
    {ERROR_SERVER_NOT_DISABLED /* 1342L */, EAGAIN  },
    {ERROR_INVALID_ID_AUTHORITY /* 1343L */, EINVAL  },
    {ERROR_ALLOTTED_SPACE_EXCEEDED /* 1344L */, ENOMEM  },
    {ERROR_INVALID_GROUP_ATTRIBUTES /* 1345L */, EINVAL  },
    {ERROR_BAD_IMPERSONATION_LEVEL /* 1346L */, EINVAL  },
    {ERROR_CANT_OPEN_ANONYMOUS /* 1347L */, EPERM  },
    {ERROR_BAD_VALIDATION_CLASS /* 1348L */, EINVAL  },
    {ERROR_BAD_TOKEN_TYPE /* 1349L */, EINVAL  },
    {ERROR_NO_SECURITY_ON_OBJECT /* 1350L */, EPERM  },
    {ERROR_CANT_ACCESS_DOMAIN_INFO /* 1351L */, EPERM  },
    {ERROR_INVALID_SERVER_STATE /* 1352L */, EINVAL  },
    {ERROR_INVALID_DOMAIN_STATE /* 1353L */, EINVAL  },
    {ERROR_INVALID_DOMAIN_ROLE /* 1354L */, EINVAL  },
    {ERROR_NO_SUCH_DOMAIN /* 1355L */, EINVAL  },
    {ERROR_DOMAIN_EXISTS /* 1356L */, EEXIST  },
    {ERROR_DOMAIN_LIMIT_EXCEEDED /* 1357L */, EAGAIN  },
    {ERROR_INTERNAL_DB_CORRUPTION /* 1358L */, EFAULT  },
    {ERROR_INTERNAL_ERROR /* 1359L */, EFAULT  },
    {ERROR_GENERIC_NOT_MAPPED /* 1360L */, EINVAL  },
    {ERROR_BAD_DESCRIPTOR_FORMAT /* 1361L */, EINVAL  },
    {ERROR_NOT_LOGON_PROCESS /* 1362L */, EPERM  },
    {ERROR_LOGON_SESSION_EXISTS /* 1363L */, EEXIST  },
    {ERROR_NO_SUCH_PACKAGE /* 1364L */, EINVAL  },
    {ERROR_BAD_LOGON_SESSION_STATE /* 1365L */, EFAULT  },
    {ERROR_LOGON_SESSION_COLLISION /* 1366L */, EINVAL  },
    {ERROR_INVALID_LOGON_TYPE /* 1367L */, EINVAL  },
    {ERROR_CANNOT_IMPERSONATE /* 1368L */, EPERM  },
    {ERROR_RXACT_INVALID_STATE /* 1369L */, EINVAL  },
    {ERROR_RXACT_COMMIT_FAILURE /* 1370L */, EIO  },
    {ERROR_SPECIAL_ACCOUNT /* 1371L */, EPERM  },
    {ERROR_SPECIAL_GROUP /* 1372L */, EPERM  },
    {ERROR_SPECIAL_USER /* 1373L */, EPERM  },
    {ERROR_MEMBERS_PRIMARY_GROUP /* 1374L */, EBUSY  },
    {ERROR_TOKEN_ALREADY_IN_USE /* 1375L */, EBUSY  },
    {ERROR_NO_SUCH_ALIAS /* 1376L */, ENOENT  },
    {ERROR_MEMBER_NOT_IN_ALIAS /* 1377L */, ENOENT  },
    {ERROR_MEMBER_IN_ALIAS /* 1378L */, EEXIST  },
    {ERROR_ALIAS_EXISTS /* 1379L */, EEXIST  },
    {ERROR_LOGON_NOT_GRANTED /* 1380L */, EPERM  },
    {ERROR_TOO_MANY_SECRETS /* 1381L */, EAGAIN  },
    {ERROR_SECRET_TOO_LONG /* 1382L */, ENAMETOOLONG  },
    {ERROR_INTERNAL_DB_ERROR /* 1383L */, EFAULT  },
    {ERROR_TOO_MANY_CONTEXT_IDS /* 1384L */, EAGAIN  },
    {ERROR_LOGON_TYPE_NOT_GRANTED /* 1385L */, EPERM  },
    {ERROR_NT_CROSS_ENCRYPTION_REQUIRED /* 1386L */, EPERM  },
    {ERROR_NO_SUCH_MEMBER /* 1387L */, ENOENT  },
    {ERROR_INVALID_MEMBER /* 1388L */, ENOENT  },
    {ERROR_TOO_MANY_SIDS /* 1389L */, EAGAIN  },
    {ERROR_LM_CROSS_ENCRYPTION_REQUIRED /* 1390L */, EPERM  },
    {ERROR_NO_INHERITANCE /* 1391L */, EINVAL  },
    {ERROR_FILE_CORRUPT /* 1392L */, EIO  },
    {ERROR_DISK_CORRUPT /* 1393L */, EIO  },
    {ERROR_NO_USER_SESSION_KEY /* 1394L */, EPERM  },
    {ERROR_LICENSE_QUOTA_EXCEEDED /* 1395L */, EAGAIN  },
    {ERROR_WRONG_TARGET_NAME /* 1396L */, EINVAL  },
    {ERROR_MUTUAL_AUTH_FAILED /* 1397L */, EPERM  },
    {ERROR_TIME_SKEW /* 1398L */, EINVAL  },
    {ERROR_CURRENT_DOMAIN_NOT_ALLOWED /* 1399L */, EPERM  },
    {ERROR_INVALID_WINDOW_HANDLE /* 1400L */, EBADF  },
    {ERROR_INVALID_MENU_HANDLE /* 1401L */, EBADF  },
    {ERROR_INVALID_CURSOR_HANDLE /* 1402L */, EBADF  },
    {ERROR_INVALID_ACCEL_HANDLE /* 1403L */, EBADF  },
    {ERROR_INVALID_HOOK_HANDLE /* 1404L */, EBADF  },
    {ERROR_INVALID_DWP_HANDLE /* 1405L */, EBADF  },
    {ERROR_TLW_WITH_WSCHILD /* 1406L */, EAGAIN  },
    {ERROR_CANNOT_FIND_WND_CLASS /* 1407L */, EINVAL  },
    {ERROR_WINDOW_OF_OTHER_THREAD /* 1408L */, EINVAL  },
    {ERROR_HOTKEY_ALREADY_REGISTERED /* 1409L */, EINVAL  },
    {ERROR_CLASS_ALREADY_EXISTS /* 1410L */, EINVAL  },
    {ERROR_CLASS_DOES_NOT_EXIST /* 1411L */, ENOENT  },
    {ERROR_CLASS_HAS_WINDOWS /* 1412L */, EBUSY  },
    {ERROR_INVALID_INDEX /* 1413L */, EINVAL  },
    {ERROR_INVALID_ICON_HANDLE /* 1414L */, EBADF  },
    {ERROR_PRIVATE_DIALOG_INDEX /* 1415L */, EPERM  },
    {ERROR_LISTBOX_ID_NOT_FOUND /* 1416L */, EINVAL  },
    {ERROR_NO_WILDCARD_CHARACTERS /* 1417L */, ESRCH  },
    {ERROR_CLIPBOARD_NOT_OPEN /* 1418L */, EPERM  },
    {ERROR_HOTKEY_NOT_REGISTERED /* 1419L */, EINVAL  },
    {ERROR_WINDOW_NOT_DIALOG /* 1420L */, EINVAL  },
    {ERROR_CONTROL_ID_NOT_FOUND /* 1421L */, EINVAL  },
    {ERROR_INVALID_COMBOBOX_MESSAGE /* 1422L */, EINVAL  },
    {ERROR_WINDOW_NOT_COMBOBOX /* 1423L */, EINVAL  },
    {ERROR_INVALID_EDIT_HEIGHT /* 1424L */, EINVAL  },
    {ERROR_DC_NOT_FOUND /* 1425L */, EFAULT  },
    {ERROR_INVALID_HOOK_FILTER /* 1426L */, EINVAL  },
    {ERROR_INVALID_FILTER_PROC /* 1427L */, EINVAL  },
    {ERROR_HOOK_NEEDS_HMOD /* 1428L */, EINVAL  },
    {ERROR_GLOBAL_ONLY_HOOK /* 1429L */, EINVAL  },
    {ERROR_JOURNAL_HOOK_SET /* 1430L */, EINVAL  },
    {ERROR_HOOK_NOT_INSTALLED /* 1431L */, EPERM  },
    {ERROR_INVALID_LB_MESSAGE /* 1432L */, EINVAL  },
    {ERROR_SETCOUNT_ON_BAD_LB /* 1433L */, EINVAL  },
    {ERROR_LB_WITHOUT_TABSTOPS /* 1434L */, EPERM  },
    {ERROR_DESTROY_OBJECT_OF_OTHER_THREAD /* 1435L */, EPERM  },
    {ERROR_CHILD_WINDOW_MENU /* 1436L */, EINVAL  },
    {ERROR_NO_SYSTEM_MENU /* 1437L */, EINVAL  },
    {ERROR_INVALID_MSGBOX_STYLE /* 1438L */, EINVAL  },
    {ERROR_INVALID_SPI_VALUE /* 1439L */, EINVAL  },
    {ERROR_SCREEN_ALREADY_LOCKED /* 1440L */, EPERM  },
    {ERROR_HWNDS_HAVE_DIFF_PARENT /* 1441L */, EINVAL  },
    {ERROR_NOT_CHILD_WINDOW /* 1442L */, EPERM  },
    {ERROR_INVALID_GW_COMMAND /* 1443L */, EINVAL  },
    {ERROR_INVALID_THREAD_ID /* 1444L */, EINVAL  },
    {ERROR_NON_MDICHILD_WINDOW /* 1445L */, EPERM  },
    {ERROR_POPUP_ALREADY_ACTIVE /* 1446L */, EPERM  },
    {ERROR_NO_SCROLLBARS /* 1447L */, EPERM  },
    {ERROR_INVALID_SCROLLBAR_RANGE /* 1448L */, EINVAL  },
    {ERROR_INVALID_SHOWWIN_COMMAND /* 1449L */, EINVAL  },
    {ERROR_NO_SYSTEM_RESOURCES /* 1450L */, EAGAIN  },
    {ERROR_NONPAGED_SYSTEM_RESOURCES /* 1451L */, EAGAIN  },
    {ERROR_PAGED_SYSTEM_RESOURCES /* 1452L */, EAGAIN  },
    {ERROR_WORKING_SET_QUOTA /* 1453L */, EAGAIN  },
    {ERROR_PAGEFILE_QUOTA /* 1454L */, EAGAIN  },
    {ERROR_COMMITMENT_LIMIT /* 1455L */, EAGAIN  },
    {ERROR_MENU_ITEM_NOT_FOUND /* 1456L */, EINVAL  },
    {ERROR_INVALID_KEYBOARD_HANDLE /* 1457L */, EBADF  },
    {ERROR_HOOK_TYPE_NOT_ALLOWED /* 1458L */, EPERM  },
    {ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION /* 1459L */, EPERM  },
    {ERROR_TIMEOUT /* 1460L */, EBUSY  },
    {ERROR_INVALID_MONITOR_HANDLE /* 1461L */, EBADF  },
    {ERROR_EVENTLOG_FILE_CORRUPT /* 1500L */, EIO  },
    {ERROR_EVENTLOG_CANT_START /* 1501L */, EIO  },
    {ERROR_LOG_FILE_FULL /* 1502L */, ENOSPC  },
    {ERROR_EVENTLOG_FILE_CHANGED /* 1503L */, EBADF  },
    {ERROR_INSTALL_SERVICE_FAILURE /* 1601L */, EIO  },
    {ERROR_INSTALL_USEREXIT /* 1602L */, EINTR  },
    {ERROR_INSTALL_FAILURE /* 1603L */, EIO  },
    {ERROR_INSTALL_SUSPEND /* 1604L */, EINTR  },
    {ERROR_UNKNOWN_PRODUCT /* 1605L */, EINVAL  },
    {ERROR_UNKNOWN_FEATURE /* 1606L */, EINVAL  },
    {ERROR_UNKNOWN_COMPONENT /* 1607L */, EINVAL  },
    {ERROR_UNKNOWN_PROPERTY /* 1608L */, EINVAL  },
    {ERROR_INVALID_HANDLE_STATE /* 1609L */, EINVAL  },
    {ERROR_BAD_CONFIGURATION /* 1610L */, EIO  },
    {ERROR_INDEX_ABSENT /* 1611L */, EINVAL  },
    {ERROR_INSTALL_SOURCE_ABSENT /* 1612L */, ENOENT  },
    {ERROR_INSTALL_PACKAGE_VERSION /* 1613L */, ENOSYS  },
    {ERROR_PRODUCT_UNINSTALLED /* 1614L */, ENOENT  },
    {ERROR_BAD_QUERY_SYNTAX /* 1615L */, EINVAL  },
    {ERROR_INVALID_FIELD /* 1616L */, EINVAL  },
    {ERROR_DEVICE_REMOVED /* 1617L */, ENODEV  },
    {ERROR_INSTALL_ALREADY_RUNNING /* 1618L */, EBUSY  },
    {ERROR_INSTALL_PACKAGE_OPEN_FAILED /* 1619L */, ENOENT  },
    {ERROR_INSTALL_PACKAGE_INVALID /* 1620L */, EIO  },
    {ERROR_INSTALL_UI_FAILURE /* 1621L */, EINVAL  },
    {ERROR_INSTALL_LOG_FAILURE /* 1622L */, ENOENT  },
    {ERROR_INSTALL_LANGUAGE_UNSUPPORTED /* 1623L */, ENOSYS  },
    {ERROR_INSTALL_TRANSFORM_FAILURE /* 1624L */, EINVAL  },
    {ERROR_INSTALL_PACKAGE_REJECTED /* 1625L */, EPERM  },
    {ERROR_FUNCTION_NOT_CALLED /* 1626L */, EPERM  },
    {ERROR_FUNCTION_FAILED /* 1627L */, EINVAL  },
    {ERROR_INVALID_TABLE /* 1628L */, EINVAL  },
    {ERROR_DATATYPE_MISMATCH /* 1629L */, EINVAL  },
    {ERROR_UNSUPPORTED_TYPE /* 1630L */, ENOSYS  },
    {ERROR_CREATE_FAILED /* 1631L */, EINVAL  },
    {ERROR_INSTALL_TEMP_UNWRITABLE /* 1632L */, EACCES  },
    {ERROR_INSTALL_PLATFORM_UNSUPPORTED /* 1633L */, ENOSYS  },
    {ERROR_INSTALL_NOTUSED /* 1634L */, EINVAL  },
    {ERROR_PATCH_PACKAGE_OPEN_FAILED /* 1635L */, EIO  },
    {ERROR_PATCH_PACKAGE_INVALID /* 1636L */, EINVAL  },
    {ERROR_PATCH_PACKAGE_UNSUPPORTED /* 1637L */, ENOSYS  },
    {ERROR_PRODUCT_VERSION /* 1638L */, EINVAL  },
    {ERROR_INVALID_COMMAND_LINE /* 1639L */, EINVAL  },
    {ERROR_INSTALL_REMOTE_DISALLOWED /* 1640L */, EPERM  },
    {ERROR_SUCCESS_REBOOT_INITIATED /* 1641L */, 0  },
    {ERROR_PATCH_TARGET_NOT_FOUND /* 1642L */, ENOENT  },
    {ERROR_PATCH_PACKAGE_REJECTED /* 1643L */, EPERM  },
    {ERROR_INSTALL_TRANSFORM_REJECTED /* 1644L */, EPERM  },
    {ERROR_INSTALL_REMOTE_PROHIBITED /* 1645L */, EPERM  },
#if 0
    {RPC_S_INVALID_STRING_BINDING /* 1700L */, EINVAL  },
    {RPC_S_WRONG_KIND_OF_BINDING /* 1701L */, EINVAL  },
    {RPC_S_INVALID_BINDING /* 1702L */, EINVAL  },
    {RPC_S_PROTSEQ_NOT_SUPPORTED /* 1703L */, E  },
    {RPC_S_INVALID_RPC_PROTSEQ /* 1704L */, E  },
    {RPC_S_INVALID_STRING_UUID /* 1705L */, E  },
    {RPC_S_INVALID_ENDPOINT_FORMAT /* 1706L */, E  },
    {RPC_S_INVALID_NET_ADDR /* 1707L */, E  },
    {RPC_S_NO_ENDPOINT_FOUND /* 1708L */, E  },
    {RPC_S_INVALID_TIMEOUT /* 1709L */, E  },
    {RPC_S_OBJECT_NOT_FOUND /* 1710L */, E  },
    {RPC_S_ALREADY_REGISTERED /* 1711L */, E  },
    {RPC_S_TYPE_ALREADY_REGISTERED /* 1712L */, E  },
    {RPC_S_ALREADY_LISTENING /* 1713L */, E  },
    {RPC_S_NO_PROTSEQS_REGISTERED /* 1714L */, E  },
    {RPC_S_NOT_LISTENING /* 1715L */, E  },
    {RPC_S_UNKNOWN_MGR_TYPE /* 1716L */, E  },
    {RPC_S_UNKNOWN_IF /* 1717L */, E  },
    {RPC_S_NO_BINDINGS /* 1718L */, E  },
    {RPC_S_NO_PROTSEQS /* 1719L */, E  },
    {RPC_S_CANT_CREATE_ENDPOINT /* 1720L */, E  },
    {RPC_S_OUT_OF_RESOURCES /* 1721L */, E  },
    {RPC_S_SERVER_UNAVAILABLE /* 1722L */, E  },
    {RPC_S_SERVER_TOO_BUSY /* 1723L */, E  },
    {RPC_S_INVALID_NETWORK_OPTIONS /* 1724L */, E  },
    {RPC_S_NO_CALL_ACTIVE /* 1725L */, E  },
    {RPC_S_CALL_FAILED /* 1726L */, E  },
    {RPC_S_CALL_FAILED_DNE /* 1727L */, E  },
    {RPC_S_PROTOCOL_ERROR /* 1728L */, E  },
    {RPC_S_UNSUPPORTED_TRANS_SYN /* 1730L */, E  },
    {RPC_S_UNSUPPORTED_TYPE /* 1732L */, E  },
    {RPC_S_INVALID_TAG /* 1733L */, E  },
    {RPC_S_INVALID_BOUND /* 1734L */, E  },
    {RPC_S_NO_ENTRY_NAME /* 1735L */, E  },
    {RPC_S_INVALID_NAME_SYNTAX /* 1736L */, E  },
    {RPC_S_UNSUPPORTED_NAME_SYNTAX /* 1737L */, E  },
    {RPC_S_UUID_NO_ADDRESS /* 1739L */, E  },
    {RPC_S_DUPLICATE_ENDPOINT /* 1740L */, E  },
    {RPC_S_UNKNOWN_AUTHN_TYPE /* 1741L */, E  },
    {RPC_S_MAX_CALLS_TOO_SMALL /* 1742L */, E  },
    {RPC_S_STRING_TOO_LONG /* 1743L */, E  },
    {RPC_S_PROTSEQ_NOT_FOUND /* 1744L */, E  },
    {RPC_S_PROCNUM_OUT_OF_RANGE /* 1745L */, E  },
    {RPC_S_BINDING_HAS_NO_AUTH /* 1746L */, E  },
    {RPC_S_UNKNOWN_AUTHN_SERVICE /* 1747L */, E  },
    {RPC_S_UNKNOWN_AUTHN_LEVEL /* 1748L */, E  },
    {RPC_S_INVALID_AUTH_IDENTITY /* 1749L */, E  },
    {RPC_S_UNKNOWN_AUTHZ_SERVICE /* 1750L */, E  },
    {EPT_S_INVALID_ENTRY /* 1751L */, E  },
    {EPT_S_CANT_PERFORM_OP /* 1752L */, E  },
    {EPT_S_NOT_REGISTERED /* 1753L */, E  },
    {RPC_S_NOTHING_TO_EXPORT /* 1754L */, E  },
    {RPC_S_INCOMPLETE_NAME /* 1755L */, E  },
    {RPC_S_INVALID_VERS_OPTION /* 1756L */, E  },
    {RPC_S_NO_MORE_MEMBERS /* 1757L */, E  },
    {RPC_S_NOT_ALL_OBJS_UNEXPORTED /* 1758L */, E  },
    {RPC_S_INTERFACE_NOT_FOUND /* 1759L */, E  },
    {RPC_S_ENTRY_ALREADY_EXISTS /* 1760L */, E  },
    {RPC_S_ENTRY_NOT_FOUND /* 1761L */, E  },
    {RPC_S_NAME_SERVICE_UNAVAILABLE /* 1762L */, E  },
    {RPC_S_INVALID_NAF_ID /* 1763L */, E  },
    {RPC_S_CANNOT_SUPPORT /* 1764L */, E  },
    {RPC_S_NO_CONTEXT_AVAILABLE /* 1765L */, E  },
    {RPC_S_INTERNAL_ERROR /* 1766L */, E  },
    {RPC_S_ZERO_DIVIDE /* 1767L */, E  },
    {RPC_S_ADDRESS_ERROR /* 1768L */, E  },
    {RPC_S_FP_DIV_ZERO /* 1769L */, E  },
    {RPC_S_FP_UNDERFLOW /* 1770L */, E  },
    {RPC_S_FP_OVERFLOW /* 1771L */, E  },
    {RPC_X_NO_MORE_ENTRIES /* 1772L */, E  },
    {RPC_X_SS_CHAR_TRANS_OPEN_FAIL /* 1773L */, E  },
    {RPC_X_SS_CHAR_TRANS_SHORT_FILE /* 1774L */, E  },
    {RPC_X_SS_IN_NULL_CONTEXT /* 1775L */, E  },
    {RPC_X_SS_CONTEXT_DAMAGED /* 1777L */, E  },
    {RPC_X_SS_HANDLES_MISMATCH /* 1778L */, E  },
    {RPC_X_SS_CANNOT_GET_CALL_HANDLE /* 1779L */, E  },
    {RPC_X_NULL_REF_POINTER /* 1780L */, E  },
    {RPC_X_ENUM_VALUE_OUT_OF_RANGE /* 1781L */, E  },
    {RPC_X_BYTE_COUNT_TOO_SMALL /* 1782L */, E  },
    {RPC_X_BAD_STUB_DATA /* 1783L */, E  },
    {ERROR_INVALID_USER_BUFFER /* 1784L */, E  },
    {ERROR_UNRECOGNIZED_MEDIA /* 1785L */, E  },
    {ERROR_NO_TRUST_LSA_SECRET /* 1786L */, E  },
    {ERROR_NO_TRUST_SAM_ACCOUNT /* 1787L */, E  },
    {ERROR_TRUSTED_DOMAIN_FAILURE /* 1788L */, E  },
    {ERROR_TRUSTED_RELATIONSHIP_FAILURE /* 1789L */, E  },
    {ERROR_TRUST_FAILURE /* 1790L */, E  },
    {RPC_S_CALL_IN_PROGRESS /* 1791L */, E  },
    {ERROR_NETLOGON_NOT_STARTED /* 1792L */, E  },
    {ERROR_ACCOUNT_EXPIRED /* 1793L */, E  },
    {ERROR_REDIRECTOR_HAS_OPEN_HANDLES /* 1794L */, E  },
    {ERROR_PRINTER_DRIVER_ALREADY_INSTALLED /* 1795L */, E  },
    {ERROR_UNKNOWN_PORT /* 1796L */, E  },
    {ERROR_UNKNOWN_PRINTER_DRIVER /* 1797L */, E  },
    {ERROR_UNKNOWN_PRINTPROCESSOR /* 1798L */, E  },
    {ERROR_INVALID_SEPARATOR_FILE /* 1799L */, E  },
    {ERROR_INVALID_PRIORITY /* 1800L */, E  },
    {ERROR_INVALID_PRINTER_NAME /* 1801L */, E  },
    {ERROR_PRINTER_ALREADY_EXISTS /* 1802L */, E  },
    {ERROR_INVALID_PRINTER_COMMAND /* 1803L */, E  },
    {ERROR_INVALID_DATATYPE /* 1804L */, E  },
    {ERROR_INVALID_ENVIRONMENT /* 1805L */, E  },
    {RPC_S_NO_MORE_BINDINGS /* 1806L */, E  },
    {ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT /* 1807L */, E  },
    {ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT /* 1808L */, E  },
    {ERROR_NOLOGON_SERVER_TRUST_ACCOUNT /* 1809L */, E  },
    {ERROR_DOMAIN_TRUST_INCONSISTENT /* 1810L */, E  },
    {ERROR_SERVER_HAS_OPEN_HANDLES /* 1811L */, E  },
    {ERROR_RESOURCE_DATA_NOT_FOUND /* 1812L */, E  },
    {ERROR_RESOURCE_TYPE_NOT_FOUND /* 1813L */, E  },
    {ERROR_RESOURCE_NAME_NOT_FOUND /* 1814L */, E  },
    {ERROR_RESOURCE_LANG_NOT_FOUND /* 1815L */, E  },
    {ERROR_NOT_ENOUGH_QUOTA /* 1816L */, E  },
    {RPC_S_NO_INTERFACES /* 1817L */, E  },
    {RPC_S_CALL_CANCELLED /* 1818L */, E  },
    {RPC_S_BINDING_INCOMPLETE /* 1819L */, E  },
    {RPC_S_COMM_FAILURE /* 1820L */, E  },
    {RPC_S_UNSUPPORTED_AUTHN_LEVEL /* 1821L */, E  },
    {RPC_S_NO_PRINC_NAME /* 1822L */, E  },
    {RPC_S_NOT_RPC_ERROR /* 1823L */, E  },
    {RPC_S_UUID_LOCAL_ONLY /* 1824L */, E  },
    {RPC_S_SEC_PKG_ERROR /* 1825L */, E  },
    {RPC_S_NOT_CANCELLED /* 1826L */, E  },
    {RPC_X_INVALID_ES_ACTION /* 1827L */, E  },
    {RPC_X_WRONG_ES_VERSION /* 1828L */, E  },
    {RPC_X_WRONG_STUB_VERSION /* 1829L */, E  },
    {RPC_X_INVALID_PIPE_OBJECT /* 1830L */, E  },
    {RPC_X_WRONG_PIPE_ORDER /* 1831L */, E  },
    {RPC_X_WRONG_PIPE_VERSION /* 1832L */, E  },
    {RPC_S_GROUP_MEMBER_NOT_FOUND /* 1898L */, E  },
    {EPT_S_CANT_CREATE /* 1899L */, E  },
    {RPC_S_INVALID_OBJECT /* 1900L */, E  },
    {ERROR_INVALID_TIME /* 1901L */, E  },
    {ERROR_INVALID_FORM_NAME /* 1902L */, E  },
    {ERROR_INVALID_FORM_SIZE /* 1903L */, E  },
    {ERROR_ALREADY_WAITING /* 1904L */, E  },
    {ERROR_PRINTER_DELETED /* 1905L */, E  },
    {ERROR_INVALID_PRINTER_STATE /* 1906L */, E  },
    {ERROR_PASSWORD_MUST_CHANGE /* 1907L */, E  },
    {ERROR_DOMAIN_CONTROLLER_NOT_FOUND /* 1908L */, E  },
    {ERROR_ACCOUNT_LOCKED_OUT /* 1909L */, E  },
    {OR_INVALID_OXID /* 1910L */, E  },
    {OR_INVALID_OID /* 1911L */, E  },
    {OR_INVALID_SET /* 1912L */, E  },
    {RPC_S_SEND_INCOMPLETE /* 1913L */, E  },
    {RPC_S_INVALID_ASYNC_HANDLE /* 1914L */, E  },
    {RPC_S_INVALID_ASYNC_CALL /* 1915L */, E  },
    {RPC_X_PIPE_CLOSED /* 1916L */, E  },
    {RPC_X_PIPE_DISCIPLINE_ERROR /* 1917L */, E  },
    {RPC_X_PIPE_EMPTY /* 1918L */, E  },
    {ERROR_NO_SITENAME /* 1919L */, E  },
    {ERROR_CANT_ACCESS_FILE /* 1920L */, E  },
    {ERROR_CANT_RESOLVE_FILENAME /* 1921L */, E  },
    {RPC_S_ENTRY_TYPE_MISMATCH /* 1922L */, E  },
    {RPC_S_NOT_ALL_OBJS_EXPORTED /* 1923L */, E  },
    {RPC_S_INTERFACE_NOT_EXPORTED /* 1924L */, E  },
    {RPC_S_PROFILE_NOT_ADDED /* 1925L */, E  },
    {RPC_S_PRF_ELT_NOT_ADDED /* 1926L */, E  },
    {RPC_S_PRF_ELT_NOT_REMOVED /* 1927L */, E  },
    {RPC_S_GRP_ELT_NOT_ADDED /* 1928L */, E  },
    {RPC_S_GRP_ELT_NOT_REMOVED /* 1929L */, E  },
    {ERROR_KM_DRIVER_BLOCKED /* 1930L */, E  },
    {ERROR_CONTEXT_EXPIRED /* 1931L */, E  },
    {ERROR_PER_USER_TRUST_QUOTA_EXCEEDED /* 1932L */, E  },
    {ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED /* 1933L */, E  },
    {ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED /* 1934L */, E  },
    {ERROR_INVALID_PIXEL_FORMAT /* 2000L */, E  },
    {ERROR_BAD_DRIVER /* 2001L */, E  },
    {ERROR_INVALID_WINDOW_STYLE /* 2002L */, E  },
    {ERROR_METAFILE_NOT_SUPPORTED /* 2003L */, E  },
    {ERROR_TRANSFORM_NOT_SUPPORTED /* 2004L */, E  },
    {ERROR_CLIPPING_NOT_SUPPORTED /* 2005L */, E  },
    {ERROR_INVALID_CMM /* 2010L */, E  },
    {ERROR_INVALID_PROFILE /* 2011L */, E  },
    {ERROR_TAG_NOT_FOUND /* 2012L */, E  },
    {ERROR_TAG_NOT_PRESENT /* 2013L */, E  },
    {ERROR_DUPLICATE_TAG /* 2014L */, E  },
    {ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE /* 2015L */, E  },
    {ERROR_PROFILE_NOT_FOUND /* 2016L */, E  },
    {ERROR_INVALID_COLORSPACE /* 2017L */, E  },
    {ERROR_ICM_NOT_ENABLED /* 2018L */, E  },
    {ERROR_DELETING_ICM_XFORM /* 2019L */, E  },
    {ERROR_INVALID_TRANSFORM /* 2020L */, E  },
    {ERROR_COLORSPACE_MISMATCH /* 2021L */, E  },
    {ERROR_INVALID_COLORINDEX /* 2022L */, E  },
    {ERROR_CONNECTED_OTHER_PASSWORD /* 2108L */, E  },
    {ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT /* 2109L */, E  },
    {ERROR_BAD_USERNAME /* 2202L */, E  },
    {ERROR_NOT_CONNECTED /* 2250L */, E  },
    {ERROR_OPEN_FILES /* 2401L */, E  },
    {ERROR_ACTIVE_CONNECTIONS /* 2402L */, E  },
    {ERROR_DEVICE_IN_USE /* 2404L */, E  },
    {ERROR_UNKNOWN_PRINT_MONITOR /* 3000L */, E  },
    {ERROR_PRINTER_DRIVER_IN_USE /* 3001L */, E  },
    {ERROR_SPOOL_FILE_NOT_FOUND /* 3002L */, E  },
    {ERROR_SPL_NO_STARTDOC /* 3003L */, E  },
    {ERROR_SPL_NO_ADDJOB /* 3004L */, E  },
    {ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED /* 3005L */, E  },
    {ERROR_PRINT_MONITOR_ALREADY_INSTALLED /* 3006L */, E  },
    {ERROR_INVALID_PRINT_MONITOR /* 3007L */, E  },
    {ERROR_PRINT_MONITOR_IN_USE /* 3008L */, E  },
    {ERROR_PRINTER_HAS_JOBS_QUEUED /* 3009L */, E  },
    {ERROR_SUCCESS_REBOOT_REQUIRED /* 3010L */, E  },
    {ERROR_SUCCESS_RESTART_REQUIRED /* 3011L */, E  },
    {ERROR_PRINTER_NOT_FOUND /* 3012L */, E  },
    {ERROR_PRINTER_DRIVER_WARNED /* 3013L */, E  },
    {ERROR_PRINTER_DRIVER_BLOCKED /* 3014L */, E  },
    {ERROR_WINS_INTERNAL /* 4000L */, E  },
    {ERROR_CAN_NOT_DEL_LOCAL_WINS /* 4001L */, E  },
    {ERROR_STATIC_INIT /* 4002L */, E  },
    {ERROR_INC_BACKUP /* 4003L */, E  },
    {ERROR_FULL_BACKUP /* 4004L */, E  },
    {ERROR_REC_NON_EXISTENT /* 4005L */, E  },
    {ERROR_RPL_NOT_ALLOWED /* 4006L */, E  },
    {ERROR_DHCP_ADDRESS_CONFLICT /* 4100L */, E  },
    {ERROR_WMI_GUID_NOT_FOUND /* 4200L */, E  },
    {ERROR_WMI_INSTANCE_NOT_FOUND /* 4201L */, E  },
    {ERROR_WMI_ITEMID_NOT_FOUND /* 4202L */, E  },
    {ERROR_WMI_TRY_AGAIN /* 4203L */, E  },
    {ERROR_WMI_DP_NOT_FOUND /* 4204L */, E  },
    {ERROR_WMI_UNRESOLVED_INSTANCE_REF /* 4205L */, E  },
    {ERROR_WMI_ALREADY_ENABLED /* 4206L */, E  },
    {ERROR_WMI_GUID_DISCONNECTED /* 4207L */, E  },
    {ERROR_WMI_SERVER_UNAVAILABLE /* 4208L */, E  },
    {ERROR_WMI_DP_FAILED /* 4209L */, E  },
    {ERROR_WMI_INVALID_MOF /* 4210L */, E  },
    {ERROR_WMI_INVALID_REGINFO /* 4211L */, E  },
    {ERROR_WMI_ALREADY_DISABLED /* 4212L */, E  },
    {ERROR_WMI_READ_ONLY /* 4213L */, E  },
    {ERROR_WMI_SET_FAILURE /* 4214L */, E  },
    {ERROR_INVALID_MEDIA /* 4300L */, E  },
    {ERROR_INVALID_LIBRARY /* 4301L */, E  },
    {ERROR_INVALID_MEDIA_POOL /* 4302L */, E  },
    {ERROR_DRIVE_MEDIA_MISMATCH /* 4303L */, E  },
    {ERROR_MEDIA_OFFLINE /* 4304L */, E  },
    {ERROR_LIBRARY_OFFLINE /* 4305L */, E  },
    {ERROR_EMPTY /* 4306L */, E  },
    {ERROR_NOT_EMPTY /* 4307L */, E  },
    {ERROR_MEDIA_UNAVAILABLE /* 4308L */, E  },
    {ERROR_RESOURCE_DISABLED /* 4309L */, E  },
    {ERROR_INVALID_CLEANER /* 4310L */, E  },
    {ERROR_UNABLE_TO_CLEAN /* 4311L */, E  },
    {ERROR_OBJECT_NOT_FOUND /* 4312L */, E  },
    {ERROR_DATABASE_FAILURE /* 4313L */, E  },
    {ERROR_DATABASE_FULL /* 4314L */, E  },
    {ERROR_MEDIA_INCOMPATIBLE /* 4315L */, E  },
    {ERROR_RESOURCE_NOT_PRESENT /* 4316L */, E  },
    {ERROR_INVALID_OPERATION /* 4317L */, E  },
    {ERROR_MEDIA_NOT_AVAILABLE /* 4318L */, E  },
    {ERROR_DEVICE_NOT_AVAILABLE /* 4319L */, E  },
    {ERROR_REQUEST_REFUSED /* 4320L */, E  },
    {ERROR_INVALID_DRIVE_OBJECT /* 4321L */, E  },
    {ERROR_LIBRARY_FULL /* 4322L */, E  },
    {ERROR_MEDIUM_NOT_ACCESSIBLE /* 4323L */, E  },
    {ERROR_UNABLE_TO_LOAD_MEDIUM /* 4324L */, E  },
    {ERROR_UNABLE_TO_INVENTORY_DRIVE /* 4325L */, E  },
    {ERROR_UNABLE_TO_INVENTORY_SLOT /* 4326L */, E  },
    {ERROR_UNABLE_TO_INVENTORY_TRANSPORT /* 4327L */, E  },
    {ERROR_TRANSPORT_FULL /* 4328L */, E  },
    {ERROR_CONTROLLING_IEPORT /* 4329L */, E  },
    {ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA /* 4330L */, E  },
    {ERROR_CLEANER_SLOT_SET /* 4331L */, E  },
    {ERROR_CLEANER_SLOT_NOT_SET /* 4332L */, E  },
    {ERROR_CLEANER_CARTRIDGE_SPENT /* 4333L */, E  },
    {ERROR_UNEXPECTED_OMID /* 4334L */, E  },
    {ERROR_CANT_DELETE_LAST_ITEM /* 4335L */, E  },
    {ERROR_MESSAGE_EXCEEDS_MAX_SIZE /* 4336L */, E  },
    {ERROR_VOLUME_CONTAINS_SYS_FILES /* 4337L */, E  },
    {ERROR_INDIGENOUS_TYPE /* 4338L */, E  },
    {ERROR_NO_SUPPORTING_DRIVES /* 4339L */, E  },
    {ERROR_CLEANER_CARTRIDGE_INSTALLED /* 4340L */, E  },
    {ERROR_FILE_OFFLINE /* 4350L */, E  },
    {ERROR_REMOTE_STORAGE_NOT_ACTIVE /* 4351L */, E  },
    {ERROR_REMOTE_STORAGE_MEDIA_ERROR /* 4352L */, E  },
    {ERROR_NOT_A_REPARSE_POINT /* 4390L */, E  },
    {ERROR_REPARSE_ATTRIBUTE_CONFLICT /* 4391L */, E  },
    {ERROR_INVALID_REPARSE_DATA /* 4392L */, E  },
    {ERROR_REPARSE_TAG_INVALID /* 4393L */, E  },
    {ERROR_REPARSE_TAG_MISMATCH /* 4394L */, E  },
    {ERROR_VOLUME_NOT_SIS_ENABLED /* 4500L */, E  },
    {ERROR_DEPENDENT_RESOURCE_EXISTS /* 5001L */, E  },
    {ERROR_DEPENDENCY_NOT_FOUND /* 5002L */, E  },
    {ERROR_DEPENDENCY_ALREADY_EXISTS /* 5003L */, E  },
    {ERROR_RESOURCE_NOT_ONLINE /* 5004L */, E  },
    {ERROR_HOST_NODE_NOT_AVAILABLE /* 5005L */, E  },
    {ERROR_RESOURCE_NOT_AVAILABLE /* 5006L */, E  },
    {ERROR_RESOURCE_NOT_FOUND /* 5007L */, E  },
    {ERROR_SHUTDOWN_CLUSTER /* 5008L */, E  },
    {ERROR_CANT_EVICT_ACTIVE_NODE /* 5009L */, E  },
    {ERROR_OBJECT_ALREADY_EXISTS /* 5010L */, E  },
    {ERROR_OBJECT_IN_LIST /* 5011L */, E  },
    {ERROR_GROUP_NOT_AVAILABLE /* 5012L */, E  },
    {ERROR_GROUP_NOT_FOUND /* 5013L */, E  },
    {ERROR_GROUP_NOT_ONLINE /* 5014L */, E  },
    {ERROR_HOST_NODE_NOT_RESOURCE_OWNER /* 5015L */, E  },
    {ERROR_HOST_NODE_NOT_GROUP_OWNER /* 5016L */, E  },
    {ERROR_RESMON_CREATE_FAILED /* 5017L */, E  },
    {ERROR_RESMON_ONLINE_FAILED /* 5018L */, E  },
    {ERROR_RESOURCE_ONLINE /* 5019L */, E  },
    {ERROR_QUORUM_RESOURCE /* 5020L */, E  },
    {ERROR_NOT_QUORUM_CAPABLE /* 5021L */, E  },
    {ERROR_CLUSTER_SHUTTING_DOWN /* 5022L */, E  },
    {ERROR_INVALID_STATE /* 5023L */, E  },
    {ERROR_RESOURCE_PROPERTIES_STORED /* 5024L */, E  },
    {ERROR_NOT_QUORUM_CLASS /* 5025L */, E  },
    {ERROR_CORE_RESOURCE /* 5026L */, E  },
    {ERROR_QUORUM_RESOURCE_ONLINE_FAILED /* 5027L */, E  },
    {ERROR_QUORUMLOG_OPEN_FAILED /* 5028L */, E  },
    {ERROR_CLUSTERLOG_CORRUPT /* 5029L */, E  },
    {ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE /* 5030L */, E  },
    {ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE /* 5031L */, E  },
    {ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND /* 5032L */, E  },
    {ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE /* 5033L */, E  },
    {ERROR_QUORUM_OWNER_ALIVE /* 5034L */, E  },
    {ERROR_NETWORK_NOT_AVAILABLE /* 5035L */, E  },
    {ERROR_NODE_NOT_AVAILABLE /* 5036L */, E  },
    {ERROR_ALL_NODES_NOT_AVAILABLE /* 5037L */, E  },
    {ERROR_RESOURCE_FAILED /* 5038L */, E  },
    {ERROR_CLUSTER_INVALID_NODE /* 5039L */, E  },
    {ERROR_CLUSTER_NODE_EXISTS /* 5040L */, E  },
    {ERROR_CLUSTER_JOIN_IN_PROGRESS /* 5041L */, E  },
    {ERROR_CLUSTER_NODE_NOT_FOUND /* 5042L */, E  },
    {ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND /* 5043L */, E  },
    {ERROR_CLUSTER_NETWORK_EXISTS /* 5044L */, E  },
    {ERROR_CLUSTER_NETWORK_NOT_FOUND /* 5045L */, E  },
    {ERROR_CLUSTER_NETINTERFACE_EXISTS /* 5046L */, E  },
    {ERROR_CLUSTER_NETINTERFACE_NOT_FOUND /* 5047L */, E  },
    {ERROR_CLUSTER_INVALID_REQUEST /* 5048L */, E  },
    {ERROR_CLUSTER_INVALID_NETWORK_PROVIDER /* 5049L */, E  },
    {ERROR_CLUSTER_NODE_DOWN /* 5050L */, E  },
    {ERROR_CLUSTER_NODE_UNREACHABLE /* 5051L */, E  },
    {ERROR_CLUSTER_NODE_NOT_MEMBER /* 5052L */, E  },
    {ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS /* 5053L */, E  },
    {ERROR_CLUSTER_INVALID_NETWORK /* 5054L */, E  },
    {ERROR_CLUSTER_NODE_UP /* 5056L */, E  },
    {ERROR_CLUSTER_IPADDR_IN_USE /* 5057L */, E  },
    {ERROR_CLUSTER_NODE_NOT_PAUSED /* 5058L */, E  },
    {ERROR_CLUSTER_NO_SECURITY_CONTEXT /* 5059L */, E  },
    {ERROR_CLUSTER_NETWORK_NOT_INTERNAL /* 5060L */, E  },
    {ERROR_CLUSTER_NODE_ALREADY_UP /* 5061L */, E  },
    {ERROR_CLUSTER_NODE_ALREADY_DOWN /* 5062L */, E  },
    {ERROR_CLUSTER_NETWORK_ALREADY_ONLINE /* 5063L */, E  },
    {ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE /* 5064L */, E  },
    {ERROR_CLUSTER_NODE_ALREADY_MEMBER /* 5065L */, E  },
    {ERROR_CLUSTER_LAST_INTERNAL_NETWORK /* 5066L */, E  },
    {ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS /* 5067L */, E  },
    {ERROR_INVALID_OPERATION_ON_QUORUM /* 5068L */, E  },
    {ERROR_DEPENDENCY_NOT_ALLOWED /* 5069L */, E  },
    {ERROR_CLUSTER_NODE_PAUSED /* 5070L */, E  },
    {ERROR_NODE_CANT_HOST_RESOURCE /* 5071L */, E  },
    {ERROR_CLUSTER_NODE_NOT_READY /* 5072L */, E  },
    {ERROR_CLUSTER_NODE_SHUTTING_DOWN /* 5073L */, E  },
    {ERROR_CLUSTER_JOIN_ABORTED /* 5074L */, E  },
    {ERROR_CLUSTER_INCOMPATIBLE_VERSIONS /* 5075L */, E  },
    {ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED /* 5076L */, E  },
    {ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED /* 5077L */, E  },
    {ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND /* 5078L */, E  },
    {ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED /* 5079L */, E  },
    {ERROR_CLUSTER_RESNAME_NOT_FOUND /* 5080L */, E  },
    {ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED /* 5081L */, E  },
    {ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST /* 5082L */, E  },
    {ERROR_CLUSTER_DATABASE_SEQMISMATCH /* 5083L */, E  },
    {ERROR_RESMON_INVALID_STATE /* 5084L */, E  },
    {ERROR_CLUSTER_GUM_NOT_LOCKER /* 5085L */, E  },
    {ERROR_QUORUM_DISK_NOT_FOUND /* 5086L */, E  },
    {ERROR_DATABASE_BACKUP_CORRUPT /* 5087L */, E  },
    {ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT /* 5088L */, E  },
    {ERROR_RESOURCE_PROPERTY_UNCHANGEABLE /* 5089L */, E  },
    {ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE /* 5890L */, E  },
    {ERROR_CLUSTER_QUORUMLOG_NOT_FOUND /* 5891L */, E  },
    {ERROR_CLUSTER_MEMBERSHIP_HALT /* 5892L */, E  },
    {ERROR_CLUSTER_INSTANCE_ID_MISMATCH /* 5893L */, E  },
    {ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP /* 5894L */, E  },
    {ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH /* 5895L */, E  },
    {ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP /* 5896L */, E  },
    {ERROR_CLUSTER_PARAMETER_MISMATCH /* 5897L */, E  },
    {ERROR_NODE_CANNOT_BE_CLUSTERED /* 5898L */, E  },
    {ERROR_CLUSTER_WRONG_OS_VERSION /* 5899L */, E  },
    {ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME /* 5900L */, E  },
    {ERROR_CLUSCFG_ALREADY_COMMITTED /* 5901L */, E  },
    {ERROR_CLUSCFG_ROLLBACK_FAILED /* 5902L */, E  },
    {ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT /* 5903L */, E  },
    {ERROR_CLUSTER_OLD_VERSION /* 5904L */, E  },
    {ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME /* 5905L */, E  },
    {ERROR_ENCRYPTION_FAILED /* 6000L */, E  },
    {ERROR_DECRYPTION_FAILED /* 6001L */, E  },
    {ERROR_FILE_ENCRYPTED /* 6002L */, E  },
    {ERROR_NO_RECOVERY_POLICY /* 6003L */, E  },
    {ERROR_NO_EFS /* 6004L */, E  },
    {ERROR_WRONG_EFS /* 6005L */, E  },
    {ERROR_NO_USER_KEYS /* 6006L */, E  },
    {ERROR_FILE_NOT_ENCRYPTED /* 6007L */, E  },
    {ERROR_NOT_EXPORT_FORMAT /* 6008L */, E  },
    {ERROR_FILE_READ_ONLY /* 6009L */, E  },
    {ERROR_DIR_EFS_DISALLOWED /* 6010L */, E  },
    {ERROR_EFS_SERVER_NOT_TRUSTED /* 6011L */, E  },
    {ERROR_BAD_RECOVERY_POLICY /* 6012L */, E  },
    {ERROR_EFS_ALG_BLOB_TOO_BIG /* 6013L */, E  },
    {ERROR_VOLUME_NOT_SUPPORT_EFS /* 6014L */, E  },
    {ERROR_EFS_DISABLED /* 6015L */, E  },
    {ERROR_EFS_VERSION_NOT_SUPPORT /* 6016L */, E  },
    {ERROR_NO_BROWSER_SERVERS_FOUND /* 6118L */, E  },
    {SCHED_E_SERVICE_NOT_LOCALSYSTEM /* 6200L */, E  },
    {ERROR_CTX_WINSTATION_NAME_INVALID /* 7001L */, E  },
    {ERROR_CTX_INVALID_PD /* 7002L */, E  },
    {ERROR_CTX_PD_NOT_FOUND /* 7003L */, E  },
    {ERROR_CTX_WD_NOT_FOUND /* 7004L */, E  },
    {ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY /* 7005L */, E  },
    {ERROR_CTX_SERVICE_NAME_COLLISION /* 7006L */, E  },
    {ERROR_CTX_CLOSE_PENDING /* 7007L */, E  },
    {ERROR_CTX_NO_OUTBUF /* 7008L */, E  },
    {ERROR_CTX_MODEM_INF_NOT_FOUND /* 7009L */, E  },
    {ERROR_CTX_INVALID_MODEMNAME /* 7010L */, E  },
    {ERROR_CTX_MODEM_RESPONSE_ERROR /* 7011L */, E  },
    {ERROR_CTX_MODEM_RESPONSE_TIMEOUT /* 7012L */, E  },
    {ERROR_CTX_MODEM_RESPONSE_NO_CARRIER /* 7013L */, E  },
    {ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE /* 7014L */, E  },
    {ERROR_CTX_MODEM_RESPONSE_BUSY /* 7015L */, E  },
    {ERROR_CTX_MODEM_RESPONSE_VOICE /* 7016L */, E  },
    {ERROR_CTX_TD_ERROR /* 7017L */, E  },
    {ERROR_CTX_WINSTATION_NOT_FOUND /* 7022L */, E  },
    {ERROR_CTX_WINSTATION_ALREADY_EXISTS /* 7023L */, E  },
    {ERROR_CTX_WINSTATION_BUSY /* 7024L */, E  },
    {ERROR_CTX_BAD_VIDEO_MODE /* 7025L */, E  },
    {ERROR_CTX_GRAPHICS_INVALID /* 7035L */, E  },
    {ERROR_CTX_LOGON_DISABLED /* 7037L */, E  },
    {ERROR_CTX_NOT_CONSOLE /* 7038L */, E  },
    {ERROR_CTX_CLIENT_QUERY_TIMEOUT /* 7040L */, E  },
    {ERROR_CTX_CONSOLE_DISCONNECT /* 7041L */, E  },
    {ERROR_CTX_CONSOLE_CONNECT /* 7042L */, E  },
    {ERROR_CTX_SHADOW_DENIED /* 7044L */, E  },
    {ERROR_CTX_WINSTATION_ACCESS_DENIED /* 7045L */, E  },
    {ERROR_CTX_INVALID_WD /* 7049L */, E  },
    {ERROR_CTX_SHADOW_INVALID /* 7050L */, E  },
    {ERROR_CTX_SHADOW_DISABLED /* 7051L */, E  },
    {ERROR_CTX_CLIENT_LICENSE_IN_USE /* 7052L */, E  },
    {ERROR_CTX_CLIENT_LICENSE_NOT_SET /* 7053L */, E  },
    {ERROR_CTX_LICENSE_NOT_AVAILABLE /* 7054L */, E  },
    {ERROR_CTX_LICENSE_CLIENT_INVALID /* 7055L */, E  },
    {ERROR_CTX_LICENSE_EXPIRED /* 7056L */, E  },
    {ERROR_CTX_SHADOW_NOT_RUNNING /* 7057L */, E  },
    {ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE /* 7058L */, E  },
    {ERROR_ACTIVATION_COUNT_EXCEEDED /* 7059L */, E  },
    {FRS_ERR_INVALID_API_SEQUENCE /* 8001L */, E  },
    {FRS_ERR_STARTING_SERVICE /* 8002L */, E  },
    {FRS_ERR_STOPPING_SERVICE /* 8003L */, E  },
    {FRS_ERR_INTERNAL_API /* 8004L */, E  },
    {FRS_ERR_INTERNAL /* 8005L */, E  },
    {FRS_ERR_SERVICE_COMM /* 8006L */, E  },
    {FRS_ERR_INSUFFICIENT_PRIV /* 8007L */, E  },
    {FRS_ERR_AUTHENTICATION /* 8008L */, E  },
    {FRS_ERR_PARENT_INSUFFICIENT_PRIV /* 8009L */, E  },
    {FRS_ERR_PARENT_AUTHENTICATION /* 8010L */, E  },
    {FRS_ERR_CHILD_TO_PARENT_COMM /* 8011L */, E  },
    {FRS_ERR_PARENT_TO_CHILD_COMM /* 8012L */, E  },
    {FRS_ERR_SYSVOL_POPULATE /* 8013L */, E  },
    {FRS_ERR_SYSVOL_POPULATE_TIMEOUT /* 8014L */, E  },
    {FRS_ERR_SYSVOL_IS_BUSY /* 8015L */, E  },
    {FRS_ERR_SYSVOL_DEMOTE /* 8016L */, E  },
    {FRS_ERR_INVALID_SERVICE_PARAMETER /* 8017L */, E  },
    {ERROR_DS_NOT_INSTALLED /* 8200L */, E  },
    {ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY /* 8201L */, E  },
    {ERROR_DS_NO_ATTRIBUTE_OR_VALUE /* 8202L */, E  },
    {ERROR_DS_INVALID_ATTRIBUTE_SYNTAX /* 8203L */, E  },
    {ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED /* 8204L */, E  },
    {ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS /* 8205L */, E  },
    {ERROR_DS_BUSY /* 8206L */, E  },
    {ERROR_DS_UNAVAILABLE /* 8207L */, E  },
    {ERROR_DS_NO_RIDS_ALLOCATED /* 8208L */, E  },
    {ERROR_DS_NO_MORE_RIDS /* 8209L */, E  },
    {ERROR_DS_INCORRECT_ROLE_OWNER /* 8210L */, E  },
    {ERROR_DS_RIDMGR_INIT_ERROR /* 8211L */, E  },
    {ERROR_DS_OBJ_CLASS_VIOLATION /* 8212L */, E  },
    {ERROR_DS_CANT_ON_NON_LEAF /* 8213L */, E  },
    {ERROR_DS_CANT_ON_RDN /* 8214L */, E  },
    {ERROR_DS_CANT_MOD_OBJ_CLASS /* 8215L */, E  },
    {ERROR_DS_CROSS_DOM_MOVE_ERROR /* 8216L */, E  },
    {ERROR_DS_GC_NOT_AVAILABLE /* 8217L */, E  },
    {ERROR_SHARED_POLICY /* 8218L */, E  },
    {ERROR_POLICY_OBJECT_NOT_FOUND /* 8219L */, E  },
    {ERROR_POLICY_ONLY_IN_DS /* 8220L */, E  },
    {ERROR_PROMOTION_ACTIVE /* 8221L */, E  },
    {ERROR_NO_PROMOTION_ACTIVE /* 8222L */, E  },
    {ERROR_DS_OPERATIONS_ERROR /* 8224L */, E  },
    {ERROR_DS_PROTOCOL_ERROR /* 8225L */, E  },
    {ERROR_DS_TIMELIMIT_EXCEEDED /* 8226L */, E  },
    {ERROR_DS_SIZELIMIT_EXCEEDED /* 8227L */, E  },
    {ERROR_DS_ADMIN_LIMIT_EXCEEDED /* 8228L */, E  },
    {ERROR_DS_COMPARE_FALSE /* 8229L */, E  },
    {ERROR_DS_COMPARE_TRUE /* 8230L */, E  },
    {ERROR_DS_AUTH_METHOD_NOT_SUPPORTED /* 8231L */, E  },
    {ERROR_DS_STRONG_AUTH_REQUIRED /* 8232L */, E  },
    {ERROR_DS_INAPPROPRIATE_AUTH /* 8233L */, E  },
    {ERROR_DS_AUTH_UNKNOWN /* 8234L */, E  },
    {ERROR_DS_REFERRAL /* 8235L */, E  },
    {ERROR_DS_UNAVAILABLE_CRIT_EXTENSION /* 8236L */, E  },
    {ERROR_DS_CONFIDENTIALITY_REQUIRED /* 8237L */, E  },
    {ERROR_DS_INAPPROPRIATE_MATCHING /* 8238L */, E  },
    {ERROR_DS_CONSTRAINT_VIOLATION /* 8239L */, E  },
    {ERROR_DS_NO_SUCH_OBJECT /* 8240L */, E  },
    {ERROR_DS_ALIAS_PROBLEM /* 8241L */, E  },
    {ERROR_DS_INVALID_DN_SYNTAX /* 8242L */, E  },
    {ERROR_DS_IS_LEAF /* 8243L */, E  },
    {ERROR_DS_ALIAS_DEREF_PROBLEM /* 8244L */, E  },
    {ERROR_DS_UNWILLING_TO_PERFORM /* 8245L */, E  },
    {ERROR_DS_LOOP_DETECT /* 8246L */, E  },
    {ERROR_DS_NAMING_VIOLATION /* 8247L */, E  },
    {ERROR_DS_OBJECT_RESULTS_TOO_LARGE /* 8248L */, E  },
    {ERROR_DS_AFFECTS_MULTIPLE_DSAS /* 8249L */, E  },
    {ERROR_DS_SERVER_DOWN /* 8250L */, E  },
    {ERROR_DS_LOCAL_ERROR /* 8251L */, E  },
    {ERROR_DS_ENCODING_ERROR /* 8252L */, E  },
    {ERROR_DS_DECODING_ERROR /* 8253L */, E  },
    {ERROR_DS_FILTER_UNKNOWN /* 8254L */, E  },
    {ERROR_DS_PARAM_ERROR /* 8255L */, E  },
    {ERROR_DS_NOT_SUPPORTED /* 8256L */, E  },
    {ERROR_DS_NO_RESULTS_RETURNED /* 8257L */, E  },
    {ERROR_DS_CONTROL_NOT_FOUND /* 8258L */, E  },
    {ERROR_DS_CLIENT_LOOP /* 8259L */, E  },
    {ERROR_DS_REFERRAL_LIMIT_EXCEEDED /* 8260L */, E  },
    {ERROR_DS_SORT_CONTROL_MISSING /* 8261L */, E  },
    {ERROR_DS_OFFSET_RANGE_ERROR /* 8262L */, E  },
    {ERROR_DS_ROOT_MUST_BE_NC /* 8301L */, E  },
    {ERROR_DS_ADD_REPLICA_INHIBITED /* 8302L */, E  },
    {ERROR_DS_ATT_NOT_DEF_IN_SCHEMA /* 8303L */, E  },
    {ERROR_DS_MAX_OBJ_SIZE_EXCEEDED /* 8304L */, E  },
    {ERROR_DS_OBJ_STRING_NAME_EXISTS /* 8305L */, E  },
    {ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA /* 8306L */, E  },
    {ERROR_DS_RDN_DOESNT_MATCH_SCHEMA /* 8307L */, E  },
    {ERROR_DS_NO_REQUESTED_ATTS_FOUND /* 8308L */, E  },
    {ERROR_DS_USER_BUFFER_TO_SMALL /* 8309L */, E  },
    {ERROR_DS_ATT_IS_NOT_ON_OBJ /* 8310L */, E  },
    {ERROR_DS_ILLEGAL_MOD_OPERATION /* 8311L */, E  },
    {ERROR_DS_OBJ_TOO_LARGE /* 8312L */, E  },
    {ERROR_DS_BAD_INSTANCE_TYPE /* 8313L */, E  },
    {ERROR_DS_MASTERDSA_REQUIRED /* 8314L */, E  },
    {ERROR_DS_OBJECT_CLASS_REQUIRED /* 8315L */, E  },
    {ERROR_DS_MISSING_REQUIRED_ATT /* 8316L */, E  },
    {ERROR_DS_ATT_NOT_DEF_FOR_CLASS /* 8317L */, E  },
    {ERROR_DS_ATT_ALREADY_EXISTS /* 8318L */, E  },
    {ERROR_DS_CANT_ADD_ATT_VALUES /* 8320L */, E  },
    {ERROR_DS_SINGLE_VALUE_CONSTRAINT /* 8321L */, E  },
    {ERROR_DS_RANGE_CONSTRAINT /* 8322L */, E  },
    {ERROR_DS_ATT_VAL_ALREADY_EXISTS /* 8323L */, E  },
    {ERROR_DS_CANT_REM_MISSING_ATT /* 8324L */, E  },
    {ERROR_DS_CANT_REM_MISSING_ATT_VAL /* 8325L */, E  },
    {ERROR_DS_ROOT_CANT_BE_SUBREF /* 8326L */, E  },
    {ERROR_DS_NO_CHAINING /* 8327L */, E  },
    {ERROR_DS_NO_CHAINED_EVAL /* 8328L */, E  },
    {ERROR_DS_NO_PARENT_OBJECT /* 8329L */, E  },
    {ERROR_DS_PARENT_IS_AN_ALIAS /* 8330L */, E  },
    {ERROR_DS_CANT_MIX_MASTER_AND_REPS /* 8331L */, E  },
    {ERROR_DS_CHILDREN_EXIST /* 8332L */, E  },
    {ERROR_DS_OBJ_NOT_FOUND /* 8333L */, E  },
    {ERROR_DS_ALIASED_OBJ_MISSING /* 8334L */, E  },
    {ERROR_DS_BAD_NAME_SYNTAX /* 8335L */, E  },
    {ERROR_DS_ALIAS_POINTS_TO_ALIAS /* 8336L */, E  },
    {ERROR_DS_CANT_DEREF_ALIAS /* 8337L */, E  },
    {ERROR_DS_OUT_OF_SCOPE /* 8338L */, E  },
    {ERROR_DS_OBJECT_BEING_REMOVED /* 8339L */, E  },
    {ERROR_DS_CANT_DELETE_DSA_OBJ /* 8340L */, E  },
    {ERROR_DS_GENERIC_ERROR /* 8341L */, E  },
    {ERROR_DS_DSA_MUST_BE_INT_MASTER /* 8342L */, E  },
    {ERROR_DS_CLASS_NOT_DSA /* 8343L */, E  },
    {ERROR_DS_INSUFF_ACCESS_RIGHTS /* 8344L */, E  },
    {ERROR_DS_ILLEGAL_SUPERIOR /* 8345L */, E  },
    {ERROR_DS_ATTRIBUTE_OWNED_BY_SAM /* 8346L */, E  },
    {ERROR_DS_NAME_TOO_MANY_PARTS /* 8347L */, E  },
    {ERROR_DS_NAME_TOO_LONG /* 8348L */, E  },
    {ERROR_DS_NAME_VALUE_TOO_LONG /* 8349L */, E  },
    {ERROR_DS_NAME_UNPARSEABLE /* 8350L */, E  },
    {ERROR_DS_NAME_TYPE_UNKNOWN /* 8351L */, E  },
    {ERROR_DS_NOT_AN_OBJECT /* 8352L */, E  },
    {ERROR_DS_SEC_DESC_TOO_SHORT /* 8353L */, E  },
    {ERROR_DS_SEC_DESC_INVALID /* 8354L */, E  },
    {ERROR_DS_NO_DELETED_NAME /* 8355L */, E  },
    {ERROR_DS_SUBREF_MUST_HAVE_PARENT /* 8356L */, E  },
    {ERROR_DS_NCNAME_MUST_BE_NC /* 8357L */, E  },
    {ERROR_DS_CANT_ADD_SYSTEM_ONLY /* 8358L */, E  },
    {ERROR_DS_CLASS_MUST_BE_CONCRETE /* 8359L */, E  },
    {ERROR_DS_INVALID_DMD /* 8360L */, E  },
    {ERROR_DS_OBJ_GUID_EXISTS /* 8361L */, E  },
    {ERROR_DS_NOT_ON_BACKLINK /* 8362L */, E  },
    {ERROR_DS_NO_CROSSREF_FOR_NC /* 8363L */, E  },
    {ERROR_DS_SHUTTING_DOWN /* 8364L */, E  },
    {ERROR_DS_UNKNOWN_OPERATION /* 8365L */, E  },
    {ERROR_DS_INVALID_ROLE_OWNER /* 8366L */, E  },
    {ERROR_DS_COULDNT_CONTACT_FSMO /* 8367L */, E  },
    {ERROR_DS_CROSS_NC_DN_RENAME /* 8368L */, E  },
    {ERROR_DS_CANT_MOD_SYSTEM_ONLY /* 8369L */, E  },
    {ERROR_DS_REPLICATOR_ONLY /* 8370L */, E  },
    {ERROR_DS_OBJ_CLASS_NOT_DEFINED /* 8371L */, E  },
    {ERROR_DS_OBJ_CLASS_NOT_SUBCLASS /* 8372L */, E  },
    {ERROR_DS_NAME_REFERENCE_INVALID /* 8373L */, E  },
    {ERROR_DS_CROSS_REF_EXISTS /* 8374L */, E  },
    {ERROR_DS_CANT_DEL_MASTER_CROSSREF /* 8375L */, E  },
    {ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD /* 8376L */, E  },
    {ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX /* 8377L */, E  },
    {ERROR_DS_DUP_RDN /* 8378L */, E  },
    {ERROR_DS_DUP_OID /* 8379L */, E  },
    {ERROR_DS_DUP_MAPI_ID /* 8380L */, E  },
    {ERROR_DS_DUP_SCHEMA_ID_GUID /* 8381L */, E  },
    {ERROR_DS_DUP_LDAP_DISPLAY_NAME /* 8382L */, E  },
    {ERROR_DS_SEMANTIC_ATT_TEST /* 8383L */, E  },
    {ERROR_DS_SYNTAX_MISMATCH /* 8384L */, E  },
    {ERROR_DS_EXISTS_IN_MUST_HAVE /* 8385L */, E  },
    {ERROR_DS_EXISTS_IN_MAY_HAVE /* 8386L */, E  },
    {ERROR_DS_NONEXISTENT_MAY_HAVE /* 8387L */, E  },
    {ERROR_DS_NONEXISTENT_MUST_HAVE /* 8388L */, E  },
    {ERROR_DS_AUX_CLS_TEST_FAIL /* 8389L */, E  },
    {ERROR_DS_NONEXISTENT_POSS_SUP /* 8390L */, E  },
    {ERROR_DS_SUB_CLS_TEST_FAIL /* 8391L */, E  },
    {ERROR_DS_BAD_RDN_ATT_ID_SYNTAX /* 8392L */, E  },
    {ERROR_DS_EXISTS_IN_AUX_CLS /* 8393L */, E  },
    {ERROR_DS_EXISTS_IN_SUB_CLS /* 8394L */, E  },
    {ERROR_DS_EXISTS_IN_POSS_SUP /* 8395L */, E  },
    {ERROR_DS_RECALCSCHEMA_FAILED /* 8396L */, E  },
    {ERROR_DS_TREE_DELETE_NOT_FINISHED /* 8397L */, E  },
    {ERROR_DS_CANT_DELETE /* 8398L */, E  },
    {ERROR_DS_ATT_SCHEMA_REQ_ID /* 8399L */, E  },
    {ERROR_DS_BAD_ATT_SCHEMA_SYNTAX /* 8400L */, E  },
    {ERROR_DS_CANT_CACHE_ATT /* 8401L */, E  },
    {ERROR_DS_CANT_CACHE_CLASS /* 8402L */, E  },
    {ERROR_DS_CANT_REMOVE_ATT_CACHE /* 8403L */, E  },
    {ERROR_DS_CANT_REMOVE_CLASS_CACHE /* 8404L */, E  },
    {ERROR_DS_CANT_RETRIEVE_DN /* 8405L */, E  },
    {ERROR_DS_MISSING_SUPREF /* 8406L */, E  },
    {ERROR_DS_CANT_RETRIEVE_INSTANCE /* 8407L */, E  },
    {ERROR_DS_CODE_INCONSISTENCY /* 8408L */, E  },
    {ERROR_DS_DATABASE_ERROR /* 8409L */, E  },
    {ERROR_DS_GOVERNSID_MISSING /* 8410L */, E  },
    {ERROR_DS_MISSING_EXPECTED_ATT /* 8411L */, E  },
    {ERROR_DS_NCNAME_MISSING_CR_REF /* 8412L */, E  },
    {ERROR_DS_SECURITY_CHECKING_ERROR /* 8413L */, E  },
    {ERROR_DS_SCHEMA_NOT_LOADED /* 8414L */, E  },
    {ERROR_DS_SCHEMA_ALLOC_FAILED /* 8415L */, E  },
    {ERROR_DS_ATT_SCHEMA_REQ_SYNTAX /* 8416L */, E  },
    {ERROR_DS_GCVERIFY_ERROR /* 8417L */, E  },
    {ERROR_DS_DRA_SCHEMA_MISMATCH /* 8418L */, E  },
    {ERROR_DS_CANT_FIND_DSA_OBJ /* 8419L */, E  },
    {ERROR_DS_CANT_FIND_EXPECTED_NC /* 8420L */, E  },
    {ERROR_DS_CANT_FIND_NC_IN_CACHE /* 8421L */, E  },
    {ERROR_DS_CANT_RETRIEVE_CHILD /* 8422L */, E  },
    {ERROR_DS_SECURITY_ILLEGAL_MODIFY /* 8423L */, E  },
    {ERROR_DS_CANT_REPLACE_HIDDEN_REC /* 8424L */, E  },
    {ERROR_DS_BAD_HIERARCHY_FILE /* 8425L */, E  },
    {ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED /* 8426L */, E  },
    {ERROR_DS_CONFIG_PARAM_MISSING /* 8427L */, E  },
    {ERROR_DS_COUNTING_AB_INDICES_FAILED /* 8428L */, E  },
    {ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED /* 8429L */, E  },
    {ERROR_DS_INTERNAL_FAILURE /* 8430L */, E  },
    {ERROR_DS_UNKNOWN_ERROR /* 8431L */, E  },
    {ERROR_DS_ROOT_REQUIRES_CLASS_TOP /* 8432L */, E  },
    {ERROR_DS_REFUSING_FSMO_ROLES /* 8433L */, E  },
    {ERROR_DS_MISSING_FSMO_SETTINGS /* 8434L */, E  },
    {ERROR_DS_UNABLE_TO_SURRENDER_ROLES /* 8435L */, E  },
    {ERROR_DS_DRA_GENERIC /* 8436L */, E  },
    {ERROR_DS_DRA_INVALID_PARAMETER /* 8437L */, E  },
    {ERROR_DS_DRA_BUSY /* 8438L */, E  },
    {ERROR_DS_DRA_BAD_DN /* 8439L */, E  },
    {ERROR_DS_DRA_BAD_NC /* 8440L */, E  },
    {ERROR_DS_DRA_DN_EXISTS /* 8441L */, E  },
    {ERROR_DS_DRA_INTERNAL_ERROR /* 8442L */, E  },
    {ERROR_DS_DRA_INCONSISTENT_DIT /* 8443L */, E  },
    {ERROR_DS_DRA_CONNECTION_FAILED /* 8444L */, E  },
    {ERROR_DS_DRA_BAD_INSTANCE_TYPE /* 8445L */, E  },
    {ERROR_DS_DRA_OUT_OF_MEM /* 8446L */, E  },
    {ERROR_DS_DRA_MAIL_PROBLEM /* 8447L */, E  },
    {ERROR_DS_DRA_REF_ALREADY_EXISTS /* 8448L */, E  },
    {ERROR_DS_DRA_REF_NOT_FOUND /* 8449L */, E  },
    {ERROR_DS_DRA_OBJ_IS_REP_SOURCE /* 8450L */, E  },
    {ERROR_DS_DRA_DB_ERROR /* 8451L */, E  },
    {ERROR_DS_DRA_NO_REPLICA /* 8452L */, E  },
    {ERROR_DS_DRA_ACCESS_DENIED /* 8453L */, E  },
    {ERROR_DS_DRA_NOT_SUPPORTED /* 8454L */, E  },
    {ERROR_DS_DRA_RPC_CANCELLED /* 8455L */, E  },
    {ERROR_DS_DRA_SOURCE_DISABLED /* 8456L */, E  },
    {ERROR_DS_DRA_SINK_DISABLED /* 8457L */, E  },
    {ERROR_DS_DRA_NAME_COLLISION /* 8458L */, E  },
    {ERROR_DS_DRA_SOURCE_REINSTALLED /* 8459L */, E  },
    {ERROR_DS_DRA_MISSING_PARENT /* 8460L */, E  },
    {ERROR_DS_DRA_PREEMPTED /* 8461L */, E  },
    {ERROR_DS_DRA_ABANDON_SYNC /* 8462L */, E  },
    {ERROR_DS_DRA_SHUTDOWN /* 8463L */, E  },
    {ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET /* 8464L */, E  },
    {ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA /* 8465L */, E  },
    {ERROR_DS_DRA_EXTN_CONNECTION_FAILED /* 8466L */, E  },
    {ERROR_DS_INSTALL_SCHEMA_MISMATCH /* 8467L */, E  },
    {ERROR_DS_DUP_LINK_ID /* 8468L */, E  },
    {ERROR_DS_NAME_ERROR_RESOLVING /* 8469L */, E  },
    {ERROR_DS_NAME_ERROR_NOT_FOUND /* 8470L */, E  },
    {ERROR_DS_NAME_ERROR_NOT_UNIQUE /* 8471L */, E  },
    {ERROR_DS_NAME_ERROR_NO_MAPPING /* 8472L */, E  },
    {ERROR_DS_NAME_ERROR_DOMAIN_ONLY /* 8473L */, E  },
    {ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING /* 8474L */, E  },
    {ERROR_DS_CONSTRUCTED_ATT_MOD /* 8475L */, E  },
    {ERROR_DS_WRONG_OM_OBJ_CLASS /* 8476L */, E  },
    {ERROR_DS_DRA_REPL_PENDING /* 8477L */, E  },
    {ERROR_DS_DS_REQUIRED /* 8478L */, E  },
    {ERROR_DS_INVALID_LDAP_DISPLAY_NAME /* 8479L */, E  },
    {ERROR_DS_NON_BASE_SEARCH /* 8480L */, E  },
    {ERROR_DS_CANT_RETRIEVE_ATTS /* 8481L */, E  },
    {ERROR_DS_BACKLINK_WITHOUT_LINK /* 8482L */, E  },
    {ERROR_DS_EPOCH_MISMATCH /* 8483L */, E  },
    {ERROR_DS_SRC_NAME_MISMATCH /* 8484L */, E  },
    {ERROR_DS_SRC_AND_DST_NC_IDENTICAL /* 8485L */, E  },
    {ERROR_DS_DST_NC_MISMATCH /* 8486L */, E  },
    {ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC /* 8487L */, E  },
    {ERROR_DS_SRC_GUID_MISMATCH /* 8488L */, E  },
    {ERROR_DS_CANT_MOVE_DELETED_OBJECT /* 8489L */, E  },
    {ERROR_DS_PDC_OPERATION_IN_PROGRESS /* 8490L */, E  },
    {ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD /* 8491L */, E  },
    {ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION /* 8492L */, E  },
    {ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS /* 8493L */, E  },
    {ERROR_DS_NC_MUST_HAVE_NC_PARENT /* 8494L */, E  },
    {ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE /* 8495L */, E  },
    {ERROR_DS_DST_DOMAIN_NOT_NATIVE /* 8496L */, E  },
    {ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER /* 8497L */, E  },
    {ERROR_DS_CANT_MOVE_ACCOUNT_GROUP /* 8498L */, E  },
    {ERROR_DS_CANT_MOVE_RESOURCE_GROUP /* 8499L */, E  },
    {ERROR_DS_INVALID_SEARCH_FLAG /* 8500L */, E  },
    {ERROR_DS_NO_TREE_DELETE_ABOVE_NC /* 8501L */, E  },
    {ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE /* 8502L */, E  },
    {ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE /* 8503L */, E  },
    {ERROR_DS_SAM_INIT_FAILURE /* 8504L */, E  },
    {ERROR_DS_SENSITIVE_GROUP_VIOLATION /* 8505L */, E  },
    {ERROR_DS_CANT_MOD_PRIMARYGROUPID /* 8506L */, E  },
    {ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD /* 8507L */, E  },
    {ERROR_DS_NONSAFE_SCHEMA_CHANGE /* 8508L */, E  },
    {ERROR_DS_SCHEMA_UPDATE_DISALLOWED /* 8509L */, E  },
    {ERROR_DS_CANT_CREATE_UNDER_SCHEMA /* 8510L */, E  },
    {ERROR_DS_INSTALL_NO_SRC_SCH_VERSION /* 8511L */, E  },
    {ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE /* 8512L */, E  },
    {ERROR_DS_INVALID_GROUP_TYPE /* 8513L */, E  },
    {ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN /* 8514L */, E  },
    {ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN /* 8515L */, E  },
    {ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER /* 8516L */, E  },
    {ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER /* 8517L */, E  },
    {ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER /* 8518L */, E  },
    {ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER /* 8519L */, E  },
    {ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER /* 8520L */, E  },
    {ERROR_DS_HAVE_PRIMARY_MEMBERS /* 8521L */, E  },
    {ERROR_DS_STRING_SD_CONVERSION_FAILED /* 8522L */, E  },
    {ERROR_DS_NAMING_MASTER_GC /* 8523L */, E  },
    {ERROR_DS_LOOKUP_FAILURE /* 8524L */, E  },
    {ERROR_DS_COULDNT_UPDATE_SPNS /* 8525L */, E  },
    {ERROR_DS_CANT_RETRIEVE_SD /* 8526L */, E  },
    {ERROR_DS_KEY_NOT_UNIQUE /* 8527L */, E  },
    {ERROR_DS_WRONG_LINKED_ATT_SYNTAX /* 8528L */, E  },
    {ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD /* 8529L */, E  },
    {ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY /* 8530L */, E  },
    {ERROR_DS_CANT_START /* 8531L */, E  },
    {ERROR_DS_INIT_FAILURE /* 8532L */, E  },
    {ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION /* 8533L */, E  },
    {ERROR_DS_SOURCE_DOMAIN_IN_FOREST /* 8534L */, E  },
    {ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST /* 8535L */, E  },
    {ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED /* 8536L */, E  },
    {ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN /* 8537L */, E  },
    {ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER /* 8538L */, E  },
    {ERROR_DS_SRC_SID_EXISTS_IN_FOREST /* 8539L */, E  },
    {ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH /* 8540L */, E  },
    {ERROR_SAM_INIT_FAILURE /* 8541L */, E  },
    {ERROR_DS_DRA_SCHEMA_INFO_SHIP /* 8542L */, E  },
    {ERROR_DS_DRA_SCHEMA_CONFLICT /* 8543L */, E  },
    {ERROR_DS_DRA_EARLIER_SCHEMA_CONLICT /* 8544L */, E  },
    {ERROR_DS_DRA_OBJ_NC_MISMATCH /* 8545L */, E  },
    {ERROR_DS_NC_STILL_HAS_DSAS /* 8546L */, E  },
    {ERROR_DS_GC_REQUIRED /* 8547L */, E  },
    {ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY /* 8548L */, E  },
    {ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS /* 8549L */, E  },
    {ERROR_DS_CANT_ADD_TO_GC /* 8550L */, E  },
    {ERROR_DS_NO_CHECKPOINT_WITH_PDC /* 8551L */, E  },
    {ERROR_DS_SOURCE_AUDITING_NOT_ENABLED /* 8552L */, E  },
    {ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC /* 8553L */, E  },
    {ERROR_DS_INVALID_NAME_FOR_SPN /* 8554L */, E  },
    {ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS /* 8555L */, E  },
    {ERROR_DS_UNICODEPWD_NOT_IN_QUOTES /* 8556L */, E  },
    {ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED /* 8557L */, E  },
    {ERROR_DS_MUST_BE_RUN_ON_DST_DC /* 8558L */, E  },
    {ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER /* 8559L */, E  },
    {ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ /* 8560L */, E  },
    {ERROR_DS_INIT_FAILURE_CONSOLE /* 8561L */, E  },
    {ERROR_DS_SAM_INIT_FAILURE_CONSOLE /* 8562L */, E  },
    {ERROR_DS_FOREST_VERSION_TOO_HIGH /* 8563L */, E  },
    {ERROR_DS_DOMAIN_VERSION_TOO_HIGH /* 8564L */, E  },
    {ERROR_DS_FOREST_VERSION_TOO_LOW /* 8565L */, E  },
    {ERROR_DS_DOMAIN_VERSION_TOO_LOW /* 8566L */, E  },
    {ERROR_DS_INCOMPATIBLE_VERSION /* 8567L */, E  },
    {ERROR_DS_LOW_DSA_VERSION /* 8568L */, E  },
    {ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN /* 8569L */, E  },
    {ERROR_DS_NOT_SUPPORTED_SORT_ORDER /* 8570L */, E  },
    {ERROR_DS_NAME_NOT_UNIQUE /* 8571L */, E  },
    {ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4 /* 8572L */, E  },
    {ERROR_DS_OUT_OF_VERSION_STORE /* 8573L */, E  },
    {ERROR_DS_INCOMPATIBLE_CONTROLS_USED /* 8574L */, E  },
    {ERROR_DS_NO_REF_DOMAIN /* 8575L */, E  },
    {ERROR_DS_RESERVED_LINK_ID /* 8576L */, E  },
    {ERROR_DS_LINK_ID_NOT_AVAILABLE /* 8577L */, E  },
    {ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER /* 8578L */, E  },
    {ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE /* 8579L */, E  },
    {ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC /* 8580L */, E  },
    {ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG /* 8581L */, E  },
    {ERROR_DS_MODIFYDN_WRONG_GRANDPARENT /* 8582L */, E  },
    {ERROR_DS_NAME_ERROR_TRUST_REFERRAL /* 8583L */, E  },
    {ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER /* 8584L */, E  },
    {ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD /* 8585L */, E  },
    {ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2 /* 8586L */, E  },
    {ERROR_DS_THREAD_LIMIT_EXCEEDED /* 8587L */, E  },
    {ERROR_DS_NOT_CLOSEST /* 8588L */, E  },
    {ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF /* 8589L */, E  },
    {ERROR_DS_SINGLE_USER_MODE_FAILED /* 8590L */, E  },
    {ERROR_DS_NTDSCRIPT_SYNTAX_ERROR /* 8591L */, E  },
    {ERROR_DS_NTDSCRIPT_PROCESS_ERROR /* 8592L */, E  },
    {ERROR_DS_DIFFERENT_REPL_EPOCHS /* 8593L */, E  },
    {ERROR_DS_DRS_EXTENSIONS_CHANGED /* 8594L */, E  },
    {ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR /* 8595L */, E  },
    {ERROR_DS_NO_MSDS_INTID /* 8596L */, E  },
    {ERROR_DS_DUP_MSDS_INTID /* 8597L */, E  },
    {ERROR_DS_EXISTS_IN_RDNATTID /* 8598L */, E  },
    {ERROR_DS_AUTHORIZATION_FAILED /* 8599L */, E  },
    {ERROR_DS_INVALID_SCRIPT /* 8600L */, E  },
    {ERROR_DS_REMOTE_CROSSREF_OP_FAILED /* 8601L */, E  },
    {ERROR_DS_CROSS_REF_BUSY /* 8602L */, E  },
    {ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN /* 8603L */, E  },
    {ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC /* 8604L */, E  },
    {ERROR_DS_DUPLICATE_ID_FOUND /* 8605L */, E  },
    {ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT /* 8606L */, E  },
    {ERROR_DS_GROUP_CONVERSION_ERROR /* 8607L */, E  },
    {ERROR_DS_CANT_MOVE_APP_BASIC_GROUP /* 8608L */, E  },
    {ERROR_DS_CANT_MOVE_APP_QUERY_GROUP /* 8609L */, E  },
    {ERROR_DS_ROLE_NOT_VERIFIED /* 8610L */, E  },
    {ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL /* 8611L */, E  },
    {ERROR_DS_DOMAIN_RENAME_IN_PROGRESS /* 8612L */, E  },
    {ERROR_DS_EXISTING_AD_CHILD_NC /* 8613L */, E  },
    {DNS_ERROR_RCODE_FORMAT_ERROR /* 9001L */, E  },
    {DNS_ERROR_RCODE_SERVER_FAILURE /* 9002L */, E  },
    {DNS_ERROR_RCODE_NAME_ERROR /* 9003L */, E  },
    {DNS_ERROR_RCODE_NOT_IMPLEMENTED /* 9004L */, E  },
    {DNS_ERROR_RCODE_REFUSED /* 9005L */, E  },
    {DNS_ERROR_RCODE_YXDOMAIN /* 9006L */, E  },
    {DNS_ERROR_RCODE_YXRRSET /* 9007L */, E  },
    {DNS_ERROR_RCODE_NXRRSET /* 9008L */, E  },
    {DNS_ERROR_RCODE_NOTAUTH /* 9009L */, E  },
    {DNS_ERROR_RCODE_NOTZONE /* 9010L */, E  },
    {DNS_ERROR_RCODE_BADSIG /* 9016L */, E  },
    {DNS_ERROR_RCODE_BADKEY /* 9017L */, E  },
    {DNS_ERROR_RCODE_BADTIME /* 9018L */, E  },
    {DNS_INFO_NO_RECORDS /* 9501L */, E  },
    {DNS_ERROR_BAD_PACKET /* 9502L */, E  },
    {DNS_ERROR_NO_PACKET /* 9503L */, E  },
    {DNS_ERROR_RCODE /* 9504L */, E  },
    {DNS_ERROR_UNSECURE_PACKET /* 9505L */, E  },
    {DNS_ERROR_INVALID_TYPE /* 9551L */, E  },
    {DNS_ERROR_INVALID_IP_ADDRESS /* 9552L */, E  },
    {DNS_ERROR_INVALID_PROPERTY /* 9553L */, E  },
    {DNS_ERROR_TRY_AGAIN_LATER /* 9554L */, E  },
    {DNS_ERROR_NOT_UNIQUE /* 9555L */, E  },
    {DNS_ERROR_NON_RFC_NAME /* 9556L */, E  },
    {DNS_STATUS_FQDN /* 9557L */, E  },
    {DNS_STATUS_DOTTED_NAME /* 9558L */, E  },
    {DNS_STATUS_SINGLE_PART_NAME /* 9559L */, E  },
    {DNS_ERROR_INVALID_NAME_CHAR /* 9560L */, E  },
    {DNS_ERROR_NUMERIC_NAME /* 9561L */, E  },
    {DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER /* 9562L */, E  },
    {DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION /* 9563L */, E  },
    {DNS_ERROR_CANNOT_FIND_ROOT_HINTS /* 9564L */, E  },
    {DNS_ERROR_INCONSISTENT_ROOT_HINTS /* 9565L */, E  },
    {DNS_ERROR_ZONE_DOES_NOT_EXIST /* 9601L */, E  },
    {DNS_ERROR_NO_ZONE_INFO /* 9602L */, E  },
    {DNS_ERROR_INVALID_ZONE_OPERATION /* 9603L */, E  },
    {DNS_ERROR_ZONE_CONFIGURATION_ERROR /* 9604L */, E  },
    {DNS_ERROR_ZONE_HAS_NO_SOA_RECORD /* 9605L */, E  },
    {DNS_ERROR_ZONE_HAS_NO_NS_RECORDS /* 9606L */, E  },
    {DNS_ERROR_ZONE_LOCKED /* 9607L */, E  },
    {DNS_ERROR_ZONE_CREATION_FAILED /* 9608L */, E  },
    {DNS_ERROR_ZONE_ALREADY_EXISTS /* 9609L */, E  },
    {DNS_ERROR_AUTOZONE_ALREADY_EXISTS /* 9610L */, E  },
    {DNS_ERROR_INVALID_ZONE_TYPE /* 9611L */, E  },
    {DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP /* 9612L */, E  },
    {DNS_ERROR_ZONE_NOT_SECONDARY /* 9613L */, E  },
    {DNS_ERROR_NEED_SECONDARY_ADDRESSES /* 9614L */, E  },
    {DNS_ERROR_WINS_INIT_FAILED /* 9615L */, E  },
    {DNS_ERROR_NEED_WINS_SERVERS /* 9616L */, E  },
    {DNS_ERROR_NBSTAT_INIT_FAILED /* 9617L */, E  },
    {DNS_ERROR_SOA_DELETE_INVALID /* 9618L */, E  },
    {DNS_ERROR_FORWARDER_ALREADY_EXISTS /* 9619L */, E  },
    {DNS_ERROR_ZONE_REQUIRES_MASTER_IP /* 9620L */, E  },
    {DNS_ERROR_ZONE_IS_SHUTDOWN /* 9621L */, E  },
    {DNS_ERROR_PRIMARY_REQUIRES_DATAFILE /* 9651L */, E  },
    {DNS_ERROR_INVALID_DATAFILE_NAME /* 9652L */, E  },
    {DNS_ERROR_DATAFILE_OPEN_FAILURE /* 9653L */, E  },
    {DNS_ERROR_FILE_WRITEBACK_FAILED /* 9654L */, E  },
    {DNS_ERROR_DATAFILE_PARSING /* 9655L */, E  },
    {DNS_ERROR_RECORD_DOES_NOT_EXIST /* 9701L */, E  },
    {DNS_ERROR_RECORD_FORMAT /* 9702L */, E  },
    {DNS_ERROR_NODE_CREATION_FAILED /* 9703L */, E  },
    {DNS_ERROR_UNKNOWN_RECORD_TYPE /* 9704L */, E  },
    {DNS_ERROR_RECORD_TIMED_OUT /* 9705L */, E  },
    {DNS_ERROR_NAME_NOT_IN_ZONE /* 9706L */, E  },
    {DNS_ERROR_CNAME_LOOP /* 9707L */, E  },
    {DNS_ERROR_NODE_IS_CNAME /* 9708L */, E  },
    {DNS_ERROR_CNAME_COLLISION /* 9709L */, E  },
    {DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT /* 9710L */, E  },
    {DNS_ERROR_RECORD_ALREADY_EXISTS /* 9711L */, E  },
    {DNS_ERROR_SECONDARY_DATA /* 9712L */, E  },
    {DNS_ERROR_NO_CREATE_CACHE_DATA /* 9713L */, E  },
    {DNS_ERROR_NAME_DOES_NOT_EXIST /* 9714L */, E  },
    {DNS_WARNING_PTR_CREATE_FAILED /* 9715L */, E  },
    {DNS_WARNING_DOMAIN_UNDELETED /* 9716L */, E  },
    {DNS_ERROR_DS_UNAVAILABLE /* 9717L */, E  },
    {DNS_ERROR_DS_ZONE_ALREADY_EXISTS /* 9718L */, E  },
    {DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE /* 9719L */, E  },
    {DNS_INFO_AXFR_COMPLETE /* 9751L */, E  },
    {DNS_ERROR_AXFR /* 9752L */, E  },
    {DNS_INFO_ADDED_LOCAL_WINS /* 9753L */, E  },
    {DNS_STATUS_CONTINUE_NEEDED /* 9801L */, E  },
    {DNS_ERROR_NO_TCPIP /* 9851L */, E  },
    {DNS_ERROR_NO_DNS_SERVERS /* 9852L */, E  },
    {DNS_ERROR_DP_DOES_NOT_EXIST /* 9901L */, E  },
    {DNS_ERROR_DP_ALREADY_EXISTS /* 9902L */, E  },
    {DNS_ERROR_DP_NOT_ENLISTED /* 9903L */, E  },
    {DNS_ERROR_DP_ALREADY_ENLISTED /* 9904L */, E  },
    {DNS_ERROR_DP_NOT_AVAILABLE /* 9905L */, E  },
    {WSABASEERR /* 10000 */, E  },
    {WSAEINTR /* 10004L */, E  },
    {WSAEBADF /* 10009L */, E  },
    {WSAEACCES /* 10013L */, E  },
    {WSAEFAULT /* 10014L */, E  },
    {WSAEINVAL /* 10022L */, E  },
    {WSAEMFILE /* 10024L */, E  },
    {WSAEWOULDBLOCK /* 10035L */, E  },
    {WSAEINPROGRESS /* 10036L */, E  },
    {WSAEALREADY /* 10037L */, E  },
    {WSAENOTSOCK /* 10038L */, E  },
    {WSAEDESTADDRREQ /* 10039L */, E  },
    {WSAEMSGSIZE /* 10040L */, E  },
    {WSAEPROTOTYPE /* 10041L */, E  },
    {WSAENOPROTOOPT /* 10042L */, E  },
    {WSAEPROTONOSUPPORT /* 10043L */, E  },
    {WSAESOCKTNOSUPPORT /* 10044L */, E  },
    {WSAEOPNOTSUPP /* 10045L */, E  },
    {WSAEPFNOSUPPORT /* 10046L */, E  },
    {WSAEAFNOSUPPORT /* 10047L */, E  },
    {WSAEADDRINUSE /* 10048L */, E  },
    {WSAEADDRNOTAVAIL /* 10049L */, E  },
    {WSAENETDOWN /* 10050L */, E  },
    {WSAENETUNREACH /* 10051L */, E  },
    {WSAENETRESET /* 10052L */, E  },
    {WSAECONNABORTED /* 10053L */, E  },
    {WSAECONNRESET /* 10054L */, E  },
    {WSAENOBUFS /* 10055L */, E  },
    {WSAEISCONN /* 10056L */, E  },
    {WSAENOTCONN /* 10057L */, E  },
    {WSAESHUTDOWN /* 10058L */, E  },
    {WSAETOOMANYREFS /* 10059L */, E  },
    {WSAETIMEDOUT /* 10060L */, E  },
    {WSAECONNREFUSED /* 10061L */, E  },
    {WSAELOOP /* 10062L */, E  },
    {WSAENAMETOOLONG /* 10063L */, E  },
    {WSAEHOSTDOWN /* 10064L */, E  },
    {WSAEHOSTUNREACH /* 10065L */, E  },
    {WSAENOTEMPTY /* 10066L */, E  },
    {WSAEPROCLIM /* 10067L */, E  },
    {WSAEUSERS /* 10068L */, E  },
    {WSAEDQUOT /* 10069L */, E  },
    {WSAESTALE /* 10070L */, E  },
    {WSAEREMOTE /* 10071L */, E  },
    {WSASYSNOTREADY /* 10091L */, E  },
    {WSAVERNOTSUPPORTED /* 10092L */, E  },
    {WSANOTINITIALISED /* 10093L */, E  },
    {WSAEDISCON /* 10101L */, E  },
    {WSAENOMORE /* 10102L */, E  },
    {WSAECANCELLED /* 10103L */, E  },
    {WSAEINVALIDPROCTABLE /* 10104L */, E  },
    {WSAEINVALIDPROVIDER /* 10105L */, E  },
    {WSAEPROVIDERFAILEDINIT /* 10106L */, E  },
    {WSASYSCALLFAILURE /* 10107L */, E  },
    {WSASERVICE_NOT_FOUND /* 10108L */, E  },
    {WSATYPE_NOT_FOUND /* 10109L */, E  },
    {WSA_E_NO_MORE /* 10110L */, E  },
    {WSA_E_CANCELLED /* 10111L */, E  },
    {WSAEREFUSED /* 10112L */, E  },
    {WSAHOST_NOT_FOUND /* 11001L */, E  },
    {WSATRY_AGAIN /* 11002L */, E  },
    {WSANO_RECOVERY /* 11003L */, E  },
    {WSANO_DATA /* 11004L */, E  },
    {WSA_QOS_RECEIVERS /* 11005L */, E  },
    {WSA_QOS_SENDERS /* 11006L */, E  },
    {WSA_QOS_NO_SENDERS /* 11007L */, E  },
    {WSA_QOS_NO_RECEIVERS /* 11008L */, E  },
    {WSA_QOS_REQUEST_CONFIRMED /* 11009L */, E  },
    {WSA_QOS_ADMISSION_FAILURE /* 11010L */, E  },
    {WSA_QOS_POLICY_FAILURE /* 11011L */, E  },
    {WSA_QOS_BAD_STYLE /* 11012L */, E  },
    {WSA_QOS_BAD_OBJECT /* 11013L */, E  },
    {WSA_QOS_TRAFFIC_CTRL_ERROR /* 11014L */, E  },
    {WSA_QOS_GENERIC_ERROR /* 11015L */, E  },
    {WSA_QOS_ESERVICETYPE /* 11016L */, E  },
    {WSA_QOS_EFLOWSPEC /* 11017L */, E  },
    {WSA_QOS_EPROVSPECBUF /* 11018L */, E  },
    {WSA_QOS_EFILTERSTYLE /* 11019L */, E  },
    {WSA_QOS_EFILTERTYPE /* 11020L */, E  },
    {WSA_QOS_EFILTERCOUNT /* 11021L */, E  },
    {WSA_QOS_EOBJLENGTH /* 11022L */, E  },
    {WSA_QOS_EFLOWCOUNT /* 11023L */, E  },
    {WSA_QOS_EUNKNOWNPSOBJ /* 11024L */, E  },
    {WSA_QOS_EPOLICYOBJ /* 11025L */, E  },
    {WSA_QOS_EFLOWDESC /* 11026L */, E  },
    {WSA_QOS_EPSFLOWSPEC /* 11027L */, E  },
    {WSA_QOS_EPSFILTERSPEC /* 11028L */, E  },
    {WSA_QOS_ESDMODEOBJ /* 11029L */, E  },
    {WSA_QOS_ESHAPERATEOBJ /* 11030L */, E  },
    {WSA_QOS_RESERVED_PETYPE /* 11031L */, E  },
#endif
    {-2, -2}
  };

  struct w32err_data *result =
    bsearch (&w32err, &errno_map[0], sizeof(errno_map)/sizeof(errno_map[0]),
	     sizeof (errno_map[0]), w32err_cmp);
  if (!result)
    return EINVAL;
  return result->errno_val;
}

int
w32_errno (int e)
{
  DWORD winerr = GetLastError ();

  if (winerr)
    return w32_to_errno (winerr);
  return e;
}
#endif

#include "cycle-check.h"
#include "filenamecat.h"
#include "stat-macros.h"
#include "xalloc.h"
#include "xgetcwd.h"

#ifndef __set_errno
# define __set_errno(Val) errno = (Val)
#endif

#include "pathmax.h"
#include "xreadlink.h"

#if !HAVE_CANONICALIZE_FILE_NAME
/* Return the canonical absolute name of file NAME.  A canonical name
   does not contain any `.', `..' components nor any repeated file name
   separators ('/') or symlinks.  All components must exist.
   The result is malloc'd.  */

char *
canonicalize_file_name (const char *name)
{
# if HAVE_RESOLVEPATH

  char *resolved, *extra_buf = NULL;
  size_t resolved_size;
  ssize_t resolved_len;

  if (name == NULL)
    {
      __set_errno (EINVAL);
      return NULL;
    }

  if (name[0] == '\0')
    {
      __set_errno (ENOENT);
      return NULL;
    }

  /* All known hosts with resolvepath (e.g. Solaris 7) don't turn
     relative names into absolute ones, so prepend the working
     directory if the file name is not absolute.  */
  if (name[0] != '/')
    {
      char *wd;

      if (!(wd = xgetcwd ()))
	return NULL;

      extra_buf = file_name_concat (wd, name, NULL);
      name = extra_buf;
      free (wd);
    }

  resolved_size = strlen (name);
  while (1)
    {
      resolved_size = 2 * resolved_size + 1;
      resolved = xmalloc (resolved_size);
      resolved_len = resolvepath (name, resolved, resolved_size);
      if (resolved_len < 0)
	{
	  free (resolved);
	  free (extra_buf);
	  return NULL;
	}
      if (resolved_len < resolved_size)
	break;
      free (resolved);
    }

  free (extra_buf);

  /* NUL-terminate the resulting name.  */
  resolved[resolved_len] = '\0';

  return resolved;

# elif defined(__MINGW32__) || defined(_MSC_VER)

  char  canonical[PATH_MAX];
  DWORD canon_len;
  char *resolved;

  canon_len = GetFullPathName (name, PATH_MAX, canonical, NULL);
  if (canon_len < PATH_MAX)
    {
      /* This ensures we return a long file name, and also verifies
	 the file exists.  */
      canon_len = GetLongPathName (canonical, canonical, PATH_MAX);
      if (canon_len >= PATH_MAX)
	{
	  __set_errno (ENAMETOOLONG);
	  resolved = NULL;
	}
      else if (canon_len <= 0)
	{
	  __set_errno (w32_to_errno (GetLastError ()));
	  resolved = NULL;
	}
      else
	{
	  char *p;

	  resolved = strdup (canonical);

	  for (p = resolved; *p; ++p)
	    {
	      if (*p == '\\')
		*p = '/';
	    }
	}
    }
  else if (canon_len <= 0)
    {
      __set_errno (w32_to_errno (GetLastError ()));
      resolved = NULL;
    }
  else
    {
      __set_errno (ENAMETOOLONG);
      resolved = NULL;
    }

  return resolved;

# else

  return canonicalize_filename_mode (name, CAN_EXISTING);

# endif /* !HAVE_RESOLVEPATH */
}
#endif /* !HAVE_CANONICALIZE_FILE_NAME */

/* Return the canonical absolute name of file NAME.  A canonical name
   does not contain any `.', `..' components nor any repeated file name
   separators ('/') or symlinks.  Whether components must exist
   or not depends on canonicalize mode.  The result is malloc'd.  */

char *
canonicalize_filename_mode (const char *name, canonicalize_mode_t can_mode)
{
  char *rname, *dest, *extra_buf = NULL;
  char const *start;
  char const *end;
  char const *rname_limit;
#ifdef S_IFLNK
  size_t extra_len = 0;
  struct cycle_check_state cycle_state;
#endif

  if (name == NULL)
    {
      __set_errno (EINVAL);
      return NULL;
    }

  if (name[0] == '\0')
    {
      __set_errno (ENOENT);
      return NULL;
    }

  if (!IS_ABSOLUTE_FILE_NAME (name))
    {
      rname = xgetcwd ();
      if (!rname)
	return NULL;
      dest = strchr (rname, '\0');
      if (dest - rname < PATH_MAX)
	{
	  char *p = xrealloc (rname, PATH_MAX);
	  dest = p + (dest - rname);
	  rname = p;
	  rname_limit = rname + PATH_MAX;
	}
      else
	{
	  rname_limit = dest;
	}
    }
  else
    {
      rname = xmalloc (PATH_MAX);
      rname_limit = rname + PATH_MAX;
      /* Copy the initial prefix of NAME into RNAME.  */
      if (FILE_SYSTEM_PREFIX_LEN (name))
	memcpy (rname, name, FILE_SYSTEM_PREFIX_LEN (name));
      rname[FILE_SYSTEM_PREFIX_LEN (name)] = '/';
      dest = rname + FILE_SYSTEM_PREFIX_LEN (name) + 1;
    }

#ifdef S_IFLNK
  cycle_check_init (&cycle_state);
#endif

  for (start = end = name + FILE_SYSTEM_PREFIX_LEN (name); *start; start = end)
    {
      /* Skip sequence of multiple file name separators.  */
      while (ISSLASH (*start))
	++start;

      /* Find end of component.  */
      for (end = start; *end && !ISSLASH (*end); ++end)
	/* Nothing.  */;

      if (end - start == 0)
	break;
      else if (end - start == 1 && start[0] == '.')
	/* nothing */;
      else if (end - start == 2 && start[0] == '.' && start[1] == '.')
	{
	  /* Back up to previous component, ignore if at root already.  */
	  if (dest > rname + FILE_SYSTEM_PREFIX_LEN (name) + 1)
	    for (--dest; !ISSLASH(dest[-1]); --dest)
	      /* Nothing.  */;
	}
      else
	{
	  struct stat st;

	  if (!ISSLASH (dest[-1]))
	    *dest++ = '/';

	  if (dest + (end - start) >= rname_limit)
	    {
	      ptrdiff_t dest_offset = dest - rname;
	      size_t new_size = rname_limit - rname;

	      if (end - start + 1 > PATH_MAX)
		new_size += end - start + 1;
	      else
		new_size += PATH_MAX;
	      rname = xrealloc (rname, new_size);
	      rname_limit = rname + new_size;

	      dest = rname + dest_offset;
	    }

	  dest = memcpy (dest, start, end - start);
	  dest += end - start;
	  *dest = '\0';

	  if (lstat (rname, &st) != 0)
	    {
	      if (can_mode == CAN_EXISTING)
		goto error;
	      if (can_mode == CAN_ALL_BUT_LAST && *end)
		goto error;
	      st.st_mode = 0;
	    }

#ifdef S_IFLNK
	  if (S_ISLNK (st.st_mode))
	    {
	      char *buf;
	      size_t n, len;

	      if (cycle_check (&cycle_state, &st))
		{
		  __set_errno (ELOOP);
		  if (can_mode == CAN_MISSING)
		    continue;
		  else
		    goto error;
		}

	      buf = xreadlink (rname, st.st_size);
	      if (!buf)
		{
		  if (can_mode == CAN_MISSING)
		    continue;
		  else
		    goto error;
		}

	      n = strlen (buf);
	      len = strlen (end);

	      if (!extra_len)
		{
		  extra_len =
		    ((n + len + 1) > PATH_MAX) ? (n + len + 1) : PATH_MAX;
		  extra_buf = xmalloc (extra_len);
		}
	      else if ((n + len + 1) > extra_len)
		{
		  extra_len = n + len + 1;
		  extra_buf = xrealloc (extra_buf, extra_len);
		}

	      /* Careful here, end may be a pointer into extra_buf... */
	      memmove (&extra_buf[n], end, len + 1);
	      name = end = memcpy (extra_buf, buf, n);

	      if (ISSLASH (buf[0]))
		dest = rname + 1;	/* It's an absolute symlink */
	      else
		/* Back up to previous component, ignore if at root already: */
		if (dest > rname + 1)
		  for (--dest; !ISSLASH (dest[-1]); --dest);

	      free (buf);
	    }
	  else
#endif
	    {
	      if (!S_ISDIR (st.st_mode) && *end && (can_mode != CAN_MISSING))
		{
		  errno = ENOTDIR;
		  goto error;
		}
	    }
	}
    }
  if (dest > rname + FILE_SYSTEM_PREFIX_LEN (rname) + 1 && ISSLASH (dest[-1]))
    --dest;
  *dest = '\0';

  free (extra_buf);
  return rname;

error:
  free (extra_buf);
  free (rname);
  return NULL;
}
