<?php
/*************************
  Coppermine Photo Gallery
  ************************
  Copyright (c) 2003-2010 Coppermine Dev Team
  originally written by Gregory DEMAR

  The floog style was written by Florian Staudacher

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 3
  as published by the Free Software Foundation.
  
  ********************************************
  Coppermine version: 1.4.18
  $HeadURL: https://coppermine.svn.sourceforge.net/svnroot/coppermine/trunk/cpg1.4.x/themes/water_drop/theme.php $
  $Revision: 4380 $
  $Author: gaugau $
  $Date: 2008-04-12 12:00:19 +0200 (Sa, 12 Apr 2008) $
**********************************************/

/**
 * unfortunately this theme requires 4 colums for album and thumbnail view
 */
$CONFIG['album_list_cols'] = 4;
$CONFIG['thumbcols'] = 4;

define('THEME_IS_XHTML10_TRANSITIONAL',1); // Remove this if you edit this template until
                                           // you have validated it. See docs/theme.htm.

// HTML template for template sys_menu spacer
//$template_sys_menu_spacer ='<img src="themes/water_drop/images/orange_carret.gif" width="8" height="8" border="0" alt="" />';
$template_sys_menu_spacer ='';
$template_thumb_view_title_row = '';

function theme_display_cat_list($breadcrumb, &$cat_data, $statistics)
{
    global $template_cat_list, $lang_cat_list, $lang_gallery_admin_menu;
    if (count($cat_data) > 0) {
        starttable('100%');
        $template = template_extract_block($template_cat_list, 'header');
        $params = array('{CATEGORY}' => $lang_gallery_admin_menu['categories_lnk'], //$lang_cat_list['category'], - need plural
            '{ALBUMS}' => $lang_cat_list['albums'],
            '{PICTURES}' => $lang_cat_list['pictures'],
            );
        echo template_eval($template, $params);
    }

    $template_noabl = template_extract_block($template_cat_list, 'catrow_noalb');
    $template = template_extract_block($template_cat_list, 'catrow');
    foreach($cat_data as $category) {
    	if (!isset($category['cat_thumb'])) {
    		$category['cat_thumb'] = ''; 
    	}
    	else {
    		if (strstr($category['cat_thumb'], "img")) {
    			$array = explode("<td>", $category['cat_thumb']);
    			$num = ((round(count($array)/2))*15)-15;
    			$category['cat_thumb'] = "margin-left: ".$num."px;";
    		}
    	}

        if (count($category) == 3) {
            $params = array('{CAT_TITLE}' => $category[0],
                    '{CAT_THUMB}' => $category['cat_thumb'],
		    '{CAT_DESC}' => $category[1],
		    '{ALBUMS}' => $lang_cat_list['albums'],
		    '{PICTURES}' => $lang_cat_list['pictures'],
                );
            echo template_eval($template_noabl, $params);
        } elseif (isset($category['cat_albums']) && ($category['cat_albums'] != '')) {
            $params = array('{CAT_TITLE}' => $category[0],
                '{CAT_THUMB}' => $category['cat_thumb'],
                '{CAT_DESC}' => $category[1],
                '{CAT_ALBUMS}' => $category['cat_albums'],
                '{ALB_COUNT}' => $category[2],
                '{PIC_COUNT}' => $category[3],
		'{ALBUMS}' => $lang_cat_list['albums'],
		'{PICTURES}' => $lang_cat_list['pictures'],
                );
            echo template_eval($template, $params);
        } else {
            $params = array('{CAT_TITLE}' => $category[0],
                '{CAT_THUMB}' => $category['cat_thumb'],
                '{CAT_DESC}' => $category[1],
                '{CAT_ALBUMS}' => '',
                '{ALB_COUNT}' => $category[2],
                '{PIC_COUNT}' => $category[3],
		'{ALBUMS}' => $lang_cat_list['albums'],
		'{PICTURES}' => $lang_cat_list['pictures'],
                );
            echo template_eval($template, $params);
        }
    }

    if ($statistics && count($cat_data) > 0) {
        $template = template_extract_block($template_cat_list, 'footer');
        $params = array('{STATISTICS}' => $statistics);
        echo template_eval($template, $params);
    }


    if (count($cat_data) > 0)
          endtable();
        echo template_extract_block($template_cat_list, 'spacer');
}

function theme_display_album_list(&$alb_list, $nbAlb, $cat, $page, $total_pages)
{

    global $CONFIG, $STATS_IN_ALB_LIST, $statistics, $template_tab_display, $template_album_list, $lang_album_list;

    $theme_alb_list_tab_tmpl = $template_tab_display;

    $theme_alb_list_tab_tmpl['left_text'] = strtr($theme_alb_list_tab_tmpl['left_text'], array('{LEFT_TEXT}' => $lang_album_list['album_on_page']));
    $theme_alb_list_tab_tmpl['inactive_tab'] = strtr($theme_alb_list_tab_tmpl['inactive_tab'], array('{LINK}' => 'index.php?cat=' . $cat . '&amp;page=%d'));
    $theme_alb_list_tab_tmpl['inactive_next_tab'] = strtr($theme_alb_list_tab_tmpl['inactive_next_tab'], array('{LINK}' => 'index.php?cat=' . $cat . '&amp;page=%d'));
    $theme_alb_list_tab_tmpl['inactive_prev_tab'] = strtr($theme_alb_list_tab_tmpl['inactive_prev_tab'], array('{LINK}' => 'index.php?cat=' . $cat . '&amp;page=%d'));

    $tabs = create_tabs($nbAlb, $page, $total_pages, $theme_alb_list_tab_tmpl);

    $album_cell = template_extract_block($template_album_list, 'album_cell');
    $empty_cell = template_extract_block($template_album_list, 'empty_cell');
    $tabs_row = template_extract_block($template_album_list, 'tabs');
    $stat_row = template_extract_block($template_album_list, 'stat_row');
    $spacer = template_extract_block($template_album_list, 'spacer');
    $header = template_extract_block($template_album_list, 'header');
    $footer = template_extract_block($template_album_list, 'footer');
    $rows_separator = template_extract_block($template_album_list, 'row_separator');

    $count = 0;

    $columns = $CONFIG['album_list_cols'];
    $column_width = ceil(100 / $columns);
    $thumb_cell_width = $CONFIG['alb_list_thumb_size'] + 2;

    starttable('100%');

    if ($STATS_IN_ALB_LIST) {
        $params = array('{STATISTICS}' => $statistics,
            '{COLUMNS}' => $columns,
            );
        echo template_eval($stat_row, $params);
    }

    echo $header;

    if (is_array($alb_list)) {
        foreach($alb_list as $album) {
            $count ++;

            $params = array('{COL_WIDTH}' => $column_width-1.5,
                '{ALBUM_TITLE}' => $album['album_title'],
                '{THUMB_CELL_WIDTH}' => $thumb_cell_width,
                '{ALB_LINK_TGT}' => "thumbnails.php?album={$album['aid']}",
                '{ALB_LINK_PIC}' => $album['thumb_pic'],
                '{ADMIN_MENU}' => $album['album_adm_menu'],
                '{ALB_DESC}' => $album['album_desc'],
                '{ALB_INFOS}' => $album['album_info'],
                );

            echo template_eval($album_cell, $params);

            if ($count % $columns == 0 && $count < count($alb_list)) {
                echo $rows_separator;
            }
        }
    }

    $params = array('{COL_WIDTH}' => $column_width,
          '{SPACER}' => $thumb_cell_width
          );
    $empty_cell = template_eval($empty_cell, $params);

    while ($count++ % $columns != 0) {
        echo $empty_cell;
    }

    echo $footer;
    // Tab display
    $params = array('{COLUMNS}' => $columns,
        '{TABS}' => $tabs,
        );
    echo template_eval($tabs_row, $params);

    endtable();

    echo $spacer;
}

/******************************************************************************
** Section <<<theme_display_thumbnails>>> - START
******************************************************************************/
function theme_display_thumbnails(&$thumb_list, $nbThumb, $album_name, $aid, $cat, $page, $total_pages, $sort_options, $display_tabs, $mode = 'thumb', $date='')
{
    global $CONFIG, $CURRENT_ALBUM_DATA;
    global $template_thumb_view_title_row,$template_fav_thumb_view_title_row, $lang_thumb_view, $lang_common, $template_tab_display, $template_thumbnail_view, $lang_album_list, $lang_errors;

    $superCage = Inspekt::makeSuperCage();

    static $header = '';
    static $thumb_cell = '';
    static $empty_cell = '';
    static $row_separator = '';
    static $footer = '';
    static $tabs = '';
    static $spacer = '';

    if ($header == '') {
        $thumb_cell = template_extract_block($template_thumbnail_view, 'thumb_cell');
        $tabs = template_extract_block($template_thumbnail_view, 'tabs');
        $header = template_extract_block($template_thumbnail_view, 'header');
        $empty_cell = template_extract_block($template_thumbnail_view, 'empty_cell');
        $row_separator = template_extract_block($template_thumbnail_view, 'row_separator');
        $footer = template_extract_block($template_thumbnail_view, 'footer');
        $spacer = template_extract_block($template_thumbnail_view, 'spacer');
    }

    $cat_link = is_numeric($aid) ? '' : '&amp;cat=' . $cat;
    $date_link = $date=='' ? '' : '&amp;date=' . $date;
    if ($superCage->get->getInt('uid')) {
      $uid_link = '&amp;uid=' . $superCage->get->getInt('uid');
    } else {
      $uid_link = '';
    }

    $album_types = array(
        'albums' => array('lastalb')
    );
    $album_types = CPGPluginAPI::filter('theme_thumbnails_album_types', $album_types);

    $theme_thumb_tab_tmpl = $template_tab_display;

    if ($mode == 'thumb') {
        $theme_thumb_tab_tmpl['left_text'] = strtr($theme_thumb_tab_tmpl['left_text'], array('{LEFT_TEXT}' => in_array($aid, $album_types['albums']) ? $lang_album_list['album_on_page'] : $lang_thumb_view['pic_on_page']));
        $theme_thumb_tab_tmpl['page_link'] = strtr($theme_thumb_tab_tmpl['page_link'], array('{LINK}' => 'thumbnails.php?album=' . $aid . $cat_link . $date_link . $uid_link . '&amp;page=%d'));
    } else {
        $theme_thumb_tab_tmpl['left_text'] = strtr($theme_thumb_tab_tmpl['left_text'], array('{LEFT_TEXT}' => $lang_thumb_view['user_on_page']));
        $theme_thumb_tab_tmpl['page_link'] = strtr($theme_thumb_tab_tmpl['page_link'], array('{LINK}' => 'index.php?cat=' . $cat . '&amp;page=%d'));
    }

	$thumbcols = $CONFIG['thumbcols'];
	$cell_width = ceil(100 / $CONFIG['thumbcols']) . '%';

    $tabs_html = $display_tabs ? create_tabs($nbThumb, $page, $total_pages, $theme_thumb_tab_tmpl) : '';

    if (!GALLERY_ADMIN_MODE && stripos($template_thumb_view_title_row, 'admin_buttons') !== false) {
        template_extract_block($template_thumb_view_title_row, 'admin_buttons');
    }
    // The sort order options are not available for meta albums
    if ($sort_options) {
        if (GALLERY_ADMIN_MODE) {
            $param = array(
                '{ALBUM_ID}'   => $aid,
                '{CAT_ID}'     => ($cat > 0 ? $cat : $CURRENT_ALBUM_DATA['category']),
                '{MODIFY_LNK}'     => $lang_common['album_properties'],
                '{MODIFY_ICO}'     => cpg_fetch_icon('modifyalb', 1),
                '{PARENT_CAT_LNK}' => $lang_common['parent_category'],
                '{PARENT_CAT_ICO}' => cpg_fetch_icon('category', 1),
                '{EDIT_PICS_LNK}'  => $lang_common['edit_files'],
                '{EDIT_PICS_ICO}'  => cpg_fetch_icon('edit', 1),
                '{ALBUM_MGR_LNK}'  => $lang_common['album_manager'],
                '{ALBUM_MGR_ICO}'  => cpg_fetch_icon('alb_mgr', 1),
            );
        } else {
            $param = array();
        }
        $param['{ALBUM_NAME}'] = $album_name;
        // Plugin Filter: allow plugin to modify or add tags to process
        $param = CPGPluginAPI::filter('theme_thumbnails_title', $param);
        $title = template_eval($template_thumb_view_title_row, $param);
    } elseif ($aid == 'favpics' && $CONFIG['enable_zipdownload'] > 0) { //Lots of stuff can be added here later
        $param = array(
            '{ALBUM_ID}'   => $aid,
            '{ALBUM_NAME}' => $album_name,
            '{DOWNLOAD_ZIP}' => cpg_fetch_icon ('zip', 2) . $lang_thumb_view['download_zip'],
        );
        // Plugin Filter: allow plugin to modify or add tags to process
        $param = CPGPluginAPI::filter('theme_thumbnails_title', $param);
        $title = template_eval($template_fav_thumb_view_title_row, $param);
    } else {
        $title = $album_name;
    }

    $wrapper_start = CPGPluginAPI::filter('theme_thumbnails_wrapper_start');
    echo $wrapper_start;

    if ($mode == 'thumb') {
        starttable('100%', $title, $thumbcols);
    } else {
        starttable('100%');
    }

    echo $header;

    $i = 0;
    global $thumb;  // make $thumb accessible to plugins
    foreach($thumb_list as $thumb) {
        $i++;
        if ($mode == 'thumb') {
            if (in_array($aid, $album_types['albums'])) {
                $params = array(
                    '{CELL_WIDTH}' => $cell_width,
                    '{LINK_TGT}'   => "thumbnails.php?album={$thumb['aid']}",
                    '{THUMB}'      => $thumb['image'],
                    '{CAPTION}'    => $thumb['caption'],
                    '{ADMIN_MENU}' => $thumb['admin_menu'],
                );
            } else {
                // determine if thumbnail link targets should open in a pop-up
                if ($CONFIG['thumbnail_to_fullsize'] == 1) { // code for full-size pop-up
                    if (!USER_ID && $CONFIG['allow_unlogged_access'] <= 2) {
                       $target = 'javascript:;" onclick="alert(\''.sprintf($lang_errors['login_needed'],'','','','').'\');';
                    } elseif (USER_ID && USER_ACCESS_LEVEL <= 2) {
                        $target = 'javascript:;" onclick="alert(\''.sprintf($lang_errors['access_intermediate_only'],'','','','').'\');';
                    } else {
                       $target = 'javascript:;" onclick="MM_openBrWindow(\'displayimage.php?pid=' . $thumb['pid'] . '&fullsize=1\',\'' . uniqid(rand()) . '\',\'scrollbars=yes,toolbar=no,status=no,resizable=yes,width=' . ((int)$thumb['pwidth']+(int)$CONFIG['fullsize_padding_x']) .  ',height=' .   ((int)$thumb['pheight']+(int)$CONFIG['fullsize_padding_y']). '\');';
                    }
                } elseif ($aid == 'random') {
                    $target = "displayimage.php?pid={$thumb['pid']}$uid_link#top_display_media";
                } elseif ($aid == 'lastcom' || $aid == 'lastcomby') {
                    $page = cpg_get_comment_page_number($thumb['msg_id']);
                    $page = (is_numeric($page)) ? "&amp;page=$page" : '';
                    $target = "displayimage.php?album=$aid$cat_link$date_link&amp;pid={$thumb['pid']}$uid_link&amp;msg_id={$thumb['msg_id']}$page#comment{$thumb['msg_id']}";
                } else {
                    $target = "displayimage.php?album=$aid$cat_link$date_link&amp;pid={$thumb['pid']}$uid_link#top_display_media";
                }
                $params = array(
                    '{CELL_WIDTH}' => $cell_width,
                    '{LINK_TGT}'   => $target,
                    '{THUMB}'      => $thumb['image'],
                    '{CAPTION}'    => $thumb['caption'],
                    '{ADMIN_MENU}' => $thumb['admin_menu'],
                );
            }

        } else {  // mode != 'thumb'

            // Used for mode = 'user' from list_users() in index.php
            $params = array(
                '{CELL_WIDTH}' => $cell_width,
                '{LINK_TGT}'   => "index.php?cat={$thumb['cat']}",
                '{THUMB}'      => $thumb['image'],
                '{CAPTION}'    => $thumb['caption'],
                '{ADMIN_MENU}' => '',
            );

        }

        // Plugin Filter: allow plugin to modify or add tags to process
        $params = CPGPluginAPI::filter('theme_display_thumbnails_params', $params);
        echo template_eval($thumb_cell, $params);

        if ((($i % $thumbcols) == 0) && ($i < count($thumb_list))) {
            echo $row_separator;
        }
    } // foreach $thumb

    unset($thumb);  // unset $thumb to avoid conflicting with global

    for (;($i % $thumbcols); $i++) {
        echo $empty_cell;
    }
    $footer = CPGPluginAPI::filter('theme_thumbnails_footer', $footer);
    echo $footer;

    if ($display_tabs) {
        $params = array(
            '{THUMB_COLS}' => $thumbcols,
            '{TABS}'       => $tabs_html,
        );
        echo template_eval($tabs, $params);
    }

    endtable();
    $wrapper_end = CPGPluginAPI::filter('theme_thumbnails_wrapper_end');
    echo $wrapper_end;
    echo $spacer;
}
/******************************************************************************
** Section <<<theme_display_thumbnails>>> - END
******************************************************************************/

/******************************************************************************
** Section <<<theme_create_tabs>>> - START
******************************************************************************/
// Function for creating tabs showing multiple pages
function theme_create_tabs($items, $curr_page, $total_pages, $template)
{
    // Tabs do not take into account $lang_text_dir for RTL languages
    global $CONFIG, $lang_create_tabs;

    // Gallery Configuration setting for maximum number of tabs to display
    $maxTab = $CONFIG['max_tabs'];

    if ($total_pages == '') {
        $total_pages = $curr_page;
    }

    if (array_key_exists('page_link',$template)) {
        // Pass through links to tabs with links
        $template['nav_tab']      = strtr($template['nav_tab'], array('{LINK}' => $template['page_link']));
        $template['inactive_tab'] = strtr($template['inactive_tab'], array('{LINK}' => $template['page_link']));
    }

    // Left text, usually shows statistics
    $tabs = sprintf($template['left_text'], $items, $total_pages);
    if (($total_pages == 1)) {
        return $tabs;
    }

    // Header for tabs
    $tabs .= $template['tab_header'];

    if ($CONFIG['tabs_dropdown']) {
        // Dropdown list for all pages
        $tabs_dropdown_js = <<< EOT
            <span id="tabs_dropdown_span"></span>
            <script type="text/javascript"><!--
                $('#tabs_dropdown_span').html('{$lang_create_tabs['jump_to_page']} <select id="tabs_dropdown_select" onchange="if (this.options[this.selectedIndex].value != -1) { window.location.href = this.options[this.selectedIndex].value; }"></select>');
                for (page = 1; page <= $total_pages; page++) {
                    var page_link = '{$template['page_link']}';
                    var selected = '';
                    if (page == $curr_page) {
                        selected = ' selected="selected"';
                    }
                    $('#tabs_dropdown_select').append('<option value="' + page_link.replace( /%d/, page ) + '"' + selected + '>' + page + '</option>');
                }
         --></script>
EOT;
        $tabs .= sprintf($template['allpages_dropdown'], $tabs_dropdown_js);
    }

    // Calculate which pages to show on tabs, limited by the maximum number of tabs (set on Gallery Configuration panel)
    if ($total_pages > $maxTab) {
        $start = max(2, $curr_page - floor(($maxTab - 2) / 2));
        $start = min($start, $total_pages - $maxTab + 2);
        $end = $start + $maxTab - 3;
    } else {
        $start = 2;
        $end = $total_pages - 1;
    }

    // Previous page tab
    if ($curr_page != ($start - 1)) {
        $tabs .= sprintf($template['nav_tab'], $curr_page-1, cpg_fetch_icon('tab_left',0,$lang_create_tabs['previous']));
    } else {
        // A previous tab with link is not needed.
        // If you want to show a disabled previous tab,
        //   create an image 'left_inactive.png', put it into themes/YOUR_THEME/images/icons/,
        //   then uncomment the line below.
        // $tabs .= sprintf($template['nav_tab_nolink'], cpg_fetch_icon('left_inactive',0,$lang_create_tabs['previous']));
    }

    // Page 1 tab
    if ($curr_page == 1) {
        $tabs .= sprintf($template['active_tab'], 1);
    } else {
        $tabs .= sprintf($template['inactive_tab'], 1, 1);
    }

    // Gap between page 1 and middle block of tabs
    if ($start > 2) {
        $tabs .= $template['page_gap'];
    }
    $page_gap = ($template['page_gap'] != '');

    // Middle block of tabs
    for ($page = $start ; $page <= $end; $page++) {
        if (!$page_gap || ($page_gap && ($page != $start))) {
            $tabs .= $template['tab_spacer'];
        }
        if ($page == $curr_page) {
            $tabs .= sprintf($template['active_tab'], $page);
        } else {
            $tabs .= sprintf($template['inactive_tab'], $page, $page);
        }
    }

    // Gap between middle block of tabs and last page
    if ($end < $total_pages - 1) {
        $tabs .= $template['page_gap'];
    }

    // Last page tab
    if (!$page_gap) {
        $tabs .= $template['tab_spacer'];
    }
    if ($total_pages > 1) {
        if ($curr_page == $total_pages) {
            $tabs .= sprintf($template['active_tab'], $total_pages);
        } else {
            $tabs .= sprintf($template['inactive_tab'], $total_pages, $total_pages);
        }
    }

    // Next page tab
    if ($curr_page != $total_pages) {
        $tabs .= sprintf($template['nav_tab'], $curr_page + 1, cpg_fetch_icon('tab_right',0,$lang_create_tabs['next']));
    } else {
        // A next tab with link is not needed.
        // If you want to show a disabled next tab,
        //   create an image 'right_inactive.png', put it into themes/YOUR_THEME/images/icons/,
        //   then uncomment the line below.
        // $tabs .= sprintf($template['nav_tab_nolink'], cpg_fetch_icon('right_inactive',0,$lang_create_tabs['next']));
    }

    // Trailer for tabs
    $tabs .= $template['tab_trailer'];

    return $tabs;
}
/******************************************************************************
** Section <<<theme_create_tabs>>> - END
******************************************************************************/

function theme_html_picinfo(&$info)
{
	global $lang_picinfo;
	
	$html = '';
	
	$html .= '        <div class="img_description" align="center"><div><b>'.$lang_picinfo['title'].'</b></div>'."\n";
	$template = '        <div class="img_info">%s: <span class="img_info_val">%s</span></div>'."\n";
	foreach ($info as $key => $value) $html .= sprintf($template, $key, $value);
	$html .= '</div>';
	return $html;
}

// Function for writing a pageheader
function pageheader($section, $meta = '')
{
    global $CONFIG, $THEME_DIR;
    global $template_header, $lang_charset, $lang_text_dir;

    $custom_header = cpg_get_custom_include($CONFIG['custom_header_path']);

        $charset = ($CONFIG['charset'] == 'language file') ? $lang_charset : $CONFIG['charset'];

    header('P3P: CP="CAO DSP COR CURa ADMa DEVa OUR IND PHY ONL UNI COM NAV INT DEM PRE"');
        header("Content-Type: text/html; charset=$charset");
    user_save_profile();

    $template_vars = array(
		'{LANG_DIR}' => $lang_text_dir,
		'{TITLE}' => $CONFIG['gallery_name'] . ' - ' . strip_tags(bb_decode($section)),
		'{CHARSET}' => $charset,
		'{META}' => $meta,
		'{GAL_NAME}' => $CONFIG['gallery_name'],
		'{GAL_DESCRIPTION}' => $CONFIG['gallery_description'],
		'{SYS_MENU}' => theme_main_menu('sys_menu'),
		'{SUB_MENU}' => theme_main_menu('sub_menu'),
		'{ADMIN_MENU}' => theme_admin_mode_menu(),
		'{CUSTOM_HEADER}' => $custom_header,
		'{JAVASCRIPT}' => theme_javascript_head(),
		'{MESSAGE_BLOCK}' => theme_display_message_block(),
	);
    // MOD - add {HEADER_BREADCRUMB} processing to pageheader
    global $template_breadcrumb, $CURRENT_ALBUM_DATA, $cat;
    $breadcrumb = '';
    $breadcrumb_text = '';
    $breadcrumb_output = '';
    $actual_cat = (is_numeric($CURRENT_ALBUM_DATA['category']) ? $CURRENT_ALBUM_DATA['category'] : $cat);
    breadcrumb($actual_cat, $breadcrumb, $breadcrumb_text);
    if ($breadcrumb) {
        $template_breadcrumb_save = $template_breadcrumb;
        $template = template_extract_block($template_breadcrumb, 'breadcrumb');
        $params = array(
            '{BREADCRUMB}' => $breadcrumb,
        );
        $breadcrumb_output = template_eval($template, $params);
        $template_breadcrumb = $template_breadcrumb_save;
    }
    $template_vars['{HEADER_BREADCRUMB}'] = $breadcrumb_output;
    // MOD - end
    echo template_eval($template_header, $template_vars);
}

// Function to start a 'standard' table
function starttable($width = '-1', $title = '', $title_colspan = '1')
{
    global $CONFIG;
	$superCage = Inspekt::makeSuperCage();
	$requestUri = $superCage->server->getRaw('REQUEST_URI');

    //if ($width == '-1') $width = $CONFIG['picture_table_width']."px";
    //if ($width == '100%') $width = $CONFIG['main_table_width'];
	$width = '100%';

	if ( strpos($requestUri, 'index.php') ||
		 strpos($requestUri, 'thumbnails.php') ||
		 strpos($requestUri, 'displayimage.php')) {
	    	$starttable = '
			<!-- Start standard table -->
			<div style="width: '.$width.';" class="maintable">
			';
		if ($title) {
			$starttable .= '
				<div><h2>'.$title.'</h2></div>
				';
		}
	} else {
		$starttable = '<!-- Start standard table -->
			<table align="center" width="'.$width.'" cellspacing="1" cellpadding="0" class="maintable">
			';
		if ($title) {
			$starttable .= '<tr><td class="tableh1" colspan="'.$title_colspan.'"><h2>'.$title.'</h2></td></tr>';
		}
	}
	
	echo $starttable;
}

// Function to end a 'standard' table
function endtable()
{
	$superCage = Inspekt::makeSuperCage();
	$requestUri = $superCage->server->getRaw('REQUEST_URI');
	
	if ( strpos($requestUri, 'index.php') ||
		 strpos($requestUri, 'thumbnails.php') ||
		 strpos($requestUri, 'displayimage.php')) {
		$endtable = '</div>
			<!-- End standard table -->';
	} else {
		$endtable = '</table>
			<!-- End standard table -->';
	}
	
	echo $endtable;
}

// HTML template for the category list
$template_cat_list = <<<EOT
<!-- BEGIN header -->
	<div><h2>{CATEGORY}</h2></div>
	<div class="list">
<!-- END header -->
<!-- BEGIN catrow -->
	<div class="catrow_noalb" style="{CAT_THUMB}">
	<div class="cat_info">{ALBUMS}: {ALB_COUNT} | {PICTURES}: {PIC_COUNT}</div>
		<div class="catlink"><b>{CAT_TITLE}</b></div>{CAT_DESC}
	</div>
<!-- END catrow -->
<!-- BEGIN catrow_noalb -->
	<div class="catrow_noalb" style="{CAT_THUMB}">
		<div class="catlink"><b>{CAT_TITLE}</b></div>{CAT_DESC}
	</div>
<!-- END catrow_noalb -->
<!-- BEGIN footer -->
	<div style="background: #E7E7E7; padding: 5px; -moz-border-radius: 5px; -webkit-border-radius: 5px; border-radius: 5px;">
		<span class="statlink">{STATISTICS}</span>
	</div>
	</div>
<!-- END footer -->
<!-- BEGIN spacer -->
<br />
<!-- END spacer -->

EOT;

// HTML template for the album list
$template_album_list = <<<EOT

<!-- BEGIN stat_row -->
	<div style="background: #E7E7E7; padding: 5px; -moz-border-radius: 5px; -webkit-border-radius: 5px; border-radius: 5px;">
		<span class="statlink">{STATISTICS}</span>
	</div>
<!-- END stat_row -->
<!-- BEGIN header -->
        <div><h2>Alben</h2></div>
	<div class="list">
<!-- END header -->
<!-- BEGIN album_cell -->
	<div class="album_thing clearfix" style="width: {COL_WIDTH}%">
		<div class="album_thing_header"><a href="{ALB_LINK_TGT}"><b>{ALBUM_TITLE}</b></a></div>
		<div class="album_thing_content"><a href="{ALB_LINK_TGT}" class="album_thing_image albums">{ALB_LINK_PIC}</a>
			{ADMIN_MENU}
			{ALB_DESC}
			<div class="album_thing_infos">{ALB_INFOS}</div></div>
        </div>
<!-- END album_cell -->
<!-- BEGIN empty_cell -->
	<div style="position: relative; min-height: 85px; padding: 5px; display: inline; width: {COL_WIDTH}%;"></div>
<!-- END empty_cell -->
<!-- BEGIN row_separator -->
	<hr style="clear: both; background: #FFF; border: 0; padding: 0; margin: 0; height: 0;" />
<!-- END row_separator -->
<!-- BEGIN footer -->
        </div>
<!-- END footer -->
<!-- BEGIN tabs -->
        <div>
		{TABS}
	</div>
<!-- END tabs -->
<!-- BEGIN spacer -->
<br />
<!-- END spacer -->

EOT;
// HTML template for filmstrip display
$template_film_strip = <<<EOT
<div class="filmstrip">
	<div style="background-image: url({TILE1}); width: 100%"><img src="{TILE1}" alt="" border="0" />&nbsp;</div>
        <div class="film_images">
          <table width="100%" cellspacing="0" cellpadding="3" border="0">
              <tr>
                 <td width="50%"></td>
                 {THUMB_STRIP}
                 <td width="50%"></td>
              </tr>
          </table>
        </div>
	<div style="background-image: url({TILE1}); width: 100%"><img src="{TILE1}" alt="" border="0" />&nbsp;</div>
</div>
<!-- BEGIN thumb_cell -->
                <td valign="top" align="center">
                                        <a href="{LINK_TGT}">{THUMB}</a>
                </td>
<!-- END thumb_cell -->
<!-- BEGIN empty_cell -->
                <td valign="top" align="center" >&nbsp;</td>
<!-- END empty_cell -->

EOT;
// HTML template for the thumbnail view when there is no picture to show
$template_no_img_to_display = <<<EOT
	<div class="tableb" height="200" align="center"><b>{TEXT}</b></div>
<!-- BEGIN spacer -->
<br />
<!-- END spacer -->
EOT;

// HTML template for thumbnails display
$template_thumbnail_view = <<<EOT

<!-- BEGIN header -->
<div class="list">
<!-- END header -->
<!-- BEGIN thumb_cell -->
        <div class="thumbnails clearfix" style="width:{CELL_WIDTH}%;" align="center">
		<a href="{LINK_TGT}">{THUMB}<br /></a>
		{CAPTION}
		{ADMIN_MENU}
        </div>
<!-- END thumb_cell -->
<!-- BEGIN empty_cell -->
	<div style="position: relative; min-height: 85px; padding: 5px; display: inline; width: {CELL_WIDTH}%;"></div>
<!-- END empty_cell -->
<!-- BEGIN row_separator -->
	<hr style="clear: both; background: #FFF; border: 0; padding: 0; margin: 0; height: 0;" />
<!-- END row_separator -->
<!-- BEGIN footer -->
</div>
<!-- END footer -->
<!-- BEGIN tabs -->
	<div style="background: #E7E7E7; padding: 5px; -moz-border-radius: 5px; -webkit-border-radius: 5px; border-radius: 5px; position: relative;">
		<span class="statlink">{TABS}</span>
	</div>
<!-- END tabs -->
<!-- BEGIN spacer -->
<br />
<!-- END spacer -->

EOT;
$template_breadcrumb = <<<EOT
<!-- BEGIN breadcrumb -->
{BREADCRUMB}
<!-- END breadcrumb -->
<!-- BEGIN breadcrumb_user_gal -->
<span class="statlink"><b>{BREADCRUMB}</b></span>
<span class="statlink">{STATISTICS}</span>
<!-- END breadcrumb_user_gal -->

EOT;

/******************************************************************************
** Section <<<$template_album_admin_menu>>> - START
******************************************************************************/
// HTML template for the ALBUM admin menu displayed in the album list
$template_album_admin_menu = <<<EOT
        <div class="buttonlist align_right clearfix">
                <ul>
                        <li>
                                <a href="delete.php?id={ALBUM_ID}&amp;what=album&amp;form_token={FORM_TOKEN}&amp;timestamp={TIMESTAMP}" class="adm_menu" onclick="return confirm('{CONFIRM_DELETE}');"><span>{DELETE}</span></a>
                        </li>
                        <li>
                                <a href="modifyalb.php?album={ALBUM_ID}" class="adm_menu"><span>{MODIFY}</span></a>
                        </li>
                        <li>
                                <a href="editpics.php?album={ALBUM_ID}" class="adm_menu"><span class="last">{EDIT_PICS}</span></a>
                        </li>
                </ul>
        </div>

EOT;

/******************************************************************************
** Section <<<$template_user_list_info_box>>> - START
******************************************************************************/
// HTML template for the USER info box in the user list view
$template_user_list_info_box = <<<EOT
	<div class="thumb_title">
		<a href="profile.php?uid={USER_ID}">{USER_NAME}</a>
	</div>
	<div class="thumb_caption">
		{ALBUMS}, {PICTURES}
	</div>

EOT;
/******************************************************************************
** Section <<<$template_user_list_info_box>>> - END
******************************************************************************/

/******************************************************************************
** Section <<<$template_img_navbar>>> - START
******************************************************************************/
// HTML template for the image navigation bar
$template_img_navbar = <<<EOT
	<div class="img_navbar">
		<span class="navmenu">
			<a href="{THUMB_TGT}" class="navmenu_pic" title="{THUMB_TITLE}"><img src="{LOCATION}images/navbar/thumbnails.png" border="0" alt="{THUMB_TITLE}" /></a>
		</span>
<!-- BEGIN pic_info_button -->
		<span class="navmenu" id="pic_info_button">
		</span>
<!-- END pic_info_button -->
<!-- BEGIN slideshow_button -->
		<span class="navmenu" id="slideshow_button">
		</span>
<!-- END slideshow_button -->
		<span class="navmenu">
			{PIC_POS}
		</span>
<!-- BEGIN report_file_button -->
		<span class="navmenu">
			<a href="{REPORT_TGT}" class="navmenu_pic" title="{REPORT_TITLE}" rel="nofollow"><img src="{LOCATION}images/navbar/report.png" border="0" alt="{REPORT_TITLE}" /></a>
		</span> 
<!-- END report_file_button -->
<!-- BEGIN ecard_button -->
		<span class="navmenu">
			<a href="{ECARD_TGT}" class="navmenu_pic" title="{ECARD_TITLE}" rel="nofollow"><img src="{LOCATION}images/navbar/ecard.png"  border="0" alt="{ECARD_TITLE}" /></a>
		</span>
<!-- END ecard_button -->
<!-- BEGIN nav_start -->
		<span class="navmenu">
			<a href="{START_TGT}" class="navmenu_pic" title="{START_TITLE}"><img src="{LOCATION}images/navbar/{START_IMAGE}" border="0" alt="{START_TITLE}" /></a>
		</span>
<!-- END nav_start -->
<!-- BEGIN nav_prev -->
		<span class="navmenu">
			<a href="{PREV_TGT}" class="navmenu_pic" title="{PREV_TITLE}"><img src="{LOCATION}images/navbar/{PREV_IMAGE}" border="0" alt="{PREV_TITLE}" /></a>
		</span>
<!-- END nav_prev -->
<!-- BEGIN nav_next -->
	<span class="navmenu">
			<a href="{NEXT_TGT}" class="navmenu_pic" title="{NEXT_TITLE}"><img src="{LOCATION}images/navbar/{NEXT_IMAGE}" border="0" alt="{NEXT_TITLE}" /></a>
		</span>
<!-- END nav_next -->
<!-- BEGIN nav_end -->
		<span class="navmenu">
			<a href="{END_TGT}" class="navmenu_pic" title="{END_TITLE}"><img src="{LOCATION}images/navbar/{END_IMAGE}" border="0" alt="{END_TITLE}" /></a>
		</span>
<!-- END nav_end -->
	</div>

EOT;
/******************************************************************************
** Section <<<$template_img_navbar>>> - END
******************************************************************************/

// HTML template for intermediate image display
$template_display_media = <<<EOT
	<div class="display_media">
		<div class="imageborder">
			{IMAGE}
		</div>
	</div>
	<div>
		<div class="img_admin_menu clearfix">
			{ADMIN_MENU}
		</div>
	</div>
<!-- BEGIN img_desc -->
	<div class="img_desc">
<!-- BEGIN title -->
		<div class="img_title">{TITLE}</div>
<!-- END title -->
<!-- BEGIN caption -->
		<div class="img_caption">{CAPTION}</div>
<!-- END caption -->
	</div>
<!-- END img_desc -->
EOT;

/******************************************************************************
** Section <<<$template_image_rating>>> - START
******************************************************************************/
// HTML template for the image rating box
$template_image_rating = <<<EOT
<table class="votings" align="center" width="{WIDTH}" cellspacing="1" cellpadding="0" class="maintable">
    <tr>
        <td colspan="6" class="tableh2" id="voting_title"><strong>{TITLE}</strong> {VOTES}</td>
    </tr>
    <tr id="rating_stars">
        <td class="tableb" id="star_rating"></td>
    </tr>
    <tr class="noscript">
      <td class="tableb" colspan="6" align="center">
        <noscript>
           {JS_WARNING}
        </noscript>
      </td>
    </tr>
</table>
EOT;
/******************************************************************************
** Section <<<$template_image_rating>>> - END
******************************************************************************/

// HTML template for the display of comments
$template_image_comments = <<<EOT
<div class="comment clearfix">
	<a name="comment{MSG_ID}"></a>
	<div class="commentInfo">
	<div class="commentDate" style="margin: 0;">
	<!-- BEGIN report_comment_button -->
		<a href="report_file.php?pid={PID}&amp;msg_id={MSG_ID}&amp;what=comment" title="{REPORT_COMMENT_TITLE}"><img src="images/report.gif" width="16" height="16" border="0" align="middle" alt="{REPORT_COMMENT_TITLE}" /></a>
	<!-- END report_comment_button -->
	<!-- BEGIN buttons -->
		<a href="javascript:;" onclick="blocking('cbody{MSG_ID}','', 'block'); blocking('cedit{MSG_ID}','', 'block'); return false;" title="{EDIT_TITLE}"><img src="images/edit.gif" border="0" align="middle" /></a>
		<a href="delete.php?msg_id={MSG_ID}&what=comment"  onclick="return confirm('{CONFIRM_DELETE}');"><img src="images/delete.gif" border="0" align="middle" /></a>
	<!-- END buttons -->
	</div>
	{MSG_AUTHOR}
	<div class="commentDate">
	<!-- BEGIN ipinfo -->
		{IP}<br />
	<!-- END ipinfo -->
	{MSG_DATE}
	</div>
	</div>
	{MSG_BODY}

	
                        <div id="cedit{MSG_ID}" style="display:none">
<!-- BEGIN edit_box_smilies -->
                                <table width="100%" cellpadding="0" cellspacing="0">

                                                <form name="f{MSG_ID}" method="POST" action="db_input.php">
                                                <input type="hidden" name="event" value="comment_update" />
                                                <input type="hidden" name="msg_id" value="{MSG_ID}" />
                                                <tr>
                                                <td>
                                                   <input type="text" name="msg_author" value="{MSG_AUTHOR}" class="textinput" size="25" />
                                                </td><td>
                                                </tr>
                                                <tr>
                                                <td width="80%">
                                                        <textarea cols="40" rows="2" class="textinput" name="msg_body" onselect="storeCaret_f{MSG_ID}(this);" onclick="storeCaret_f{MSG_ID}(this);" onkeyup="storeCaret_f{MSG_ID}(this);" style="width: 100%;">{MSG_BODY_RAW}</textarea>
                                                </td>
                                                <td class="tableb_compact">
                                                </td>
                                                <td>
                                                        <input type="submit" class="comment_button" name="submit" value="{OK}" />
                                                </td>
                                                </form>
                                        </tr>
                                        <tr>
                                                <td colspan="3"><img src="images/spacer.gif" width="1" height="2" /><br /></td>
                                        </tr>
                                </table>
                                {SMILIES}
<!-- END edit_box_smilies -->
<!-- BEGIN edit_box_no_smilies -->
                                <table width="100%" cellpadding="0" cellspacing="0">
                                        <tr>
                                                <form name="f{MSG_ID}" method="POST" action="db_input.php">
                                                <input type="hidden" name="event" value="comment_update" />
                                                <input type="hidden" name="msg_id" value="{MSG_ID}" />
                                                <td>
                                                <input type="text" name="msg_author" value="{MSG_AUTHOR}" class="textinput" size="25" />
                                                </td>
                                        </tr>
                                        <tr>
                                                <td width="100%">
                                                        <textarea cols="40" rows="2" class="textinput" name="msg_body" style="width: 100%;">{MSG_BODY_RAW}</textarea>
                                                </td>
                                                <td class="tableb_compact">
                                                </td>
                                                <td>
                                                        <input type="submit" class="comment_button" name="submit" value="{OK}" />
                                                </td>
                                                </form>
                                        </tr>
                                        <tr>
                                                <td colspan="3"><img src="images/spacer.gif" width="1" height="2" /><br /></td>
                                        </tr>
                                </table>
<!-- END edit_box_no_smilies -->
                        </div>
</div>
EOT;

/******************************************************************************
** Section <<<$template_add_your_comment>>> - START
******************************************************************************/
$template_add_your_comment = <<<EOT
        <form method="post" name="post" id="post" action="db_input.php">
                <table align="center" width="{WIDTH}" cellspacing="1" cellpadding="0" class="maintable">
                        <tr>
                                        <td width="100%" class="tableh2">{ADD_YOUR_COMMENT}{HELP_ICON}</td>
                        </tr>
                        <tr>
                <td colspan="1">
                        <table width="100%" cellpadding="0" cellspacing="0">

<!-- BEGIN user_name_input -->
                                                        <tr>
                               <td class="tableb tableb_alternate">
                                        {NAME}
                                </td>
                                <td class="tableb tableb_alternate">
                                        <input type="text" class="textinput" name="msg_author" size="10" maxlength="20" value="{USER_NAME}" onclick="if (this.value == '{DEFAULT_USERNAME}') this.value = '';" onkeyup="if (this.value == '{DEFAULT_USERNAME}') this.value = '';" />
                                </td>
<!-- END user_name_input -->
<!-- BEGIN input_box_smilies -->
                                <td class="tableb tableb_alternate">
                                {COMMENT}
                                </td>
                                <td width="100%" class="tableb tableb_alternate">
                                <input type="text" class="textinput" id="message" name="msg_body" onselect="storeCaret_post(this);" onclick="storeCaret_post(this);" onkeyup="storeCaret_post(this);" maxlength="{MAX_COM_LENGTH}" style="width: 100%;" />
                                </td>
<!-- END input_box_smilies -->
<!-- BEGIN input_box_no_smilies -->
                                <td class="tableb tableb_alternate">
                                {COMMENT}
                                </td>
                                <td width="100%" class="tableb tableb_alternate">
                                <input type="text" class="textinput" id="message" name="msg_body"  maxlength="{MAX_COM_LENGTH}" style="width: 100%;" />
                                </td>
<!-- END input_box_no_smilies -->
<!-- BEGIN submit -->
                                <td class="tableb tableb_alternate">
                                <input type="hidden" name="event" value="comment" />
                                <input type="hidden" name="pid" value="{PIC_ID}" />
                                <button type="submit" class="button" name="submit" value="{OK}"  onclick="return notDefaultUsername(this.form, '{DEFAULT_USERNAME}', '{DEFAULT_USERNAME_MESSAGE}');">{OK_ICON}{OK}</button>
                                <input type="hidden" name="form_token" value="{FORM_TOKEN}" />
                                <input type="hidden" name="timestamp" value="{TIMESTAMP}" />
                                </td>
<!-- END submit -->
                                                        </tr>
<!-- BEGIN comment_captcha -->
                                                        <tr>
                                <td class="tableb tableb_alternate" colspan="2">
                                  {CONFIRM}
                                </td>
                                <td class="tableb tableb_alternate" colspan="2">
                                  <input type="text" name="confirmCode" size="5" maxlength="5" class="textinput" />
                                  <img src="captcha.php" align="middle" border="0" alt="" />
                                </td>
                                                        </tr>
<!-- END comment_captcha -->
                        </table>
                </td>
        </tr>
<!-- BEGIN smilies -->
        <tr>
                <td width="100%" class="tableb tableb_alternate">
                        {SMILIES}
                </td>
        </tr>
<!-- END smilies -->
<!-- BEGIN login_to_comment -->
        <tr>
                                <td class="tableb tableb_alternate" colspan="2">
                                  {LOGIN_TO_COMMENT}
                                </td>
        </tr>
<!-- END login_to_comment -->
                </table>
        </form>
EOT;
/******************************************************************************
** Section <<<$template_add_your_comment>>> - END
******************************************************************************/

// HTML template used by the cpg_die function
$template_cpg_die = <<<EOT

        <tr>
                <td class="tableb" align="center">
                        <font size="3"><b>{MESSAGE}</b></font>
<!-- BEGIN file_line -->
                        <br />
                        <br />
                        {FILE_TXT}{FILE} - {LINE_TXT}{LINE}
<!-- END file_line -->
<!-- BEGIN output_buffer -->
                        <br />
                        <br />
                        <div align="left">
                                {OUTPUT_BUFFER}
                        </div>
<!-- END output_buffer -->
                        <br /><br />
                </td>
        </tr>


EOT;

// HTML template used by the msg_box function
$template_msg_box = <<<EOT

        <tr>
                <td class="tableb" align="center">
                        <font size="3"><b>{MESSAGE}</b></font>
                </td>
        </tr>
<!-- BEGIN button -->
                <tr>
                        <td align="center" class="tablef">
                                <table cellpadding="0" cellspacing="0">
                                        <tr>
                                                <td class="admin_menu">
                                                        <a href="{LINK}">{TEXT}</a>
                                                </td>
                                        </tr>
                                </table>
                        </td>
                </tr>
<!-- END button -->

EOT;

// HTML template for e-cards
$template_ecard = <<<EOT
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html dir="{LANG_DIR}">
<head>
<meta http-equiv="content-type" content="text/html; charset={CHARSET}" />
<title>{TITLE}</title>
<style type="text/css">
#e-card, #e-card * {
  color: #333;
}
</style>
</head>
<body bgcolor="#FFFFFF" text="#0F5475" link="#0F5475" vlink="#0F5475" alink="#0F5475">
<br />
<p align="center"><a href="{VIEW_ECARD_TGT}"><b>{VIEW_ECARD_LNK}</b></a></p>
<div id="e-card" style="border: 2px solid #666; background: #EEE; width: 80%; margin: auto; padding: 10px;">
  <div style="float: left; padding: 5px;">
    <a href="{VIEW_MORE_TGT}displayimage.php?pos=-{PID}">
      <img src="{PIC_URL}" border="1" alt="" />
    </a>
    <br />
    <div align="center">
      <h3>{PIC_TITLE}</h3>
    </div>
  </div>
  <div align="right"><img src="{URL_PREFIX}images/stamp.gif" border="0" alt="" /></div>
  <br />
  <div style="color: #333 !important;">
    <h2>{GREETINGS}</h2>
    {MESSAGE}
    <br /><br />
    <small>{SENDER_NAME}, (<a href="mailto:{SENDER_EMAIL}">{SENDER_EMAIL}</a>)</small>
  </div>
</div>
<p align="center"><a href="{VIEW_MORE_TGT}"><b>{VIEW_MORE_LNK}</b></a></p>
</body>
</html>
EOT;

// plain-text template for e-cards (as fallback for clients that can't display html-formatted mails)
$template_ecard_plaintext = <<<EOT
{TITLE}
=========================================

{VIEW_ECARD_LNK_PLAINTEXT}:
{VIEW_ECARD_TGT}

{GREETINGS}


{PLAINTEXT_MESSAGE}

{SENDER_NAME} ({SENDER_EMAIL})

-----------------------------------------
{VIEW_MORE_LNK}:
{VIEW_MORE_TGT}
EOT;

/******************************************************************************
** Section <<<$template_tab_display>>> - START
******************************************************************************/
// Template used for tabbed display
$template_tab_display = array(
    'left_text'         => '<span class="tableh1_compact" style="white-space: nowrap"><b>{LEFT_TEXT}</b></span>' . $LINEBREAK,
    'tab_header'        => '<div class="pagination">',
    'tab_trailer'       => '</div>',
    'active_tab'        => '<span class="active_page" ><b>%d</b></span>',
    'inactive_tab'      => '<span class="navmenu"><a href="{LINK}"><b>%d</b></a></span>' . $LINEBREAK,
    'nav_tab'           => '<td align="center" valign="middle" class="navmenu"><a href="{LINK}">%s</a></td>' . $LINEBREAK,
    'nav_tab_nolink'    => '<td align="center" valign="middle" class="navmenu">%s</td>' . $LINEBREAK,
    'allpages_dropdown' => '<td align="center" valign="middle" style="white-space: nowrap; padding-right: 10px;" class="navmenu">%s</td>' . $LINEBREAK,
    'page_gap'          => '<td align="center" valign="middle" class="navmenu">-</td>' . $LINEBREAK,
    'tab_spacer'        => '',
    'page_link'         => '{LINK}',
);
/******************************************************************************
** Section <<<$template_tab_display>>> - END
******************************************************************************/

// Displays a picture
function theme_html_picture()
{
    global $CONFIG, $CURRENT_PIC_DATA, $CURRENT_ALBUM_DATA, $USER;
    global $album, $comment_date_fmt, $template_display_media;
    global $lang_display_image_php, $lang_picinfo;

    $pid = $CURRENT_PIC_DATA['pid'];
    $pic_title = '';

    if (!isset($USER['liv']) || !is_array($USER['liv'])) {
        $USER['liv'] = array();
    }
    // Add 1 to hit counter
    if (!USER_IS_ADMIN && !in_array($pid, $USER['liv']) && isset($_COOKIE[$CONFIG['cookie_name'] . '_data'])) {
        add_hit($pid);
        if (count($USER['liv']) > 4) array_shift($USER['liv']);
        array_push($USER['liv'], $pid);
    }

    if($CONFIG['thumb_use']=='ht' && $CURRENT_PIC_DATA['pheight'] > $CONFIG['picture_width'] ){ // The wierd comparision is because only picture_width is stored
      $condition = true;
    }elseif($CONFIG['thumb_use']=='wd' && $CURRENT_PIC_DATA['pwidth'] > $CONFIG['picture_width']){
      $condition = true;
    }elseif($CONFIG['thumb_use']=='any' && max($CURRENT_PIC_DATA['pwidth'], $CURRENT_PIC_DATA['pheight']) > $CONFIG['picture_width']){
      $condition = true;
    }else{
     $condition = false;
    }

    if ($CURRENT_PIC_DATA['title'] != '') {
        $pic_title .= $CURRENT_PIC_DATA['title'] . "\n";
    }
    if ($CURRENT_PIC_DATA['caption'] != '') {
        $pic_title .= $CURRENT_PIC_DATA['caption'] . "\n";
    }
    if ($CURRENT_PIC_DATA['keywords'] != '') {
        $pic_title .= $lang_picinfo['Keywords'] . ": " . $CURRENT_PIC_DATA['keywords'];
    }

    if (!$CURRENT_PIC_DATA['title'] && !$CURRENT_PIC_DATA['caption']) {
        template_extract_block($template_display_media, 'img_desc');
    } else {
        if (!$CURRENT_PIC_DATA['title']) {
            template_extract_block($template_display_media, 'title');
        }
        if (!$CURRENT_PIC_DATA['caption']) {
            template_extract_block($template_display_media, 'caption');
        }
    }

    $CURRENT_PIC_DATA['menu'] = html_picture_menu(); //((USER_ADMIN_MODE && $CURRENT_ALBUM_DATA['category'] == FIRST_USER_CAT + USER_ID) || ($CONFIG['users_can_edit_pics'] && $CURRENT_PIC_DATA['owner_id'] == USER_ID && USER_ID != 0) || GALLERY_ADMIN_MODE) ? html_picture_menu($pid) : '';

    if ($CONFIG['make_intermediate'] && $condition ) {
        $picture_url = get_pic_url($CURRENT_PIC_DATA, 'normal');
    } else {
        $picture_url = get_pic_url($CURRENT_PIC_DATA, 'fullsize');
    }

    $image_size = compute_img_size($CURRENT_PIC_DATA['pwidth'], $CURRENT_PIC_DATA['pheight'], $CONFIG['picture_width']);

    $pic_title = '';
    $mime_content = cpg_get_type($CURRENT_PIC_DATA['filename']);


    if ($mime_content['content']=='movie' || $mime_content['content']=='audio') {

        if ($CURRENT_PIC_DATA['pwidth']==0 || $CURRENT_PIC_DATA['pheight']==0) {
            $CURRENT_PIC_DATA['pwidth']  = 320; // Default width

            // Set default height; if file is a movie
            if ($mime_content['content']=='movie') {
                $CURRENT_PIC_DATA['pheight'] = 240; // Default height
            }
        }

        $ctrl_offset['mov']=15;
        $ctrl_offset['wmv']=45;
        $ctrl_offset['swf']=0;
        $ctrl_offset['rm']=0;
        $ctrl_offset_default=45;
        $ctrl_height = (isset($ctrl_offset[$mime_content['extension']]))?($ctrl_offset[$mime_content['extension']]):$ctrl_offset_default;
        $image_size['whole']='width="'.$CURRENT_PIC_DATA['pwidth'].'" height="'.($CURRENT_PIC_DATA['pheight']+$ctrl_height).'"';
    }

    if ($mime_content['content']=='image') {
        if (isset($image_size['reduced'])) {
            $winsizeX = $CURRENT_PIC_DATA['pwidth']+5;  //the +'s are the mysterious FF and IE paddings
            $winsizeY = $CURRENT_PIC_DATA['pheight']+3; //the +'s are the mysterious FF and IE paddings
            $pic_html = "<a href=\"displayimage.php?pid=$pid&amp;fullsize=1\" onclick=\"MM_openBrWindow('displayimage.php?pid=$pid&amp;fullsize=1','" . uniqid(rand()) . "','scrollbars=yes,toolbar=no,status=no,resizable=yes,width=$winsizeX,height=$winsizeY');return false;\">";
            $pic_title = $lang_display_image_php['view_fs'] . "\n==============\n" . $pic_title;
            $pic_html .= "<img src=\"" . $picture_url . "\" class=\"image\" border=\"0\" alt=\"{$lang_display_image_php['view_fs']}\" /><br />";
            $pic_html .= "</a>\n";
        } else {
            $pic_html = "<img src=\"" . $picture_url . "\" {$image_size['geom']} class=\"image\" border=\"0\" alt=\"\" /><br />\n";
        }
    } elseif ($mime_content['content']=='document') {
        $pic_thumb_url = get_pic_url($CURRENT_PIC_DATA,'thumb');
        $pic_html = "<a href=\"{$picture_url}\" target=\"_blank\" class=\"document_link\"><img src=\"".$pic_thumb_url."\" border=\"0\" class=\"image\" /></a>\n<br />";
    } else {
        $autostart = ($CONFIG['media_autostart']) ? ('true'):('false');

        $players['WMP'] = array('id' => 'MediaPlayer',
                                'clsid' => 'classid="clsid:22D6F312-B0F6-11D0-94AB-0080C74C7E95" ',
                                'codebase' => 'codebase="http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=6,4,7,1112" ',
                                'mime' => 'type="application/x-mplayer2" ',
                               );
        $players['RMP'] = array('id' => 'RealPlayer',
                                'clsid' => 'classid="clsid:CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA" ',
                                'codebase' => '',
                                'mime' => 'type="audio/x-pn-realaudio-plugin" '
                               );
        $players['QT']  = array('id' => 'QuickTime',
                                'clsid' => 'classid="clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B" ',
                                'codebase' => 'codebase="http://www.apple.com/qtactivex/qtplugin.cab" ',
                                'mime' => 'type="video/x-quicktime" '
                               );
        $players['SWF'] = array('id' => 'SWFlash',
                                'clsid' => ' classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" ',
                                'codebase' => 'codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0" ',
                                'mime' => 'type="application/x-shockwave-flash" '
                               );
        $players['UNK'] = array('id' => 'DefaultPlayer',
                                'clsid' => '',
                                'codebase' => '',
                                'mime' => ''
                               );

        if (isset($_COOKIE[$CONFIG['cookie_name'].'_'.$mime_content['extension'].'player'])) {
            $user_player = $_COOKIE[$CONFIG['cookie_name'].'_'.$mime_content['extension'].'player'];
        } else {
            $user_player = $mime_content['player'];
        }

                // There isn't a player selected or user wants client-side control
        if (!$user_player) {
            $user_player = 'UNK';
        }

        $player = $players[$user_player];

        $pic_html  = '<object id="'.$player['id'].'" '.$player['clsid'].$player['codebase'].$player['mime'].$image_size['whole'].'>';
        $pic_html .= "<param name=\"autostart\" value=\"$autostart\" /><param name=\"src\" value=\"". $picture_url . "\" />";
        $pic_html .= '<embed '.$image_size['whole'].' src="'. $picture_url . '" autostart="'.$autostart.'" '.$player['mime'].'></embed>';
        $pic_html .= "</object><br />\n";
    }

    $CURRENT_PIC_DATA['html'] = $pic_html;
    $CURRENT_PIC_DATA['header'] = '';
    $CURRENT_PIC_DATA['footer'] = '';

    $CURRENT_PIC_DATA = CPGPluginAPI::filter('file_data',$CURRENT_PIC_DATA);

    $params = array('{CELL_HEIGHT}' => '100',
        '{IMAGE}' => $CURRENT_PIC_DATA['header'].$CURRENT_PIC_DATA['html'].$CURRENT_PIC_DATA['footer'],
        '{ADMIN_MENU}' => $CURRENT_PIC_DATA['menu'],
        '{TITLE}' => bb_decode($CURRENT_PIC_DATA['title']),
        '{CAPTION}' => bb_decode($CURRENT_PIC_DATA['caption']),
        );

    return template_eval($template_display_media, $params);
}

?>