<?php
/*************************
  Coppermine Photo Gallery
  ************************
  Copyright (c) 2003-2010 Coppermine Dev Team
  v1.0 originally written by Gregory Demar

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 3
  as published by the Free Software Foundation.

  ********************************************
  Coppermine version: 1.5.10
  $HeadURL: https://coppermine.svn.sourceforge.net/svnroot/coppermine/trunk/cpg1.5.x/include/themes.inc.php $
  $Revision: 8107 $
  $LastChangedBy$: DaMysterious
  $Date$: 06-12-2010
**********************************************/

/////////////////////////////////////////////////////////////////
//                                                             //
// Do not edit this file.                                      //
// If you need to customize your theme,                        //
// edit themes/yourtheme/theme.php instead !!!                 //
// Take a look at the sample theme (themes/sample/theme.php)   //
// to get an idea what to copy into your custom theme.         //
// Really, don't edit this file! We mean it!                   //
//                                                             //
/////////////////////////////////////////////////////////////////

// ----------------------------------------------------------------------------- //
// All lines that should NOT be IN themes/sample/theme.php             //{THEMES}//
// should end in "//{THEMES}" so that they can be easily stripped      //{THEMES}//
// The individual sections are marked accordingly with                       //
      /***********************************
      ** Section <<<SECTIONNAME>>> - START
      ***********************************/
      // actual code here
      /***********************************
      ** Section <<<SECTIONNAME>>> - END
      ***********************************/
// ----------------------------------------------------------------------------- //

if (!defined('IN_COPPERMINE')) { die('Not in Coppermine...');}         //{THEMES}//

// The following terms can be defined in theme.php
// ('THEME_HAS_RATING_GRAPHICS', 1) : The location for the ratings graphics will
//    be directed to the themes images folder.
//('THEME_HAS_NAVBAR_GRAPHICS', 1); : The location for the navbar graphics will
//    be directed to the themes images folder.
//    Back to thumbnails   : images/navbar/thumbnails.png
//    Picture Information  : images/navbar/info.png
//    Slideshow            : images/navbar/slideshow.png
//    Report to admin      : images/navbar/report.png
//    Ecard                : images/navbar/ecard.png
//    Previous             : images/navbar/prev.png
//    Next                 : images/navbar/next.png
// ('THEME_HAS_FILM_STRIP_GRAPHIC', 1) : The location for the film strip graphics will
//    be directed to the themes images folder.
//    tile                 : images/tile.gif
// ('THEME_HAS_FILM_STRIP_GRAPHICS', 1) : The location for the film strip graphics will
//    be directed to the themes images folder.
//    tile on the top      : images/tile1.gif
//    tile on the bottom   : images/tile2.gif
//  ('THEME_HAS_NO_SYS_MENU_BUTTONS', 1) : When present the system won't attempt to replace {BUTTONS} in the SYS_MENU template
//    The entire block needs to be present like in Coppermine 1.3 themes
//  ('THEME_HAS_NO_SUB_MENU_BUTTONS', 1) When present the system won't attempt to replace {BUTTONS} in the SUB_MENU template
//    The entire block needs to be present like in Coppermine 1.3 themes

define('THEME_HAS_PROGRESS_GRAPHICS', 1);
define('THEME_HAS_FILM_STRIP_GRAPHIC', 1); 

// These parameters overide what the user inputs in the Configuration setup to prevent the theme from breaking.
$CONFIG['max_film_strip_items'] = 3; //overrides the number of thumbnails.
$CONFIG['thumbcols'] = 3; //overrides the number of columns for thumbnails.
$CONFIG['main_table_width'] = '100%'; //overrides the Width of the main table (pixels or %).
$CONFIG['picture_table_width'] = '100%'; //overrides the Width of the table for file display (pixels or %).
$CONFIG['album_list_cols'] = 2; // sets "Number of columns for the album list = 2"
$CONFIG['first_level'] = 1; //sets "Show first level album thumbnails in categories = no".

// HTML template for template sys_menu spacer
$template_sys_menu_spacer ="&raquo;";

if (!isset($template_sub_menu)) { //{THEMES}
/******************************************************************************
** Section <<<$template_sub_menu>>> - START
******************************************************************************/
// HTML template for sub_menu
$template_sub_menu = <<<EOT

	<table cellpadding="0" cellspacing="0" border="0" class="top_menu_bttn">
			<tr>
					<!-- BEGIN custom_link -->
					<td class="active_button">
							<a href="{CUSTOM_LNK_TGT}" title="{CUSTOM_LNK_TITLE}">{CUSTOM_LNK_LNK}</a>
					</td>
					<!-- END custom_link -->
					<td class="active_button">
							<a href="{ALB_LIST_TGT}" title="{ALB_LIST_TITLE}">{ALB_LIST_LNK}</a>
					</td>
					<td class="active_button">
							<a href="{LASTUP_TGT}" title="{LASTUP_LNK}">{LASTUP_LNK}</a>
					</td>
					<td class="active_button">
							<a href="{LASTCOM_TGT}" title="{LASTCOM_LNK}">{LASTCOM_LNK}</a>
					</td>
					<td class="active_button">
							<a href="{TOPN_TGT}" title="{TOPN_LNK}">{TOPN_LNK}</a>
					</td>
					<td class="active_button">
							<a href="{TOPRATED_TGT}" title="{TOPRATED_LNK}">{TOPRATED_LNK}</a>
					</td>
					<td class="active_button">
					<a href="{FAV_TGT}" title="{FAV_LNK}">{FAV_LNK}</a>
					</td>
					 <td class="active_button">
							<a href="{SEARCH_TGT}" title="{SEARCH_LNK}">{SEARCH_LNK}</a>
					</td>

			</tr>
	</table>

EOT;
/******************************************************************************
** Section <<<$template_sub_menu>>> - END
******************************************************************************/
} //{THEMES}

if (!isset($template_gallery_admin_menu)) { //{THEMES}
/******************************************************************************
** Section <<<$template_gallery_admin_menu>>> - START
******************************************************************************/
// HTML template for gallery admin menu
$template_gallery_admin_menu = <<<EOT
  <ul class="dropmenu">
	  <li>
		  <a href="#" title="{FILES_TITLE}" class="firstlevel"><span class="firstlevel">{FILES_ICO}{FILES_LNK}</span></a>
		  <ul>
		  <!-- BEGIN admin_approval -->
			  <li><a href="editpics.php?mode=upload_approval" title="{UPL_APP_TITLE}" class="admin_menu_anim"><span>{UPL_APP_ICO}{UPL_APP_LNK}</span></a></li>
		  <!-- END admin_approval -->
		  <!-- BEGIN catmgr -->
			  <li><a href="catmgr.php" title="{CATEGORIES_TITLE}"><span>{CATEGORIES_ICO}{CATEGORIES_LNK}</span></a></li>
		  <!-- END catmgr -->
		  <!-- BEGIN albmgr -->
			  <li><a href="albmgr.php{CATL}" title="{ALBUMS_TITLE}"><span>{ALBUMS_ICO}{ALBUMS_LNK}</span></a></li>
		  <!-- END albmgr -->
		  <!-- BEGIN picmgr -->
			  <li><a href="picmgr.php" title="{PICTURES_TITLE}"><span>{PICTURES_ICO}{PICTURES_LNK}</span></a></li>
		  <!-- end picmgr -->
		  <!-- BEGIN batch_add -->
			  <li><a href="searchnew.php" title="{SEARCHNEW_TITLE}"><span>{SEARCHNEW_ICO}{SEARCHNEW_LNK}</span></a></li>
		  <!-- END batch_add -->
		  <!-- BEGIN admin_tools -->
			  <li><a href="util.php?t={TIME_STAMP}#admin_tools" title="{UTIL_TITLE}"><span>{UTIL_ICO}{UTIL_LNK}</span></a></li>
		  <!-- END admin_tools -->
		  </ul>
	  </li>
	  <li>
		  <a href="#" class="firstlevel" title="{INFO_TITLE}"><span class="firstlevel">{INFO_ICO}{INFO_LNK}</span></a>
		  <ul>
		  <!-- BEGIN review_comments -->
			  <li><a href="reviewcom.php" title="{COMMENTS_TITLE}"><span>{COMMENTS_ICO}{COMMENTS_LNK}</span></a></li>
		  <!-- END review_comments -->
		  <!-- BEGIN log_ecards -->
			  <li><a href="db_ecard.php" title="{DB_ECARD_TITLE}"><span>{DB_ECARD_ICO}{DB_ECARD_LNK}</span></a></li>
		  <!-- END log_ecards -->
		  <!-- BEGIN view_log_files -->
			  <li><a href="viewlog.php" title="{VIEW_LOG_FILES_TITLE}"><span>{VIEW_LOG_FILES_ICO}{VIEW_LOG_FILES_LNK}</span></a></li>
		  <!-- END view_log_files -->
		  <!-- BEGIN overall_stats -->
			  <li><a href="stat_details.php?type=hits&amp;sort=sdate&amp;dir=&amp;sdate=1&amp;ip=1&amp;search_phrase=0&amp;referer=0&amp;browser=1&amp;os=1&amp;mode=fullscreen&amp;page=1&amp;amount=50" title="{OVERALL_STATS_TITLE}" ><span>{OVERALL_STATS_ICO}{OVERALL_STATS_LNK}</span></a></li>
		  <!-- END overall_stats -->
		  <!-- BEGIN check_versions -->
			  <li><a href="versioncheck.php" title="{CHECK_VERSIONS_TITLE}"><span>{CHECK_VERSIONS_ICO}{CHECK_VERSIONS_LNK}</span></a></li>
		  <!-- END check_versions -->
		  <!-- BEGIN php_info -->
			  <li><a href="phpinfo.php" title="{PHPINFO_TITLE}"><span>{PHPINFO_ICO}{PHPINFO_LNK}</span></a></li>
		  <!-- END php_info -->
		  <!-- BEGIN show_news -->
			  <li><a href="mode.php?what=news&amp;referer=$REFERER" title="{SHOWNEWS_TITLE}"><span>{SHOWNEWS_ICO}{SHOWNEWS_LNK}</span></a></li>
		  <!-- END show_news -->
		  <!-- BEGIN documentation -->
			  <li><a href="{DOCUMENTATION_HREF}" title="{DOCUMENTATION_TITLE}"><span>{DOCUMENTATION_ICO}{DOCUMENTATION_LNK}</span></a></li>
		  <!-- END documentation -->
		  </ul>
	  </li>
  <!-- BEGIN config -->
	  <li>
		  <a href="admin.php" title="{ADMIN_TITLE}" class="firstlevel"><span class="firstlevel">{ADMIN_ICO}{ADMIN_LNK}</span></a>
		  <ul>
		  <!-- BEGIN keyword_manager -->
			  <li><a href="keywordmgr.php" title="{KEYWORDMGR_TITLE}"><span>{KEYWORDMGR_ICO}{KEYWORDMGR_LNK}</span></a></li>
		  <!-- END keyword_manager -->
		  <!-- BEGIN exif_manager -->
			  <li><a href="exifmgr.php" title="{EXIFMGR_TITLE}"><span>{EXIFMGR_ICO}{EXIFMGR_LNK}</span></a></li>
		  <!-- END exif_manager -->
		  <!-- BEGIN plugin_manager -->
			  <li><a href="pluginmgr.php" title="{PLUGINMGR_TITLE}"><span>{PLUGINMGR_ICO}{PLUGINMGR_LNK}</span></a></li>
		  <!-- END plugin_manager -->

		  <!-- BEGIN bridge_manager -->
			  <li><a href="bridgemgr.php" title="{BRIDGEMGR_TITLE}"><span>{BRIDGEMGR_ICO}{BRIDGEMGR_LNK}</span></a></li>
		  <!-- END bridge_manager -->
		  <!-- BEGIN update_database -->
			  <li><a href="update.php" title="{UPDATE_DATABASE_TITLE}"><span>{UPDATE_DATABASE_ICO}{UPDATE_DATABASE_LNK}</span></a></li>
		  <!-- END update_database -->
		  </ul>
	  </li>
  <!-- END config -->
  <!-- BEGIN usermgr -->
	  <li>
		  <a href="usermgr.php" title="{USERS_TITLE}" class="firstlevel"><span class="firstlevel">{USERS_ICO}{USERS_LNK}</span></a>
		  <ul>
		  <!-- BEGIN banmgr -->
			  <li><a href="banning.php" title="{BAN_TITLE}"><span>{BAN_ICO}{BAN_LNK}</span></a></li>
		  <!-- END banmgr -->
		  <!-- BEGIN groupmgr -->
			  <li><a href="groupmgr.php" title="{GROUPS_TITLE}"><span>{GROUPS_ICO}{GROUPS_LNK}</span></a></li>
		  <!-- END groupmgr -->
		  <!-- BEGIN admin_profile -->
			  <li><a href="profile.php?op=edit_profile" title="{MY_PROF_TITLE}"><span>{MY_PROF_ICO}{MY_PROF_LNK}</span></a></li>
		  <!-- END admin_profile -->
		  </ul>
	  </li>
  <!-- END usermgr -->
  </ul>
EOT;
/******************************************************************************
** Section <<<$template_gallery_admin_menu>>> - END
******************************************************************************/
} //{THEMES}

if (!isset($template_user_admin_menu)) { //{THEMES}
/******************************************************************************
** Section <<<$template_user_admin_menu>>> - START
******************************************************************************/
// HTML template for user admin menu
$template_user_admin_menu = <<<EOT
  <ul class="dropmenu">
	  <li>
		  <a href="profile.php?op=edit_profile" title="{MY_PROF_TITLE}" class="firstlevel"><span class="firstlevel">{MY_PROF_ICO}{MY_PROF_LNK}</span></a>
		  <ul>
			  <li><a href="albmgr.php" title="{ALBMGR_TITLE}"><span>{ALBUMS_ICO}{ALBMGR_LNK}</span></a></li>
			  <li><a href="modifyalb.php" title="{MODIFYALB_TITLE}"><span>{MODIFYALB_ICO}{MODIFYALB_LNK}</span></a></li>
			  <li><a href="picmgr.php" title="{PICTURES_TITLE}"><span>{PICTURES_ICO}{PICTURES_LNK}</span></a></li>
		  </ul>
	  </li>
  </ul>
EOT;
/******************************************************************************
** Section <<<$template_user_admin_menu>>> - END
******************************************************************************/
} //{THEMES}

if (!isset($template_cat_list)) { //{THEMES}
/******************************************************************************
** Section <<<$template_cat_list>>> - START
******************************************************************************/
// HTML template for the category list
$template_cat_list = <<<EOT

<!-- BEGIN header -->
        <tr>
                <td class="tableh1" width="80%" align="left">{CATEGORY}</td>
                <td class="tableh1" width="10%" align="center">{ALBUMS}</td>
                <td class="tableh1" width="10%" align="center">{PICTURES}</td>
        </tr>
<!-- END header -->
<!-- BEGIN catrow_noalb -->
        <tr>
                <td class="catrow_noalb" colspan="3"><table border="0"><tr><td align="left"><img src="themes/avalanche/images/forum_read.png" border="0" width="27" height="27" alt="" align="left" /> {CAT_THUMB}</td><td align="left"><span class="catlink">{CAT_TITLE}</span>{CAT_DESC}</td></tr></table></td>
        </tr>
<!-- END catrow_noalb -->
<!-- BEGIN catrow -->
        <tr>
                <td class="catrow" align="left"><table border="0"><tr><td><img src="themes/avalanche/images/forum_read.png" border="0" width="27" height="27" alt="" align="left" /> {CAT_THUMB}</td><td><span class="catlink">{CAT_TITLE}</span>{CAT_DESC}</td></tr></table></td>
                <td class="catrow" align="center">{ALB_COUNT}</td>
                <td class="catrow" align="center">{PIC_COUNT}</td>
        </tr>
        <tr>
            <td colspan="3">{CAT_ALBUMS}</td>
        </tr>
<!-- END catrow -->
<!-- BEGIN footer -->
        <tr>
                <td colspan="3" class="tableh1" align="center"><span class="statlink">{STATISTICS}</span></td>
        </tr>
<!-- END footer -->
<!-- BEGIN spacer -->
        <img src="images/spacer.gif" width="1" height="7" border="" alt="" /><br />
<!-- END spacer -->

EOT;
/******************************************************************************
** Section <<<$template_cat_list>>> - END
******************************************************************************/
} //{THEMES}

if (!function_exists('theme_style_credits')) {  //{THEMES}
/******************************************************************************
** Section <<<theme_credits>>> - START
******************************************************************************/
// Function for the credits-section
function theme_style_credits() 
{
    $return = <<< EOT
<span class="footer">Theme based on <a href="http://www.phpbb.com/" title="&copy; phpBB Group" rel="external">subsilver2</a> &copy; phpBB Group<br /> Converted for Coppermine Gallery 1.5.x by <a href="http://www.portalxl.nl/forum/">PortalXL Group</a>&nbsp;&copy; 2010</span>
EOT;
    return $return;
}
/******************************************************************************
** Section <<<theme_credits>>> - END
******************************************************************************/
}  //{THEMES}

if (!function_exists('pagefooter')) {  //{THEMES}
/******************************************************************************
** Section <<<pagefooter>>> - START
******************************************************************************/
// Function for writing a pagefooter
function pagefooter()
{
    //global $HTTP_GET_VARS, $HTTP_POST_VARS, $HTTP_SERVER_VARS;
    global $USER, $USER_DATA, $CONFIG, $time_start, $query_stats, $queries;
    global $template_footer;

    $custom_footer = cpg_get_custom_include($CONFIG['custom_footer_path']);

    if ($CONFIG['debug_mode']==1 || ($CONFIG['debug_mode']==2 && GALLERY_ADMIN_MODE)) {
        cpg_debug_output();
    }

    $template_vars = array(
        '{GAL_NAME}' => $CONFIG['gallery_name'],
        '{GAL_DESCRIPTION}' => $CONFIG['gallery_description'],
        '{SYS_MENU}' => theme_main_menu('sys_menu'),
        '{SUB_MENU}' => theme_main_menu('sub_menu'),
        '{ADMIN_MENU}' => theme_admin_mode_menu(),
        '{CUSTOM_HEADER}' => $custom_header,
        '{JAVASCRIPT}' => theme_javascript_head(),
        '{CUSTOM_FOOTER}' => $custom_footer,
        '{VANITY}' => (defined('THEME_IS_XHTML10_TRANSITIONAL')) ? theme_vanity() : '',
        '{CREDITS}' => theme_credits(),
        '{THEME_CREDITS}' => theme_style_credits(),
    );

    echo template_eval($template_footer, $template_vars);
}
/******************************************************************************
** Section <<<pagefooter>>> - END
******************************************************************************/
}  //{THEMES}
if (!isset($template_film_strip)) { //{THEMES}
/******************************************************************************
** Section <<<$template_film_strip>>> - START
******************************************************************************/
// HTML template for filmstrip display
$template_film_strip = <<<EOT

      <table width="100%" cellspacing="0" cellpadding="0" class="filmstrip_background">
        <tr>
          <td class="filmstrip_background" style="overflow-y: hidden; background-image: url({TILE1});"><img src="{TILE1}" alt="" border="0" style="visibility:hidden;" /></td>
          <td><table>
              <tr>
                <td class="prev_strip"></td>
              </tr>
              <tr>
                <td valign="bottom" style="{THUMB_TD_STYLE}" class="filmstrip_background" height="100%">
                  <div id="film">
                    <table class="tape">
                      {THUMB_STRIP}
                    </table>
                  </div></td>
              </tr>
              <tr>
                <td class="next_strip"></td>
              </tr>
            </table></td>
          <td class="filmstrip_background" style="background-image: url({TILE2});"><img src="{TILE2}" alt="" border="0" style="visibility:hidden;" /></td>
        </tr>
      </table>

<!-- BEGIN thumb_cell -->
                <tr><td class="thumb" style="height:{$CONFIG['thumb_width']}px;vertical-align: middle; text-align: center;">
                  <a href="{LINK_TGT}" class="thumbLink" style="{ONE_WIDTH}">{THUMB}</a>
                </td></tr>
<!-- END thumb_cell -->
<!-- BEGIN empty_cell -->
                <tr><td valign="top" align="center" >&nbsp;</td></tr>
<!-- END empty_cell -->
EOT;
/******************************************************************************
** Section <<<$template_film_strip>>> - END
******************************************************************************/
} //{THEMES}

if (!isset($template_display_media)) { //{THEMES}
/******************************************************************************
** Section <<<$template_display_media>>> - START
******************************************************************************/
// HTML template for intermediate image display
$template_display_media = <<<EOT
        <tr>
                <td align="center" nowrap="nowrap">
                        <table width="100%" cellspacing="0" cellpadding="0">
                                <tr>
                                        <td align="center" style="{SLIDESHOW_STYLE}">
                                                {IMAGE}
                                        </td>
                                </tr>
                        </table>
                </td>
            </tr>
            <tr>
                <td>
                        <table width="100%" cellspacing="2" cellpadding="0">
                                        <tr>
                                                <td align="center">
                                                        {ADMIN_MENU}
                                                </td>
                                        </tr>
                        </table>


<!-- BEGIN img_desc -->
                        <table cellpadding="0" cellspacing="0" width="100%">
<!-- BEGIN title -->
                                <tr>
                                        <td><h1 class="pic_title">
                                                {TITLE}
                                        </h1></td>
                                </tr>
<!-- END title -->
<!-- BEGIN caption -->
                                <tr>
                                        <td><h2 class="pic_caption">
                                                {CAPTION}
                                        </h2></td>
                                </tr>
<!-- END caption -->
                        </table>
<!-- END img_desc -->
                </td>
        </tr>

EOT;
/******************************************************************************
** Section <<<$template_display_media>>> - END
******************************************************************************/
} //{THEMES}

if (!function_exists('theme_display_film_strip')) {  //{THEMES}
/******************************************************************************
** Section <<<theme_display_film_strip>>> - START
******************************************************************************/
// Function to display the film strip
function theme_display_film_strip(&$thumb_list, $nbThumb, $album_name, $aid, $cat, $pos, $sort_options, $mode = 'thumb', $date='', $filmstrip_prev_pos, $filmstrip_next_pos,$max_block_items,$thumb_width)
{
    global $CONFIG, $THEME_DIR;
    global $template_film_strip, $lang_film_strip, $lang_common, $pic_count,$mar_pic;

    $superCage = Inspekt::makeSuperCage();

    static $template = '';
    static $thumb_cell = '';
    static $empty_cell = '';
    static $spacer = '';

    if (defined('THEME_HAS_FILM_STRIP_GRAPHIC')) { set_js_var('vertstrip', 1); }

    if ((!$template)) {
        $template = $template_film_strip;
        $thumb_cell = template_extract_block($template, 'thumb_cell');
        $empty_cell = template_extract_block($template, 'empty_cell');
    }

    $cat_link = is_numeric($aid) ? '' : '&amp;cat=' . $cat;
    $date_link = $date=='' ? '' : '&amp;date=' . $date;

    if ($superCage->get->getInt('uid')) {
        $uid_link = '&amp;uid=' . $superCage->get->getInt('uid');
    } else {
        $uid_link = '';
    }

    $i = 0;
    $thumb_strip = '';
    foreach($thumb_list as $thumb) {
        $i++;
        if ($mode == 'thumb') {
            if ($thumb['pos'] == $pos && !$superCage->get->keyExists('film_strip')) {
                    $thumb['image'] = str_replace('class="image"', 'class="image middlethumb"', $thumb['image']);
            }
            // determine if thumbnail link targets should open in a pop-up
            if ($CONFIG['thumbnail_to_fullsize'] == 1) { // code for full-size pop-up
                if (!USER_ID && $CONFIG['allow_unlogged_access'] <= 2) {
                    $target = 'javascript:;" onclick="alert(\''.sprintf($lang_errors['login_needed'],'','','','').'\');';
                } elseif (USER_ID && USER_ACCESS_LEVEL <= 2) {
                    $target = 'javascript:;" onclick="alert(\''.sprintf($lang_errors['access_intermediate_only'],'','','','').'\');';
                } else {
                    $target = 'javascript:;" onclick="MM_openBrWindow(\'displayimage.php?pid=' . $thumb['pid'] . '&fullsize=1\',\'' . uniqid(rand()) . '\',\'scrollbars=yes,toolbar=no,status=no,resizable=yes,width=' . ((int)$thumb['pwidth']+(int)$CONFIG['fullsize_padding_x']) .  ',height=' .   ((int)$thumb['pheight']+(int)$CONFIG['fullsize_padding_y']). '\');';
                }
            } elseif ($aid == 'lastcom' || $aid == 'lastcomby') {
                $page = cpg_get_comment_page_number($thumb['msg_id']);
                $page = (is_numeric($page)) ? "&amp;page=$page" : '';
                $target = "displayimage.php?album=$aid$cat_link$date_link&amp;pid={$thumb['pid']}$uid_link&amp;msg_id={$thumb['msg_id']}$page#comment{$thumb['msg_id']}";
            } else {
                $target = "displayimage.php?album=$aid$cat_link$date_link&amp;pid={$thumb['pid']}$uid_link#top_display_media";
            }
            $params = array(
                '{LINK_TGT}' => $target,
                '{THUMB}' => $thumb['image'],
                '{ONE_WIDTH}'  => "width:".$thumb_width."px; float: left" ,
                );
        } else {
            $params = array(
                '{LINK_TGT}' => "index.php?cat={$thumb['cat']}",
                '{THUMB}' => $thumb['image'],
                '{ONE_WIDTH}'  => "width:".$thumb_width."px; float: left" ,
                );
        }
        $thumb_strip .= template_eval($thumb_cell, $params);
    }

        $tile1 = $THEME_DIR . 'images/tile1.gif';
        $tile2 = $THEME_DIR . 'images/tile2.gif';


    if (defined('THEME_HAS_NAVBAR_GRAPHICS')) {
        $location = $THEME_DIR;
    } else {
        $location= '';
    }
    $max_itme_width_ul = $max_block_items;
    if(($max_block_items%2)==0){
        $max_itme_width_ul = $max_block_items +1;
    }
    $set_width_to_film = "width:".($max_block_items*($thumb_width+4))."px; position:relative;";

    $params = array('{THUMB_STRIP}' => $thumb_strip,
        '{COLS}' => $i,
        '{TILE1}' => $tile1,
        '{TILE2}' => $tile2,
        '{SET_WIDTH}'  => $set_width_to_film,
        );

    ob_start();
    echo '<div id="filmstrip">';
    if (!defined('THEME_HAS_FILM_STRIP_GRAPHIC')) { starttable($CONFIG['picture_table_width']); }
    echo template_eval($template, $params);
    if (!defined('THEME_HAS_FILM_STRIP_GRAPHIC')) { endtable(); }
    echo '</div>';
    $film_strip = ob_get_contents();
    ob_end_clean();

    return $film_strip;
}
/******************************************************************************
** Section <<<theme_display_film_strip>>> - END
******************************************************************************/
}  //{THEMES}

if (!function_exists('theme_display_image')) {  //{THEMES}
/******************************************************************************
** Section <<<theme_display_image>>> - START
******************************************************************************/
function theme_display_image($nav_menu, $picture, $votes, $pic_info, $comments, $film_strip)
{
    global $CONFIG, $LINEBREAK;

    $superCage = Inspekt::makeSuperCage();

    $width = $CONFIG['picture_table_width'];

    echo '<a name="top_display_media"></a>'; // set the navbar-anchor
    starttable();
    echo $nav_menu;
    endtable();

    starttable();

    echo "<tr>";
    echo "<td height='100%'><table width='100%'><!-- gb before picture -->";    
    echo $picture;
    echo "</table></td><!-- gb after picture -->";
    if ($CONFIG['display_film_strip'] == 1) {
    echo "<td width='200' height='100%' class=\"tablebspecial\"><!-- gb before film_strip -->";
          echo $film_strip;
    echo "</td><!-- gb after film_strip -->";
    }
    echo "</tr>";


    endtable();


    echo $votes;

    $picinfo = $superCage->cookie->keyExists('picinfo') ? $superCage->cookie->getAlpha('picinfo') : ($CONFIG['display_pic_info'] ? 'block' : 'none');
    echo $LINEBREAK . '<div id="picinfo" style="display: '.$picinfo.';">' . $LINEBREAK;
    starttable();
    echo $pic_info;
    endtable();
    echo '</div>' . $LINEBREAK;

    echo '<a name="comments_top"></a>';
    echo '<div id="comments">' . $LINEBREAK;
    echo $comments;
    echo '</div>' . $LINEBREAK;

}
/******************************************************************************
** Section <<<theme_display_image>>> - END
******************************************************************************/
}  //{THEMES}

?>