<?php 
define('THEME_HAS_FILM_STRIP_GRAPHIC', 1); 

// HTML template for filmstrip display
$template_film_strip = <<<EOT
<tr><td>
	<table width="100%" cellspacing="0" cellpadding="0">			
		<tr>
		<td valign="top" style="background-image: url({TILE1});"><img src="{TILE1}" alt="" border="0" /></td>
		<td>
         	{THUMB_STRIP}
		</td> 
		<td valign="top" style="background-image: url({TILE2});"><img src="{TILE2}" alt="" border="0" /></td>
        	</tr>
	</table>
</td></tr>
	
<!-- BEGIN thumb_cell -->
			<table width="100%" cellspacing="0" cellpadding="0">
			<tr>
				<td align="center" valign="bottom">
				<a href="{LINK_TGT}">{THUMB}</a>
				</td>
			</tr>
			</table>
			{CAPTION}
			{ADMIN_MENU}
<!-- END thumb_cell -->
<!-- BEGIN empty_cell -->
                <td valign="top" align="center">&nbsp;</td>
<!-- END empty_cell -->

EOT;


// HTML template for intermediate image display - HS: valign
$template_display_media = <<<EOT
                <td align="center" valign="top" class="display_media" height="{CELL_HEIGHT}" style="white-space: nowrap; padding: 0px;">
                        <table cellspacing="2" cellpadding="0" class="imageborder">
                               <tr>
                                        <td align="center">
                                                {IMAGE}
                                                {ADMIN_MENU}
                                        </td>
                               </tr>
                        </table>
<!-- BEGIN img_desc -->
                        <table cellpadding="0" cellspacing="0" class="tableb">
<!-- BEGIN title -->
                                <tr>
                                        <td class="tableb"><center><b>
                                                {TITLE}
                                        </b></center></td>
                                </tr>
<!-- END title -->
<!-- BEGIN caption -->
                                <tr>
                                        <td class="tableb"><center>
                                                {CAPTION}
                                        </center></td>
                                </tr>
<!-- END caption -->
                        </table>
<!-- END img_desc -->
                </td>
EOT;

// Added to display film_strip
function theme_display_film_strip(&$thumb_list, $nbThumb, $album_name, $aid, $cat, $pos, $sort_options, $mode = 'thumb')
{
    global $CONFIG, $THEME_DIR;
    global $template_film_strip, $lang_film_strip;

    static $template = '';
    static $thumb_cell = '';
    static $empty_cell = '';
    static $spacer = '';

    if ((!$template)) {
        $template = $template_film_strip;
        $thumb_cell = template_extract_block($template, 'thumb_cell');
        $empty_cell = template_extract_block($template, 'empty_cell');
    }

    $cat_link = is_numeric($aid) ? '' : '&cat=' . $cat;

    $thumbcols = $CONFIG['thumbcols'];
    $cell_width = ceil(100 / $CONFIG['max_film_strip_items']) . '%';

    $i = 0;
    $thumb_strip = '';
    foreach($thumb_list as $thumb) {
        $i++;
        if ($mode == 'thumb') {
            $params = array('{CELL_WIDTH}' => $cell_width,
                '{LINK_TGT}' => "displayimage.php?album=$aid$cat_link&pos={$thumb['pos']}",
                '{THUMB}' => $thumb['image'],
                '{CAPTION}' => '',
                '{ADMIN_MENU}' => ''
                );
        } else {
            $params = array('{CELL_WIDTH}' => $cell_width,
                '{LINK_TGT}' => "index.php?cat={$thumb['cat']}",
                '{THUMB}' => $thumb['image'],
                '{CAPTION}' => '',
                '{ADMIN_MENU}' => ''
                );
        }
        $thumb_strip .= template_eval($thumb_cell, $params);
    }

    if (defined('THEME_HAS_FILM_STRIP_GRAPHICS')) {
        $tile1 = $THEME_DIR . 'images/tile1.gif';
        $tile2 = $THEME_DIR . 'images/tile2.gif';
    } elseif (defined('THEME_HAS_FILM_STRIP_GRAPHIC')) {
        $tile1=$tile2=$THEME_DIR . 'images/tile.gif';
    } else {
        $tile1=$tile2= 'images/tile.gif';
    }

    $params = array('{THUMB_STRIP}' => $thumb_strip,
        '{COLS}' => $i,
        '{TILE1}' => $tile1,
        '{TILE2}' => $tile2,
        );

    ob_start();
    starttable('');
      echo template_eval($template, $params);
    endtable();
    $film_strip = ob_get_contents();
    ob_end_clean();

    return $film_strip;
}

function theme_display_image($nav_menu, $picture, $votes, $pic_info, $comments, $film_strip)
{
    global $HTTP_COOKIE_VARS, $CONFIG;

    starttable();
	    echo $nav_menu;
    endtable();
    starttable();
    if ($CONFIG['display_film_strip'] == 1) {
		echo '<tr><td width="200" class="tableb" valign="middle" ><!-- gb before film_strip -->';
	        echo $film_strip;
		echo "</td><!-- gb after film_strip -->";
    }
		echo "<!-- gb before picture -->";		
    echo $picture;
    echo "</tr><!-- gb after picture -->";
    endtable();

    starttable();
    	echo $votes;
    endtable();

    $picinfo = isset($HTTP_COOKIE_VARS['picinfo']) ? $HTTP_COOKIE_VARS['picinfo'] : ($CONFIG['display_pic_info'] ? 'block' : 'none');
    echo "<div id=\"picinfo\" style=\"display: $picinfo;\">\n";
    starttable();
    echo $pic_info;
    endtable();
    echo "</div>\n";

    starttable();
    echo $comments;
    endtable();
}

?>
