<?php
/**
 * the main administration function
 */
function pnCPG_admin_main()
{

    // Create output object
    $output = new pnHTML();

    // Security check
    if (!pnSecAuthAction(0, 'pnCPG::', '::', ACCESS_ADMIN)) {
        $output->Text(pnVarPrepHTMLDisplay(_PNCPGNOAUTH));
        return $output->GetOutput();
    }

    // Add menu to output
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->Text(pnCPG_adminmenu());
    $output->SetInputMode(_PNH_PARSEINPUT);

    // Return the output that has been generated by this function
    return $output->GetOutput();
}

/*
 * Main administration menu
 */
function pnCPG_adminmenu() {

   $theme = pnUserGetTheme();
	pnThemeLoad($theme);

    // Create output object
    $output = new pnHTML();

    // Security check
    if (!pnSecAuthAction(0, 'pnCPG::', '::', ACCESS_ADMIN)) {
        $output->Text(pnVarPrepHTMLDisplay(_PNCPGNOAUTH));
        return $output->GetOutput();
    }

	//Title
	ob_start();
	OpenTable();
	$oTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($oTable);
	$output->Title(pnVarPrepHTMLDisplay('<b>'._PNCPG.'</b>'));
    $output->Text(pnVarPrepHTMLDisplay(_PNCPGMODIFYCONFIG));
	ob_start();
	CloseTable();
	$cTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($cTable);

///////////////////////////////////////
	// Start form
    $output->FormStart(pnModURL('pnCPG', 'admin', 'createconfig'));

    // Add an authorisation ID
    $output->FormHidden('authid', pnSecGenAuthKey());


    // Start the table that holds the information to be modified.
    ob_start();
	OpenTable();
	$oTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($oTable);
	$output->TableStart();
	


//create configurattion file
	$row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODCREATECONFIG));
    $row[] = $output->FormText('newconf', '', 15, 15);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	$output->TableEnd();
	ob_start();
	CloseTable();
	$cTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($cTable);

	// End form
    //$output->Linebreak(1);
	ob_start();
	OpenTable();
	$oTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($oTable);
	$output->Text('<div align="center"><br>');
    $output->FormSubmit(pnVarPrepHTMLDisplay(_PNCPGCREATE));
	$output->Text('<br><br></div>');
	ob_start();
	CloseTable();
	$cTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($cTable);
    $output->FormEnd();

	//////////////////////////////////////////
	
		// Start form
    $output->FormStart(pnModURL('pnCPG', 'admin', 'selectconfig'));

    // Add an authorisation ID
    $output->FormHidden('authid', pnSecGenAuthKey());


    // Start the table that holds the information to be modified.
    ob_start();
	OpenTable();
	$oTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($oTable);
	$output->TableStart();

		// select configurattion file
	$row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODCONFIG));
  
	$configdir =getcwd() ;
	$configdir.="/modules/pnCPG/pnconfig";
	$dh = opendir( $configdir );
	$ini_info = array();
	
	while( $file = readdir( $dh ) ) {
		// look for these file types....
		if (preg_match('/(ini)$/i',$file)) {
			$ini_info[] = $file;
		}
	}	
	echo '<SELECT name=selconfig>'; 
		foreach ($ini_info as $key => $value) { 
			echo '<OPTION value='.$value.'> '.$value.''; 
		} 
	echo '</select>'; 

    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');
	


	$output->TableEnd();
	ob_start();
	CloseTable();
	$cTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($cTable);

	// End form
    //$output->Linebreak(1);
	ob_start();
	OpenTable();
	$oTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($oTable);
	$output->Text('<div align="center"><br>');
    $output->FormSubmit(pnVarPrepHTMLDisplay(_PNCPGSELECT));
	$output->Text('<br><br></div>');
	ob_start();
	CloseTable();
	$cTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($cTable);
    $output->FormEnd();
///////////////////////////////////////
	
	
	// Start form
    $output->FormStart(pnModURL('pnCPG', 'admin', 'updateconfig'));

    // Add an authorisation ID
    $output->FormHidden('authid', pnSecGenAuthKey());

	
	// first get configuration parameter
	$selconfig = pnModGetVar('pnCPG', '_inifile');
	// if not supplied, insert default value
	if(!$selconfig){
		$selconfig="config.ini";
	}
	$configfile =getcwd() ;
	$configfile.="/modules/pnCPG/pnconfig/";
	$configfile.=$selconfig ;
	$ini_array = parse_ini_file($configfile);

    // Start the table that holds the information to be modified.
    ob_start();
	OpenTable();
	$oTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($oTable);
	$output->TableStart();
	
	// pnCPGini fileon
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_PNCPGCURRENT));
    $row[] = $output->Text(pnVarPrepHTMLDisplay($selconfig));
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');
    //$output->SetInputMode(_PNH_PARSEINPUT);
	// pnCPG location
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODSUBJECT));
    $row[] = $output->FormText('_CPGloc', $ini_array[cpg_location], 75, 75);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');
    //$output->SetInputMode(_PNH_PARSEINPUT);



	// Warning
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODWARNING));
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	// pnCPG database
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODDB));
    $row[] = $output->FormText('_db', $ini_array[cpg_database], 50, 50);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	// Table Prefix
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODPRF));
    $row[] = $output->FormText('_prf',$ini_array[cpg_prefix],20,20);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	// Using AutoTheme
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_USEAT));
    $row[] = $output->FormText('_useat', $ini_array[cpg_at_theme], 1, 1);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	
	// Open in New >Window
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODWINDOW));
    $row[] = $output->FormText('_CPGwindow',$ini_array[cpg_full_window], 1, 1);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	// Default language
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODLANG));
    $row[] = $output->FormText('_lang', $ini_array[cpg_language], 35, 35);
   $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	// Default theme
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODTHEME));
    $row[] = $output->FormText('_theme', $ini_array[cpg_theme], 35, 35);
   $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	// Create users
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODUSERS));
    $row[] = $output->FormText('_CPGusers', $ini_array[cpg_create_user], 1, 1);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	// Use Dynamic User Data to store password
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_USEDUD));
    $row[] = $output->FormText('_usedud', $ini_array[cpg_connect], 1, 1);
	$output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	// Send password by email
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_SENDMAIL));
    $row[] = $output->FormText('_sendmail', $ini_array[cpg_send_password], 1, 1);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	// Create album
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MAKE));
    $row[] = $output->FormText('_make', $ini_array[cpg_create_album],1,1);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	// Coppermine Album
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_ALBUM));
    $row[] = $output->FormText('_album',  $ini_array[cpg_album_name], 35, 35);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	// Create Guest account
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_PNCPGGUEST));
    $row[] = $output->FormText('_CPGguest', $ini_array[cpg_create_guest], 1, 1);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');



	// Use Original Guest account
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_PNCPGGUESTORG));
    $row[] = $output->FormText('_CPGguestorg', $ini_array[cpg_use_cpg_guest],1,1);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');



	// Postnuke Prefix
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_PNPREFIX));
    $row[] = $output->FormText('_pn_prf', $ini_array[cpg_pn_prefix], 35, 35);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');


	// Coppermine Prefix
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_CPGPREFIX));
    $row[] = $output->FormText('_cpg_prf', $ini_array[cpg_prefix], 35, 35);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');


	// PostNuke home
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_PNROOT));
    $row[] = $output->FormText('_pnroot', $ini_array[cpg_pn_root],100,100);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	// pnCPG database host
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODDBHOST));
    $row[] = $output->FormText('_dbhost', $ini_array[cpg_pn_host], 50, 50);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	// pnCPG  database user
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODDBUSER));
    $row[] = $output->FormText('_dbuser', $ini_array[cpg_pn_dbuser], 50, 50);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	// pnCPG database pw
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODDBPW));
    $row[] = $output->FormText('_dbpw', $ini_array[cpg_pn_dbpwd], 50, 50);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');


	$output->TableEnd();
	ob_start();
	CloseTable();
	$cTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($cTable);

	// End form
    //$output->Linebreak(1);
	ob_start();
	OpenTable();
	$oTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($oTable);
	$output->Text('<div align="center"><br>');
    $output->FormSubmit(pnVarPrepHTMLDisplay(_PNCPGUPDATE));
	$output->Text('<br><br></div>');
	ob_start();
	CloseTable();
	$cTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($cTable);
    $output->FormEnd();

	// Start form
    $output->FormStart(pnModURL('pnCPG', 'admin', 'SyncPN'));

    // Add an authorisation ID
    $output->FormHidden('authid', pnSecGenAuthKey());


    // Start the table that holds the information to be modified.
    ob_start();
	OpenTable();
	$oTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($oTable);
	$output->TableStart();

	$row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODUPDATEPN));
     $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	$output->TableEnd();
	ob_start();
	CloseTable();
	$cTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($cTable);

	// End form
    //$output->Linebreak(1);
	ob_start();
	OpenTable();
	$oTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($oTable);
	$output->Text('<div align="center"><br>');
    $output->FormSubmit(pnVarPrepHTMLDisplay(_PNCPGSYNC));
	$output->Text('<br><br></div>');
	ob_start();
	CloseTable();
	$cTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($cTable);
    $output->FormEnd();
	
	// Return the output that has been generated by this function
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
	return $output->GetOutput();
}

function pnCPG_admin_updateconfig()
{
    // Get parameters from whatever input we need.
	$_CPGloc = pnVarCleanFromInput('_CPGloc');
	$_CPGwindow = pnVarCleanFromInput('_CPGwindow');
	$_prf = pnVarCleanFromInput('_prf');
	$_CPGusers = pnVarCleanFromInput('_CPGusers');
	$_CPGguest = pnVarCleanFromInput('_CPGguest');
	$_CPGguestorg = pnVarCleanFromInput('_CPGguestorg');
	$_cpg_prf = pnVarCleanFromInput('_cpg_prf');
	$_pn_prf = pnVarCleanFromInput('_pn_prf');
	$_db = pnVarCleanFromInput('_db');
	$_lang = pnVarCleanFromInput('_lang');
	$_make = pnVarCleanFromInput('_make');
	$_album = pnVarCleanFromInput('_album');
	$_theme = pnVarCleanFromInput('_theme');
	$_sendmail = pnVarCleanFromInput('_sendmail');
	$_usedud = pnVarCleanFromInput('_usedud');
	$_pnroot = pnVarCleanFromInput('_pnroot');
	$_dbhost = pnVarCleanFromInput('_dbhost');
	$_dbuser = pnVarCleanFromInput('_dbuser');
	$_dbpw = pnVarCleanFromInput('_dbpw');
	$_useat = pnVarCleanFromInput('_useat');


    // Confirm authorisation code.
    if (!pnSecConfirmAuthKey()) {
        pnSessionSetVar('errormsg', _BADAUTHKEY);
        pnRedirect(pnModURL('pnCPG', 'admin', ''));
        return true;
    }

    // Update module variables.
$selconfig = pnModGetVar('pnCPG', '_inifile');
	$configfile =getcwd() ;
	$configfile.="/modules/pnCPG/pnconfig/";
	$configfile.=$selconfig ;	
	
		$fp = unlink($configfile);
		if (!$fp){
//			echo $_CPGloc;
	//		echo $configfile;
		//	die;
		}
		$fp = fopen($configfile, "xt");
		fwrite($fp, "[settings]"."\n");
		fwrite($fp, "cpg_location=".$_CPGloc. "\n");
		fwrite($fp, "cpg_database=".$_db. "\n");
		fwrite($fp, "cpg_prefix=".$_prf. "\n");
		fwrite($fp, "cpg_at_theme=".$_useat. "\n");
		fwrite($fp, "cpg_full_window=".$_CPGwindow. "\n");
		fwrite($fp, "cpg_language=".$_lang. "\n");
		fwrite($fp, "cpg_theme=".$_theme. "\n");
		fwrite($fp, "cpg_create_user=".$_CPGusers. "\n");
		fwrite($fp, "cpg_connect=".$_usedud. "\n");
		fwrite($fp, "cpg_send_password=".$_sendmail. "\n");
		fwrite($fp, "cpg_create_album=".$_make. "\n");
		fwrite($fp, "cpg_album_name=".$_album. "\n");
		fwrite($fp, "cpg_create_guest=".$_CPGguest. "\n");
		fwrite($fp, "cpg_use_cpg_guest=".$_CPGguestorg. "\n");
		fwrite($fp, "cpg_pn_users=". "\n");
		fwrite($fp, "cpg_pn_root=". $_pnroot."\n");
		fwrite($fp, "cpg_pn_host=". $_dbhost."\n");
		fwrite($fp, "cpg_pn_dbuser=".$_dbuser. "\n");
		fwrite($fp, "cpg_pn_dbpwd=".$_dbpw. "\n");
		fclose($fp);

    // This function generated no output, and so now it is complete we redirect
    // the user to an appropriate page for them to carry on their work
pnRedirect('index.php?module=pnCPG&type=admin');

    // Return
    return true;
}

function pnCPG_admin_SyncPN()
{
$cpg_loc = readini($configfile,"settings","cpg_location");
$_cpg_prf = readini("$configfile","settings","cpg_prefix");
$_pn_prf = readini($configfile,"settings","cpg_prefix");
$db=readini($configfile,"settings","cpg_database");
$_dbhost=readini($configfile,"settings","cpg_pn_host");
$_dbuser=readini($configfile,"settings","cpg_pn_dbuser");
$_dbpw=readini($configfile,"settings","cpg_pn_dbpwd");
$_pnroot=readini($configfile,"settings","cpg_pn_root");
$makealbum=readini($configfile,"settings","cpg_create_album");

$std_db =  pnConfigGetVar('dbname');

// Load Postnuke users
$results = mysql_query( "SELECT pn_uname,pn_email FROM $_pn_prf LIMIT 0 , 999999" );

//store the result in a PHP array for multiple use
$dbdata=array();
$dbdata1=array();
$usr_num = 0;
while($row = mysql_fetch_array($results)) {
$usr_num ++;
$dbdata[$usr_num]=$row[0];
$dbdata1[$usr_num]=$row[1];
}

// is there another database owner, let's connect
if ($_dbhost !==""){
	$link = mysql_connect($_dbhost, $_dbuser, $_dbpw) or mysql_error();
}
$true = mysql_select_db($db) ;

$teller = 0;
while ($teller < $usr_num ){

$teller ++ ;
$username = $dbdata[$teller];
$usermail = $dbdata1[$teller];

// Check if already added to Coppermine
$results1 = mysql_query( "SELECT * FROM $_cpg_prf WHERE user_name=$username " );
$num_rows1 = mysql_num_rows($results1);


// if not there, add the account
if ($num_rows1 < 1){
$cpg_pwd = ranpass() ;
$adding = mysql_query("INSERT INTO $_cpg_prf(user_group, user_active,user_name, user_password,user_lastvisit, user_regdate,user_email) VALUES ('2','YES', '$username','$cpg_pwd',NOW(), NOW(),'$usermail')");


if ($makealbum == 'y'){
$results = mysql_query( "SELECT * FROM $_cpg_prf where user_name='$username' " );
$USER_DATA = mysql_fetch_array($results);
$temp_user_cat = $USER_DATA['user_id'];
$temp_user_cat = $temp_user_cat + 10000;
mysql_query("INSERT INTO $_cpg_album(title, description, visibility, uploads, comments, votes, pos, category, pic_count, thumb, last_addition, stat_uptodate, keyword) VALUES ('$f_username', '', '0', 'NO', 'YES', 'YES', '1', '$temp_user_cat', '0', '0', '0', 'NO', '$f_username')");

}





} else {
//update e-mail
$updating = mysql_query("UPDATE $_cpg_prf set  user_email = '$usermail' where user_name='$username' limit 1");

}
}

if ($_dbhost !==""){
	include_once($_pnroot."config.php");
// Decode encoded DB parameters
if ($pnconfig['encoded']) {
	$pnconfig['dbuname'] = base64_decode($pnconfig['dbuname']);
	$pnconfig['dbpass'] = base64_decode($pnconfig['dbpass']);
}

	$link = mysql_connect($pnconfig['dbhost'], $pnconfig['dbuname'], $pnconfig['dbpass']) or mysql_error();
}
$true = mysql_select_db($std_db) ;


    // Return
    return true;
}

function pnCPG_admin_createconfig() 
{
// Get parameters from whatever input we need.
$newconf = pnVarCleanFromInput('newconf');
if ($newconf) {
    // Confirm authorisation code.
    if (!pnSecConfirmAuthKey()) {
        pnSessionSetVar('errormsg', _BADAUTHKEY);
        pnRedirect(pnModURL('pnCPG', 'admin', ''));
        return true;
    }

    // Create empty configfile
	
	$newfile =getcwd() ;
	$newfile.="/modules/pnCPG/pnconfig/";
	$newfile.=$newconf ;
	$newfile.=".ini" ;

	if (!file_exists($newfile)) {

		$fp = fopen($newfile, "xt");
		fwrite($fp, "[settings]". "\n");
		fwrite($fp, "cpg_location=". "\n");
		fwrite($fp, "cpg_database=". "\n");
		fwrite($fp, "cpg_prefix=". "\n");
		fwrite($fp, "cpg_at_theme=". "\n");
		fwrite($fp, "cpg_full_window=". "\n");
		fwrite($fp, "cpg_language=". "\n");
		fwrite($fp, "cpg_theme=". "\n");
		fwrite($fp, "cpg_create_user=". "\n");
		fwrite($fp, "cpg_connect=". "\n");
		fwrite($fp, "cpg_send_password=". "\n");
		fwrite($fp, "cpg_create_album=". "\n");
		fwrite($fp, "cpg_album_name=". "\n");
		fwrite($fp, "cpg_create_guest=". "\n");
		fwrite($fp, "cpg_use_cpg_guest=". "\n");
		fwrite($fp, "cpg_create_all=". "\n");
		fwrite($fp, "cpg_pn_users=". "\n");
		fwrite($fp, "cpg_cpg_users=". "\n");
		fwrite($fp, "cpg_pn_root=". "\n");
		fwrite($fp, "cpg_pn_host=". "\n");
		fwrite($fp, "cpg_pn_dbuser=". "\n");
		fwrite($fp, "cpg_pn_dbpwd=". "\n");
		fclose($fp);
	}
}
$selconfig= $newconf;
$selconfig=".ini";
   pnModSetVar('pnCPG', '_inifile', $selconfig);
// This function generated no output, and so now it is complete we redirect
// the user to an appropriate page for them to carry on their work
pnRedirect('index.php?module=pnCPG&type=admin');
// Return
return true;
}


function pnCPG_admin_selectconfig() 
{
// Get parameters from whatever input we need.
$selconfig = pnVarCleanFromInput('selconfig');
    pnModSetVar('pnCPG', '_inifile', $selconfig);

// This function generated no output, and so now it is complete we redirect
// the user to an appropriate page for them to carry on their work
pnRedirect('index.php?module=pnCPG&type=admin');
// Return
return true;
}

/*
	
	create password
*/
function ranpass($len = "8"){
 $pass = NULL;
 for($i=0; $i<$len; $i++) {
   $char = chr(rand(48,122));
   while (!ereg("[a-zA-Z0-9]", $char)){
     if($char == $lchar) continue;
     $char = chr(rand(48,90));
   }
   $pass .= $char;
   $lchar = $char;
 }
 return $pass;
}
?>