#/**************************************************
#  Coppermine 1.5.x Plugin - social_bookmarks
#  *************************************************
#  Copyright (c) 2003-2009 Coppermine Dev Team
#  *************************************************
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#  ********************************************
#  $HeadURL: https://coppermine.svn.sourceforge.net/svnroot/coppermine/branches/cpg1.5.x/plugins/social_bookmarks/schema.sql $
#  $Revision: 7119 $
#  $LastChangedBy: gaugau $
#  $Date: 2010-01-24 21:39:28 +0100 (So, 24 Jan 2010) $
#  **************************************************/

INSERT IGNORE INTO CPG_config (`name`, `value`) VALUES ('plugin_social_bookmarks_position', '2');
INSERT IGNORE INTO CPG_config (`name`, `value`) VALUES ('plugin_social_bookmarks_visibility', '2');
INSERT IGNORE INTO CPG_config (`name`, `value`) VALUES ('plugin_social_bookmarks_greyout', '0');
INSERT IGNORE INTO CPG_config (`name`, `value`) VALUES ('plugin_social_bookmarks_layout', '2');
INSERT IGNORE INTO CPG_config (`name`, `value`) VALUES ('plugin_social_bookmarks_columns', '5');
INSERT IGNORE INTO CPG_config (`name`, `value`) VALUES ('plugin_social_bookmarks_smart_language', 1);
INSERT IGNORE INTO CPG_config (`name`, `value`) VALUES ('plugin_social_bookmarks_admin_menu', '0');


CREATE TABLE IF NOT EXISTS `CPG_plugin_social_bookmarks_services` (
  service_id int(11) NOT NULL auto_increment,
  service_active enum('YES','NO') NOT NULL default 'NO',
  service_name_short varchar(25) NOT NULL default '',
  service_name_full varchar(25) NOT NULL default '',
  service_url varchar(255) NOT NULL default '',
  service_lang varchar(255) NOT NULL default '',
  icon_filename varchar(40) NOT NULL default '',
  relevance int(4) NOT NULL default 0,
  PRIMARY KEY  (service_id),
  UNIQUE KEY service_name_full (service_name_full),
  UNIQUE KEY service_url (service_url)
) TYPE=MyISAM COMMENT='Contains the social bookmark services';

INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Alltagz', 'alltagz', 'http://www.alltagz.de/bookmarks/?action=add&amp;address={u}&amp;title={t}', 'de', 'alltagz.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Allvoices', 'Allvoices', 'http://www.allvoices.com/post_event?url={u}&amp;title={t}', 'en', 'allvoices.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Amazon', 'Amazon WishList', 'http://www.amazon.com/wishlist/add?u={u}&amp;t={t}', 'en', 'amazon.png', 3);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('AOL', 'myAOL', 'http://favorites.my.aol.com/ffclient/AddBookmark?url={u}&amp;title={t}', 'en', 'aol.png', 4);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Arto', 'Arto', 'http://www.arto.com/section/linkshare/?lu={u}&amp;ln={t}', 'en', 'arto.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Ask', 'Ask', 'http://myjeeves.ask.com/mysearch/BookmarkIt?v=1.2&amp;t=webpages&amp;url={u}&amp;title={t}', 'en', 'ask.png', 3);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Backflip', 'Backflip', 'http://www.backflip.com/add_page_pop.ihtml?url={u}&amp;title={t}', 'en', 'backflip.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('BallHype', 'BallHype', 'http://ballhype.com/post/url/?url={u}&amp;title={t}', 'en', 'ballhype.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Bebo', 'Bebo', 'http://bebo.com/c/share?Url={u}&amp;Title={t}', 'en', 'bebo.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('BibSonomy', 'BibSonomy', 'http://www.bibsonomy.org/BibtexHandler?requTask=upload&amp;url={u}&amp;description={t}', 'en', 'bibsonomy.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('BlinkList', 'BlinkList', 'http://www.blinklist.com/index.php?Action=Blink/addblink.php&amp;Url={u}&amp;Title={t}', 'multi', 'blink.png', 6);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Blogmarks', 'Blogmarks', 'http://blogmarks.net/my/new.php?mini=1&amp;simple=1&amp;url={u}&amp;title={t}', 'en', 'blogmarks.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Bookmarkit', 'bookmark.it', 'http://www.bookmark.it/bookmark.php?url={u}', 'it', 'bookmark.it.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Bookmarks.fr', 'Bookmarks.fr', 'http://www.bookmarks.fr/favoris/AjoutFavori?action=add&amp;address={u}&amp;title={t}', 'fr', 'bookmarks.fr.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('BuddyMarks', 'BuddyMarks', 'http://buddymarks.com/add_bookmark.php?bookmark_url={u}&amp;bookmark_title={t}', 'en', 'buddymarks.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('BX', 'Business Exchange', 'http://bx.businessweek.com/api/add-article-to-bx.tn?url={u}', 'en', 'business_exchange.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Bzzster', 'Bzzster', 'http://bzzster.com/share?v=5;link={u}&amp;subject={t}', 'en', 'bzzster.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Care2', 'Care2', 'http://www.care2.com/news/news_post.html?url={u}&amp;title={t}', 'en', 'care2.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Citeulike', 'Citeulike', 'http://www.citeulike.org/posturl?url={u}&amp;title={t}', 'en', 'citeulike.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('connotea', 'Connotea', 'http://www.connotea.org/add?uri={u}&amp;title={t}', 'en', 'connotea.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Current', 'Current', 'http://current.com/clipper.htm?url={u}&amp;title={t}', 'en', 'current.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Deals plus', 'deals plus', 'http://dealspl.us/add.php?ibm=1&amp;url={u}', 'en', 'deals_plus.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('del.icio.us', 'del.icio.us', 'http://del.icio.us/post?url={u}&amp;title={t}', 'en', 'del.icio.us.png', 7);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Design Float', 'Design Float', 'http://www.designfloat.com/submit.php?url={u}&amp;title={t}', 'en', 'design_float.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Digg', 'Digg', 'http://digg.com/submit?phase=2&amp;url={u}&amp;title={t}', 'en', 'digg.png', 6);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Diigo', 'Diigo', 'http://www.diigo.com/post?url={u}&amp;title={t}', 'en', 'diigo.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('DZone', 'DZone', 'http://www.dzone.com/links/add.html?url={u}&amp;title={t}', 'en', 'dzone.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Evernote', 'Evernote', 'http://www.evernote.com/clip.action?url={u}&amp;title={t}', 'en', 'evernote.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Expression', 'Microsoft Expression', 'http://social.expression.microsoft.com/en-US/action/Create/s/E/?url={u}&amp;bm=true&amp;ttl={t}', 'br|cn|cz|de|en|es|fr|it|jp|kr|ru|cn|', 'expression.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services ( `service_name_short`, `service_name_full` , `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Facebook', 'Facebook', 'http://www.facebook.com/sharer.php?u={u}&amp;t={t}', 'multi', 'facebook.png', 8);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Fark', 'Fark', 'http://cgi.fark.com/cgi/fark/submit.pl?new_url={u}&amp;new_comment={t}', 'en', 'fark.png', 5);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Faves', 'Faves', 'http://faves.com/Authoring.aspx?u={u}&amp;t={t}', 'en', 'faves.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Folkd', 'Folkd', 'http://www.folkd.com/submit/{u}', 'en|de', 'folkd.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('FoxieWire', 'FoxieWire', 'http://www.foxiewire.com/submit?url={u}&amp;title={t}', 'en', 'foxiewire.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Fresqui', 'Fresqui', 'http://ocio.fresqui.com/post?url={u}&amp;title={t}', 'en', 'fresqui.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('FriendFeed', 'FriendFeed', 'http://friendfeed.com/share?url={u}&amp;title={t}', 'en', 'friendfeed.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('FunP', 'funP', 'http://funp.com/pages/submit/add.php?url={u}&amp;title={t}', 'en', 'funp.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Gabbr', 'Gabbr', 'http://www.gabbr.com/submit/?bookurl={u}', 'en', 'gabbr.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Global Grind', 'Global Grind', 'http://globalgrind.com/submission/submit.aspx?url={u}&amp;type=Article&amp;title={t}', 'en', 'global_grind.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Google', 'Google Bookmarks', 'http://www.google.com/bookmarks/mark?op=edit&amp;bkmk={u}&amp;title={t}', 'multi', 'google.png', 8);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Gravee', 'Gravee', 'http://www.gravee.com/account/bookmarkpop?u={u}&amp;t={t}', 'en', 'gravee.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('HealthRanker', 'HealthRanker', 'http://www.healthranker.com/submit.php?url={u}&amp;title={t}', 'en', 'healthranker.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('HemiDemi', 'HEMiDEMi', 'http://www.hemidemi.com/user_bookmark/new?url={u}&amp;title={t}', 'tw', 'hemidemi.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Hugg', 'Hugg', 'http://www.hugg.com/submit?url={u}', 'en', 'hugg.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Identi.ca', 'identi.ca', 'http://identi.ca/notice/new?status_textarea={t}%20{u}', 'en', 'identi.ca.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Imera', 'Imera', 'http://www.imera.com.br/post_d.html?linkUrl={u}&amp;linkName={t}', 'en', 'imera.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Instapaper', 'Instapaper', 'http://www.instapaper.com/b?u={u}&amp;t={y}', 'en', 'instapaper.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Jamespot', 'Jamespot', 'http://www.jamespot.com/?action=spotit&amp;url={u}', 'en', 'jamespot.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Jumptags', 'Jumptags', 'http://www.jumptags.com/add/?url={u}&amp;title={t}', 'en', 'jumptags.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Kaboodle', 'Kaboodle', 'http://www.kaboodle.com/grab/addItemWithUrl?url={u}&amp;pidOrRid=pid=&amp;redirectToKPage=true', 'en', 'kaboodle.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Khabbr', 'Khabbr', 'http://www.khabbr.com/submit.php?out=yes&amp;url={u}', 'en', 'khabbr.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Kledy', 'Kledy', 'http://www.kledy.de/submit.php?url={u}', 'de', 'kledy.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Kirtsy', 'Kirtsy', 'http://www.kirtsy.com/submit.php?url={u}', 'en', 'kirtsy.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Kool', 'Koolontheweb', 'http://www.koolontheweb.com/post?url={u}&amp;title={t}', 'en', 'koolontheweb.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Linkarena', 'Linkarena', 'http://linkarena.com/bookmarks/addlink/?url={u}&amp;title={t}&amp;desc=&amp;tags=', 'en|de', 'linkarena.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Linkagogo', 'LinkaGoGo', 'http://www.linkagogo.com/go/AddNoPopup?url={u}&amp;title={t}', 'en', 'linkagogo.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Linkedin', 'LinkedIn', 'http://www.linkedin.com/shareArticle?mini=true&amp;url={u}&amp;title={t}&amp;ro=false&amp;summary=&amp;source=', 'en', 'linkedin.png', 5);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('LiveJournal', 'LiveJournal', 'http://www.livejournal.com/update.bml?subject={u}', 'en', 'livejournal.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Maple', 'Maple', 'http://www.maple.nu/bookmarks/bookmarklet?bookmark[url]={u}&amp;bookmark[description]={t}', 'en', 'maple.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Meneame', 'menéame', 'http://meneame.net/submit.php?url={u}', 'en', 'meneame.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('MindBody', 'MindBodyGreen', 'http://www.mindbodygreen.com/passvote.action?u={u}', 'en', 'mindbodygreen.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Mr Wong', 'Mister Wong', 'http://www.mister-wong.com/index.php?action=addurl&amp;bm_url={u}&amp;bm_description={t}', 'cn|de|en|es|fr|ru', 'misterwong.png', 6);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Mixx', 'Mixx', 'http://www.mixx.com/submit/story?page_url={u}&amp;title={t}', 'en', 'mixx.png', 4);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Multiply', 'Multiply', 'http://multiply.com/gus/journal/compose/addthis?body=&amp;url={u}&amp;subject={t}', 'en', 'multiply.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('myLinkVault', 'MyLinkVault', 'http://www.mylinkvault.com/link-page.php?u={u}&amp;n={t}', 'en', 'mylinkvault.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('MySpace', 'MySpace', 'http://www.myspace.com/Modules/PostTo/Pages/?u={u}&amp;t={t}', 'en|de', 'myspace.png', 7);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('n4g', 'N4G', 'http://www.n4g.com/tips.aspx?url={u}&amp;title={t}', 'en', 'n4g.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('NetLog', 'NetLog', 'http://www.netlog.com/go/manage/links/view=save&amp;origin=external&amp;url={u}&amp;title={t}', 'en', 'netlog.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Netscape', 'Netscape', 'http://www.netscape.com/submit/?U={u}&amp;T={t}', 'en', 'netscape.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Netvibes', 'Netvibes', 'http://www.netvibes.com/share?url={u}&amp;title={t}', 'en', 'netvibes.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Netvouz', 'Netvouz', 'http://netvouz.com/action/submitBookmark?url={u}&amp;title={t}&amp;popup=no', 'en|se', 'netvouz.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('NewsTrust', 'NewsTrust', 'http://newstrust.net/submit?url={u}&amp;title={t}&amp;ref=addtoany', 'en', 'newstrust.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Newsvine', 'Newsvine', 'http://www.newsvine.com/_wine/save?u={u}&amp;h={t}', 'en', 'newsvine.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('NowPublic', 'NowPublic', 'http://view.nowpublic.com/?src={u}&amp;t={t}', 'en', 'nowpublic.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('OKNOtizie', 'OK NOtizie Italia', 'http://oknotizie.alice.it/post?url={u}&amp;title={t}', 'it', 'oknotozie.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('OneView', 'OneView', 'http://www.oneview.de/quickadd/neu/addBookmark.jsf?URL={u}&amp;title={t}', 'de', 'oneview.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Ping', 'Ping', 'http://ping.fm/ref/?link={u}&amp;title={t}', 'en', 'ping.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Plaxo', 'Plaxo Pulse', 'http://www.plaxo.com/pulse/?share_link={u}', 'en', 'plaxo_pulse.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Propeller', 'Propeller', 'http://www.propeller.com/submit/?U={u}&amp;T={t}', 'en', 'propeller.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Protopage', 'Protopage', 'http://www.protopage.com/add-button-site?url={u}&amp;label={t}&amp;type=page', 'en', 'protopage.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Pusha', 'Pusha', 'http://www.pusha.se/posta?url={u}', 'en', 'pusha.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Reddit', 'reddit', 'http://reddit.com/submit?url={u}&amp;title={t}', 'en|de', 'reddit.png', 5);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Scoopeo', 'Scoopeo', 'http://www.scoopeo.com/scoop/new?newurl={u}&amp;title={t}', 'fr|en', 'scoopeo.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Segnalo', 'Segnalo', 'http://segnalo.alice.it/post.html.php?url={u}&amp;title={t}', 'it', 'segnalo.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('ShoutWire', 'ShoutWire', 'http://www.shoutwire.com/?s={u}', 'en', 'shoutwire.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Simpy', 'Simpy', 'http://www.simpy.com/simpy/LinkAdd.do?href={u}&amp;title={t}', 'en|de', 'simpy.png', 3);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Sitejot', 'Sitejot', 'http://www.sitejot.com/addform.php?iSiteAdd={u}&amp;iSiteDes={t}', 'en', 'sitejot.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Slashdot', 'Slashdot', 'http://slashdot.org/bookmark.pl?url={u}&amp;title={t}', 'en', 'slashdot.png', 4);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('SmaknNews', 'SmakNews', 'http://smaknews.com/submit.php?url={u}&amp;title={t}', 'en', 'smaknews.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Sphinn', 'Sphinn', 'http://sphinn.com/submit.php?url={u}&amp;title={t}', 'en', 'sphinn.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Spurl', 'Spurl', 'http://www.spurl.net/spurl.php?url={u}&amp;title={t}', 'en', 'spurl.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Squidoo', 'Squidoo', 'http://www.squidoo.com/lensmaster/bookmark?{u}&amp;title={t}', 'en', 'squidoo.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('StartAid', 'StartAid', 'http://www.startaid.com/index.php?st=AddBrowserLink&amp;type=Detail&amp;v=3&amp;urlname={u}&amp;urltitle={t}', 'en', 'startaid.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Strands', 'Strands', 'http://www.strands.com/tools/share/webpage?url={u}&amp;title={t}', 'en', 'strands.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Stumbleupon', 'StumbleUpon', 'http://www.stumbleupon.com/submit?url={u}&amp;title={t}', 'en', 'stumbleupon.png', 7);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Stumpedia', 'Stumpedia', 'http://www.stumpedia.com/submit?url={u}&amp;title={t}', 'en', 'stumpedia.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Tagza', 'Tagza', 'http://www.tagza.com/submit.php?url={u}', 'en', 'tagza.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('TechNet', 'Microsoft TechNet', 'http://social.technet.microsoft.com/en-US/action/Create/s/E/?url={u}&amp;bm=true&amp;ttl={t}', 'en', 'technet.png', 3);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Technorati', 'Technorati', 'http://www.technorati.com/faves?add={u}', 'en|jp', 'technorati.png', 3);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Technotizie', 'Technotizie', 'http://www.technotizie.it/posta_ok?action=f2&amp;url={u}&amp;title={t}', 'it', 'technotizie.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Thisnext', 'ThisNext', 'http://www.thisnext.com/pick/new/submit/sociable/?url={u}&amp;name={t}', 'en', 'thisnext.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Tipd', 'Tip\'d', 'http://tipd.com/submit.php?url={u}', 'en', 'tipd.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Tumblr', 'tumblr', 'http://www.tumblr.com/share?v=3&amp;u={u}&amp;t={t}', 'en', 'tumblr.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Twitter', 'TwitThis', 'http://twitthis.com/twit?url={u}', 'en', 'twitthis.png', 7);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Viadeo', 'Viadeo', 'http://www.viadeo.com/shareit/share/?url={u}&amp;title={t}', 'en', 'viadeo.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Vodpod', 'Vodpod', 'http://vodpod.com/account/add_video_page?p={u}', 'en', 'vodpod.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('WebNews', 'WebNews', 'http://www.webnews.de/einstellen?url={u}&amp;title={t}', 'de', 'webnews.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Wikio', 'Wikio', 'http://www.wikio.com/vote?newurl={u}', 'en', 'wikio.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Windows Live', 'Windows Live Favorites', 'https://favorites.live.com/quickadd.aspx?marklet=1&amp;mkt=en-us&amp;url={u}&amp;title={t}', 'multi', 'windows.png', 7);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Wists', 'Wists', 'http://wists.com/r.php?r={u}&amp;title={t}', 'en', 'wists.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Xanga', 'Xanga', 'http://www.xanga.com/private/editorx.aspx?u={u}&amp;t={t}', 'en', 'xanga.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Xerpi', 'Xerpi', 'http://www.xerpi.com/block/add_link_from_extension?url={u}&amp;title={t}', 'en', 'xerpi.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Yahoo', 'Yahoo Bookmarks', 'http://bookmarks.yahoo.com/toolbar/savebm?opener=tb&amp;u={u}&amp;t={t}', 'en', 'yahoo.png', 7);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('YahooBuzz', 'Yahoo Buzz', 'http://buzz.yahoo.com/submit?submitUrl={u}&amp;submitHeadline={t}', 'en', 'yahoobuzz.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Yahoo MyWeb', 'Yahoo MyWeb', 'http://myweb2.search.yahoo.com/myresults/bookmarklet?u={u}&amp;t={t}', 'multi', 'yahoomyweb.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Yardbarker', 'Yardbarker', 'http://www.yardbarker.com/author/new/?pUrl={u}', 'en', 'yardbarker.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Yigg', 'Yigg', 'http://www.yigg.de/neu?exturl={u}&amp;exttitle={t}', 'de', 'yigg.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('yoolink', 'yoolink', 'http://www.yoolink.fr/post/tag?f=aa&amp;url_value={u}&amp;title={t}', 'fr', 'yoolink.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('BoniTrust', 'BoniTrust', 'http://www.bonitrust.de/account/bookmark/?bookmark_url={u}', 'de', 'bonitrust.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Seek XXL', 'Seek XXL', 'http://social-bookmarking.seekxl.de/?add_url={u}&amp;title={t}', 'de', 'seekxxl.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Readster', 'Readster', 'http://www.readster.de/submit/?url={u}&amp;title={t}', 'de', 'readster.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Favoriten.de', 'Favoriten.de', 'http://www.favoriten.de/url-hinzufuegen.html?bm_url={u}&amp;bm_title={t}', 'de', 'favoriten.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('SOFTigg', 'SOFTigg.de', 'http://www.softigg.de/artikel/schreiben/news?url={u}&amp;title={t}', 'de', 'softigg.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('87c', '87c', 'http://87c.de/submit.php?url={u}', 'de', '87c.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Area-53', '$Area-53', 'http://area-53.de/account/bookmark/?bookmark_url={u}', 'de', 'area-53.png', 0);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Linksilo', 'Linksilo', 'http://www.linksilo.de/index.php?area=bookmarks&amp;func=bookmark_new&amp;addurl={u}&amp;addtitle={t}', 'de', 'linksilo.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Edelight', 'Edelight', 'http://www.edelight.de/geschenk/neu?purl={u}', 'de', 'edelight.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('etikett-en', 'etikett-en', 'http://etikett-en.de/account/bookmark/?bookmark_url={u}', 'de', 'ettiket-en.png', 0);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('icio', 'icio.de', 'http://www.icio.de/add.php?popup=1&url={u}&title={t}', 'de', 'icio.de.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Infopirat', 'Infopirat', 'http://infopirat.com/node/add/userlink?edit[url]={u}&edit[title]={t}', 'de', 'infopirat.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Lufee', 'Lufee', 'http://www.lufee.de/submit.php?link={u}&amp;ititle={t}', 'de', 'lufee.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Minota', 'mi:nota', 'http://www.minota.de/account/bookmark/?bookmark_url={u}', 'de', 'minota.png', 0);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('mytagz', 'MyTagz', 'http://www.mytagz.de/bookmarks/?action=add&address={u}&amp;title={t}', 'de', 'mytagz.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Favit', 'Favit', 'http://www.favit.de/submit.php?url={u}', 'de', 'favit.gif', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('bookmrk', 'bookmrk', 'http://www.bookmrk.de/account/bookmark/?bookmark_url=', 'de', 'bookmrk.gif', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Publishr', 'Publishr', 'http://www.publishr.de/account/bookmark/?bookmark_url={u}', 'de', 'publishr.gif', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Bookmarks.cc', 'Bookmarks.cc', 'http://www.bookmarks.cc/bookmarken.php?action=neu&amp;url={u}&amp;title={t}', 'de', 'bookmarkscc.gif', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Newsider', 'Newsider', 'http://www.newsider.de/submit.php?url={u}', 'de', 'newsider.gif', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Bloglines', 'Bloglines', 'http://www.bloglines.com/sub/{u}', 'en', 'bloglines.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Bumpzee', 'Bumpzee', 'http://www.bumpzee.com/bump.php?u={u}', 'en', 'bumpzee.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('co.mments', 'co.mments', 'http://co.mments.com/?url={u}&amp;title={t}', 'de', 'co.mments.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('DotNetKicks', 'DotNetKicks', 'http://www.dotnetkicks.com/kick?url={u]&amp;title={t}', 'en', 'dotnetkicks.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('HaoHao', 'HaoHao Report', 'http://www.haohaoreport.com/submit/?url={u}&amp;title={t}', 'en', 'haohao.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('IndianPad', 'IndianPad', 'http://www.indianpad.com/submit.php?url={u}', 'en', 'indianpad.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('PlugIM', 'PlugIM', 'http://www.plugim.com/submit?url={u}&amp;title={t}', 'en', 'plugim.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Socializer', 'Socializer', 'http://ekstreme.com/socializer/?url={u}&amp;title={t}', 'en', 'socializer.png', 3);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('WebRide', 'WebRide', 'http://webride.org/discuss/split.php?uri={u}&amp;title={t}', 'en', 'webride.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Wykop', 'Wykop', 'http://www.wykop.pl/dodaj?url={u}', 'pl', 'wykop.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Gwar', 'Gwar', 'http://www.gwar.pl/DodajGwar.html?u={u}', 'pl', 'gwar.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('rec6', 'rec6', 'http://rec6.via6.com/link.php?url={u}&={t}', 'br', 'rec6.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('InternetMedia', 'InternetMedia', 'http://www.internetmedia.hu/submit.php?url={u}', 'hu', 'internetmedia.hu.png', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Twine', 'Twine', 'http://www.twine.com/bookmark/basic?u={u}', 'en', 'twackle.gif', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Twackle', 'Twackle', 'http://www.twackle.com/chicklet?site={u}', 'en', 'twine.gif', 1);
INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('Aim', 'Aim', 'http://share.aim.com/share/?url={u}&amp;title={t}', 'en', 'aim.png', 1);
## INSERT IGNORE INTO CPG_plugin_social_bookmarks_services (`service_name_short`, `service_name_full`, `service_url`, `service_lang`, `icon_filename`, `relevance`) VALUES ('', '', '', '', '.png', 1);


