/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.filedata.helper;

import java.util.HashMap;
import java.util.Map;
import wjhk.jupload2.exception.JUploadException;

public class ImageFileConversionInfo {
    private static final String FORMAT_SEPARATOR = ",";
    private static final String RELATION_SEPARATOR = ";";
    private static final String RELATION_ASSIGNMENT = ":";
    private Map<String, String> formatRelations = new HashMap<String, String>();

    public ImageFileConversionInfo(String conversionList) throws JUploadException {
        this.parseConversionList(conversionList);
    }

    public String getTargetFormatOrNull(String sourceFormat) {
        if (sourceFormat == null) {
            return null;
        }
        String mapValue = this.formatRelations.get(sourceFormat.toLowerCase());
        return mapValue;
    }

    public String getTargetFormat(String sourceFormat) {
        if (sourceFormat == null) {
            return null;
        }
        String targetFormatOrNull = this.getTargetFormatOrNull(sourceFormat);
        if (targetFormatOrNull == null) {
            return sourceFormat.toLowerCase();
        }
        return targetFormatOrNull;
    }

    private void parseConversionList(String conversionList) throws JUploadException {
        String[] relations;
        if (conversionList == null || conversionList.equals("")) {
            return;
        }
        if (!conversionList.endsWith(RELATION_SEPARATOR)) {
            conversionList = conversionList + RELATION_SEPARATOR;
        }
        for (String relation : relations = conversionList.split(RELATION_SEPARATOR)) {
            String[] sourceFormats;
            String[] assignmentDetails = relation.split(RELATION_ASSIGNMENT);
            if (assignmentDetails.length != 2) {
                throw new JUploadException("Invalid format: relation '" + relation + "' should contain exatly one '" + RELATION_ASSIGNMENT + "'");
            }
            String sourceFormatList = assignmentDetails[0];
            String targetFormat = assignmentDetails[1].toLowerCase();
            for (String sourceFormat : sourceFormats = sourceFormatList.split(FORMAT_SEPARATOR)) {
                String lcSourceFormat = sourceFormat.toLowerCase();
                if (lcSourceFormat.equals(targetFormat)) {
                    throw new JUploadException("format '" + sourceFormat + "' is assigned to itself");
                }
                String putResult = this.formatRelations.put(lcSourceFormat, targetFormat);
                if (putResult == null) continue;
                throw new JUploadException("format '" + lcSourceFormat + "' is assigned to multiple target formats: '" + targetFormat + "', '" + putResult + "'");
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ImageFileConversionInfo (");
        for (Map.Entry<String, String> formatRelation : this.formatRelations.entrySet()) {
            sb.append(formatRelation.getKey());
            sb.append("-->");
            sb.append(formatRelation.getValue());
            sb.append(RELATION_SEPARATOR);
        }
        sb.append(")");
        return sb.toString();
    }
}

