<?php
  /*******************************************************
  			Add Meta Descriptions and canonical references 
  			By Joe Carver 
			Version 1.3 - 14 June 2010 
  *******************************************************/

	require_once('./plugins/description_metas/init.inc.php');

	if (!GALLERY_ADMIN_MODE) {
		cpg_die(ERROR, $lang_errors['perm_denied'], __FILE__, __LINE__);
	}
	js_include('js/edit_one_pic.js');
	
	pageheader(sprintf($description_metas_lang['configure_plugin_x'], $description_metas_lang['display_name']));
	
    global $lang_plugin_php, $CONFIG, $lang_common, $lang_pluginmgr_php, $lang_admin_php, $icon_array;

	list($timestamp, $form_token) = getFormToken();

	// get sanitized POST parameters
		if ($superCage->post->keyExists('submit')) {
		//Check if the form token is valid
		if(!checkFormToken()){
			cpg_die(ERROR, $lang_errors['invalid_form_token'], __FILE__, __LINE__);
		}

  // Define the sanitization patterns
  $sanitization_array = array(  
      'add_meta_home' => array('type' => 'array', 'regex_ok' => '/^[a-z]+$/'),
      'add_meta_alblist' => array('type' => 'array', 'regex_ok' => '/^[a-z]+$/'),
      'add_meta_search' => array('type' => 'array', 'regex_ok' => '/^[a-z]+$/'),
      'add_meta_pics' => array('type' => 'array', 'regex_ok' => '(/^[a-z]+$/'),
	  'add_meta_owner_name' => array('type' => 'int', 'min' => '0', 'max' => '1')
	  );
  $config_changes_counter = 0;
  foreach ($sanitization_array as $san_key => $san_value) {
      if (isset($CONFIG[$san_key]) == TRUE) { // only loop if config value is set --- start
 	          if ($san_value['type'] == 'array') { // type is array --- start              
          $evaluate_value = cpgSanitizeUserTextInput($superCage->post->getEscaped($san_key));
              //print_r($superCage->post->getRaw($san_key));
              if (is_array($evaluate_value) && isset($san_value['regex_ok']) == TRUE && isset($san_value['delimiter']) == TRUE) {
                  $temp = '';
                  for ($i = 0; $i <= count($evaluate_value); $i++) {
                      if (preg_match($san_value['regex_ok'], $evaluate_value[$i])) {
                          $temp .= $evaluate_value[$i] . $san_value['delimiter'];
                      }
                  }
                  unset($evaluate_value);
                  $evaluate_value = rtrim($temp, $san_value['delimiter']);
                  unset($temp);
              }
              if ($evaluate_value != $CONFIG[$san_key]) {
                  $CONFIG[$san_key] = $evaluate_value;
                  cpg_db_query("UPDATE {$CONFIG['TABLE_CONFIG']} SET value='{$CONFIG[$san_key]}' WHERE name='$san_key'");
                  $config_changes_counter++;
              }
          } // type is array --- end
          if ($san_value['type'] == 'int') { // type is integer --- start
              if ($superCage->post->getInt($san_key) <= $san_value['max'] && $superCage->post->getInt($san_key) >= $san_value['min'] && $superCage->post->getInt($san_key) != $CONFIG[$san_key]) {
                  $CONFIG[$san_key] = $superCage->post->getInt($san_key);
                  cpg_db_query("UPDATE {$CONFIG['TABLE_CONFIG']} SET value='{$CONFIG[$san_key]}' WHERE name='$san_key'");
                  $config_changes_counter++;
              }
          } // type is integer --- end		  
      } // only loop if config value is set --- end
  }
}	

// Set the option output 
if ($CONFIG['add_meta_owner_name'] == '1') {
	$option_output['add_meta_owner_name'] = 'checked="checked"';
} else { 
	$option_output['add_meta_owner_name'] = '';
}

	
// +++++++++++++++++++
	// start form
	$superCage = Inspekt::makeSuperCage();
	echo <<< EOT
	<form name="cpgform" id="cpgform" action="{$_SERVER['REQUEST_URI']}" method="post">
EOT;
	
	starttable('100%',  sprintf($description_metas_lang['configure_plugin_x'], $description_metas_lang['display_name']), 2, 'cpg_zebra');	
	
	// reply with success to changes or no changes made
	if ($superCage->post->keyExists('submit')) {
    echo <<< EOT
	<tr>
		<td class="tableh2" colspan="2">
EOT;
    if ($config_changes_counter > 0) {
        msg_box('', $description_metas_lang['update_success'], '', '', 'success');
    } else {
        msg_box('', $description_metas_lang['no_changes'], '', '', 'validation');
    }
echo <<< EOT
		</td>
	</tr>
EOT;
}

	// complete form
echo <<< EOT
			<tr>
			<td><br><b>{$description_metas_lang['page_head']}</b></td>
			</tr>
			<tr>
			<td></td>
            </tr>
            <tr>
            <td class="tableb" width="40%">
			<hr>
			{$description_metas_lang['add_meta_home']}<a href="plugins/description_metas/docs/{$documentation_file}.htm#add_meta_home" class="greybox" title="{{$description_metas_lang['add_meta_home']}}"><img src="images/help.gif" width="13" height="11" border="0" alt="" /></a>
            </td>
            <td>
			<br />
            <textarea name="add_meta_home" id="add_meta_home" rows="1" cols="80" class="elastic textinput" onkeydown="textCounter(this, {$CONFIG['max_img_desc_length']});" onkeyup="textCounter(this, {$CONFIG['max_img_desc_length']});" style="max-height:200px;">{$CONFIG['add_meta_home']}</textarea>
		    </td>
            </tr>
            <tr>
            <td class="tableb" width="40%">
			<hr>
			{$description_metas_lang['add_meta_alblist']}<a href="plugins/description_metas/docs/{$documentation_file}.htm#add_meta_alblist" class="greybox" title="{{$description_metas_lang['add_meta_alblist']}}"><img src="images/help.gif" width="13" height="11" border="0" alt="" /></a>
            </td>
            <td>
			<br />
            <textarea name="add_meta_alblist" id="add_meta_alblist" rows="1" cols="80" class="elastic textinput" onkeydown="textCounter(this, {$CONFIG['max_img_desc_length']});" onkeyup="textCounter(this, {$CONFIG['max_img_desc_length']});" style="max-height:200px;">{$CONFIG['add_meta_alblist']}</textarea>
			</td>
            </tr>
            <tr>
            <td class="tableb" width="40%">
			<hr>
			{$description_metas_lang['add_meta_search']}<a href="plugins/description_metas/docs/{$documentation_file}.htm#add_meta_search" class="greybox" title="{{$description_metas_lang['add_meta_search']}}"><img src="images/help.gif" width="13" height="11" border="0" alt="" /></a>
            </td>
            <td>
			<br />
            <textarea name="add_meta_search" id="add_meta_search" rows="1" cols="80" class="elastic textinput" onkeydown="textCounter(this, {$CONFIG['max_img_desc_length']});" onkeyup="textCounter(this, {$CONFIG['max_img_desc_length']});" style="max-height:200px;">{$CONFIG['add_meta_search']}</textarea>
			</td>
			</tr>
            <tr>
			
            <td class="tableb" width="40%">
			<hr>
			{$description_metas_lang['add_meta_pics']}<a href="plugins/description_metas/docs/{$documentation_file}.htm#add_meta_pics" class="greybox" title="{{$description_metas_lang['add_meta_pics']}}"><img src="images/help.gif" width="13" height="11" border="0" alt="" /></a>
            </td>
            <td>
			<br />
            <textarea name="add_meta_pics" id="add_meta_pics" rows="1" cols="80" class="elastic textinput" onkeydown="textCounter(this, {$CONFIG['max_img_desc_length']});" onkeyup="textCounter(this, {$CONFIG['max_img_desc_length']});" style="max-height:200px;">{$CONFIG['add_meta_pics']}</textarea>
			</td>			
			</tr>
            <tr>
            <td> 
                {$description_metas_lang['add_meta_owner_name']} <a href="plugins/description_metas/docs/{$documentation_file}.htm#add_meta_owner_name" class="greybox" title="{$description_metas_lang['add_meta_owner_text']}"><img src="images/help.gif" width="13" height="11" border="0" alt="" /></a>
            </td>
            <td>
                <input type="checkbox" name="add_meta_owner_name" id="add_meta_owner_name" class="checkbox" value="1" {$option_output['add_meta_owner_name']} />
                <label for="add_meta_owner_name" class="clickable_option">{$lang_common['yes']}</label>
            </td>
            </tr>
			<tr>	
            <td class="tableb" align="right"><br /><br />
			<span>
			<input type="hidden" name="form_token" value="{$form_token}" />
    		<input type="hidden" name="timestamp" value="{$timestamp}" />
			<input type="submit" name="submit" value="{$description_metas_lang['submit_change']}" /> 
		</span>
		</td>
		</tr>
		</td>		
EOT;

	endtable();
	echo <<< EOT
	</form>
EOT;

	pagefooter();
	ob_end_flush();

?>